/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The pipeline (queue) that is used to manage jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Pipeline implements SdkPojo, Serializable, ToCopyableBuilder<Pipeline.Builder, Pipeline> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Pipeline::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Pipeline::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Pipeline::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Pipeline::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> INPUT_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Pipeline::inputBucket)).setter(setter(Builder::inputBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputBucket").build()).build();

    private static final SdkField<String> OUTPUT_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Pipeline::outputBucket)).setter(setter(Builder::outputBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputBucket").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Pipeline::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> AWS_KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Pipeline::awsKmsKeyArn)).setter(setter(Builder::awsKmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsKmsKeyArn").build()).build();

    private static final SdkField<Notifications> NOTIFICATIONS_FIELD = SdkField.<Notifications> builder(MarshallingType.SDK_POJO)
            .getter(getter(Pipeline::notifications)).setter(setter(Builder::notifications)).constructor(Notifications::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notifications").build()).build();

    private static final SdkField<PipelineOutputConfig> CONTENT_CONFIG_FIELD = SdkField
            .<PipelineOutputConfig> builder(MarshallingType.SDK_POJO).getter(getter(Pipeline::contentConfig))
            .setter(setter(Builder::contentConfig)).constructor(PipelineOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentConfig").build()).build();

    private static final SdkField<PipelineOutputConfig> THUMBNAIL_CONFIG_FIELD = SdkField
            .<PipelineOutputConfig> builder(MarshallingType.SDK_POJO).getter(getter(Pipeline::thumbnailConfig))
            .setter(setter(Builder::thumbnailConfig)).constructor(PipelineOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThumbnailConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, STATUS_FIELD, INPUT_BUCKET_FIELD, OUTPUT_BUCKET_FIELD, ROLE_FIELD, AWS_KMS_KEY_ARN_FIELD,
            NOTIFICATIONS_FIELD, CONTENT_CONFIG_FIELD, THUMBNAIL_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final String status;

    private final String inputBucket;

    private final String outputBucket;

    private final String role;

    private final String awsKmsKeyArn;

    private final Notifications notifications;

    private final PipelineOutputConfig contentConfig;

    private final PipelineOutputConfig thumbnailConfig;

    private Pipeline(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.status = builder.status;
        this.inputBucket = builder.inputBucket;
        this.outputBucket = builder.outputBucket;
        this.role = builder.role;
        this.awsKmsKeyArn = builder.awsKmsKeyArn;
        this.notifications = builder.notifications;
        this.contentConfig = builder.contentConfig;
        this.thumbnailConfig = builder.thumbnailConfig;
    }

    /**
     * <p>
     * The identifier for the pipeline. You use this value to identify the pipeline in which you want to perform a
     * variety of operations, such as creating a job or a preset.
     * </p>
     * 
     * @return The identifier for the pipeline. You use this value to identify the pipeline in which you want to perform
     *         a variety of operations, such as creating a job or a preset.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the pipeline.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the pipeline. We recommend that the name be unique within the AWS account, but uniqueness is not
     * enforced.
     * </p>
     * <p>
     * Constraints: Maximum 40 characters
     * </p>
     * 
     * @return The name of the pipeline. We recommend that the name be unique within the AWS account, but uniqueness is
     *         not enforced.</p>
     *         <p>
     *         Constraints: Maximum 40 characters
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The current status of the pipeline:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Active</code>: The pipeline is processing jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Paused</code>: The pipeline is not currently processing jobs.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The current status of the pipeline:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Active</code>: The pipeline is processing jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Paused</code>: The pipeline is not currently processing jobs.
     *         </p>
     *         </li>
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The Amazon S3 bucket from which Elastic Transcoder gets media files for transcoding and the graphics files, if
     * any, that you want to use for watermarks.
     * </p>
     * 
     * @return The Amazon S3 bucket from which Elastic Transcoder gets media files for transcoding and the graphics
     *         files, if any, that you want to use for watermarks.
     */
    public String inputBucket() {
        return inputBucket;
    }

    /**
     * <p>
     * The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files, thumbnails, and playlists.
     * Either you specify this value, or you specify both <code>ContentConfig</code> and <code>ThumbnailConfig</code>.
     * </p>
     * 
     * @return The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files, thumbnails, and
     *         playlists. Either you specify this value, or you specify both <code>ContentConfig</code> and
     *         <code>ThumbnailConfig</code>.
     */
    public String outputBucket() {
        return outputBucket;
    }

    /**
     * <p>
     * The IAM Amazon Resource Name (ARN) for the role that Elastic Transcoder uses to transcode jobs for this pipeline.
     * </p>
     * 
     * @return The IAM Amazon Resource Name (ARN) for the role that Elastic Transcoder uses to transcode jobs for this
     *         pipeline.
     */
    public String role() {
        return role;
    }

    /**
     * <p>
     * The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.
     * </p>
     * <p>
     * If you use either <code>s3</code> or <code>s3-aws-kms</code> as your <code>Encryption:Mode</code>, you don't need
     * to provide a key with your job because a default key, known as an AWS-KMS key, is created for you automatically.
     * You need to provide an AWS-KMS key only if you want to use a non-default AWS-KMS key, or if you are using an
     * <code>Encryption:Mode</code> of <code>aes-cbc-pkcs7</code>, <code>aes-ctr</code>, or <code>aes-gcm</code>.
     * </p>
     * 
     * @return The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.</p>
     *         <p>
     *         If you use either <code>s3</code> or <code>s3-aws-kms</code> as your <code>Encryption:Mode</code>, you
     *         don't need to provide a key with your job because a default key, known as an AWS-KMS key, is created for
     *         you automatically. You need to provide an AWS-KMS key only if you want to use a non-default AWS-KMS key,
     *         or if you are using an <code>Encryption:Mode</code> of <code>aes-cbc-pkcs7</code>, <code>aes-ctr</code>,
     *         or <code>aes-gcm</code>.
     */
    public String awsKmsKeyArn() {
        return awsKmsKeyArn;
    }

    /**
     * <p>
     * The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status.
     * </p>
     * <important>
     * <p>
     * To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.
     * </p>
     * </important>
     * <ul>
     * <li>
     * <p>
     * <b>Progressing</b> (optional): The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify
     * when Elastic Transcoder has started to process the job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Complete</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder has finished
     * processing the job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Warning</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder encounters a
     * warning condition.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error
     * condition.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job
     *         status.</p> <important>
     *         <p>
     *         To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.
     *         </p>
     *         </important>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Progressing</b> (optional): The Amazon Simple Notification Service (Amazon SNS) topic that you want to
     *         notify when Elastic Transcoder has started to process the job.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Complete</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder has
     *         finished processing the job.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Warning</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder
     *         encounters a warning condition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Error</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder encounters
     *         an error condition.
     *         </p>
     *         </li>
     */
    public Notifications notifications() {
        return notifications;
    }

    /**
     * <p>
     * Information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and
     * playlists. Either you specify both <code>ContentConfig</code> and <code>ThumbnailConfig</code>, or you specify
     * <code>OutputBucket</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Permissions</b>: A list of the users and/or predefined Amazon S3 groups you want to have access to transcoded
     * files and playlists, and the type of access that you want them to have.
     * </p>
     * <ul>
     * <li>
     * <p>
     * GranteeType: The type of value that appears in the <code>Grantee</code> object:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity for an
     * Amazon CloudFront distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Email</code>: The registered email address of an AWS account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>,
     * <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>Grantee</code>: The AWS user or group that you want to have access to transcoded files and playlists.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Access</code>: The permission that you want to give to the AWS user that is listed in <code>Grantee</code>.
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READ</code>: The grantee can read the objects and metadata for objects that Elastic Transcoder adds to the
     * Amazon S3 bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READ_ACP</code>: The grantee can read the object ACL for objects that Elastic Transcoder adds to the Amazon
     * S3 bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WRITE_ACP</code>: The grantee can write the ACL for the objects that Elastic Transcoder adds to the Amazon
     * S3 bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and <code>WRITE_ACP</code>
     * permissions for the objects that Elastic Transcoder adds to the Amazon S3 bucket.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>StorageClass</b>: The Amazon S3 storage class, Standard or ReducedRedundancy, that you want Elastic Transcoder
     * to assign to the video files and playlists that it stores in your Amazon S3 bucket.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and
     *         playlists. Either you specify both <code>ContentConfig</code> and <code>ThumbnailConfig</code>, or you
     *         specify <code>OutputBucket</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and
     *         playlists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Permissions</b>: A list of the users and/or predefined Amazon S3 groups you want to have access to
     *         transcoded files and playlists, and the type of access that you want them to have.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         GranteeType: The type of value that appears in the <code>Grantee</code> object:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity for
     *         an Amazon CloudFront distribution.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Email</code>: The registered email address of an AWS account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>,
     *         <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Grantee</code>: The AWS user or group that you want to have access to transcoded files and
     *         playlists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Access</code>: The permission that you want to give to the AWS user that is listed in
     *         <code>Grantee</code>. Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READ</code>: The grantee can read the objects and metadata for objects that Elastic Transcoder adds
     *         to the Amazon S3 bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READ_ACP</code>: The grantee can read the object ACL for objects that Elastic Transcoder adds to
     *         the Amazon S3 bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WRITE_ACP</code>: The grantee can write the ACL for the objects that Elastic Transcoder adds to the
     *         Amazon S3 bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and
     *         <code>WRITE_ACP</code> permissions for the objects that Elastic Transcoder adds to the Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>StorageClass</b>: The Amazon S3 storage class, Standard or ReducedRedundancy, that you want Elastic
     *         Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket.
     *         </p>
     *         </li>
     */
    public PipelineOutputConfig contentConfig() {
        return contentConfig;
    }

    /**
     * <p>
     * Information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. Either you
     * specify both <code>ContentConfig</code> and <code>ThumbnailConfig</code>, or you specify
     * <code>OutputBucket</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Bucket</code>: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Permissions</code>: A list of the users and/or predefined Amazon S3 groups you want to have access to
     * thumbnail files, and the type of access that you want them to have.
     * </p>
     * <ul>
     * <li>
     * <p>
     * GranteeType: The type of value that appears in the Grantee object:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity for an
     * Amazon CloudFront distribution.
     * </p>
     * <important>
     * <p>
     * A canonical user ID is not the same as an AWS account number.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <code>Email</code>: The registered email address of an AWS account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>,
     * <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>Grantee</code>: The AWS user or group that you want to have access to thumbnail files.
     * </p>
     * </li>
     * <li>
     * <p>
     * Access: The permission that you want to give to the AWS user that is listed in Grantee. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READ</code>: The grantee can read the thumbnails and metadata for thumbnails that Elastic Transcoder adds
     * to the Amazon S3 bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the
     * Amazon S3 bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the
     * Amazon S3 bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FULL_CONTROL</code>: The grantee has READ, READ_ACP, and WRITE_ACP permissions for the thumbnails that
     * Elastic Transcoder adds to the Amazon S3 bucket.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>StorageClass</code>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>,
     * that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.
     *         Either you specify both <code>ContentConfig</code> and <code>ThumbnailConfig</code>, or you specify
     *         <code>OutputBucket</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Bucket</code>: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Permissions</code>: A list of the users and/or predefined Amazon S3 groups you want to have access
     *         to thumbnail files, and the type of access that you want them to have.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         GranteeType: The type of value that appears in the Grantee object:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity for
     *         an Amazon CloudFront distribution.
     *         </p>
     *         <important>
     *         <p>
     *         A canonical user ID is not the same as an AWS account number.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         <code>Email</code>: The registered email address of an AWS account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>,
     *         <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Grantee</code>: The AWS user or group that you want to have access to thumbnail files.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Access: The permission that you want to give to the AWS user that is listed in Grantee. Valid values
     *         include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READ</code>: The grantee can read the thumbnails and metadata for thumbnails that Elastic
     *         Transcoder adds to the Amazon S3 bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to
     *         the Amazon S3 bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to
     *         the Amazon S3 bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FULL_CONTROL</code>: The grantee has READ, READ_ACP, and WRITE_ACP permissions for the thumbnails
     *         that Elastic Transcoder adds to the Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>StorageClass</code>: The Amazon S3 storage class, <code>Standard</code> or
     *         <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the thumbnails that it
     *         stores in your Amazon S3 bucket.
     *         </p>
     *         </li>
     */
    public PipelineOutputConfig thumbnailConfig() {
        return thumbnailConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(inputBucket());
        hashCode = 31 * hashCode + Objects.hashCode(outputBucket());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(awsKmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(notifications());
        hashCode = 31 * hashCode + Objects.hashCode(contentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(thumbnailConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pipeline)) {
            return false;
        }
        Pipeline other = (Pipeline) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(status(), other.status()) && Objects.equals(inputBucket(), other.inputBucket())
                && Objects.equals(outputBucket(), other.outputBucket()) && Objects.equals(role(), other.role())
                && Objects.equals(awsKmsKeyArn(), other.awsKmsKeyArn()) && Objects.equals(notifications(), other.notifications())
                && Objects.equals(contentConfig(), other.contentConfig())
                && Objects.equals(thumbnailConfig(), other.thumbnailConfig());
    }

    @Override
    public String toString() {
        return ToString.builder("Pipeline").add("Id", id()).add("Arn", arn()).add("Name", name()).add("Status", status())
                .add("InputBucket", inputBucket()).add("OutputBucket", outputBucket()).add("Role", role())
                .add("AwsKmsKeyArn", awsKmsKeyArn()).add("Notifications", notifications()).add("ContentConfig", contentConfig())
                .add("ThumbnailConfig", thumbnailConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "InputBucket":
            return Optional.ofNullable(clazz.cast(inputBucket()));
        case "OutputBucket":
            return Optional.ofNullable(clazz.cast(outputBucket()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "AwsKmsKeyArn":
            return Optional.ofNullable(clazz.cast(awsKmsKeyArn()));
        case "Notifications":
            return Optional.ofNullable(clazz.cast(notifications()));
        case "ContentConfig":
            return Optional.ofNullable(clazz.cast(contentConfig()));
        case "ThumbnailConfig":
            return Optional.ofNullable(clazz.cast(thumbnailConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Pipeline, T> g) {
        return obj -> g.apply((Pipeline) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Pipeline> {
        /**
         * <p>
         * The identifier for the pipeline. You use this value to identify the pipeline in which you want to perform a
         * variety of operations, such as creating a job or a preset.
         * </p>
         * 
         * @param id
         *        The identifier for the pipeline. You use this value to identify the pipeline in which you want to
         *        perform a variety of operations, such as creating a job or a preset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the pipeline.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the pipeline. We recommend that the name be unique within the AWS account, but uniqueness is not
         * enforced.
         * </p>
         * <p>
         * Constraints: Maximum 40 characters
         * </p>
         * 
         * @param name
         *        The name of the pipeline. We recommend that the name be unique within the AWS account, but uniqueness
         *        is not enforced.</p>
         *        <p>
         *        Constraints: Maximum 40 characters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of the pipeline:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Active</code>: The pipeline is processing jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Paused</code>: The pipeline is not currently processing jobs.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the pipeline:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Active</code>: The pipeline is processing jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Paused</code>: The pipeline is not currently processing jobs.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The Amazon S3 bucket from which Elastic Transcoder gets media files for transcoding and the graphics files,
         * if any, that you want to use for watermarks.
         * </p>
         * 
         * @param inputBucket
         *        The Amazon S3 bucket from which Elastic Transcoder gets media files for transcoding and the graphics
         *        files, if any, that you want to use for watermarks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputBucket(String inputBucket);

        /**
         * <p>
         * The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files, thumbnails, and
         * playlists. Either you specify this value, or you specify both <code>ContentConfig</code> and
         * <code>ThumbnailConfig</code>.
         * </p>
         * 
         * @param outputBucket
         *        The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files, thumbnails, and
         *        playlists. Either you specify this value, or you specify both <code>ContentConfig</code> and
         *        <code>ThumbnailConfig</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputBucket(String outputBucket);

        /**
         * <p>
         * The IAM Amazon Resource Name (ARN) for the role that Elastic Transcoder uses to transcode jobs for this
         * pipeline.
         * </p>
         * 
         * @param role
         *        The IAM Amazon Resource Name (ARN) for the role that Elastic Transcoder uses to transcode jobs for
         *        this pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.
         * </p>
         * <p>
         * If you use either <code>s3</code> or <code>s3-aws-kms</code> as your <code>Encryption:Mode</code>, you don't
         * need to provide a key with your job because a default key, known as an AWS-KMS key, is created for you
         * automatically. You need to provide an AWS-KMS key only if you want to use a non-default AWS-KMS key, or if
         * you are using an <code>Encryption:Mode</code> of <code>aes-cbc-pkcs7</code>, <code>aes-ctr</code>, or
         * <code>aes-gcm</code>.
         * </p>
         * 
         * @param awsKmsKeyArn
         *        The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.</p>
         *        <p>
         *        If you use either <code>s3</code> or <code>s3-aws-kms</code> as your <code>Encryption:Mode</code>, you
         *        don't need to provide a key with your job because a default key, known as an AWS-KMS key, is created
         *        for you automatically. You need to provide an AWS-KMS key only if you want to use a non-default
         *        AWS-KMS key, or if you are using an <code>Encryption:Mode</code> of <code>aes-cbc-pkcs7</code>,
         *        <code>aes-ctr</code>, or <code>aes-gcm</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsKmsKeyArn(String awsKmsKeyArn);

        /**
         * <p>
         * The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status.
         * </p>
         * <important>
         * <p>
         * To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.
         * </p>
         * </important>
         * <ul>
         * <li>
         * <p>
         * <b>Progressing</b> (optional): The Amazon Simple Notification Service (Amazon SNS) topic that you want to
         * notify when Elastic Transcoder has started to process the job.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Complete</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder has finished
         * processing the job.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Warning</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder encounters a
         * warning condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Error</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder encounters an
         * error condition.
         * </p>
         * </li>
         * </ul>
         * 
         * @param notifications
         *        The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job
         *        status.</p> <important>
         *        <p>
         *        To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.
         *        </p>
         *        </important>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Progressing</b> (optional): The Amazon Simple Notification Service (Amazon SNS) topic that you want
         *        to notify when Elastic Transcoder has started to process the job.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Complete</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder has
         *        finished processing the job.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Warning</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder
         *        encounters a warning condition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Error</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder
         *        encounters an error condition.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notifications(Notifications notifications);

        /**
         * <p>
         * The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status.
         * </p>
         * <important>
         * <p>
         * To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.
         * </p>
         * </important>
         * <ul>
         * <li>
         * <p>
         * <b>Progressing</b> (optional): The Amazon Simple Notification Service (Amazon SNS) topic that you want to
         * notify when Elastic Transcoder has started to process the job.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Complete</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder has finished
         * processing the job.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Warning</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder encounters a
         * warning condition.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Error</b> (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder encounters an
         * error condition.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link Notifications.Builder} avoiding the need to
         * create one manually via {@link Notifications#builder()}.
         *
         * When the {@link Consumer} completes, {@link Notifications.Builder#build()} is called immediately and its
         * result is passed to {@link #notifications(Notifications)}.
         * 
         * @param notifications
         *        a consumer that will call methods on {@link Notifications.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notifications(Notifications)
         */
        default Builder notifications(Consumer<Notifications.Builder> notifications) {
            return notifications(Notifications.builder().applyMutation(notifications).build());
        }

        /**
         * <p>
         * Information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and
         * playlists. Either you specify both <code>ContentConfig</code> and <code>ThumbnailConfig</code>, or you
         * specify <code>OutputBucket</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and
         * playlists.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Permissions</b>: A list of the users and/or predefined Amazon S3 groups you want to have access to
         * transcoded files and playlists, and the type of access that you want them to have.
         * </p>
         * <ul>
         * <li>
         * <p>
         * GranteeType: The type of value that appears in the <code>Grantee</code> object:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity for an
         * Amazon CloudFront distribution.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Email</code>: The registered email address of an AWS account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>,
         * <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>Grantee</code>: The AWS user or group that you want to have access to transcoded files and playlists.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Access</code>: The permission that you want to give to the AWS user that is listed in
         * <code>Grantee</code>. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READ</code>: The grantee can read the objects and metadata for objects that Elastic Transcoder adds to
         * the Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READ_ACP</code>: The grantee can read the object ACL for objects that Elastic Transcoder adds to the
         * Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WRITE_ACP</code>: The grantee can write the ACL for the objects that Elastic Transcoder adds to the
         * Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and
         * <code>WRITE_ACP</code> permissions for the objects that Elastic Transcoder adds to the Amazon S3 bucket.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>StorageClass</b>: The Amazon S3 storage class, Standard or ReducedRedundancy, that you want Elastic
         * Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket.
         * </p>
         * </li>
         * </ul>
         * 
         * @param contentConfig
         *        Information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files
         *        and playlists. Either you specify both <code>ContentConfig</code> and <code>ThumbnailConfig</code>, or
         *        you specify <code>OutputBucket</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and
         *        playlists.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Permissions</b>: A list of the users and/or predefined Amazon S3 groups you want to have access to
         *        transcoded files and playlists, and the type of access that you want them to have.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        GranteeType: The type of value that appears in the <code>Grantee</code> object:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity
         *        for an Amazon CloudFront distribution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Email</code>: The registered email address of an AWS account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>,
         *        <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Grantee</code>: The AWS user or group that you want to have access to transcoded files and
         *        playlists.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Access</code>: The permission that you want to give to the AWS user that is listed in
         *        <code>Grantee</code>. Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READ</code>: The grantee can read the objects and metadata for objects that Elastic Transcoder
         *        adds to the Amazon S3 bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READ_ACP</code>: The grantee can read the object ACL for objects that Elastic Transcoder adds to
         *        the Amazon S3 bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WRITE_ACP</code>: The grantee can write the ACL for the objects that Elastic Transcoder adds to
         *        the Amazon S3 bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and
         *        <code>WRITE_ACP</code> permissions for the objects that Elastic Transcoder adds to the Amazon S3
         *        bucket.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>StorageClass</b>: The Amazon S3 storage class, Standard or ReducedRedundancy, that you want Elastic
         *        Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentConfig(PipelineOutputConfig contentConfig);

        /**
         * <p>
         * Information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and
         * playlists. Either you specify both <code>ContentConfig</code> and <code>ThumbnailConfig</code>, or you
         * specify <code>OutputBucket</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and
         * playlists.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Permissions</b>: A list of the users and/or predefined Amazon S3 groups you want to have access to
         * transcoded files and playlists, and the type of access that you want them to have.
         * </p>
         * <ul>
         * <li>
         * <p>
         * GranteeType: The type of value that appears in the <code>Grantee</code> object:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity for an
         * Amazon CloudFront distribution.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Email</code>: The registered email address of an AWS account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>,
         * <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>Grantee</code>: The AWS user or group that you want to have access to transcoded files and playlists.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Access</code>: The permission that you want to give to the AWS user that is listed in
         * <code>Grantee</code>. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READ</code>: The grantee can read the objects and metadata for objects that Elastic Transcoder adds to
         * the Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READ_ACP</code>: The grantee can read the object ACL for objects that Elastic Transcoder adds to the
         * Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WRITE_ACP</code>: The grantee can write the ACL for the objects that Elastic Transcoder adds to the
         * Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and
         * <code>WRITE_ACP</code> permissions for the objects that Elastic Transcoder adds to the Amazon S3 bucket.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>StorageClass</b>: The Amazon S3 storage class, Standard or ReducedRedundancy, that you want Elastic
         * Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link PipelineOutputConfig.Builder} avoiding the need
         * to create one manually via {@link PipelineOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link PipelineOutputConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #contentConfig(PipelineOutputConfig)}.
         * 
         * @param contentConfig
         *        a consumer that will call methods on {@link PipelineOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentConfig(PipelineOutputConfig)
         */
        default Builder contentConfig(Consumer<PipelineOutputConfig.Builder> contentConfig) {
            return contentConfig(PipelineOutputConfig.builder().applyMutation(contentConfig).build());
        }

        /**
         * <p>
         * Information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. Either
         * you specify both <code>ContentConfig</code> and <code>ThumbnailConfig</code>, or you specify
         * <code>OutputBucket</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Bucket</code>: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Permissions</code>: A list of the users and/or predefined Amazon S3 groups you want to have access to
         * thumbnail files, and the type of access that you want them to have.
         * </p>
         * <ul>
         * <li>
         * <p>
         * GranteeType: The type of value that appears in the Grantee object:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity for an
         * Amazon CloudFront distribution.
         * </p>
         * <important>
         * <p>
         * A canonical user ID is not the same as an AWS account number.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <code>Email</code>: The registered email address of an AWS account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>,
         * <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>Grantee</code>: The AWS user or group that you want to have access to thumbnail files.
         * </p>
         * </li>
         * <li>
         * <p>
         * Access: The permission that you want to give to the AWS user that is listed in Grantee. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READ</code>: The grantee can read the thumbnails and metadata for thumbnails that Elastic Transcoder
         * adds to the Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the
         * Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the
         * Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FULL_CONTROL</code>: The grantee has READ, READ_ACP, and WRITE_ACP permissions for the thumbnails that
         * Elastic Transcoder adds to the Amazon S3 bucket.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>StorageClass</code>: The Amazon S3 storage class, <code>Standard</code> or
         * <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the thumbnails that it stores
         * in your Amazon S3 bucket.
         * </p>
         * </li>
         * </ul>
         * 
         * @param thumbnailConfig
         *        Information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.
         *        Either you specify both <code>ContentConfig</code> and <code>ThumbnailConfig</code>, or you specify
         *        <code>OutputBucket</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Bucket</code>: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail
         *        files.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Permissions</code>: A list of the users and/or predefined Amazon S3 groups you want to have
         *        access to thumbnail files, and the type of access that you want them to have.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        GranteeType: The type of value that appears in the Grantee object:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity
         *        for an Amazon CloudFront distribution.
         *        </p>
         *        <important>
         *        <p>
         *        A canonical user ID is not the same as an AWS account number.
         *        </p>
         *        </important></li>
         *        <li>
         *        <p>
         *        <code>Email</code>: The registered email address of an AWS account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>,
         *        <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Grantee</code>: The AWS user or group that you want to have access to thumbnail files.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Access: The permission that you want to give to the AWS user that is listed in Grantee. Valid values
         *        include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READ</code>: The grantee can read the thumbnails and metadata for thumbnails that Elastic
         *        Transcoder adds to the Amazon S3 bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds
         *        to the Amazon S3 bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds
         *        to the Amazon S3 bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FULL_CONTROL</code>: The grantee has READ, READ_ACP, and WRITE_ACP permissions for the
         *        thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>StorageClass</code>: The Amazon S3 storage class, <code>Standard</code> or
         *        <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the thumbnails that it
         *        stores in your Amazon S3 bucket.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailConfig(PipelineOutputConfig thumbnailConfig);

        /**
         * <p>
         * Information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. Either
         * you specify both <code>ContentConfig</code> and <code>ThumbnailConfig</code>, or you specify
         * <code>OutputBucket</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Bucket</code>: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Permissions</code>: A list of the users and/or predefined Amazon S3 groups you want to have access to
         * thumbnail files, and the type of access that you want them to have.
         * </p>
         * <ul>
         * <li>
         * <p>
         * GranteeType: The type of value that appears in the Grantee object:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Canonical</code>: Either the canonical user ID for an AWS account or an origin access identity for an
         * Amazon CloudFront distribution.
         * </p>
         * <important>
         * <p>
         * A canonical user ID is not the same as an AWS account number.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <code>Email</code>: The registered email address of an AWS account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Group</code>: One of the following predefined Amazon S3 groups: <code>AllUsers</code>,
         * <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>Grantee</code>: The AWS user or group that you want to have access to thumbnail files.
         * </p>
         * </li>
         * <li>
         * <p>
         * Access: The permission that you want to give to the AWS user that is listed in Grantee. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READ</code>: The grantee can read the thumbnails and metadata for thumbnails that Elastic Transcoder
         * adds to the Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the
         * Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the
         * Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FULL_CONTROL</code>: The grantee has READ, READ_ACP, and WRITE_ACP permissions for the thumbnails that
         * Elastic Transcoder adds to the Amazon S3 bucket.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>StorageClass</code>: The Amazon S3 storage class, <code>Standard</code> or
         * <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the thumbnails that it stores
         * in your Amazon S3 bucket.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link PipelineOutputConfig.Builder} avoiding the need
         * to create one manually via {@link PipelineOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link PipelineOutputConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #thumbnailConfig(PipelineOutputConfig)}.
         * 
         * @param thumbnailConfig
         *        a consumer that will call methods on {@link PipelineOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thumbnailConfig(PipelineOutputConfig)
         */
        default Builder thumbnailConfig(Consumer<PipelineOutputConfig.Builder> thumbnailConfig) {
            return thumbnailConfig(PipelineOutputConfig.builder().applyMutation(thumbnailConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String status;

        private String inputBucket;

        private String outputBucket;

        private String role;

        private String awsKmsKeyArn;

        private Notifications notifications;

        private PipelineOutputConfig contentConfig;

        private PipelineOutputConfig thumbnailConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Pipeline model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            status(model.status);
            inputBucket(model.inputBucket);
            outputBucket(model.outputBucket);
            role(model.role);
            awsKmsKeyArn(model.awsKmsKeyArn);
            notifications(model.notifications);
            contentConfig(model.contentConfig);
            thumbnailConfig(model.thumbnailConfig);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getInputBucket() {
            return inputBucket;
        }

        @Override
        public final Builder inputBucket(String inputBucket) {
            this.inputBucket = inputBucket;
            return this;
        }

        public final void setInputBucket(String inputBucket) {
            this.inputBucket = inputBucket;
        }

        public final String getOutputBucket() {
            return outputBucket;
        }

        @Override
        public final Builder outputBucket(String outputBucket) {
            this.outputBucket = outputBucket;
            return this;
        }

        public final void setOutputBucket(String outputBucket) {
            this.outputBucket = outputBucket;
        }

        public final String getRole() {
            return role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getAwsKmsKeyArn() {
            return awsKmsKeyArn;
        }

        @Override
        public final Builder awsKmsKeyArn(String awsKmsKeyArn) {
            this.awsKmsKeyArn = awsKmsKeyArn;
            return this;
        }

        public final void setAwsKmsKeyArn(String awsKmsKeyArn) {
            this.awsKmsKeyArn = awsKmsKeyArn;
        }

        public final Notifications.Builder getNotifications() {
            return notifications != null ? notifications.toBuilder() : null;
        }

        @Override
        public final Builder notifications(Notifications notifications) {
            this.notifications = notifications;
            return this;
        }

        public final void setNotifications(Notifications.BuilderImpl notifications) {
            this.notifications = notifications != null ? notifications.build() : null;
        }

        public final PipelineOutputConfig.Builder getContentConfig() {
            return contentConfig != null ? contentConfig.toBuilder() : null;
        }

        @Override
        public final Builder contentConfig(PipelineOutputConfig contentConfig) {
            this.contentConfig = contentConfig;
            return this;
        }

        public final void setContentConfig(PipelineOutputConfig.BuilderImpl contentConfig) {
            this.contentConfig = contentConfig != null ? contentConfig.build() : null;
        }

        public final PipelineOutputConfig.Builder getThumbnailConfig() {
            return thumbnailConfig != null ? thumbnailConfig.toBuilder() : null;
        }

        @Override
        public final Builder thumbnailConfig(PipelineOutputConfig thumbnailConfig) {
            this.thumbnailConfig = thumbnailConfig;
            return this;
        }

        public final void setThumbnailConfig(PipelineOutputConfig.BuilderImpl thumbnailConfig) {
            this.thumbnailConfig = thumbnailConfig != null ? thumbnailConfig.build() : null;
        }

        @Override
        public Pipeline build() {
            return new Pipeline(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
