/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elastictranscoder.model.Encryption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CaptionSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CaptionSource> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CaptionSource.getter(CaptionSource::key)).setter(CaptionSource.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CaptionSource.getter(CaptionSource::language)).setter(CaptionSource.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()}).build();
    private static final SdkField<String> TIME_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CaptionSource.getter(CaptionSource::timeOffset)).setter(CaptionSource.setter(Builder::timeOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeOffset").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CaptionSource.getter(CaptionSource::label)).setter(CaptionSource.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()}).build();
    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CaptionSource.getter(CaptionSource::encryption)).setter(CaptionSource.setter(Builder::encryption)).constructor(Encryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, LANGUAGE_FIELD, TIME_OFFSET_FIELD, LABEL_FIELD, ENCRYPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String key;
    private final String language;
    private final String timeOffset;
    private final String label;
    private final Encryption encryption;

    private CaptionSource(BuilderImpl builder) {
        this.key = builder.key;
        this.language = builder.language;
        this.timeOffset = builder.timeOffset;
        this.label = builder.label;
        this.encryption = builder.encryption;
    }

    public String key() {
        return this.key;
    }

    public String language() {
        return this.language;
    }

    public String timeOffset() {
        return this.timeOffset;
    }

    public String label() {
        return this.label;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionSource)) {
            return false;
        }
        CaptionSource other = (CaptionSource)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.language(), other.language()) && Objects.equals(this.timeOffset(), other.timeOffset()) && Objects.equals(this.label(), other.label()) && Objects.equals(this.encryption(), other.encryption());
    }

    public String toString() {
        return ToString.builder((String)"CaptionSource").add("Key", (Object)this.key()).add("Language", (Object)this.language()).add("TimeOffset", (Object)this.timeOffset()).add("Label", (Object)this.label()).add("Encryption", (Object)this.encryption()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "Language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "TimeOffset": {
                return Optional.ofNullable(clazz.cast(this.timeOffset()));
            }
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CaptionSource, T> g) {
        return obj -> g.apply((CaptionSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private String language;
        private String timeOffset;
        private String label;
        private Encryption encryption;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionSource model) {
            this.key(model.key);
            this.language(model.language);
            this.timeOffset(model.timeOffset);
            this.label(model.label);
            this.encryption(model.encryption);
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getLanguage() {
            return this.language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        public final String getTimeOffset() {
            return this.timeOffset;
        }

        @Override
        public final Builder timeOffset(String timeOffset) {
            this.timeOffset = timeOffset;
            return this;
        }

        public final void setTimeOffset(String timeOffset) {
            this.timeOffset = timeOffset;
        }

        public final String getLabel() {
            return this.label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final Encryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public CaptionSource build() {
            return new CaptionSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CaptionSource> {
        public Builder key(String var1);

        public Builder language(String var1);

        public Builder timeOffset(String var1);

        public Builder label(String var1);

        public Builder encryption(Encryption var1);

        default public Builder encryption(Consumer<Encryption.Builder> encryption) {
            return this.encryption((Encryption)((Encryption.Builder)Encryption.builder().applyMutation(encryption)).build());
        }
    }
}

