/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elastictranscoder.ElasticTranscoderClient;
import software.amazon.awssdk.services.elastictranscoder.model.ListPresetsRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ListPresetsResponse;
import software.amazon.awssdk.services.elastictranscoder.model.Preset;

public class ListPresetsIterable
implements SdkIterable<ListPresetsResponse> {
    private final ElasticTranscoderClient client;
    private final ListPresetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPresetsIterable(ElasticTranscoderClient client, ListPresetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPresetsResponseFetcher();
    }

    public Iterator<ListPresetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Preset> presets() {
        Function<ListPresetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.presets() != null) {
                return response.presets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListPresetsIterable resume(ListPresetsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPresetsIterable(this.client, (ListPresetsRequest)((Object)this.firstRequest.toBuilder().pageToken(lastSuccessfulPage.nextPageToken()).build()));
        }
        return new ListPresetsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListPresetsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListPresetsResponseFetcher
    implements SyncPageFetcher<ListPresetsResponse> {
        private ListPresetsResponseFetcher() {
        }

        public boolean hasNextPage(ListPresetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public ListPresetsResponse nextPage(ListPresetsResponse previousPage) {
            if (previousPage == null) {
                return ListPresetsIterable.this.client.listPresets(ListPresetsIterable.this.firstRequest);
            }
            return ListPresetsIterable.this.client.listPresets((ListPresetsRequest)((Object)ListPresetsIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

