/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.elastictranscoder.ElasticTranscoderAsyncClient;
import software.amazon.awssdk.services.elastictranscoder.ElasticTranscoderServiceClientConfiguration;
import software.amazon.awssdk.services.elastictranscoder.internal.ElasticTranscoderServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.elastictranscoder.model.AccessDeniedException;
import software.amazon.awssdk.services.elastictranscoder.model.CancelJobRequest;
import software.amazon.awssdk.services.elastictranscoder.model.CancelJobResponse;
import software.amazon.awssdk.services.elastictranscoder.model.CreateJobRequest;
import software.amazon.awssdk.services.elastictranscoder.model.CreateJobResponse;
import software.amazon.awssdk.services.elastictranscoder.model.CreatePipelineRequest;
import software.amazon.awssdk.services.elastictranscoder.model.CreatePipelineResponse;
import software.amazon.awssdk.services.elastictranscoder.model.CreatePresetRequest;
import software.amazon.awssdk.services.elastictranscoder.model.CreatePresetResponse;
import software.amazon.awssdk.services.elastictranscoder.model.DeletePipelineRequest;
import software.amazon.awssdk.services.elastictranscoder.model.DeletePipelineResponse;
import software.amazon.awssdk.services.elastictranscoder.model.DeletePresetRequest;
import software.amazon.awssdk.services.elastictranscoder.model.DeletePresetResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ElasticTranscoderException;
import software.amazon.awssdk.services.elastictranscoder.model.IncompatibleVersionException;
import software.amazon.awssdk.services.elastictranscoder.model.InternalServiceException;
import software.amazon.awssdk.services.elastictranscoder.model.LimitExceededException;
import software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ListPresetsRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ListPresetsResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ReadJobRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ReadJobResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ReadPipelineRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ReadPipelineResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ReadPresetRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ReadPresetResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ResourceInUseException;
import software.amazon.awssdk.services.elastictranscoder.model.ResourceNotFoundException;
import software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineNotificationsRequest;
import software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineNotificationsResponse;
import software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineRequest;
import software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineResponse;
import software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineStatusRequest;
import software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineStatusResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ValidationException;
import software.amazon.awssdk.services.elastictranscoder.transform.CancelJobRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.CreateJobRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.CreatePipelineRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.CreatePresetRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.DeletePipelineRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.DeletePresetRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.ListJobsByPipelineRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.ListJobsByStatusRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.ListPipelinesRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.ListPresetsRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.ReadJobRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.ReadPipelineRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.ReadPresetRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.UpdatePipelineNotificationsRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.UpdatePipelineRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.UpdatePipelineStatusRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.waiters.ElasticTranscoderAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultElasticTranscoderAsyncClient
implements ElasticTranscoderAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultElasticTranscoderAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final ScheduledExecutorService executorService;

    protected DefaultElasticTranscoderAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Elastic_Transcoder#2.31.76").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = (ScheduledExecutorService)clientConfiguration.option((ClientOption)SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    @Override
    public CompletableFuture<CancelJobResponse> cancelJob(CancelJobRequest cancelJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticTranscoderAsyncClient.resolveMetricPublishers(clientConfiguration, cancelJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Transcoder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IncompatibleVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleVersionException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CancelJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)cancelJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticTranscoderAsyncClient.lambda$cancelJob$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticTranscoderAsyncClient.lambda$cancelJob$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateJobResponse> createJob(CreateJobRequest createJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticTranscoderAsyncClient.resolveMetricPublishers(clientConfiguration, createJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Transcoder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IncompatibleVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleVersionException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticTranscoderAsyncClient.lambda$createJob$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticTranscoderAsyncClient.lambda$createJob$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreatePipelineResponse> createPipeline(CreatePipelineRequest createPipelineRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticTranscoderAsyncClient.resolveMetricPublishers(clientConfiguration, createPipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Transcoder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePipelineResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IncompatibleVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleVersionException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreatePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createPipelineRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticTranscoderAsyncClient.lambda$createPipeline$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticTranscoderAsyncClient.lambda$createPipeline$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreatePresetResponse> createPreset(CreatePresetRequest createPresetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPresetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticTranscoderAsyncClient.resolveMetricPublishers(clientConfiguration, createPresetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Transcoder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePreset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePresetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IncompatibleVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleVersionException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePreset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreatePresetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createPresetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticTranscoderAsyncClient.lambda$createPreset$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticTranscoderAsyncClient.lambda$createPreset$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeletePipelineResponse> deletePipeline(DeletePipelineRequest deletePipelineRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticTranscoderAsyncClient.resolveMetricPublishers(clientConfiguration, deletePipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Transcoder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePipelineResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IncompatibleVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleVersionException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeletePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deletePipelineRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticTranscoderAsyncClient.lambda$deletePipeline$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticTranscoderAsyncClient.lambda$deletePipeline$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeletePresetResponse> deletePreset(DeletePresetRequest deletePresetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePresetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticTranscoderAsyncClient.resolveMetricPublishers(clientConfiguration, deletePresetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Transcoder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePreset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePresetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IncompatibleVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleVersionException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePreset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeletePresetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deletePresetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticTranscoderAsyncClient.lambda$deletePreset$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticTranscoderAsyncClient.lambda$deletePreset$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListJobsByPipelineResponse> listJobsByPipeline(ListJobsByPipelineRequest listJobsByPipelineRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listJobsByPipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticTranscoderAsyncClient.resolveMetricPublishers(clientConfiguration, listJobsByPipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Transcoder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListJobsByPipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListJobsByPipelineResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IncompatibleVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleVersionException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListJobsByPipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListJobsByPipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listJobsByPipelineRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticTranscoderAsyncClient.lambda$listJobsByPipeline$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticTranscoderAsyncClient.lambda$listJobsByPipeline$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListJobsByStatusResponse> listJobsByStatus(ListJobsByStatusRequest listJobsByStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listJobsByStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticTranscoderAsyncClient.resolveMetricPublishers(clientConfiguration, listJobsByStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Transcoder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListJobsByStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListJobsByStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IncompatibleVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleVersionException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListJobsByStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListJobsByStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listJobsByStatusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticTranscoderAsyncClient.lambda$listJobsByStatus$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticTranscoderAsyncClient.lambda$listJobsByStatus$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListPipelinesResponse> listPipelines(ListPipelinesRequest listPipelinesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPipelinesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticTranscoderAsyncClient.resolveMetricPublishers(clientConfiguration, listPipelinesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Transcoder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPipelines");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPipelinesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IncompatibleVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleVersionException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPipelines").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListPipelinesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listPipelinesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticTranscoderAsyncClient.lambda$listPipelines$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticTranscoderAsyncClient.lambda$listPipelines$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListPresetsResponse> listPresets(ListPresetsRequest listPresetsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPresetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticTranscoderAsyncClient.resolveMetricPublishers(clientConfiguration, listPresetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Transcoder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPresets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPresetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IncompatibleVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleVersionException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPresets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListPresetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listPresetsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticTranscoderAsyncClient.lambda$listPresets$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticTranscoderAsyncClient.lambda$listPresets$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ReadJobResponse> readJob(ReadJobRequest readJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)readJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticTranscoderAsyncClient.resolveMetricPublishers(clientConfiguration, readJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Transcoder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReadJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReadJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IncompatibleVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleVersionException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReadJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ReadJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)readJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticTranscoderAsyncClient.lambda$readJob$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticTranscoderAsyncClient.lambda$readJob$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ReadPipelineResponse> readPipeline(ReadPipelineRequest readPipelineRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)readPipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticTranscoderAsyncClient.resolveMetricPublishers(clientConfiguration, readPipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Transcoder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReadPipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReadPipelineResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IncompatibleVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleVersionException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReadPipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ReadPipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)readPipelineRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticTranscoderAsyncClient.lambda$readPipeline$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticTranscoderAsyncClient.lambda$readPipeline$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ReadPresetResponse> readPreset(ReadPresetRequest readPresetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)readPresetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticTranscoderAsyncClient.resolveMetricPublishers(clientConfiguration, readPresetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Transcoder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ReadPreset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReadPresetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IncompatibleVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleVersionException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReadPreset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ReadPresetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)readPresetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticTranscoderAsyncClient.lambda$readPreset$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticTranscoderAsyncClient.lambda$readPreset$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdatePipelineResponse> updatePipeline(UpdatePipelineRequest updatePipelineRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updatePipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticTranscoderAsyncClient.resolveMetricPublishers(clientConfiguration, updatePipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Transcoder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePipeline");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePipelineResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IncompatibleVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleVersionException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdatePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updatePipelineRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticTranscoderAsyncClient.lambda$updatePipeline$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticTranscoderAsyncClient.lambda$updatePipeline$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdatePipelineNotificationsResponse> updatePipelineNotifications(UpdatePipelineNotificationsRequest updatePipelineNotificationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updatePipelineNotificationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticTranscoderAsyncClient.resolveMetricPublishers(clientConfiguration, updatePipelineNotificationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Transcoder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePipelineNotifications");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePipelineNotificationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IncompatibleVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleVersionException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePipelineNotifications").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdatePipelineNotificationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updatePipelineNotificationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticTranscoderAsyncClient.lambda$updatePipelineNotifications$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticTranscoderAsyncClient.lambda$updatePipelineNotifications$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdatePipelineStatusResponse> updatePipelineStatus(UpdatePipelineStatusRequest updatePipelineStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updatePipelineStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultElasticTranscoderAsyncClient.resolveMetricPublishers(clientConfiguration, updatePipelineStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Transcoder");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePipelineStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePipelineStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "IncompatibleVersionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleVersionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(IncompatibleVersionException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                    case "InternalServiceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePipelineStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdatePipelineStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updatePipelineStatusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultElasticTranscoderAsyncClient.lambda$updatePipelineStatus$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultElasticTranscoderAsyncClient.lambda$updatePipelineStatus$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ElasticTranscoderAsyncWaiter waiter() {
        return ElasticTranscoderAsyncWaiter.builder().client(this).scheduledExecutorService(this.executorService).build();
    }

    @Override
    public final ElasticTranscoderServiceClientConfiguration serviceClientConfiguration() {
        return new ElasticTranscoderServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "elastictranscoder";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ElasticTranscoderException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        ElasticTranscoderServiceClientConfigurationBuilder serviceConfigBuilder = new ElasticTranscoderServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updatePipelineStatus$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePipelineStatus$62(List metricPublishers, MetricCollector apiCallMetricCollector, UpdatePipelineStatusResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updatePipelineNotifications$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePipelineNotifications$58(List metricPublishers, MetricCollector apiCallMetricCollector, UpdatePipelineNotificationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updatePipeline$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePipeline$54(List metricPublishers, MetricCollector apiCallMetricCollector, UpdatePipelineResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$readPreset$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$readPreset$50(List metricPublishers, MetricCollector apiCallMetricCollector, ReadPresetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$readPipeline$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$readPipeline$46(List metricPublishers, MetricCollector apiCallMetricCollector, ReadPipelineResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$readJob$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$readJob$42(List metricPublishers, MetricCollector apiCallMetricCollector, ReadJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listPresets$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPresets$38(List metricPublishers, MetricCollector apiCallMetricCollector, ListPresetsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listPipelines$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPipelines$34(List metricPublishers, MetricCollector apiCallMetricCollector, ListPipelinesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listJobsByStatus$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listJobsByStatus$30(List metricPublishers, MetricCollector apiCallMetricCollector, ListJobsByStatusResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listJobsByPipeline$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listJobsByPipeline$26(List metricPublishers, MetricCollector apiCallMetricCollector, ListJobsByPipelineResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deletePreset$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePreset$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeletePresetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deletePipeline$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePipeline$18(List metricPublishers, MetricCollector apiCallMetricCollector, DeletePipelineResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createPreset$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPreset$14(List metricPublishers, MetricCollector apiCallMetricCollector, CreatePresetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createPipeline$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPipeline$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreatePipelineResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createJob$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createJob$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreateJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$cancelJob$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelJob$2(List metricPublishers, MetricCollector apiCallMetricCollector, CancelJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

