/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsContentProtection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HlsContentProtection> {
    private static final SdkField<String> METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsContentProtection.getter(HlsContentProtection::method)).setter(HlsContentProtection.setter(Builder::method)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Method").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsContentProtection.getter(HlsContentProtection::key)).setter(HlsContentProtection.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()}).build();
    private static final SdkField<String> KEY_MD5_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsContentProtection.getter(HlsContentProtection::keyMd5)).setter(HlsContentProtection.setter(Builder::keyMd5)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMd5").build()}).build();
    private static final SdkField<String> INITIALIZATION_VECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsContentProtection.getter(HlsContentProtection::initializationVector)).setter(HlsContentProtection.setter(Builder::initializationVector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitializationVector").build()}).build();
    private static final SdkField<String> LICENSE_ACQUISITION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsContentProtection.getter(HlsContentProtection::licenseAcquisitionUrl)).setter(HlsContentProtection.setter(Builder::licenseAcquisitionUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseAcquisitionUrl").build()}).build();
    private static final SdkField<String> KEY_STORAGE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsContentProtection.getter(HlsContentProtection::keyStoragePolicy)).setter(HlsContentProtection.setter(Builder::keyStoragePolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyStoragePolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METHOD_FIELD, KEY_FIELD, KEY_MD5_FIELD, INITIALIZATION_VECTOR_FIELD, LICENSE_ACQUISITION_URL_FIELD, KEY_STORAGE_POLICY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String method;
    private final String key;
    private final String keyMd5;
    private final String initializationVector;
    private final String licenseAcquisitionUrl;
    private final String keyStoragePolicy;

    private HlsContentProtection(BuilderImpl builder) {
        this.method = builder.method;
        this.key = builder.key;
        this.keyMd5 = builder.keyMd5;
        this.initializationVector = builder.initializationVector;
        this.licenseAcquisitionUrl = builder.licenseAcquisitionUrl;
        this.keyStoragePolicy = builder.keyStoragePolicy;
    }

    public String method() {
        return this.method;
    }

    public String key() {
        return this.key;
    }

    public String keyMd5() {
        return this.keyMd5;
    }

    public String initializationVector() {
        return this.initializationVector;
    }

    public String licenseAcquisitionUrl() {
        return this.licenseAcquisitionUrl;
    }

    public String keyStoragePolicy() {
        return this.keyStoragePolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.method());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyMd5());
        hashCode = 31 * hashCode + Objects.hashCode(this.initializationVector());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseAcquisitionUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyStoragePolicy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsContentProtection)) {
            return false;
        }
        HlsContentProtection other = (HlsContentProtection)obj;
        return Objects.equals(this.method(), other.method()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.keyMd5(), other.keyMd5()) && Objects.equals(this.initializationVector(), other.initializationVector()) && Objects.equals(this.licenseAcquisitionUrl(), other.licenseAcquisitionUrl()) && Objects.equals(this.keyStoragePolicy(), other.keyStoragePolicy());
    }

    public String toString() {
        return ToString.builder((String)"HlsContentProtection").add("Method", (Object)this.method()).add("Key", (Object)this.key()).add("KeyMd5", (Object)this.keyMd5()).add("InitializationVector", (Object)this.initializationVector()).add("LicenseAcquisitionUrl", (Object)this.licenseAcquisitionUrl()).add("KeyStoragePolicy", (Object)this.keyStoragePolicy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Method": {
                return Optional.ofNullable(clazz.cast(this.method()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "KeyMd5": {
                return Optional.ofNullable(clazz.cast(this.keyMd5()));
            }
            case "InitializationVector": {
                return Optional.ofNullable(clazz.cast(this.initializationVector()));
            }
            case "LicenseAcquisitionUrl": {
                return Optional.ofNullable(clazz.cast(this.licenseAcquisitionUrl()));
            }
            case "KeyStoragePolicy": {
                return Optional.ofNullable(clazz.cast(this.keyStoragePolicy()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsContentProtection, T> g) {
        return obj -> g.apply((HlsContentProtection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String method;
        private String key;
        private String keyMd5;
        private String initializationVector;
        private String licenseAcquisitionUrl;
        private String keyStoragePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsContentProtection model) {
            this.method(model.method);
            this.key(model.key);
            this.keyMd5(model.keyMd5);
            this.initializationVector(model.initializationVector);
            this.licenseAcquisitionUrl(model.licenseAcquisitionUrl);
            this.keyStoragePolicy(model.keyStoragePolicy);
        }

        public final String getMethod() {
            return this.method;
        }

        @Override
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getKeyMd5() {
            return this.keyMd5;
        }

        @Override
        public final Builder keyMd5(String keyMd5) {
            this.keyMd5 = keyMd5;
            return this;
        }

        public final void setKeyMd5(String keyMd5) {
            this.keyMd5 = keyMd5;
        }

        public final String getInitializationVector() {
            return this.initializationVector;
        }

        @Override
        public final Builder initializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
            return this;
        }

        public final void setInitializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
        }

        public final String getLicenseAcquisitionUrl() {
            return this.licenseAcquisitionUrl;
        }

        @Override
        public final Builder licenseAcquisitionUrl(String licenseAcquisitionUrl) {
            this.licenseAcquisitionUrl = licenseAcquisitionUrl;
            return this;
        }

        public final void setLicenseAcquisitionUrl(String licenseAcquisitionUrl) {
            this.licenseAcquisitionUrl = licenseAcquisitionUrl;
        }

        public final String getKeyStoragePolicy() {
            return this.keyStoragePolicy;
        }

        @Override
        public final Builder keyStoragePolicy(String keyStoragePolicy) {
            this.keyStoragePolicy = keyStoragePolicy;
            return this;
        }

        public final void setKeyStoragePolicy(String keyStoragePolicy) {
            this.keyStoragePolicy = keyStoragePolicy;
        }

        public HlsContentProtection build() {
            return new HlsContentProtection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HlsContentProtection> {
        public Builder method(String var1);

        public Builder key(String var1);

        public Builder keyMd5(String var1);

        public Builder initializationVector(String var1);

        public Builder licenseAcquisitionUrl(String var1);

        public Builder keyStoragePolicy(String var1);
    }
}

