/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elastictranscoder.model.ElasticTranscoderResponse;
import software.amazon.awssdk.services.elastictranscoder.model.Preset;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePresetResponse
extends ElasticTranscoderResponse
implements ToCopyableBuilder<Builder, CreatePresetResponse> {
    private static final SdkField<Preset> PRESET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreatePresetResponse.getter(CreatePresetResponse::preset)).setter(CreatePresetResponse.setter(Builder::preset)).constructor(Preset::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Preset").build()}).build();
    private static final SdkField<String> WARNING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreatePresetResponse.getter(CreatePresetResponse::warning)).setter(CreatePresetResponse.setter(Builder::warning)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warning").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRESET_FIELD, WARNING_FIELD));
    private final Preset preset;
    private final String warning;

    private CreatePresetResponse(BuilderImpl builder) {
        super(builder);
        this.preset = builder.preset;
        this.warning = builder.warning;
    }

    public Preset preset() {
        return this.preset;
    }

    public String warning() {
        return this.warning;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.preset());
        hashCode = 31 * hashCode + Objects.hashCode(this.warning());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePresetResponse)) {
            return false;
        }
        CreatePresetResponse other = (CreatePresetResponse)((Object)obj);
        return Objects.equals(this.preset(), other.preset()) && Objects.equals(this.warning(), other.warning());
    }

    public String toString() {
        return ToString.builder((String)"CreatePresetResponse").add("Preset", (Object)this.preset()).add("Warning", (Object)this.warning()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Preset": {
                return Optional.ofNullable(clazz.cast(this.preset()));
            }
            case "Warning": {
                return Optional.ofNullable(clazz.cast(this.warning()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePresetResponse, T> g) {
        return obj -> g.apply((CreatePresetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticTranscoderResponse.BuilderImpl
    implements Builder {
        private Preset preset;
        private String warning;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePresetResponse model) {
            super(model);
            this.preset(model.preset);
            this.warning(model.warning);
        }

        public final Preset.Builder getPreset() {
            return this.preset != null ? this.preset.toBuilder() : null;
        }

        @Override
        public final Builder preset(Preset preset) {
            this.preset = preset;
            return this;
        }

        public final void setPreset(Preset.BuilderImpl preset) {
            this.preset = preset != null ? preset.build() : null;
        }

        public final String getWarning() {
            return this.warning;
        }

        @Override
        public final Builder warning(String warning) {
            this.warning = warning;
            return this;
        }

        public final void setWarning(String warning) {
            this.warning = warning;
        }

        @Override
        public CreatePresetResponse build() {
            return new CreatePresetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticTranscoderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePresetResponse> {
        public Builder preset(Preset var1);

        default public Builder preset(Consumer<Preset.Builder> preset) {
            return this.preset((Preset)((Preset.Builder)Preset.builder().applyMutation(preset)).build());
        }

        public Builder warning(String var1);
    }
}

