/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.elastictranscoder.model.JobInput;
import software.amazon.awssdk.services.elastictranscoder.model.JobInputsCopier;
import software.amazon.awssdk.services.elastictranscoder.model.JobOutput;
import software.amazon.awssdk.services.elastictranscoder.model.JobOutputsCopier;
import software.amazon.awssdk.services.elastictranscoder.model.Playlist;
import software.amazon.awssdk.services.elastictranscoder.model.PlaylistsCopier;
import software.amazon.awssdk.services.elastictranscoder.model.Timing;
import software.amazon.awssdk.services.elastictranscoder.model.UserMetadataCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Job
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Job> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Job.getter(Job::id)).setter(Job.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Job.getter(Job::arn)).setter(Job.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> PIPELINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Job.getter(Job::pipelineId)).setter(Job.setter(Builder::pipelineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineId").build()}).build();
    private static final SdkField<JobInput> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Job.getter(Job::input)).setter(Job.setter(Builder::input)).constructor(JobInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()}).build();
    private static final SdkField<List<JobInput>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Job.getter(Job::inputs)).setter(Job.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<JobOutput> OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Job.getter(Job::output)).setter(Job.setter(Builder::output)).constructor(JobOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Output").build()}).build();
    private static final SdkField<List<JobOutput>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Job.getter(Job::outputs)).setter(Job.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OUTPUT_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Job.getter(Job::outputKeyPrefix)).setter(Job.setter(Builder::outputKeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputKeyPrefix").build()}).build();
    private static final SdkField<List<Playlist>> PLAYLISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Job.getter(Job::playlists)).setter(Job.setter(Builder::playlists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Playlists").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Playlist::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Job.getter(Job::status)).setter(Job.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Map<String, String>> USER_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Job.getter(Job::userMetadata)).setter(Job.setter(Builder::userMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Timing> TIMING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Job.getter(Job::timing)).setter(Job.setter(Builder::timing)).constructor(Timing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timing").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, PIPELINE_ID_FIELD, INPUT_FIELD, INPUTS_FIELD, OUTPUT_FIELD, OUTPUTS_FIELD, OUTPUT_KEY_PREFIX_FIELD, PLAYLISTS_FIELD, STATUS_FIELD, USER_METADATA_FIELD, TIMING_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String pipelineId;
    private final JobInput input;
    private final List<JobInput> inputs;
    private final JobOutput output;
    private final List<JobOutput> outputs;
    private final String outputKeyPrefix;
    private final List<Playlist> playlists;
    private final String status;
    private final Map<String, String> userMetadata;
    private final Timing timing;

    private Job(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.pipelineId = builder.pipelineId;
        this.input = builder.input;
        this.inputs = builder.inputs;
        this.output = builder.output;
        this.outputs = builder.outputs;
        this.outputKeyPrefix = builder.outputKeyPrefix;
        this.playlists = builder.playlists;
        this.status = builder.status;
        this.userMetadata = builder.userMetadata;
        this.timing = builder.timing;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public String pipelineId() {
        return this.pipelineId;
    }

    public JobInput input() {
        return this.input;
    }

    public List<JobInput> inputs() {
        return this.inputs;
    }

    public JobOutput output() {
        return this.output;
    }

    public List<JobOutput> outputs() {
        return this.outputs;
    }

    public String outputKeyPrefix() {
        return this.outputKeyPrefix;
    }

    public List<Playlist> playlists() {
        return this.playlists;
    }

    public String status() {
        return this.status;
    }

    public Map<String, String> userMetadata() {
        return this.userMetadata;
    }

    public Timing timing() {
        return this.timing;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.output());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputKeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.playlists());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.userMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.timing());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.pipelineId(), other.pipelineId()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.output(), other.output()) && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.outputKeyPrefix(), other.outputKeyPrefix()) && Objects.equals(this.playlists(), other.playlists()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.userMetadata(), other.userMetadata()) && Objects.equals(this.timing(), other.timing());
    }

    public String toString() {
        return ToString.builder((String)"Job").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("PipelineId", (Object)this.pipelineId()).add("Input", (Object)this.input()).add("Inputs", this.inputs()).add("Output", (Object)this.output()).add("Outputs", this.outputs()).add("OutputKeyPrefix", (Object)this.outputKeyPrefix()).add("Playlists", this.playlists()).add("Status", (Object)this.status()).add("UserMetadata", this.userMetadata()).add("Timing", (Object)this.timing()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "PipelineId": {
                return Optional.ofNullable(clazz.cast(this.pipelineId()));
            }
            case "Input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "Output": {
                return Optional.ofNullable(clazz.cast(this.output()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "OutputKeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.outputKeyPrefix()));
            }
            case "Playlists": {
                return Optional.ofNullable(clazz.cast(this.playlists()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "UserMetadata": {
                return Optional.ofNullable(clazz.cast(this.userMetadata()));
            }
            case "Timing": {
                return Optional.ofNullable(clazz.cast(this.timing()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Job, T> g) {
        return obj -> g.apply((Job)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String pipelineId;
        private JobInput input;
        private List<JobInput> inputs = DefaultSdkAutoConstructList.getInstance();
        private JobOutput output;
        private List<JobOutput> outputs = DefaultSdkAutoConstructList.getInstance();
        private String outputKeyPrefix;
        private List<Playlist> playlists = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Map<String, String> userMetadata = DefaultSdkAutoConstructMap.getInstance();
        private Timing timing;

        private BuilderImpl() {
        }

        private BuilderImpl(Job model) {
            this.id(model.id);
            this.arn(model.arn);
            this.pipelineId(model.pipelineId);
            this.input(model.input);
            this.inputs(model.inputs);
            this.output(model.output);
            this.outputs(model.outputs);
            this.outputKeyPrefix(model.outputKeyPrefix);
            this.playlists(model.playlists);
            this.status(model.status);
            this.userMetadata(model.userMetadata);
            this.timing(model.timing);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        public final JobInput.Builder getInput() {
            return this.input != null ? this.input.toBuilder() : null;
        }

        @Override
        public final Builder input(JobInput input) {
            this.input = input;
            return this;
        }

        public final void setInput(JobInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        public final Collection<JobInput.Builder> getInputs() {
            return this.inputs != null ? (Collection)this.inputs.stream().map(JobInput::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputs(Collection<JobInput> inputs) {
            this.inputs = JobInputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(JobInput ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<JobInput.Builder> ... inputs) {
            this.inputs(Stream.of(inputs).map(c -> (JobInput)((JobInput.Builder)JobInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputs(Collection<JobInput.BuilderImpl> inputs) {
            this.inputs = JobInputsCopier.copyFromBuilder(inputs);
        }

        public final JobOutput.Builder getOutput() {
            return this.output != null ? this.output.toBuilder() : null;
        }

        @Override
        public final Builder output(JobOutput output) {
            this.output = output;
            return this;
        }

        public final void setOutput(JobOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        public final Collection<JobOutput.Builder> getOutputs() {
            return this.outputs != null ? (Collection)this.outputs.stream().map(JobOutput::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputs(Collection<JobOutput> outputs) {
            this.outputs = JobOutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(JobOutput ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<JobOutput.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (JobOutput)((JobOutput.Builder)JobOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputs(Collection<JobOutput.BuilderImpl> outputs) {
            this.outputs = JobOutputsCopier.copyFromBuilder(outputs);
        }

        public final String getOutputKeyPrefix() {
            return this.outputKeyPrefix;
        }

        @Override
        public final Builder outputKeyPrefix(String outputKeyPrefix) {
            this.outputKeyPrefix = outputKeyPrefix;
            return this;
        }

        public final void setOutputKeyPrefix(String outputKeyPrefix) {
            this.outputKeyPrefix = outputKeyPrefix;
        }

        public final Collection<Playlist.Builder> getPlaylists() {
            return this.playlists != null ? (Collection)this.playlists.stream().map(Playlist::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder playlists(Collection<Playlist> playlists) {
            this.playlists = PlaylistsCopier.copy(playlists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playlists(Playlist ... playlists) {
            this.playlists(Arrays.asList(playlists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playlists(Consumer<Playlist.Builder> ... playlists) {
            this.playlists(Stream.of(playlists).map(c -> (Playlist)((Playlist.Builder)Playlist.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlaylists(Collection<Playlist.BuilderImpl> playlists) {
            this.playlists = PlaylistsCopier.copyFromBuilder(playlists);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Map<String, String> getUserMetadata() {
            return this.userMetadata;
        }

        @Override
        public final Builder userMetadata(Map<String, String> userMetadata) {
            this.userMetadata = UserMetadataCopier.copy(userMetadata);
            return this;
        }

        public final void setUserMetadata(Map<String, String> userMetadata) {
            this.userMetadata = UserMetadataCopier.copy(userMetadata);
        }

        public final Timing.Builder getTiming() {
            return this.timing != null ? this.timing.toBuilder() : null;
        }

        @Override
        public final Builder timing(Timing timing) {
            this.timing = timing;
            return this;
        }

        public final void setTiming(Timing.BuilderImpl timing) {
            this.timing = timing != null ? timing.build() : null;
        }

        public Job build() {
            return new Job(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Job> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder pipelineId(String var1);

        public Builder input(JobInput var1);

        default public Builder input(Consumer<JobInput.Builder> input) {
            return this.input((JobInput)((JobInput.Builder)JobInput.builder().applyMutation(input)).build());
        }

        public Builder inputs(Collection<JobInput> var1);

        public Builder inputs(JobInput ... var1);

        public Builder inputs(Consumer<JobInput.Builder> ... var1);

        public Builder output(JobOutput var1);

        default public Builder output(Consumer<JobOutput.Builder> output) {
            return this.output((JobOutput)((JobOutput.Builder)JobOutput.builder().applyMutation(output)).build());
        }

        public Builder outputs(Collection<JobOutput> var1);

        public Builder outputs(JobOutput ... var1);

        public Builder outputs(Consumer<JobOutput.Builder> ... var1);

        public Builder outputKeyPrefix(String var1);

        public Builder playlists(Collection<Playlist> var1);

        public Builder playlists(Playlist ... var1);

        public Builder playlists(Consumer<Playlist.Builder> ... var1);

        public Builder status(String var1);

        public Builder userMetadata(Map<String, String> var1);

        public Builder timing(Timing var1);

        default public Builder timing(Consumer<Timing.Builder> timing) {
            return this.timing((Timing)((Timing.Builder)Timing.builder().applyMutation(timing)).build());
        }
    }
}

