/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>CreatePipelineRequest</code> structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePipelineRequest extends ElasticTranscoderRequest implements
        ToCopyableBuilder<CreatePipelineRequest.Builder, CreatePipelineRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePipelineRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> INPUT_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePipelineRequest::inputBucket)).setter(setter(Builder::inputBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputBucket").build()).build();

    private static final SdkField<String> OUTPUT_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePipelineRequest::outputBucket)).setter(setter(Builder::outputBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputBucket").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePipelineRequest::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> AWS_KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePipelineRequest::awsKmsKeyArn)).setter(setter(Builder::awsKmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsKmsKeyArn").build()).build();

    private static final SdkField<Notifications> NOTIFICATIONS_FIELD = SdkField.<Notifications> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreatePipelineRequest::notifications)).setter(setter(Builder::notifications))
            .constructor(Notifications::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notifications").build()).build();

    private static final SdkField<PipelineOutputConfig> CONTENT_CONFIG_FIELD = SdkField
            .<PipelineOutputConfig> builder(MarshallingType.SDK_POJO).getter(getter(CreatePipelineRequest::contentConfig))
            .setter(setter(Builder::contentConfig)).constructor(PipelineOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentConfig").build()).build();

    private static final SdkField<PipelineOutputConfig> THUMBNAIL_CONFIG_FIELD = SdkField
            .<PipelineOutputConfig> builder(MarshallingType.SDK_POJO).getter(getter(CreatePipelineRequest::thumbnailConfig))
            .setter(setter(Builder::thumbnailConfig)).constructor(PipelineOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThumbnailConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            INPUT_BUCKET_FIELD, OUTPUT_BUCKET_FIELD, ROLE_FIELD, AWS_KMS_KEY_ARN_FIELD, NOTIFICATIONS_FIELD,
            CONTENT_CONFIG_FIELD, THUMBNAIL_CONFIG_FIELD));

    private final String name;

    private final String inputBucket;

    private final String outputBucket;

    private final String role;

    private final String awsKmsKeyArn;

    private final Notifications notifications;

    private final PipelineOutputConfig contentConfig;

    private final PipelineOutputConfig thumbnailConfig;

    private CreatePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.inputBucket = builder.inputBucket;
        this.outputBucket = builder.outputBucket;
        this.role = builder.role;
        this.awsKmsKeyArn = builder.awsKmsKeyArn;
        this.notifications = builder.notifications;
        this.contentConfig = builder.contentConfig;
        this.thumbnailConfig = builder.thumbnailConfig;
    }

    /**
     * <p>
     * The name of the pipeline. We recommend that the name be unique within the AWS account, but uniqueness is not
     * enforced.
     * </p>
     * <p>
     * Constraints: Maximum 40 characters.
     * </p>
     * 
     * @return The name of the pipeline. We recommend that the name be unique within the AWS account, but uniqueness is
     *         not enforced.</p>
     *         <p>
     *         Constraints: Maximum 40 characters.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon S3 bucket in which you saved the media files that you want to transcode.
     * </p>
     * 
     * @return The Amazon S3 bucket in which you saved the media files that you want to transcode.
     */
    public String inputBucket() {
        return inputBucket;
    }

    /**
     * <p>
     * The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files. (Use this, or use
     * ContentConfig:Bucket plus ThumbnailConfig:Bucket.)
     * </p>
     * <p>
     * Specify this value when all of the following are true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You want to save transcoded files, thumbnails (if any), and playlists (if any) together in one bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * You do not want to specify the users or groups who have access to the transcoded files, thumbnails, and
     * playlists.
     * </p>
     * </li>
     * <li>
     * <p>
     * You do not want to specify the permissions that Elastic Transcoder grants to the files.
     * </p>
     * <important>
     * <p>
     * When Elastic Transcoder saves files in <code>OutputBucket</code>, it grants full control over the files only to
     * the AWS account that owns the role that is specified by <code>Role</code>.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * You want to associate the transcoded files and thumbnails with the Amazon S3 Standard storage class.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you want to save transcoded files and playlists in one bucket and thumbnails in another bucket, specify which
     * users can access the transcoded files or the permissions the users have, or change the Amazon S3 storage class,
     * omit <code>OutputBucket</code> and specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code>
     * instead.
     * </p>
     * 
     * @return The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files. (Use this, or use
     *         ContentConfig:Bucket plus ThumbnailConfig:Bucket.)</p>
     *         <p>
     *         Specify this value when all of the following are true:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You want to save transcoded files, thumbnails (if any), and playlists (if any) together in one bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You do not want to specify the users or groups who have access to the transcoded files, thumbnails, and
     *         playlists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You do not want to specify the permissions that Elastic Transcoder grants to the files.
     *         </p>
     *         <important>
     *         <p>
     *         When Elastic Transcoder saves files in <code>OutputBucket</code>, it grants full control over the files
     *         only to the AWS account that owns the role that is specified by <code>Role</code>.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         You want to associate the transcoded files and thumbnails with the Amazon S3 Standard storage class.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you want to save transcoded files and playlists in one bucket and thumbnails in another bucket,
     *         specify which users can access the transcoded files or the permissions the users have, or change the
     *         Amazon S3 storage class, omit <code>OutputBucket</code> and specify values for <code>ContentConfig</code>
     *         and <code>ThumbnailConfig</code> instead.
     */
    public String outputBucket() {
        return outputBucket;
    }

    /**
     * <p>
     * The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to create the pipeline.
     * </p>
     * 
     * @return The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to create the
     *         pipeline.
     */
    public String role() {
        return role;
    }

    /**
     * <p>
     * The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.
     * </p>
     * <p>
     * If you use either <code>s3</code> or <code>s3-aws-kms</code> as your <code>Encryption:Mode</code>, you don't need
     * to provide a key with your job because a default key, known as an AWS-KMS key, is created for you automatically.
     * You need to provide an AWS-KMS key only if you want to use a non-default AWS-KMS key, or if you are using an
     * <code>Encryption:Mode</code> of <code>aes-cbc-pkcs7</code>, <code>aes-ctr</code>, or <code>aes-gcm</code>.
     * </p>
     * 
     * @return The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.</p>
     *         <p>
     *         If you use either <code>s3</code> or <code>s3-aws-kms</code> as your <code>Encryption:Mode</code>, you
     *         don't need to provide a key with your job because a default key, known as an AWS-KMS key, is created for
     *         you automatically. You need to provide an AWS-KMS key only if you want to use a non-default AWS-KMS key,
     *         or if you are using an <code>Encryption:Mode</code> of <code>aes-cbc-pkcs7</code>, <code>aes-ctr</code>,
     *         or <code>aes-gcm</code>.
     */
    public String awsKmsKeyArn() {
        return awsKmsKeyArn;
    }

    /**
     * <p>
     * The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status.
     * </p>
     * <important>
     * <p>
     * To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.
     * </p>
     * </important>
     * <ul>
     * <li>
     * <p>
     * <b>Progressing</b>: The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to
     * notify when Elastic Transcoder has started to process a job in this pipeline. This is the ARN that Amazon SNS
     * returned when you created the topic. For more information, see Create a Topic in the Amazon Simple Notification
     * Service Developer Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Complete</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder has
     * finished processing a job in this pipeline. This is the ARN that Amazon SNS returned when you created the topic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Warning</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters
     * a warning condition while processing a job in this pipeline. This is the ARN that Amazon SNS returned when you
     * created the topic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters
     * an error condition while processing a job in this pipeline. This is the ARN that Amazon SNS returned when you
     * created the topic.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job
     *         status.</p> <important>
     *         <p>
     *         To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.
     *         </p>
     *         </important>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Progressing</b>: The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you
     *         want to notify when Elastic Transcoder has started to process a job in this pipeline. This is the ARN
     *         that Amazon SNS returned when you created the topic. For more information, see Create a Topic in the
     *         Amazon Simple Notification Service Developer Guide.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Complete</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder
     *         has finished processing a job in this pipeline. This is the ARN that Amazon SNS returned when you created
     *         the topic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Warning</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder
     *         encounters a warning condition while processing a job in this pipeline. This is the ARN that Amazon SNS
     *         returned when you created the topic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Error</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder
     *         encounters an error condition while processing a job in this pipeline. This is the ARN that Amazon SNS
     *         returned when you created the topic.
     *         </p>
     *         </li>
     */
    public Notifications notifications() {
        return notifications;
    }

    /**
     * <p>
     * The optional <code>ContentConfig</code> object specifies information about the Amazon S3 bucket in which you want
     * Elastic Transcoder to save transcoded files and playlists: which bucket to use, which users you want to have
     * access to the files, the type of access you want users to have, and the storage class that you want to assign to
     * the files.
     * </p>
     * <p>
     * If you specify values for <code>ContentConfig</code>, you must also specify values for
     * <code>ThumbnailConfig</code>.
     * </p>
     * <p>
     * If you specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code>, omit the
     * <code>OutputBucket</code> object.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Permissions</b> (Optional): The Permissions object specifies which users you want to have access to transcoded
     * files and the type of access you want them to have. You can grant permissions to a maximum of 30 users and/or
     * predefined Amazon S3 groups.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Grantee Type</b>: Specify the type of value that appears in the <code>Grantee</code> object:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Canonical</b>: The value in the <code>Grantee</code> object is either the canonical user ID for an AWS account
     * or an origin access identity for an Amazon CloudFront distribution. For more information about canonical user
     * IDs, see Access Control List (ACL) Overview in the Amazon Simple Storage Service Developer Guide. For more
     * information about using CloudFront origin access identities to require that users use CloudFront URLs instead of
     * Amazon S3 URLs, see Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content.
     * </p>
     * <important>
     * <p>
     * A canonical user ID is not the same as an AWS account number.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <b>Email</b>: The value in the <code>Grantee</code> object is the registered email address of an AWS account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Group</b>: The value in the <code>Grantee</code> object is one of the following predefined Amazon S3 groups:
     * <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Grantee</b>: The AWS user or group that you want to have access to transcoded files and playlists. To identify
     * the user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a
     * CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Access</b>: The permission that you want to give to the AWS user that you specified in <code>Grantee</code>.
     * Permissions are granted on the files that Elastic Transcoder adds to the bucket, including playlists and video
     * files. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READ</code>: The grantee can read the objects and metadata for objects that Elastic Transcoder adds to the
     * Amazon S3 bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READ_ACP</code>: The grantee can read the object ACL for objects that Elastic Transcoder adds to the Amazon
     * S3 bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WRITE_ACP</code>: The grantee can write the ACL for the objects that Elastic Transcoder adds to the Amazon
     * S3 bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and <code>WRITE_ACP</code>
     * permissions for the objects that Elastic Transcoder adds to the Amazon S3 bucket.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>StorageClass</b>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that
     * you want Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The optional <code>ContentConfig</code> object specifies information about the Amazon S3 bucket in which
     *         you want Elastic Transcoder to save transcoded files and playlists: which bucket to use, which users you
     *         want to have access to the files, the type of access you want users to have, and the storage class that
     *         you want to assign to the files.</p>
     *         <p>
     *         If you specify values for <code>ContentConfig</code>, you must also specify values for
     *         <code>ThumbnailConfig</code>.
     *         </p>
     *         <p>
     *         If you specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code>, omit the
     *         <code>OutputBucket</code> object.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and
     *         playlists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Permissions</b> (Optional): The Permissions object specifies which users you want to have access to
     *         transcoded files and the type of access you want them to have. You can grant permissions to a maximum of
     *         30 users and/or predefined Amazon S3 groups.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Grantee Type</b>: Specify the type of value that appears in the <code>Grantee</code> object:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Canonical</b>: The value in the <code>Grantee</code> object is either the canonical user ID for an AWS
     *         account or an origin access identity for an Amazon CloudFront distribution. For more information about
     *         canonical user IDs, see Access Control List (ACL) Overview in the Amazon Simple Storage Service Developer
     *         Guide. For more information about using CloudFront origin access identities to require that users use
     *         CloudFront URLs instead of Amazon S3 URLs, see Using an Origin Access Identity to Restrict Access to Your
     *         Amazon S3 Content.
     *         </p>
     *         <important>
     *         <p>
     *         A canonical user ID is not the same as an AWS account number.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         <b>Email</b>: The value in the <code>Grantee</code> object is the registered email address of an AWS
     *         account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Group</b>: The value in the <code>Grantee</code> object is one of the following predefined Amazon S3
     *         groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Grantee</b>: The AWS user or group that you want to have access to transcoded files and playlists. To
     *         identify the user or group, you can specify the canonical user ID for an AWS account, an origin access
     *         identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined
     *         Amazon S3 group
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Access</b>: The permission that you want to give to the AWS user that you specified in
     *         <code>Grantee</code>. Permissions are granted on the files that Elastic Transcoder adds to the bucket,
     *         including playlists and video files. Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READ</code>: The grantee can read the objects and metadata for objects that Elastic Transcoder adds
     *         to the Amazon S3 bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READ_ACP</code>: The grantee can read the object ACL for objects that Elastic Transcoder adds to
     *         the Amazon S3 bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WRITE_ACP</code>: The grantee can write the ACL for the objects that Elastic Transcoder adds to the
     *         Amazon S3 bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and
     *         <code>WRITE_ACP</code> permissions for the objects that Elastic Transcoder adds to the Amazon S3 bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>StorageClass</b>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>
     *         , that you want Elastic Transcoder to assign to the video files and playlists that it stores in your
     *         Amazon S3 bucket.
     *         </p>
     *         </li>
     */
    public PipelineOutputConfig contentConfig() {
        return contentConfig;
    }

    /**
     * <p>
     * The <code>ThumbnailConfig</code> object specifies several values, including the Amazon S3 bucket in which you
     * want Elastic Transcoder to save thumbnail files, which users you want to have access to the files, the type of
     * access you want users to have, and the storage class that you want to assign to the files.
     * </p>
     * <p>
     * If you specify values for <code>ContentConfig</code>, you must also specify values for
     * <code>ThumbnailConfig</code> even if you don't want to create thumbnails.
     * </p>
     * <p>
     * If you specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code>, omit the
     * <code>OutputBucket</code> object.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Permissions</b> (Optional): The <code>Permissions</code> object specifies which users and/or predefined Amazon
     * S3 groups you want to have access to thumbnail files, and the type of access you want them to have. You can grant
     * permissions to a maximum of 30 users and/or predefined Amazon S3 groups.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>GranteeType</b>: Specify the type of value that appears in the Grantee object:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Canonical</b>: The value in the <code>Grantee</code> object is either the canonical user ID for an AWS account
     * or an origin access identity for an Amazon CloudFront distribution.
     * </p>
     * <important>
     * <p>
     * A canonical user ID is not the same as an AWS account number.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <b>Email</b>: The value in the <code>Grantee</code> object is the registered email address of an AWS account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Group</b>: The value in the <code>Grantee</code> object is one of the following predefined Amazon S3 groups:
     * <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>Grantee</b>: The AWS user or group that you want to have access to thumbnail files. To identify the user or
     * group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront
     * distribution, the registered email address of an AWS account, or a predefined Amazon S3 group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Access</b>: The permission that you want to give to the AWS user that you specified in <code>Grantee</code>.
     * Permissions are granted on the thumbnail files that Elastic Transcoder adds to the bucket. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>READ</code>: The grantee can read the thumbnails and metadata for objects that Elastic Transcoder adds to
     * the Amazon S3 bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the
     * Amazon S3 bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the
     * Amazon S3 bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and <code>WRITE_ACP</code>
     * permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b>StorageClass</b>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that
     * you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The <code>ThumbnailConfig</code> object specifies several values, including the Amazon S3 bucket in which
     *         you want Elastic Transcoder to save thumbnail files, which users you want to have access to the files,
     *         the type of access you want users to have, and the storage class that you want to assign to the
     *         files.</p>
     *         <p>
     *         If you specify values for <code>ContentConfig</code>, you must also specify values for
     *         <code>ThumbnailConfig</code> even if you don't want to create thumbnails.
     *         </p>
     *         <p>
     *         If you specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code>, omit the
     *         <code>OutputBucket</code> object.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Permissions</b> (Optional): The <code>Permissions</code> object specifies which users and/or
     *         predefined Amazon S3 groups you want to have access to thumbnail files, and the type of access you want
     *         them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>GranteeType</b>: Specify the type of value that appears in the Grantee object:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Canonical</b>: The value in the <code>Grantee</code> object is either the canonical user ID for an AWS
     *         account or an origin access identity for an Amazon CloudFront distribution.
     *         </p>
     *         <important>
     *         <p>
     *         A canonical user ID is not the same as an AWS account number.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         <b>Email</b>: The value in the <code>Grantee</code> object is the registered email address of an AWS
     *         account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Group</b>: The value in the <code>Grantee</code> object is one of the following predefined Amazon S3
     *         groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Grantee</b>: The AWS user or group that you want to have access to thumbnail files. To identify the
     *         user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a
     *         CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Access</b>: The permission that you want to give to the AWS user that you specified in
     *         <code>Grantee</code>. Permissions are granted on the thumbnail files that Elastic Transcoder adds to the
     *         bucket. Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>READ</code>: The grantee can read the thumbnails and metadata for objects that Elastic Transcoder
     *         adds to the Amazon S3 bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to
     *         the Amazon S3 bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to
     *         the Amazon S3 bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and
     *         <code>WRITE_ACP</code> permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3
     *         bucket.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b>StorageClass</b>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>
     *         , that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.
     *         </p>
     *         </li>
     */
    public PipelineOutputConfig thumbnailConfig() {
        return thumbnailConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(inputBucket());
        hashCode = 31 * hashCode + Objects.hashCode(outputBucket());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(awsKmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(notifications());
        hashCode = 31 * hashCode + Objects.hashCode(contentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(thumbnailConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePipelineRequest)) {
            return false;
        }
        CreatePipelineRequest other = (CreatePipelineRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(inputBucket(), other.inputBucket())
                && Objects.equals(outputBucket(), other.outputBucket()) && Objects.equals(role(), other.role())
                && Objects.equals(awsKmsKeyArn(), other.awsKmsKeyArn()) && Objects.equals(notifications(), other.notifications())
                && Objects.equals(contentConfig(), other.contentConfig())
                && Objects.equals(thumbnailConfig(), other.thumbnailConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreatePipelineRequest").add("Name", name()).add("InputBucket", inputBucket())
                .add("OutputBucket", outputBucket()).add("Role", role()).add("AwsKmsKeyArn", awsKmsKeyArn())
                .add("Notifications", notifications()).add("ContentConfig", contentConfig())
                .add("ThumbnailConfig", thumbnailConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "InputBucket":
            return Optional.ofNullable(clazz.cast(inputBucket()));
        case "OutputBucket":
            return Optional.ofNullable(clazz.cast(outputBucket()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "AwsKmsKeyArn":
            return Optional.ofNullable(clazz.cast(awsKmsKeyArn()));
        case "Notifications":
            return Optional.ofNullable(clazz.cast(notifications()));
        case "ContentConfig":
            return Optional.ofNullable(clazz.cast(contentConfig()));
        case "ThumbnailConfig":
            return Optional.ofNullable(clazz.cast(thumbnailConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePipelineRequest, T> g) {
        return obj -> g.apply((CreatePipelineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticTranscoderRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePipelineRequest> {
        /**
         * <p>
         * The name of the pipeline. We recommend that the name be unique within the AWS account, but uniqueness is not
         * enforced.
         * </p>
         * <p>
         * Constraints: Maximum 40 characters.
         * </p>
         * 
         * @param name
         *        The name of the pipeline. We recommend that the name be unique within the AWS account, but uniqueness
         *        is not enforced.</p>
         *        <p>
         *        Constraints: Maximum 40 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon S3 bucket in which you saved the media files that you want to transcode.
         * </p>
         * 
         * @param inputBucket
         *        The Amazon S3 bucket in which you saved the media files that you want to transcode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputBucket(String inputBucket);

        /**
         * <p>
         * The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files. (Use this, or use
         * ContentConfig:Bucket plus ThumbnailConfig:Bucket.)
         * </p>
         * <p>
         * Specify this value when all of the following are true:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You want to save transcoded files, thumbnails (if any), and playlists (if any) together in one bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * You do not want to specify the users or groups who have access to the transcoded files, thumbnails, and
         * playlists.
         * </p>
         * </li>
         * <li>
         * <p>
         * You do not want to specify the permissions that Elastic Transcoder grants to the files.
         * </p>
         * <important>
         * <p>
         * When Elastic Transcoder saves files in <code>OutputBucket</code>, it grants full control over the files only
         * to the AWS account that owns the role that is specified by <code>Role</code>.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * You want to associate the transcoded files and thumbnails with the Amazon S3 Standard storage class.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you want to save transcoded files and playlists in one bucket and thumbnails in another bucket, specify
         * which users can access the transcoded files or the permissions the users have, or change the Amazon S3
         * storage class, omit <code>OutputBucket</code> and specify values for <code>ContentConfig</code> and
         * <code>ThumbnailConfig</code> instead.
         * </p>
         * 
         * @param outputBucket
         *        The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files. (Use this, or
         *        use ContentConfig:Bucket plus ThumbnailConfig:Bucket.)</p>
         *        <p>
         *        Specify this value when all of the following are true:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        You want to save transcoded files, thumbnails (if any), and playlists (if any) together in one bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You do not want to specify the users or groups who have access to the transcoded files, thumbnails,
         *        and playlists.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You do not want to specify the permissions that Elastic Transcoder grants to the files.
         *        </p>
         *        <important>
         *        <p>
         *        When Elastic Transcoder saves files in <code>OutputBucket</code>, it grants full control over the
         *        files only to the AWS account that owns the role that is specified by <code>Role</code>.
         *        </p>
         *        </important></li>
         *        <li>
         *        <p>
         *        You want to associate the transcoded files and thumbnails with the Amazon S3 Standard storage class.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you want to save transcoded files and playlists in one bucket and thumbnails in another bucket,
         *        specify which users can access the transcoded files or the permissions the users have, or change the
         *        Amazon S3 storage class, omit <code>OutputBucket</code> and specify values for
         *        <code>ContentConfig</code> and <code>ThumbnailConfig</code> instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputBucket(String outputBucket);

        /**
         * <p>
         * The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to create the
         * pipeline.
         * </p>
         * 
         * @param role
         *        The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to create the
         *        pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.
         * </p>
         * <p>
         * If you use either <code>s3</code> or <code>s3-aws-kms</code> as your <code>Encryption:Mode</code>, you don't
         * need to provide a key with your job because a default key, known as an AWS-KMS key, is created for you
         * automatically. You need to provide an AWS-KMS key only if you want to use a non-default AWS-KMS key, or if
         * you are using an <code>Encryption:Mode</code> of <code>aes-cbc-pkcs7</code>, <code>aes-ctr</code>, or
         * <code>aes-gcm</code>.
         * </p>
         * 
         * @param awsKmsKeyArn
         *        The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.</p>
         *        <p>
         *        If you use either <code>s3</code> or <code>s3-aws-kms</code> as your <code>Encryption:Mode</code>, you
         *        don't need to provide a key with your job because a default key, known as an AWS-KMS key, is created
         *        for you automatically. You need to provide an AWS-KMS key only if you want to use a non-default
         *        AWS-KMS key, or if you are using an <code>Encryption:Mode</code> of <code>aes-cbc-pkcs7</code>,
         *        <code>aes-ctr</code>, or <code>aes-gcm</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsKmsKeyArn(String awsKmsKeyArn);

        /**
         * <p>
         * The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status.
         * </p>
         * <important>
         * <p>
         * To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.
         * </p>
         * </important>
         * <ul>
         * <li>
         * <p>
         * <b>Progressing</b>: The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want
         * to notify when Elastic Transcoder has started to process a job in this pipeline. This is the ARN that Amazon
         * SNS returned when you created the topic. For more information, see Create a Topic in the Amazon Simple
         * Notification Service Developer Guide.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Complete</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder has
         * finished processing a job in this pipeline. This is the ARN that Amazon SNS returned when you created the
         * topic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Warning</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder
         * encounters a warning condition while processing a job in this pipeline. This is the ARN that Amazon SNS
         * returned when you created the topic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Error</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder
         * encounters an error condition while processing a job in this pipeline. This is the ARN that Amazon SNS
         * returned when you created the topic.
         * </p>
         * </li>
         * </ul>
         * 
         * @param notifications
         *        The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job
         *        status.</p> <important>
         *        <p>
         *        To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.
         *        </p>
         *        </important>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Progressing</b>: The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that
         *        you want to notify when Elastic Transcoder has started to process a job in this pipeline. This is the
         *        ARN that Amazon SNS returned when you created the topic. For more information, see Create a Topic in
         *        the Amazon Simple Notification Service Developer Guide.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Complete</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic
         *        Transcoder has finished processing a job in this pipeline. This is the ARN that Amazon SNS returned
         *        when you created the topic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Warning</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder
         *        encounters a warning condition while processing a job in this pipeline. This is the ARN that Amazon
         *        SNS returned when you created the topic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Error</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder
         *        encounters an error condition while processing a job in this pipeline. This is the ARN that Amazon SNS
         *        returned when you created the topic.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notifications(Notifications notifications);

        /**
         * <p>
         * The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status.
         * </p>
         * <important>
         * <p>
         * To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.
         * </p>
         * </important>
         * <ul>
         * <li>
         * <p>
         * <b>Progressing</b>: The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want
         * to notify when Elastic Transcoder has started to process a job in this pipeline. This is the ARN that Amazon
         * SNS returned when you created the topic. For more information, see Create a Topic in the Amazon Simple
         * Notification Service Developer Guide.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Complete</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder has
         * finished processing a job in this pipeline. This is the ARN that Amazon SNS returned when you created the
         * topic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Warning</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder
         * encounters a warning condition while processing a job in this pipeline. This is the ARN that Amazon SNS
         * returned when you created the topic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Error</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder
         * encounters an error condition while processing a job in this pipeline. This is the ARN that Amazon SNS
         * returned when you created the topic.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link Notifications.Builder} avoiding the need to
         * create one manually via {@link Notifications#builder()}.
         *
         * When the {@link Consumer} completes, {@link Notifications.Builder#build()} is called immediately and its
         * result is passed to {@link #notifications(Notifications)}.
         * 
         * @param notifications
         *        a consumer that will call methods on {@link Notifications.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notifications(Notifications)
         */
        default Builder notifications(Consumer<Notifications.Builder> notifications) {
            return notifications(Notifications.builder().applyMutation(notifications).build());
        }

        /**
         * <p>
         * The optional <code>ContentConfig</code> object specifies information about the Amazon S3 bucket in which you
         * want Elastic Transcoder to save transcoded files and playlists: which bucket to use, which users you want to
         * have access to the files, the type of access you want users to have, and the storage class that you want to
         * assign to the files.
         * </p>
         * <p>
         * If you specify values for <code>ContentConfig</code>, you must also specify values for
         * <code>ThumbnailConfig</code>.
         * </p>
         * <p>
         * If you specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code>, omit the
         * <code>OutputBucket</code> object.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and
         * playlists.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Permissions</b> (Optional): The Permissions object specifies which users you want to have access to
         * transcoded files and the type of access you want them to have. You can grant permissions to a maximum of 30
         * users and/or predefined Amazon S3 groups.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Grantee Type</b>: Specify the type of value that appears in the <code>Grantee</code> object:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Canonical</b>: The value in the <code>Grantee</code> object is either the canonical user ID for an AWS
         * account or an origin access identity for an Amazon CloudFront distribution. For more information about
         * canonical user IDs, see Access Control List (ACL) Overview in the Amazon Simple Storage Service Developer
         * Guide. For more information about using CloudFront origin access identities to require that users use
         * CloudFront URLs instead of Amazon S3 URLs, see Using an Origin Access Identity to Restrict Access to Your
         * Amazon S3 Content.
         * </p>
         * <important>
         * <p>
         * A canonical user ID is not the same as an AWS account number.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <b>Email</b>: The value in the <code>Grantee</code> object is the registered email address of an AWS account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Group</b>: The value in the <code>Grantee</code> object is one of the following predefined Amazon S3
         * groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>Grantee</b>: The AWS user or group that you want to have access to transcoded files and playlists. To
         * identify the user or group, you can specify the canonical user ID for an AWS account, an origin access
         * identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined
         * Amazon S3 group
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Access</b>: The permission that you want to give to the AWS user that you specified in
         * <code>Grantee</code>. Permissions are granted on the files that Elastic Transcoder adds to the bucket,
         * including playlists and video files. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READ</code>: The grantee can read the objects and metadata for objects that Elastic Transcoder adds to
         * the Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READ_ACP</code>: The grantee can read the object ACL for objects that Elastic Transcoder adds to the
         * Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WRITE_ACP</code>: The grantee can write the ACL for the objects that Elastic Transcoder adds to the
         * Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and
         * <code>WRITE_ACP</code> permissions for the objects that Elastic Transcoder adds to the Amazon S3 bucket.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>StorageClass</b>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>,
         * that you want Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3
         * bucket.
         * </p>
         * </li>
         * </ul>
         * 
         * @param contentConfig
         *        The optional <code>ContentConfig</code> object specifies information about the Amazon S3 bucket in
         *        which you want Elastic Transcoder to save transcoded files and playlists: which bucket to use, which
         *        users you want to have access to the files, the type of access you want users to have, and the storage
         *        class that you want to assign to the files.</p>
         *        <p>
         *        If you specify values for <code>ContentConfig</code>, you must also specify values for
         *        <code>ThumbnailConfig</code>.
         *        </p>
         *        <p>
         *        If you specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code>, omit the
         *        <code>OutputBucket</code> object.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and
         *        playlists.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Permissions</b> (Optional): The Permissions object specifies which users you want to have access to
         *        transcoded files and the type of access you want them to have. You can grant permissions to a maximum
         *        of 30 users and/or predefined Amazon S3 groups.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Grantee Type</b>: Specify the type of value that appears in the <code>Grantee</code> object:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Canonical</b>: The value in the <code>Grantee</code> object is either the canonical user ID for an
         *        AWS account or an origin access identity for an Amazon CloudFront distribution. For more information
         *        about canonical user IDs, see Access Control List (ACL) Overview in the Amazon Simple Storage Service
         *        Developer Guide. For more information about using CloudFront origin access identities to require that
         *        users use CloudFront URLs instead of Amazon S3 URLs, see Using an Origin Access Identity to Restrict
         *        Access to Your Amazon S3 Content.
         *        </p>
         *        <important>
         *        <p>
         *        A canonical user ID is not the same as an AWS account number.
         *        </p>
         *        </important></li>
         *        <li>
         *        <p>
         *        <b>Email</b>: The value in the <code>Grantee</code> object is the registered email address of an AWS
         *        account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Group</b>: The value in the <code>Grantee</code> object is one of the following predefined Amazon
         *        S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Grantee</b>: The AWS user or group that you want to have access to transcoded files and playlists.
         *        To identify the user or group, you can specify the canonical user ID for an AWS account, an origin
         *        access identity for a CloudFront distribution, the registered email address of an AWS account, or a
         *        predefined Amazon S3 group
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Access</b>: The permission that you want to give to the AWS user that you specified in
         *        <code>Grantee</code>. Permissions are granted on the files that Elastic Transcoder adds to the bucket,
         *        including playlists and video files. Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READ</code>: The grantee can read the objects and metadata for objects that Elastic Transcoder
         *        adds to the Amazon S3 bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READ_ACP</code>: The grantee can read the object ACL for objects that Elastic Transcoder adds to
         *        the Amazon S3 bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WRITE_ACP</code>: The grantee can write the ACL for the objects that Elastic Transcoder adds to
         *        the Amazon S3 bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and
         *        <code>WRITE_ACP</code> permissions for the objects that Elastic Transcoder adds to the Amazon S3
         *        bucket.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>StorageClass</b>: The Amazon S3 storage class, <code>Standard</code> or
         *        <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the video files and
         *        playlists that it stores in your Amazon S3 bucket.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentConfig(PipelineOutputConfig contentConfig);

        /**
         * <p>
         * The optional <code>ContentConfig</code> object specifies information about the Amazon S3 bucket in which you
         * want Elastic Transcoder to save transcoded files and playlists: which bucket to use, which users you want to
         * have access to the files, the type of access you want users to have, and the storage class that you want to
         * assign to the files.
         * </p>
         * <p>
         * If you specify values for <code>ContentConfig</code>, you must also specify values for
         * <code>ThumbnailConfig</code>.
         * </p>
         * <p>
         * If you specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code>, omit the
         * <code>OutputBucket</code> object.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and
         * playlists.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Permissions</b> (Optional): The Permissions object specifies which users you want to have access to
         * transcoded files and the type of access you want them to have. You can grant permissions to a maximum of 30
         * users and/or predefined Amazon S3 groups.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Grantee Type</b>: Specify the type of value that appears in the <code>Grantee</code> object:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Canonical</b>: The value in the <code>Grantee</code> object is either the canonical user ID for an AWS
         * account or an origin access identity for an Amazon CloudFront distribution. For more information about
         * canonical user IDs, see Access Control List (ACL) Overview in the Amazon Simple Storage Service Developer
         * Guide. For more information about using CloudFront origin access identities to require that users use
         * CloudFront URLs instead of Amazon S3 URLs, see Using an Origin Access Identity to Restrict Access to Your
         * Amazon S3 Content.
         * </p>
         * <important>
         * <p>
         * A canonical user ID is not the same as an AWS account number.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <b>Email</b>: The value in the <code>Grantee</code> object is the registered email address of an AWS account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Group</b>: The value in the <code>Grantee</code> object is one of the following predefined Amazon S3
         * groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>Grantee</b>: The AWS user or group that you want to have access to transcoded files and playlists. To
         * identify the user or group, you can specify the canonical user ID for an AWS account, an origin access
         * identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined
         * Amazon S3 group
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Access</b>: The permission that you want to give to the AWS user that you specified in
         * <code>Grantee</code>. Permissions are granted on the files that Elastic Transcoder adds to the bucket,
         * including playlists and video files. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READ</code>: The grantee can read the objects and metadata for objects that Elastic Transcoder adds to
         * the Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READ_ACP</code>: The grantee can read the object ACL for objects that Elastic Transcoder adds to the
         * Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WRITE_ACP</code>: The grantee can write the ACL for the objects that Elastic Transcoder adds to the
         * Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and
         * <code>WRITE_ACP</code> permissions for the objects that Elastic Transcoder adds to the Amazon S3 bucket.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>StorageClass</b>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>,
         * that you want Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3
         * bucket.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link PipelineOutputConfig.Builder} avoiding the need
         * to create one manually via {@link PipelineOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link PipelineOutputConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #contentConfig(PipelineOutputConfig)}.
         * 
         * @param contentConfig
         *        a consumer that will call methods on {@link PipelineOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentConfig(PipelineOutputConfig)
         */
        default Builder contentConfig(Consumer<PipelineOutputConfig.Builder> contentConfig) {
            return contentConfig(PipelineOutputConfig.builder().applyMutation(contentConfig).build());
        }

        /**
         * <p>
         * The <code>ThumbnailConfig</code> object specifies several values, including the Amazon S3 bucket in which you
         * want Elastic Transcoder to save thumbnail files, which users you want to have access to the files, the type
         * of access you want users to have, and the storage class that you want to assign to the files.
         * </p>
         * <p>
         * If you specify values for <code>ContentConfig</code>, you must also specify values for
         * <code>ThumbnailConfig</code> even if you don't want to create thumbnails.
         * </p>
         * <p>
         * If you specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code>, omit the
         * <code>OutputBucket</code> object.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Permissions</b> (Optional): The <code>Permissions</code> object specifies which users and/or predefined
         * Amazon S3 groups you want to have access to thumbnail files, and the type of access you want them to have.
         * You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>GranteeType</b>: Specify the type of value that appears in the Grantee object:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Canonical</b>: The value in the <code>Grantee</code> object is either the canonical user ID for an AWS
         * account or an origin access identity for an Amazon CloudFront distribution.
         * </p>
         * <important>
         * <p>
         * A canonical user ID is not the same as an AWS account number.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <b>Email</b>: The value in the <code>Grantee</code> object is the registered email address of an AWS account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Group</b>: The value in the <code>Grantee</code> object is one of the following predefined Amazon S3
         * groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>Grantee</b>: The AWS user or group that you want to have access to thumbnail files. To identify the user
         * or group, you can specify the canonical user ID for an AWS account, an origin access identity for a
         * CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Access</b>: The permission that you want to give to the AWS user that you specified in
         * <code>Grantee</code>. Permissions are granted on the thumbnail files that Elastic Transcoder adds to the
         * bucket. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READ</code>: The grantee can read the thumbnails and metadata for objects that Elastic Transcoder adds
         * to the Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the
         * Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the
         * Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and
         * <code>WRITE_ACP</code> permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>StorageClass</b>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>,
         * that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.
         * </p>
         * </li>
         * </ul>
         * 
         * @param thumbnailConfig
         *        The <code>ThumbnailConfig</code> object specifies several values, including the Amazon S3 bucket in
         *        which you want Elastic Transcoder to save thumbnail files, which users you want to have access to the
         *        files, the type of access you want users to have, and the storage class that you want to assign to the
         *        files.</p>
         *        <p>
         *        If you specify values for <code>ContentConfig</code>, you must also specify values for
         *        <code>ThumbnailConfig</code> even if you don't want to create thumbnails.
         *        </p>
         *        <p>
         *        If you specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code>, omit the
         *        <code>OutputBucket</code> object.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Permissions</b> (Optional): The <code>Permissions</code> object specifies which users and/or
         *        predefined Amazon S3 groups you want to have access to thumbnail files, and the type of access you
         *        want them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3
         *        groups.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>GranteeType</b>: Specify the type of value that appears in the Grantee object:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Canonical</b>: The value in the <code>Grantee</code> object is either the canonical user ID for an
         *        AWS account or an origin access identity for an Amazon CloudFront distribution.
         *        </p>
         *        <important>
         *        <p>
         *        A canonical user ID is not the same as an AWS account number.
         *        </p>
         *        </important></li>
         *        <li>
         *        <p>
         *        <b>Email</b>: The value in the <code>Grantee</code> object is the registered email address of an AWS
         *        account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Group</b>: The value in the <code>Grantee</code> object is one of the following predefined Amazon
         *        S3 groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Grantee</b>: The AWS user or group that you want to have access to thumbnail files. To identify the
         *        user or group, you can specify the canonical user ID for an AWS account, an origin access identity for
         *        a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3
         *        group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Access</b>: The permission that you want to give to the AWS user that you specified in
         *        <code>Grantee</code>. Permissions are granted on the thumbnail files that Elastic Transcoder adds to
         *        the bucket. Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>READ</code>: The grantee can read the thumbnails and metadata for objects that Elastic
         *        Transcoder adds to the Amazon S3 bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds
         *        to the Amazon S3 bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds
         *        to the Amazon S3 bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and
         *        <code>WRITE_ACP</code> permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3
         *        bucket.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b>StorageClass</b>: The Amazon S3 storage class, <code>Standard</code> or
         *        <code>ReducedRedundancy</code>, that you want Elastic Transcoder to assign to the thumbnails that it
         *        stores in your Amazon S3 bucket.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailConfig(PipelineOutputConfig thumbnailConfig);

        /**
         * <p>
         * The <code>ThumbnailConfig</code> object specifies several values, including the Amazon S3 bucket in which you
         * want Elastic Transcoder to save thumbnail files, which users you want to have access to the files, the type
         * of access you want users to have, and the storage class that you want to assign to the files.
         * </p>
         * <p>
         * If you specify values for <code>ContentConfig</code>, you must also specify values for
         * <code>ThumbnailConfig</code> even if you don't want to create thumbnails.
         * </p>
         * <p>
         * If you specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code>, omit the
         * <code>OutputBucket</code> object.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Bucket</b>: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Permissions</b> (Optional): The <code>Permissions</code> object specifies which users and/or predefined
         * Amazon S3 groups you want to have access to thumbnail files, and the type of access you want them to have.
         * You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>GranteeType</b>: Specify the type of value that appears in the Grantee object:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Canonical</b>: The value in the <code>Grantee</code> object is either the canonical user ID for an AWS
         * account or an origin access identity for an Amazon CloudFront distribution.
         * </p>
         * <important>
         * <p>
         * A canonical user ID is not the same as an AWS account number.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <b>Email</b>: The value in the <code>Grantee</code> object is the registered email address of an AWS account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Group</b>: The value in the <code>Grantee</code> object is one of the following predefined Amazon S3
         * groups: <code>AllUsers</code>, <code>AuthenticatedUsers</code>, or <code>LogDelivery</code>.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>Grantee</b>: The AWS user or group that you want to have access to thumbnail files. To identify the user
         * or group, you can specify the canonical user ID for an AWS account, an origin access identity for a
         * CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Access</b>: The permission that you want to give to the AWS user that you specified in
         * <code>Grantee</code>. Permissions are granted on the thumbnail files that Elastic Transcoder adds to the
         * bucket. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>READ</code>: The grantee can read the thumbnails and metadata for objects that Elastic Transcoder adds
         * to the Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READ_ACP</code>: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the
         * Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WRITE_ACP</code>: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the
         * Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FULL_CONTROL</code>: The grantee has <code>READ</code>, <code>READ_ACP</code>, and
         * <code>WRITE_ACP</code> permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b>StorageClass</b>: The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>,
         * that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link PipelineOutputConfig.Builder} avoiding the need
         * to create one manually via {@link PipelineOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link PipelineOutputConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #thumbnailConfig(PipelineOutputConfig)}.
         * 
         * @param thumbnailConfig
         *        a consumer that will call methods on {@link PipelineOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thumbnailConfig(PipelineOutputConfig)
         */
        default Builder thumbnailConfig(Consumer<PipelineOutputConfig.Builder> thumbnailConfig) {
            return thumbnailConfig(PipelineOutputConfig.builder().applyMutation(thumbnailConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticTranscoderRequest.BuilderImpl implements Builder {
        private String name;

        private String inputBucket;

        private String outputBucket;

        private String role;

        private String awsKmsKeyArn;

        private Notifications notifications;

        private PipelineOutputConfig contentConfig;

        private PipelineOutputConfig thumbnailConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePipelineRequest model) {
            super(model);
            name(model.name);
            inputBucket(model.inputBucket);
            outputBucket(model.outputBucket);
            role(model.role);
            awsKmsKeyArn(model.awsKmsKeyArn);
            notifications(model.notifications);
            contentConfig(model.contentConfig);
            thumbnailConfig(model.thumbnailConfig);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getInputBucket() {
            return inputBucket;
        }

        @Override
        public final Builder inputBucket(String inputBucket) {
            this.inputBucket = inputBucket;
            return this;
        }

        public final void setInputBucket(String inputBucket) {
            this.inputBucket = inputBucket;
        }

        public final String getOutputBucket() {
            return outputBucket;
        }

        @Override
        public final Builder outputBucket(String outputBucket) {
            this.outputBucket = outputBucket;
            return this;
        }

        public final void setOutputBucket(String outputBucket) {
            this.outputBucket = outputBucket;
        }

        public final String getRole() {
            return role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getAwsKmsKeyArn() {
            return awsKmsKeyArn;
        }

        @Override
        public final Builder awsKmsKeyArn(String awsKmsKeyArn) {
            this.awsKmsKeyArn = awsKmsKeyArn;
            return this;
        }

        public final void setAwsKmsKeyArn(String awsKmsKeyArn) {
            this.awsKmsKeyArn = awsKmsKeyArn;
        }

        public final Notifications.Builder getNotifications() {
            return notifications != null ? notifications.toBuilder() : null;
        }

        @Override
        public final Builder notifications(Notifications notifications) {
            this.notifications = notifications;
            return this;
        }

        public final void setNotifications(Notifications.BuilderImpl notifications) {
            this.notifications = notifications != null ? notifications.build() : null;
        }

        public final PipelineOutputConfig.Builder getContentConfig() {
            return contentConfig != null ? contentConfig.toBuilder() : null;
        }

        @Override
        public final Builder contentConfig(PipelineOutputConfig contentConfig) {
            this.contentConfig = contentConfig;
            return this;
        }

        public final void setContentConfig(PipelineOutputConfig.BuilderImpl contentConfig) {
            this.contentConfig = contentConfig != null ? contentConfig.build() : null;
        }

        public final PipelineOutputConfig.Builder getThumbnailConfig() {
            return thumbnailConfig != null ? thumbnailConfig.toBuilder() : null;
        }

        @Override
        public final Builder thumbnailConfig(PipelineOutputConfig thumbnailConfig) {
            this.thumbnailConfig = thumbnailConfig;
            return this;
        }

        public final void setThumbnailConfig(PipelineOutputConfig.BuilderImpl thumbnailConfig) {
            this.thumbnailConfig = thumbnailConfig != null ? thumbnailConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePipelineRequest build() {
            return new CreatePipelineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
