/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>CreatePresetRequest</code> structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePresetRequest extends ElasticTranscoderRequest implements
        ToCopyableBuilder<CreatePresetRequest.Builder, CreatePresetRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePresetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePresetRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CONTAINER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePresetRequest::container)).setter(setter(Builder::container))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Container").build()).build();

    private static final SdkField<VideoParameters> VIDEO_FIELD = SdkField.<VideoParameters> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreatePresetRequest::video)).setter(setter(Builder::video)).constructor(VideoParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Video").build()).build();

    private static final SdkField<AudioParameters> AUDIO_FIELD = SdkField.<AudioParameters> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreatePresetRequest::audio)).setter(setter(Builder::audio)).constructor(AudioParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Audio").build()).build();

    private static final SdkField<Thumbnails> THUMBNAILS_FIELD = SdkField.<Thumbnails> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreatePresetRequest::thumbnails)).setter(setter(Builder::thumbnails)).constructor(Thumbnails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Thumbnails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            CONTAINER_FIELD, VIDEO_FIELD, AUDIO_FIELD, THUMBNAILS_FIELD));

    private final String name;

    private final String description;

    private final String container;

    private final VideoParameters video;

    private final AudioParameters audio;

    private final Thumbnails thumbnails;

    private CreatePresetRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.container = builder.container;
        this.video = builder.video;
        this.audio = builder.audio;
        this.thumbnails = builder.thumbnails;
    }

    /**
     * <p>
     * The name of the preset. We recommend that the name be unique within the AWS account, but uniqueness is not
     * enforced.
     * </p>
     * 
     * @return The name of the preset. We recommend that the name be unique within the AWS account, but uniqueness is
     *         not enforced.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the preset.
     * </p>
     * 
     * @return A description of the preset.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The container type for the output file. Valid values include <code>flac</code>, <code>flv</code>,
     * <code>fmp4</code>, <code>gif</code>, <code>mp3</code>, <code>mp4</code>, <code>mpg</code>, <code>mxf</code>,
     * <code>oga</code>, <code>ogg</code>, <code>ts</code>, and <code>webm</code>.
     * </p>
     * 
     * @return The container type for the output file. Valid values include <code>flac</code>, <code>flv</code>,
     *         <code>fmp4</code>, <code>gif</code>, <code>mp3</code>, <code>mp4</code>, <code>mpg</code>,
     *         <code>mxf</code>, <code>oga</code>, <code>ogg</code>, <code>ts</code>, and <code>webm</code>.
     */
    public String container() {
        return container;
    }

    /**
     * <p>
     * A section of the request body that specifies the video parameters.
     * </p>
     * 
     * @return A section of the request body that specifies the video parameters.
     */
    public VideoParameters video() {
        return video;
    }

    /**
     * <p>
     * A section of the request body that specifies the audio parameters.
     * </p>
     * 
     * @return A section of the request body that specifies the audio parameters.
     */
    public AudioParameters audio() {
        return audio;
    }

    /**
     * <p>
     * A section of the request body that specifies the thumbnail parameters, if any.
     * </p>
     * 
     * @return A section of the request body that specifies the thumbnail parameters, if any.
     */
    public Thumbnails thumbnails() {
        return thumbnails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(container());
        hashCode = 31 * hashCode + Objects.hashCode(video());
        hashCode = 31 * hashCode + Objects.hashCode(audio());
        hashCode = 31 * hashCode + Objects.hashCode(thumbnails());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePresetRequest)) {
            return false;
        }
        CreatePresetRequest other = (CreatePresetRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(container(), other.container()) && Objects.equals(video(), other.video())
                && Objects.equals(audio(), other.audio()) && Objects.equals(thumbnails(), other.thumbnails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreatePresetRequest").add("Name", name()).add("Description", description())
                .add("Container", container()).add("Video", video()).add("Audio", audio()).add("Thumbnails", thumbnails())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Container":
            return Optional.ofNullable(clazz.cast(container()));
        case "Video":
            return Optional.ofNullable(clazz.cast(video()));
        case "Audio":
            return Optional.ofNullable(clazz.cast(audio()));
        case "Thumbnails":
            return Optional.ofNullable(clazz.cast(thumbnails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePresetRequest, T> g) {
        return obj -> g.apply((CreatePresetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticTranscoderRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePresetRequest> {
        /**
         * <p>
         * The name of the preset. We recommend that the name be unique within the AWS account, but uniqueness is not
         * enforced.
         * </p>
         * 
         * @param name
         *        The name of the preset. We recommend that the name be unique within the AWS account, but uniqueness is
         *        not enforced.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the preset.
         * </p>
         * 
         * @param description
         *        A description of the preset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The container type for the output file. Valid values include <code>flac</code>, <code>flv</code>,
         * <code>fmp4</code>, <code>gif</code>, <code>mp3</code>, <code>mp4</code>, <code>mpg</code>, <code>mxf</code>,
         * <code>oga</code>, <code>ogg</code>, <code>ts</code>, and <code>webm</code>.
         * </p>
         * 
         * @param container
         *        The container type for the output file. Valid values include <code>flac</code>, <code>flv</code>,
         *        <code>fmp4</code>, <code>gif</code>, <code>mp3</code>, <code>mp4</code>, <code>mpg</code>,
         *        <code>mxf</code>, <code>oga</code>, <code>ogg</code>, <code>ts</code>, and <code>webm</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder container(String container);

        /**
         * <p>
         * A section of the request body that specifies the video parameters.
         * </p>
         * 
         * @param video
         *        A section of the request body that specifies the video parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder video(VideoParameters video);

        /**
         * <p>
         * A section of the request body that specifies the video parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link VideoParameters.Builder} avoiding the need to
         * create one manually via {@link VideoParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link VideoParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #video(VideoParameters)}.
         * 
         * @param video
         *        a consumer that will call methods on {@link VideoParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #video(VideoParameters)
         */
        default Builder video(Consumer<VideoParameters.Builder> video) {
            return video(VideoParameters.builder().applyMutation(video).build());
        }

        /**
         * <p>
         * A section of the request body that specifies the audio parameters.
         * </p>
         * 
         * @param audio
         *        A section of the request body that specifies the audio parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audio(AudioParameters audio);

        /**
         * <p>
         * A section of the request body that specifies the audio parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link AudioParameters.Builder} avoiding the need to
         * create one manually via {@link AudioParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link AudioParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #audio(AudioParameters)}.
         * 
         * @param audio
         *        a consumer that will call methods on {@link AudioParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audio(AudioParameters)
         */
        default Builder audio(Consumer<AudioParameters.Builder> audio) {
            return audio(AudioParameters.builder().applyMutation(audio).build());
        }

        /**
         * <p>
         * A section of the request body that specifies the thumbnail parameters, if any.
         * </p>
         * 
         * @param thumbnails
         *        A section of the request body that specifies the thumbnail parameters, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnails(Thumbnails thumbnails);

        /**
         * <p>
         * A section of the request body that specifies the thumbnail parameters, if any.
         * </p>
         * This is a convenience that creates an instance of the {@link Thumbnails.Builder} avoiding the need to create
         * one manually via {@link Thumbnails#builder()}.
         *
         * When the {@link Consumer} completes, {@link Thumbnails.Builder#build()} is called immediately and its result
         * is passed to {@link #thumbnails(Thumbnails)}.
         * 
         * @param thumbnails
         *        a consumer that will call methods on {@link Thumbnails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thumbnails(Thumbnails)
         */
        default Builder thumbnails(Consumer<Thumbnails.Builder> thumbnails) {
            return thumbnails(Thumbnails.builder().applyMutation(thumbnails).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticTranscoderRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String container;

        private VideoParameters video;

        private AudioParameters audio;

        private Thumbnails thumbnails;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePresetRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            container(model.container);
            video(model.video);
            audio(model.audio);
            thumbnails(model.thumbnails);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getContainer() {
            return container;
        }

        @Override
        public final Builder container(String container) {
            this.container = container;
            return this;
        }

        public final void setContainer(String container) {
            this.container = container;
        }

        public final VideoParameters.Builder getVideo() {
            return video != null ? video.toBuilder() : null;
        }

        @Override
        public final Builder video(VideoParameters video) {
            this.video = video;
            return this;
        }

        public final void setVideo(VideoParameters.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        public final AudioParameters.Builder getAudio() {
            return audio != null ? audio.toBuilder() : null;
        }

        @Override
        public final Builder audio(AudioParameters audio) {
            this.audio = audio;
            return this;
        }

        public final void setAudio(AudioParameters.BuilderImpl audio) {
            this.audio = audio != null ? audio.build() : null;
        }

        public final Thumbnails.Builder getThumbnails() {
            return thumbnails != null ? thumbnails.toBuilder() : null;
        }

        @Override
        public final Builder thumbnails(Thumbnails thumbnails) {
            this.thumbnails = thumbnails;
            return this;
        }

        public final void setThumbnails(Thumbnails.BuilderImpl thumbnails) {
            this.thumbnails = thumbnails != null ? thumbnails.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePresetRequest build() {
            return new CreatePresetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
