/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>ListJobsByStatusResponse</code> structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJobsByStatusResponse extends ElasticTranscoderResponse implements
        ToCopyableBuilder<ListJobsByStatusResponse.Builder, ListJobsByStatusResponse> {
    private static final SdkField<List<Job>> JOBS_FIELD = SdkField
            .<List<Job>> builder(MarshallingType.LIST)
            .getter(getter(ListJobsByStatusResponse::jobs))
            .setter(setter(Builder::jobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Jobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Job> builder(MarshallingType.SDK_POJO)
                                            .constructor(Job::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListJobsByStatusResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOBS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<Job> jobs;

    private final String nextPageToken;

    private ListJobsByStatusResponse(BuilderImpl builder) {
        super(builder);
        this.jobs = builder.jobs;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * An array of <code>Job</code> objects that have the specified status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>Job</code> objects that have the specified status.
     */
    public List<Job> jobs() {
        return jobs;
    }

    /**
     * <p>
     * A value that you use to access the second and subsequent pages of results, if any. When the jobs in the specified
     * pipeline fit on one page or when you've reached the last page of results, the value of <code>NextPageToken</code>
     * is <code>null</code>.
     * </p>
     * 
     * @return A value that you use to access the second and subsequent pages of results, if any. When the jobs in the
     *         specified pipeline fit on one page or when you've reached the last page of results, the value of
     *         <code>NextPageToken</code> is <code>null</code>.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobs());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsByStatusResponse)) {
            return false;
        }
        ListJobsByStatusResponse other = (ListJobsByStatusResponse) obj;
        return Objects.equals(jobs(), other.jobs()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListJobsByStatusResponse").add("Jobs", jobs()).add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Jobs":
            return Optional.ofNullable(clazz.cast(jobs()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobsByStatusResponse, T> g) {
        return obj -> g.apply((ListJobsByStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticTranscoderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListJobsByStatusResponse> {
        /**
         * <p>
         * An array of <code>Job</code> objects that have the specified status.
         * </p>
         * 
         * @param jobs
         *        An array of <code>Job</code> objects that have the specified status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(Collection<Job> jobs);

        /**
         * <p>
         * An array of <code>Job</code> objects that have the specified status.
         * </p>
         * 
         * @param jobs
         *        An array of <code>Job</code> objects that have the specified status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(Job... jobs);

        /**
         * <p>
         * An array of <code>Job</code> objects that have the specified status.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Job>.Builder} avoiding the need to create
         * one manually via {@link List<Job>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Job>.Builder#build()} is called immediately and its result
         * is passed to {@link #jobs(List<Job>)}.
         * 
         * @param jobs
         *        a consumer that will call methods on {@link List<Job>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobs(List<Job>)
         */
        Builder jobs(Consumer<Job.Builder>... jobs);

        /**
         * <p>
         * A value that you use to access the second and subsequent pages of results, if any. When the jobs in the
         * specified pipeline fit on one page or when you've reached the last page of results, the value of
         * <code>NextPageToken</code> is <code>null</code>.
         * </p>
         * 
         * @param nextPageToken
         *        A value that you use to access the second and subsequent pages of results, if any. When the jobs in
         *        the specified pipeline fit on one page or when you've reached the last page of results, the value of
         *        <code>NextPageToken</code> is <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends ElasticTranscoderResponse.BuilderImpl implements Builder {
        private List<Job> jobs = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsByStatusResponse model) {
            super(model);
            jobs(model.jobs);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<Job.Builder> getJobs() {
            return jobs != null ? jobs.stream().map(Job::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobs(Collection<Job> jobs) {
            this.jobs = JobsCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Job... jobs) {
            jobs(Arrays.asList(jobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Consumer<Job.Builder>... jobs) {
            jobs(Stream.of(jobs).map(c -> Job.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobs(Collection<Job.BuilderImpl> jobs) {
            this.jobs = JobsCopier.copyFromBuilder(jobs);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListJobsByStatusResponse build() {
            return new ListJobsByStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
