/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>ListPresetsRequest</code> structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPresetsRequest extends ElasticTranscoderRequest implements
        ToCopyableBuilder<ListPresetsRequest.Builder, ListPresetsRequest> {
    private static final SdkField<String> ASCENDING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListPresetsRequest::ascending)).setter(setter(Builder::ascending))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Ascending").build()).build();

    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListPresetsRequest::pageToken)).setter(setter(Builder::pageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("PageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASCENDING_FIELD,
            PAGE_TOKEN_FIELD));

    private final String ascending;

    private final String pageToken;

    private ListPresetsRequest(BuilderImpl builder) {
        super(builder);
        this.ascending = builder.ascending;
        this.pageToken = builder.pageToken;
    }

    /**
     * <p>
     * To list presets in chronological order by the date and time that they were created, enter <code>true</code>. To
     * list presets in reverse chronological order, enter <code>false</code>.
     * </p>
     * 
     * @return To list presets in chronological order by the date and time that they were created, enter
     *         <code>true</code>. To list presets in reverse chronological order, enter <code>false</code>.
     */
    public String ascending() {
        return ascending;
    }

    /**
     * <p>
     * When Elastic Transcoder returns more than one page of results, use <code>pageToken</code> in subsequent
     * <code>GET</code> requests to get each successive page of results.
     * </p>
     * 
     * @return When Elastic Transcoder returns more than one page of results, use <code>pageToken</code> in subsequent
     *         <code>GET</code> requests to get each successive page of results.
     */
    public String pageToken() {
        return pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ascending());
        hashCode = 31 * hashCode + Objects.hashCode(pageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPresetsRequest)) {
            return false;
        }
        ListPresetsRequest other = (ListPresetsRequest) obj;
        return Objects.equals(ascending(), other.ascending()) && Objects.equals(pageToken(), other.pageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPresetsRequest").add("Ascending", ascending()).add("PageToken", pageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ascending":
            return Optional.ofNullable(clazz.cast(ascending()));
        case "PageToken":
            return Optional.ofNullable(clazz.cast(pageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPresetsRequest, T> g) {
        return obj -> g.apply((ListPresetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticTranscoderRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListPresetsRequest> {
        /**
         * <p>
         * To list presets in chronological order by the date and time that they were created, enter <code>true</code>.
         * To list presets in reverse chronological order, enter <code>false</code>.
         * </p>
         * 
         * @param ascending
         *        To list presets in chronological order by the date and time that they were created, enter
         *        <code>true</code>. To list presets in reverse chronological order, enter <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ascending(String ascending);

        /**
         * <p>
         * When Elastic Transcoder returns more than one page of results, use <code>pageToken</code> in subsequent
         * <code>GET</code> requests to get each successive page of results.
         * </p>
         * 
         * @param pageToken
         *        When Elastic Transcoder returns more than one page of results, use <code>pageToken</code> in
         *        subsequent <code>GET</code> requests to get each successive page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageToken(String pageToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticTranscoderRequest.BuilderImpl implements Builder {
        private String ascending;

        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPresetsRequest model) {
            super(model);
            ascending(model.ascending);
            pageToken(model.pageToken);
        }

        public final String getAscending() {
            return ascending;
        }

        @Override
        public final Builder ascending(String ascending) {
            this.ascending = ascending;
            return this;
        }

        public final void setAscending(String ascending) {
            this.ascending = ascending;
        }

        public final String getPageToken() {
            return pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPresetsRequest build() {
            return new ListPresetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
