/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>PipelineOutputConfig</code> structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineOutputConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<PipelineOutputConfig.Builder, PipelineOutputConfig> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PipelineOutputConfig::bucket)).setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").build()).build();

    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PipelineOutputConfig::storageClass)).setter(setter(Builder::storageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageClass").build()).build();

    private static final SdkField<List<Permission>> PERMISSIONS_FIELD = SdkField
            .<List<Permission>> builder(MarshallingType.LIST)
            .getter(getter(PipelineOutputConfig::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Permission> builder(MarshallingType.SDK_POJO)
                                            .constructor(Permission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD,
            STORAGE_CLASS_FIELD, PERMISSIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucket;

    private final String storageClass;

    private final List<Permission> permissions;

    private PipelineOutputConfig(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.storageClass = builder.storageClass;
        this.permissions = builder.permissions;
    }

    /**
     * <p>
     * The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files. Specify this value when
     * all of the following are true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You want to save transcoded files, thumbnails (if any), and playlists (if any) together in one bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * You do not want to specify the users or groups who have access to the transcoded files, thumbnails, and
     * playlists.
     * </p>
     * </li>
     * <li>
     * <p>
     * You do not want to specify the permissions that Elastic Transcoder grants to the files.
     * </p>
     * </li>
     * <li>
     * <p>
     * You want to associate the transcoded files and thumbnails with the Amazon S3 Standard storage class.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you want to save transcoded files and playlists in one bucket and thumbnails in another bucket, specify which
     * users can access the transcoded files or the permissions the users have, or change the Amazon S3 storage class,
     * omit OutputBucket and specify values for <code>ContentConfig</code> and <code>ThumbnailConfig</code> instead.
     * </p>
     * 
     * @return The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files. Specify this
     *         value when all of the following are true:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You want to save transcoded files, thumbnails (if any), and playlists (if any) together in one bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You do not want to specify the users or groups who have access to the transcoded files, thumbnails, and
     *         playlists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You do not want to specify the permissions that Elastic Transcoder grants to the files.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You want to associate the transcoded files and thumbnails with the Amazon S3 Standard storage class.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you want to save transcoded files and playlists in one bucket and thumbnails in another bucket,
     *         specify which users can access the transcoded files or the permissions the users have, or change the
     *         Amazon S3 storage class, omit OutputBucket and specify values for <code>ContentConfig</code> and
     *         <code>ThumbnailConfig</code> instead.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want Elastic
     * Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket.
     * </p>
     * 
     * @return The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want
     *         Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket.
     */
    public String storageClass() {
        return storageClass;
    }

    /**
     * <p>
     * Optional. The <code>Permissions</code> object specifies which users and/or predefined Amazon S3 groups you want
     * to have access to transcoded files and playlists, and the type of access you want them to have. You can grant
     * permissions to a maximum of 30 users and/or predefined Amazon S3 groups.
     * </p>
     * <p>
     * If you include <code>Permissions</code>, Elastic Transcoder grants only the permissions that you specify. It does
     * not grant full permissions to the owner of the role specified by <code>Role</code>. If you want that user to have
     * full control, you must explicitly grant full control to the user.
     * </p>
     * <p>
     * If you omit <code>Permissions</code>, Elastic Transcoder grants full control over the transcoded files and
     * playlists to the owner of the role specified by <code>Role</code>, and grants no other permissions to any other
     * user or group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Optional. The <code>Permissions</code> object specifies which users and/or predefined Amazon S3 groups
     *         you want to have access to transcoded files and playlists, and the type of access you want them to have.
     *         You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.</p>
     *         <p>
     *         If you include <code>Permissions</code>, Elastic Transcoder grants only the permissions that you specify.
     *         It does not grant full permissions to the owner of the role specified by <code>Role</code>. If you want
     *         that user to have full control, you must explicitly grant full control to the user.
     *         </p>
     *         <p>
     *         If you omit <code>Permissions</code>, Elastic Transcoder grants full control over the transcoded files
     *         and playlists to the owner of the role specified by <code>Role</code>, and grants no other permissions to
     *         any other user or group.
     */
    public List<Permission> permissions() {
        return permissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(storageClass());
        hashCode = 31 * hashCode + Objects.hashCode(permissions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineOutputConfig)) {
            return false;
        }
        PipelineOutputConfig other = (PipelineOutputConfig) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(storageClass(), other.storageClass())
                && Objects.equals(permissions(), other.permissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PipelineOutputConfig").add("Bucket", bucket()).add("StorageClass", storageClass())
                .add("Permissions", permissions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "StorageClass":
            return Optional.ofNullable(clazz.cast(storageClass()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineOutputConfig, T> g) {
        return obj -> g.apply((PipelineOutputConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineOutputConfig> {
        /**
         * <p>
         * The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files. Specify this value
         * when all of the following are true:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You want to save transcoded files, thumbnails (if any), and playlists (if any) together in one bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * You do not want to specify the users or groups who have access to the transcoded files, thumbnails, and
         * playlists.
         * </p>
         * </li>
         * <li>
         * <p>
         * You do not want to specify the permissions that Elastic Transcoder grants to the files.
         * </p>
         * </li>
         * <li>
         * <p>
         * You want to associate the transcoded files and thumbnails with the Amazon S3 Standard storage class.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you want to save transcoded files and playlists in one bucket and thumbnails in another bucket, specify
         * which users can access the transcoded files or the permissions the users have, or change the Amazon S3
         * storage class, omit OutputBucket and specify values for <code>ContentConfig</code> and
         * <code>ThumbnailConfig</code> instead.
         * </p>
         * 
         * @param bucket
         *        The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files. Specify this
         *        value when all of the following are true:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        You want to save transcoded files, thumbnails (if any), and playlists (if any) together in one bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You do not want to specify the users or groups who have access to the transcoded files, thumbnails,
         *        and playlists.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You do not want to specify the permissions that Elastic Transcoder grants to the files.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You want to associate the transcoded files and thumbnails with the Amazon S3 Standard storage class.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you want to save transcoded files and playlists in one bucket and thumbnails in another bucket,
         *        specify which users can access the transcoded files or the permissions the users have, or change the
         *        Amazon S3 storage class, omit OutputBucket and specify values for <code>ContentConfig</code> and
         *        <code>ThumbnailConfig</code> instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want Elastic
         * Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket.
         * </p>
         * 
         * @param storageClass
         *        The Amazon S3 storage class, <code>Standard</code> or <code>ReducedRedundancy</code>, that you want
         *        Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageClass(String storageClass);

        /**
         * <p>
         * Optional. The <code>Permissions</code> object specifies which users and/or predefined Amazon S3 groups you
         * want to have access to transcoded files and playlists, and the type of access you want them to have. You can
         * grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.
         * </p>
         * <p>
         * If you include <code>Permissions</code>, Elastic Transcoder grants only the permissions that you specify. It
         * does not grant full permissions to the owner of the role specified by <code>Role</code>. If you want that
         * user to have full control, you must explicitly grant full control to the user.
         * </p>
         * <p>
         * If you omit <code>Permissions</code>, Elastic Transcoder grants full control over the transcoded files and
         * playlists to the owner of the role specified by <code>Role</code>, and grants no other permissions to any
         * other user or group.
         * </p>
         * 
         * @param permissions
         *        Optional. The <code>Permissions</code> object specifies which users and/or predefined Amazon S3 groups
         *        you want to have access to transcoded files and playlists, and the type of access you want them to
         *        have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.</p>
         *        <p>
         *        If you include <code>Permissions</code>, Elastic Transcoder grants only the permissions that you
         *        specify. It does not grant full permissions to the owner of the role specified by <code>Role</code>.
         *        If you want that user to have full control, you must explicitly grant full control to the user.
         *        </p>
         *        <p>
         *        If you omit <code>Permissions</code>, Elastic Transcoder grants full control over the transcoded files
         *        and playlists to the owner of the role specified by <code>Role</code>, and grants no other permissions
         *        to any other user or group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<Permission> permissions);

        /**
         * <p>
         * Optional. The <code>Permissions</code> object specifies which users and/or predefined Amazon S3 groups you
         * want to have access to transcoded files and playlists, and the type of access you want them to have. You can
         * grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.
         * </p>
         * <p>
         * If you include <code>Permissions</code>, Elastic Transcoder grants only the permissions that you specify. It
         * does not grant full permissions to the owner of the role specified by <code>Role</code>. If you want that
         * user to have full control, you must explicitly grant full control to the user.
         * </p>
         * <p>
         * If you omit <code>Permissions</code>, Elastic Transcoder grants full control over the transcoded files and
         * playlists to the owner of the role specified by <code>Role</code>, and grants no other permissions to any
         * other user or group.
         * </p>
         * 
         * @param permissions
         *        Optional. The <code>Permissions</code> object specifies which users and/or predefined Amazon S3 groups
         *        you want to have access to transcoded files and playlists, and the type of access you want them to
         *        have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.</p>
         *        <p>
         *        If you include <code>Permissions</code>, Elastic Transcoder grants only the permissions that you
         *        specify. It does not grant full permissions to the owner of the role specified by <code>Role</code>.
         *        If you want that user to have full control, you must explicitly grant full control to the user.
         *        </p>
         *        <p>
         *        If you omit <code>Permissions</code>, Elastic Transcoder grants full control over the transcoded files
         *        and playlists to the owner of the role specified by <code>Role</code>, and grants no other permissions
         *        to any other user or group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Permission... permissions);

        /**
         * <p>
         * Optional. The <code>Permissions</code> object specifies which users and/or predefined Amazon S3 groups you
         * want to have access to transcoded files and playlists, and the type of access you want them to have. You can
         * grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.
         * </p>
         * <p>
         * If you include <code>Permissions</code>, Elastic Transcoder grants only the permissions that you specify. It
         * does not grant full permissions to the owner of the role specified by <code>Role</code>. If you want that
         * user to have full control, you must explicitly grant full control to the user.
         * </p>
         * <p>
         * If you omit <code>Permissions</code>, Elastic Transcoder grants full control over the transcoded files and
         * playlists to the owner of the role specified by <code>Role</code>, and grants no other permissions to any
         * other user or group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Permission>.Builder} avoiding the need to
         * create one manually via {@link List<Permission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Permission>.Builder#build()} is called immediately and its
         * result is passed to {@link #permissions(List<Permission>)}.
         * 
         * @param permissions
         *        a consumer that will call methods on {@link List<Permission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(List<Permission>)
         */
        Builder permissions(Consumer<Permission.Builder>... permissions);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private String storageClass;

        private List<Permission> permissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineOutputConfig model) {
            bucket(model.bucket);
            storageClass(model.storageClass);
            permissions(model.permissions);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getStorageClass() {
            return storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public final Collection<Permission.Builder> getPermissions() {
            return permissions != null ? permissions.stream().map(Permission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder permissions(Collection<Permission> permissions) {
            this.permissions = PermissionsCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Permission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<Permission.Builder>... permissions) {
            permissions(Stream.of(permissions).map(c -> Permission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPermissions(Collection<Permission.BuilderImpl> permissions) {
            this.permissions = PermissionsCopier.copyFromBuilder(permissions);
        }

        @Override
        public PipelineOutputConfig build() {
            return new PipelineOutputConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
