/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>UpdatePipelineNotificationsRequest</code> structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePipelineNotificationsRequest extends ElasticTranscoderRequest implements
        ToCopyableBuilder<UpdatePipelineNotificationsRequest.Builder, UpdatePipelineNotificationsRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdatePipelineNotificationsRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()).build();

    private static final SdkField<Notifications> NOTIFICATIONS_FIELD = SdkField.<Notifications> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdatePipelineNotificationsRequest::notifications)).setter(setter(Builder::notifications))
            .constructor(Notifications::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notifications").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ID_FIELD, NOTIFICATIONS_FIELD));

    private final String id;

    private final Notifications notifications;

    private UpdatePipelineNotificationsRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.notifications = builder.notifications;
    }

    /**
     * <p>
     * The identifier of the pipeline for which you want to change notification settings.
     * </p>
     * 
     * @return The identifier of the pipeline for which you want to change notification settings.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job
     * status.
     * </p>
     * <important>
     * <p>
     * To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.
     * </p>
     * </important>
     * <ul>
     * <li>
     * <p>
     * <b>Progressing</b>: The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to
     * notify when Elastic Transcoder has started to process jobs that are added to this pipeline. This is the ARN that
     * Amazon SNS returned when you created the topic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Complete</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder has
     * finished processing a job. This is the ARN that Amazon SNS returned when you created the topic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Warning</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters
     * a warning condition. This is the ARN that Amazon SNS returned when you created the topic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Error</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters
     * an error condition. This is the ARN that Amazon SNS returned when you created the topic.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to
     *         report job status.</p> <important>
     *         <p>
     *         To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.
     *         </p>
     *         </important>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Progressing</b>: The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you
     *         want to notify when Elastic Transcoder has started to process jobs that are added to this pipeline. This
     *         is the ARN that Amazon SNS returned when you created the topic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Complete</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder
     *         has finished processing a job. This is the ARN that Amazon SNS returned when you created the topic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Warning</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder
     *         encounters a warning condition. This is the ARN that Amazon SNS returned when you created the topic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Error</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder
     *         encounters an error condition. This is the ARN that Amazon SNS returned when you created the topic.
     *         </p>
     *         </li>
     */
    public Notifications notifications() {
        return notifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(notifications());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipelineNotificationsRequest)) {
            return false;
        }
        UpdatePipelineNotificationsRequest other = (UpdatePipelineNotificationsRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(notifications(), other.notifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdatePipelineNotificationsRequest").add("Id", id()).add("Notifications", notifications())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Notifications":
            return Optional.ofNullable(clazz.cast(notifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipelineNotificationsRequest, T> g) {
        return obj -> g.apply((UpdatePipelineNotificationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticTranscoderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePipelineNotificationsRequest> {
        /**
         * <p>
         * The identifier of the pipeline for which you want to change notification settings.
         * </p>
         * 
         * @param id
         *        The identifier of the pipeline for which you want to change notification settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report
         * job status.
         * </p>
         * <important>
         * <p>
         * To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.
         * </p>
         * </important>
         * <ul>
         * <li>
         * <p>
         * <b>Progressing</b>: The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want
         * to notify when Elastic Transcoder has started to process jobs that are added to this pipeline. This is the
         * ARN that Amazon SNS returned when you created the topic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Complete</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder has
         * finished processing a job. This is the ARN that Amazon SNS returned when you created the topic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Warning</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder
         * encounters a warning condition. This is the ARN that Amazon SNS returned when you created the topic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Error</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder
         * encounters an error condition. This is the ARN that Amazon SNS returned when you created the topic.
         * </p>
         * </li>
         * </ul>
         * 
         * @param notifications
         *        The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to
         *        report job status.</p> <important>
         *        <p>
         *        To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.
         *        </p>
         *        </important>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Progressing</b>: The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that
         *        you want to notify when Elastic Transcoder has started to process jobs that are added to this
         *        pipeline. This is the ARN that Amazon SNS returned when you created the topic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Complete</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic
         *        Transcoder has finished processing a job. This is the ARN that Amazon SNS returned when you created
         *        the topic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Warning</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder
         *        encounters a warning condition. This is the ARN that Amazon SNS returned when you created the topic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Error</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder
         *        encounters an error condition. This is the ARN that Amazon SNS returned when you created the topic.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notifications(Notifications notifications);

        /**
         * <p>
         * The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report
         * job status.
         * </p>
         * <important>
         * <p>
         * To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.
         * </p>
         * </important>
         * <ul>
         * <li>
         * <p>
         * <b>Progressing</b>: The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want
         * to notify when Elastic Transcoder has started to process jobs that are added to this pipeline. This is the
         * ARN that Amazon SNS returned when you created the topic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Complete</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder has
         * finished processing a job. This is the ARN that Amazon SNS returned when you created the topic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Warning</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder
         * encounters a warning condition. This is the ARN that Amazon SNS returned when you created the topic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Error</b>: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder
         * encounters an error condition. This is the ARN that Amazon SNS returned when you created the topic.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link Notifications.Builder} avoiding the need to
         * create one manually via {@link Notifications#builder()}.
         *
         * When the {@link Consumer} completes, {@link Notifications.Builder#build()} is called immediately and its
         * result is passed to {@link #notifications(Notifications)}.
         * 
         * @param notifications
         *        a consumer that will call methods on {@link Notifications.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notifications(Notifications)
         */
        default Builder notifications(Consumer<Notifications.Builder> notifications) {
            return notifications(Notifications.builder().applyMutation(notifications).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticTranscoderRequest.BuilderImpl implements Builder {
        private String id;

        private Notifications notifications;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipelineNotificationsRequest model) {
            super(model);
            id(model.id);
            notifications(model.notifications);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Notifications.Builder getNotifications() {
            return notifications != null ? notifications.toBuilder() : null;
        }

        @Override
        public final Builder notifications(Notifications notifications) {
            this.notifications = notifications;
            return this;
        }

        public final void setNotifications(Notifications.BuilderImpl notifications) {
            this.notifications = notifications != null ? notifications.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePipelineNotificationsRequest build() {
            return new UpdatePipelineNotificationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
