/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>UpdatePipelineStatusRequest</code> structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePipelineStatusRequest extends ElasticTranscoderRequest implements
        ToCopyableBuilder<UpdatePipelineStatusRequest.Builder, UpdatePipelineStatusRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdatePipelineStatusRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdatePipelineStatusRequest::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STATUS_FIELD));

    private final String id;

    private final String status;

    private UpdatePipelineStatusRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.status = builder.status;
    }

    /**
     * <p>
     * The identifier of the pipeline to update.
     * </p>
     * 
     * @return The identifier of the pipeline to update.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The desired status of the pipeline:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Active</code>: The pipeline is processing jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Paused</code>: The pipeline is not currently processing jobs.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The desired status of the pipeline:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Active</code>: The pipeline is processing jobs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Paused</code>: The pipeline is not currently processing jobs.
     *         </p>
     *         </li>
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipelineStatusRequest)) {
            return false;
        }
        UpdatePipelineStatusRequest other = (UpdatePipelineStatusRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdatePipelineStatusRequest").add("Id", id()).add("Status", status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipelineStatusRequest, T> g) {
        return obj -> g.apply((UpdatePipelineStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticTranscoderRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePipelineStatusRequest> {
        /**
         * <p>
         * The identifier of the pipeline to update.
         * </p>
         * 
         * @param id
         *        The identifier of the pipeline to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The desired status of the pipeline:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Active</code>: The pipeline is processing jobs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Paused</code>: The pipeline is not currently processing jobs.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The desired status of the pipeline:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Active</code>: The pipeline is processing jobs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Paused</code>: The pipeline is not currently processing jobs.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticTranscoderRequest.BuilderImpl implements Builder {
        private String id;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipelineStatusRequest model) {
            super(model);
            id(model.id);
            status(model.status);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePipelineStatusRequest build() {
            return new UpdatePipelineStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
