/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options associated with your audio codec.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioCodecOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioCodecOptions.Builder, AudioCodecOptions> {
    private static final SdkField<String> PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AudioCodecOptions::profile)).setter(setter(Builder::profile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Profile").build()).build();

    private static final SdkField<String> BIT_DEPTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AudioCodecOptions::bitDepth)).setter(setter(Builder::bitDepth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BitDepth").build()).build();

    private static final SdkField<String> BIT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AudioCodecOptions::bitOrder)).setter(setter(Builder::bitOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BitOrder").build()).build();

    private static final SdkField<String> SIGNED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AudioCodecOptions::signed)).setter(setter(Builder::signed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Signed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_FIELD,
            BIT_DEPTH_FIELD, BIT_ORDER_FIELD, SIGNED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String profile;

    private final String bitDepth;

    private final String bitOrder;

    private final String signed;

    private AudioCodecOptions(BuilderImpl builder) {
        this.profile = builder.profile;
        this.bitDepth = builder.bitDepth;
        this.bitOrder = builder.bitOrder;
        this.signed = builder.signed;
    }

    /**
     * <p>
     * You can only choose an audio profile when you specify AAC for the value of Audio:Codec.
     * </p>
     * <p>
     * Specify the AAC profile for the output file. Elastic Transcoder supports the following profiles:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>auto</code>: If you specify <code>auto</code>, Elastic Transcoder selects the profile based on the bit rate
     * selected for the output file.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AAC-LC</code>: The most common AAC profile. Use for bit rates larger than 64 kbps.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HE-AAC</code>: Not supported on some older players and devices. Use for bit rates between 40 and 80 kbps.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HE-AACv2</code>: Not supported on some players and devices. Use for bit rates less than 48 kbps.
     * </p>
     * </li>
     * </ul>
     * <p>
     * All outputs in a <code>Smooth</code> playlist must have the same value for <code>Profile</code>.
     * </p>
     * <note>
     * <p>
     * If you created any presets before AAC profiles were added, Elastic Transcoder automatically updated your presets
     * to use AAC-LC. You can change the value as required.
     * </p>
     * </note>
     * 
     * @return You can only choose an audio profile when you specify AAC for the value of Audio:Codec.</p>
     *         <p>
     *         Specify the AAC profile for the output file. Elastic Transcoder supports the following profiles:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>auto</code>: If you specify <code>auto</code>, Elastic Transcoder selects the profile based on the
     *         bit rate selected for the output file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AAC-LC</code>: The most common AAC profile. Use for bit rates larger than 64 kbps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HE-AAC</code>: Not supported on some older players and devices. Use for bit rates between 40 and 80
     *         kbps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HE-AACv2</code>: Not supported on some players and devices. Use for bit rates less than 48 kbps.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         All outputs in a <code>Smooth</code> playlist must have the same value for <code>Profile</code>.
     *         </p>
     *         <note>
     *         <p>
     *         If you created any presets before AAC profiles were added, Elastic Transcoder automatically updated your
     *         presets to use AAC-LC. You can change the value as required.
     *         </p>
     */
    public String profile() {
        return profile;
    }

    /**
     * <p>
     * You can only choose an audio bit depth when you specify <code>flac</code> or <code>pcm</code> for the value of
     * Audio:Codec.
     * </p>
     * <p>
     * The bit depth of a sample is how many bits of information are included in the audio samples. The higher the bit
     * depth, the better the audio, but the larger the file.
     * </p>
     * <p>
     * Valid values are <code>16</code> and <code>24</code>.
     * </p>
     * <p>
     * The most common bit depth is <code>24</code>.
     * </p>
     * 
     * @return You can only choose an audio bit depth when you specify <code>flac</code> or <code>pcm</code> for the
     *         value of Audio:Codec.</p>
     *         <p>
     *         The bit depth of a sample is how many bits of information are included in the audio samples. The higher
     *         the bit depth, the better the audio, but the larger the file.
     *         </p>
     *         <p>
     *         Valid values are <code>16</code> and <code>24</code>.
     *         </p>
     *         <p>
     *         The most common bit depth is <code>24</code>.
     */
    public String bitDepth() {
        return bitDepth;
    }

    /**
     * <p>
     * You can only choose an audio bit order when you specify <code>pcm</code> for the value of Audio:Codec.
     * </p>
     * <p>
     * The order the bits of a PCM sample are stored in.
     * </p>
     * <p>
     * The supported value is <code>LittleEndian</code>.
     * </p>
     * 
     * @return You can only choose an audio bit order when you specify <code>pcm</code> for the value of
     *         Audio:Codec.</p>
     *         <p>
     *         The order the bits of a PCM sample are stored in.
     *         </p>
     *         <p>
     *         The supported value is <code>LittleEndian</code>.
     */
    public String bitOrder() {
        return bitOrder;
    }

    /**
     * <p>
     * You can only choose whether an audio sample is signed when you specify <code>pcm</code> for the value of
     * Audio:Codec.
     * </p>
     * <p>
     * Whether audio samples are represented with negative and positive numbers (signed) or only positive numbers
     * (unsigned).
     * </p>
     * <p>
     * The supported value is <code>Signed</code>.
     * </p>
     * 
     * @return You can only choose whether an audio sample is signed when you specify <code>pcm</code> for the value of
     *         Audio:Codec.</p>
     *         <p>
     *         Whether audio samples are represented with negative and positive numbers (signed) or only positive
     *         numbers (unsigned).
     *         </p>
     *         <p>
     *         The supported value is <code>Signed</code>.
     */
    public String signed() {
        return signed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(profile());
        hashCode = 31 * hashCode + Objects.hashCode(bitDepth());
        hashCode = 31 * hashCode + Objects.hashCode(bitOrder());
        hashCode = 31 * hashCode + Objects.hashCode(signed());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioCodecOptions)) {
            return false;
        }
        AudioCodecOptions other = (AudioCodecOptions) obj;
        return Objects.equals(profile(), other.profile()) && Objects.equals(bitDepth(), other.bitDepth())
                && Objects.equals(bitOrder(), other.bitOrder()) && Objects.equals(signed(), other.signed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AudioCodecOptions").add("Profile", profile()).add("BitDepth", bitDepth())
                .add("BitOrder", bitOrder()).add("Signed", signed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Profile":
            return Optional.ofNullable(clazz.cast(profile()));
        case "BitDepth":
            return Optional.ofNullable(clazz.cast(bitDepth()));
        case "BitOrder":
            return Optional.ofNullable(clazz.cast(bitOrder()));
        case "Signed":
            return Optional.ofNullable(clazz.cast(signed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioCodecOptions, T> g) {
        return obj -> g.apply((AudioCodecOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioCodecOptions> {
        /**
         * <p>
         * You can only choose an audio profile when you specify AAC for the value of Audio:Codec.
         * </p>
         * <p>
         * Specify the AAC profile for the output file. Elastic Transcoder supports the following profiles:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>auto</code>: If you specify <code>auto</code>, Elastic Transcoder selects the profile based on the bit
         * rate selected for the output file.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AAC-LC</code>: The most common AAC profile. Use for bit rates larger than 64 kbps.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HE-AAC</code>: Not supported on some older players and devices. Use for bit rates between 40 and 80
         * kbps.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HE-AACv2</code>: Not supported on some players and devices. Use for bit rates less than 48 kbps.
         * </p>
         * </li>
         * </ul>
         * <p>
         * All outputs in a <code>Smooth</code> playlist must have the same value for <code>Profile</code>.
         * </p>
         * <note>
         * <p>
         * If you created any presets before AAC profiles were added, Elastic Transcoder automatically updated your
         * presets to use AAC-LC. You can change the value as required.
         * </p>
         * </note>
         * 
         * @param profile
         *        You can only choose an audio profile when you specify AAC for the value of Audio:Codec.</p>
         *        <p>
         *        Specify the AAC profile for the output file. Elastic Transcoder supports the following profiles:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>auto</code>: If you specify <code>auto</code>, Elastic Transcoder selects the profile based on
         *        the bit rate selected for the output file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AAC-LC</code>: The most common AAC profile. Use for bit rates larger than 64 kbps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HE-AAC</code>: Not supported on some older players and devices. Use for bit rates between 40 and
         *        80 kbps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HE-AACv2</code>: Not supported on some players and devices. Use for bit rates less than 48 kbps.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        All outputs in a <code>Smooth</code> playlist must have the same value for <code>Profile</code>.
         *        </p>
         *        <note>
         *        <p>
         *        If you created any presets before AAC profiles were added, Elastic Transcoder automatically updated
         *        your presets to use AAC-LC. You can change the value as required.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profile(String profile);

        /**
         * <p>
         * You can only choose an audio bit depth when you specify <code>flac</code> or <code>pcm</code> for the value
         * of Audio:Codec.
         * </p>
         * <p>
         * The bit depth of a sample is how many bits of information are included in the audio samples. The higher the
         * bit depth, the better the audio, but the larger the file.
         * </p>
         * <p>
         * Valid values are <code>16</code> and <code>24</code>.
         * </p>
         * <p>
         * The most common bit depth is <code>24</code>.
         * </p>
         * 
         * @param bitDepth
         *        You can only choose an audio bit depth when you specify <code>flac</code> or <code>pcm</code> for the
         *        value of Audio:Codec.</p>
         *        <p>
         *        The bit depth of a sample is how many bits of information are included in the audio samples. The
         *        higher the bit depth, the better the audio, but the larger the file.
         *        </p>
         *        <p>
         *        Valid values are <code>16</code> and <code>24</code>.
         *        </p>
         *        <p>
         *        The most common bit depth is <code>24</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitDepth(String bitDepth);

        /**
         * <p>
         * You can only choose an audio bit order when you specify <code>pcm</code> for the value of Audio:Codec.
         * </p>
         * <p>
         * The order the bits of a PCM sample are stored in.
         * </p>
         * <p>
         * The supported value is <code>LittleEndian</code>.
         * </p>
         * 
         * @param bitOrder
         *        You can only choose an audio bit order when you specify <code>pcm</code> for the value of
         *        Audio:Codec.</p>
         *        <p>
         *        The order the bits of a PCM sample are stored in.
         *        </p>
         *        <p>
         *        The supported value is <code>LittleEndian</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitOrder(String bitOrder);

        /**
         * <p>
         * You can only choose whether an audio sample is signed when you specify <code>pcm</code> for the value of
         * Audio:Codec.
         * </p>
         * <p>
         * Whether audio samples are represented with negative and positive numbers (signed) or only positive numbers
         * (unsigned).
         * </p>
         * <p>
         * The supported value is <code>Signed</code>.
         * </p>
         * 
         * @param signed
         *        You can only choose whether an audio sample is signed when you specify <code>pcm</code> for the value
         *        of Audio:Codec.</p>
         *        <p>
         *        Whether audio samples are represented with negative and positive numbers (signed) or only positive
         *        numbers (unsigned).
         *        </p>
         *        <p>
         *        The supported value is <code>Signed</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signed(String signed);
    }

    static final class BuilderImpl implements Builder {
        private String profile;

        private String bitDepth;

        private String bitOrder;

        private String signed;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioCodecOptions model) {
            profile(model.profile);
            bitDepth(model.bitDepth);
            bitOrder(model.bitOrder);
            signed(model.signed);
        }

        public final String getProfile() {
            return profile;
        }

        @Override
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        public final String getBitDepth() {
            return bitDepth;
        }

        @Override
        public final Builder bitDepth(String bitDepth) {
            this.bitDepth = bitDepth;
            return this;
        }

        public final void setBitDepth(String bitDepth) {
            this.bitDepth = bitDepth;
        }

        public final String getBitOrder() {
            return bitOrder;
        }

        @Override
        public final Builder bitOrder(String bitOrder) {
            this.bitOrder = bitOrder;
            return this;
        }

        public final void setBitOrder(String bitOrder) {
            this.bitOrder = bitOrder;
        }

        public final String getSigned() {
            return signed;
        }

        @Override
        public final Builder signed(String signed) {
            this.signed = signed;
            return this;
        }

        public final void setSigned(String signed) {
            this.signed = signed;
        }

        @Override
        public AudioCodecOptions build() {
            return new AudioCodecOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
