/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The detected properties of the input file. Elastic Transcoder identifies these values from the input file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectedProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectedProperties.Builder, DetectedProperties> {
    private static final SdkField<Integer> WIDTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DetectedProperties::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Width").build()).build();

    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DetectedProperties::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Height").build()).build();

    private static final SdkField<String> FRAME_RATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DetectedProperties::frameRate)).setter(setter(Builder::frameRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameRate").build()).build();

    private static final SdkField<Long> FILE_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DetectedProperties::fileSize)).setter(setter(Builder::fileSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSize").build()).build();

    private static final SdkField<Long> DURATION_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DetectedProperties::durationMillis)).setter(setter(Builder::durationMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMillis").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WIDTH_FIELD, HEIGHT_FIELD,
            FRAME_RATE_FIELD, FILE_SIZE_FIELD, DURATION_MILLIS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer width;

    private final Integer height;

    private final String frameRate;

    private final Long fileSize;

    private final Long durationMillis;

    private DetectedProperties(BuilderImpl builder) {
        this.width = builder.width;
        this.height = builder.height;
        this.frameRate = builder.frameRate;
        this.fileSize = builder.fileSize;
        this.durationMillis = builder.durationMillis;
    }

    /**
     * <p>
     * The detected width of the input file, in pixels.
     * </p>
     * 
     * @return The detected width of the input file, in pixels.
     */
    public Integer width() {
        return width;
    }

    /**
     * <p>
     * The detected height of the input file, in pixels.
     * </p>
     * 
     * @return The detected height of the input file, in pixels.
     */
    public Integer height() {
        return height;
    }

    /**
     * <p>
     * The detected frame rate of the input file, in frames per second.
     * </p>
     * 
     * @return The detected frame rate of the input file, in frames per second.
     */
    public String frameRate() {
        return frameRate;
    }

    /**
     * <p>
     * The detected file size of the input file, in bytes.
     * </p>
     * 
     * @return The detected file size of the input file, in bytes.
     */
    public Long fileSize() {
        return fileSize;
    }

    /**
     * <p>
     * The detected duration of the input file, in milliseconds.
     * </p>
     * 
     * @return The detected duration of the input file, in milliseconds.
     */
    public Long durationMillis() {
        return durationMillis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(width());
        hashCode = 31 * hashCode + Objects.hashCode(height());
        hashCode = 31 * hashCode + Objects.hashCode(frameRate());
        hashCode = 31 * hashCode + Objects.hashCode(fileSize());
        hashCode = 31 * hashCode + Objects.hashCode(durationMillis());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectedProperties)) {
            return false;
        }
        DetectedProperties other = (DetectedProperties) obj;
        return Objects.equals(width(), other.width()) && Objects.equals(height(), other.height())
                && Objects.equals(frameRate(), other.frameRate()) && Objects.equals(fileSize(), other.fileSize())
                && Objects.equals(durationMillis(), other.durationMillis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DetectedProperties").add("Width", width()).add("Height", height()).add("FrameRate", frameRate())
                .add("FileSize", fileSize()).add("DurationMillis", durationMillis()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Width":
            return Optional.ofNullable(clazz.cast(width()));
        case "Height":
            return Optional.ofNullable(clazz.cast(height()));
        case "FrameRate":
            return Optional.ofNullable(clazz.cast(frameRate()));
        case "FileSize":
            return Optional.ofNullable(clazz.cast(fileSize()));
        case "DurationMillis":
            return Optional.ofNullable(clazz.cast(durationMillis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectedProperties, T> g) {
        return obj -> g.apply((DetectedProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectedProperties> {
        /**
         * <p>
         * The detected width of the input file, in pixels.
         * </p>
         * 
         * @param width
         *        The detected width of the input file, in pixels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(Integer width);

        /**
         * <p>
         * The detected height of the input file, in pixels.
         * </p>
         * 
         * @param height
         *        The detected height of the input file, in pixels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(Integer height);

        /**
         * <p>
         * The detected frame rate of the input file, in frames per second.
         * </p>
         * 
         * @param frameRate
         *        The detected frame rate of the input file, in frames per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameRate(String frameRate);

        /**
         * <p>
         * The detected file size of the input file, in bytes.
         * </p>
         * 
         * @param fileSize
         *        The detected file size of the input file, in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSize(Long fileSize);

        /**
         * <p>
         * The detected duration of the input file, in milliseconds.
         * </p>
         * 
         * @param durationMillis
         *        The detected duration of the input file, in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationMillis(Long durationMillis);
    }

    static final class BuilderImpl implements Builder {
        private Integer width;

        private Integer height;

        private String frameRate;

        private Long fileSize;

        private Long durationMillis;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectedProperties model) {
            width(model.width);
            height(model.height);
            frameRate(model.frameRate);
            fileSize(model.fileSize);
            durationMillis(model.durationMillis);
        }

        public final Integer getWidth() {
            return width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        public final Integer getHeight() {
            return height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        public final String getFrameRate() {
            return frameRate;
        }

        @Override
        public final Builder frameRate(String frameRate) {
            this.frameRate = frameRate;
            return this;
        }

        public final void setFrameRate(String frameRate) {
            this.frameRate = frameRate;
        }

        public final Long getFileSize() {
            return fileSize;
        }

        @Override
        public final Builder fileSize(Long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public final void setFileSize(Long fileSize) {
            this.fileSize = fileSize;
        }

        public final Long getDurationMillis() {
            return durationMillis;
        }

        @Override
        public final Builder durationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
            return this;
        }

        public final void setDurationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
        }

        @Override
        public DetectedProperties build() {
            return new DetectedProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
