/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The PlayReady DRM settings, if any, that you want Elastic Transcoder to apply to the output files associated with
 * this playlist.
 * </p>
 * <p>
 * PlayReady DRM encrypts your media files using <code>aes-ctr</code> encryption.
 * </p>
 * <p>
 * If you use DRM for an <code>HLSv3</code> playlist, your outputs must have a master playlist.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PlayReadyDrm implements SdkPojo, Serializable, ToCopyableBuilder<PlayReadyDrm.Builder, PlayReadyDrm> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlayReadyDrm::format)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlayReadyDrm::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> KEY_MD5_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlayReadyDrm::keyMd5)).setter(setter(Builder::keyMd5))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMd5").build()).build();

    private static final SdkField<String> KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlayReadyDrm::keyId)).setter(setter(Builder::keyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()).build();

    private static final SdkField<String> INITIALIZATION_VECTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlayReadyDrm::initializationVector)).setter(setter(Builder::initializationVector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitializationVector").build())
            .build();

    private static final SdkField<String> LICENSE_ACQUISITION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlayReadyDrm::licenseAcquisitionUrl)).setter(setter(Builder::licenseAcquisitionUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseAcquisitionUrl").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, KEY_FIELD,
            KEY_MD5_FIELD, KEY_ID_FIELD, INITIALIZATION_VECTOR_FIELD, LICENSE_ACQUISITION_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String format;

    private final String key;

    private final String keyMd5;

    private final String keyId;

    private final String initializationVector;

    private final String licenseAcquisitionUrl;

    private PlayReadyDrm(BuilderImpl builder) {
        this.format = builder.format;
        this.key = builder.key;
        this.keyMd5 = builder.keyMd5;
        this.keyId = builder.keyId;
        this.initializationVector = builder.initializationVector;
        this.licenseAcquisitionUrl = builder.licenseAcquisitionUrl;
    }

    /**
     * <p>
     * The type of DRM, if any, that you want Elastic Transcoder to apply to the output files associated with this
     * playlist.
     * </p>
     * 
     * @return The type of DRM, if any, that you want Elastic Transcoder to apply to the output files associated with
     *         this playlist.
     */
    public String format() {
        return format;
    }

    /**
     * <p>
     * The DRM key for your file, provided by your DRM license provider. The key must be base64-encoded, and it must be
     * one of the following bit lengths before being base64-encoded:
     * </p>
     * <p>
     * <code>128</code>, <code>192</code>, or <code>256</code>.
     * </p>
     * <p>
     * The key must also be encrypted by using AWS KMS.
     * </p>
     * 
     * @return The DRM key for your file, provided by your DRM license provider. The key must be base64-encoded, and it
     *         must be one of the following bit lengths before being base64-encoded:</p>
     *         <p>
     *         <code>128</code>, <code>192</code>, or <code>256</code>.
     *         </p>
     *         <p>
     *         The key must also be encrypted by using AWS KMS.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The MD5 digest of the key used for DRM on your file, and that you want Elastic Transcoder to use as a checksum to
     * make sure your key was not corrupted in transit. The key MD5 must be base64-encoded, and it must be exactly 16
     * bytes before being base64-encoded.
     * </p>
     * 
     * @return The MD5 digest of the key used for DRM on your file, and that you want Elastic Transcoder to use as a
     *         checksum to make sure your key was not corrupted in transit. The key MD5 must be base64-encoded, and it
     *         must be exactly 16 bytes before being base64-encoded.
     */
    public String keyMd5() {
        return keyMd5;
    }

    /**
     * <p>
     * The ID for your DRM key, so that your DRM license provider knows which key to provide.
     * </p>
     * <p>
     * The key ID must be provided in big endian, and Elastic Transcoder converts it to little endian before inserting
     * it into the PlayReady DRM headers. If you are unsure whether your license server provides your key ID in big or
     * little endian, check with your DRM provider.
     * </p>
     * 
     * @return The ID for your DRM key, so that your DRM license provider knows which key to provide.</p>
     *         <p>
     *         The key ID must be provided in big endian, and Elastic Transcoder converts it to little endian before
     *         inserting it into the PlayReady DRM headers. If you are unsure whether your license server provides your
     *         key ID in big or little endian, check with your DRM provider.
     */
    public String keyId() {
        return keyId;
    }

    /**
     * <p>
     * The series of random bits created by a random bit generator, unique for every encryption operation, that you want
     * Elastic Transcoder to use to encrypt your files. The initialization vector must be base64-encoded, and it must be
     * exactly 8 bytes long before being base64-encoded. If no initialization vector is provided, Elastic Transcoder
     * generates one for you.
     * </p>
     * 
     * @return The series of random bits created by a random bit generator, unique for every encryption operation, that
     *         you want Elastic Transcoder to use to encrypt your files. The initialization vector must be
     *         base64-encoded, and it must be exactly 8 bytes long before being base64-encoded. If no initialization
     *         vector is provided, Elastic Transcoder generates one for you.
     */
    public String initializationVector() {
        return initializationVector;
    }

    /**
     * <p>
     * The location of the license key required to play DRM content. The URL must be an absolute path, and is referenced
     * by the PlayReady header. The PlayReady header is referenced in the protection header of the client manifest for
     * Smooth Streaming outputs, and in the EXT-X-DXDRM and EXT-XDXDRMINFO metadata tags for HLS playlist outputs. An
     * example URL looks like this: <code>https://www.example.com/exampleKey/</code>
     * </p>
     * 
     * @return The location of the license key required to play DRM content. The URL must be an absolute path, and is
     *         referenced by the PlayReady header. The PlayReady header is referenced in the protection header of the
     *         client manifest for Smooth Streaming outputs, and in the EXT-X-DXDRM and EXT-XDXDRMINFO metadata tags for
     *         HLS playlist outputs. An example URL looks like this: <code>https://www.example.com/exampleKey/</code>
     */
    public String licenseAcquisitionUrl() {
        return licenseAcquisitionUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(format());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(keyMd5());
        hashCode = 31 * hashCode + Objects.hashCode(keyId());
        hashCode = 31 * hashCode + Objects.hashCode(initializationVector());
        hashCode = 31 * hashCode + Objects.hashCode(licenseAcquisitionUrl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlayReadyDrm)) {
            return false;
        }
        PlayReadyDrm other = (PlayReadyDrm) obj;
        return Objects.equals(format(), other.format()) && Objects.equals(key(), other.key())
                && Objects.equals(keyMd5(), other.keyMd5()) && Objects.equals(keyId(), other.keyId())
                && Objects.equals(initializationVector(), other.initializationVector())
                && Objects.equals(licenseAcquisitionUrl(), other.licenseAcquisitionUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PlayReadyDrm").add("Format", format()).add("Key", key()).add("KeyMd5", keyMd5())
                .add("KeyId", keyId()).add("InitializationVector", initializationVector())
                .add("LicenseAcquisitionUrl", licenseAcquisitionUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Format":
            return Optional.ofNullable(clazz.cast(format()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "KeyMd5":
            return Optional.ofNullable(clazz.cast(keyMd5()));
        case "KeyId":
            return Optional.ofNullable(clazz.cast(keyId()));
        case "InitializationVector":
            return Optional.ofNullable(clazz.cast(initializationVector()));
        case "LicenseAcquisitionUrl":
            return Optional.ofNullable(clazz.cast(licenseAcquisitionUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlayReadyDrm, T> g) {
        return obj -> g.apply((PlayReadyDrm) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PlayReadyDrm> {
        /**
         * <p>
         * The type of DRM, if any, that you want Elastic Transcoder to apply to the output files associated with this
         * playlist.
         * </p>
         * 
         * @param format
         *        The type of DRM, if any, that you want Elastic Transcoder to apply to the output files associated with
         *        this playlist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        /**
         * <p>
         * The DRM key for your file, provided by your DRM license provider. The key must be base64-encoded, and it must
         * be one of the following bit lengths before being base64-encoded:
         * </p>
         * <p>
         * <code>128</code>, <code>192</code>, or <code>256</code>.
         * </p>
         * <p>
         * The key must also be encrypted by using AWS KMS.
         * </p>
         * 
         * @param key
         *        The DRM key for your file, provided by your DRM license provider. The key must be base64-encoded, and
         *        it must be one of the following bit lengths before being base64-encoded:</p>
         *        <p>
         *        <code>128</code>, <code>192</code>, or <code>256</code>.
         *        </p>
         *        <p>
         *        The key must also be encrypted by using AWS KMS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The MD5 digest of the key used for DRM on your file, and that you want Elastic Transcoder to use as a
         * checksum to make sure your key was not corrupted in transit. The key MD5 must be base64-encoded, and it must
         * be exactly 16 bytes before being base64-encoded.
         * </p>
         * 
         * @param keyMd5
         *        The MD5 digest of the key used for DRM on your file, and that you want Elastic Transcoder to use as a
         *        checksum to make sure your key was not corrupted in transit. The key MD5 must be base64-encoded, and
         *        it must be exactly 16 bytes before being base64-encoded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyMd5(String keyMd5);

        /**
         * <p>
         * The ID for your DRM key, so that your DRM license provider knows which key to provide.
         * </p>
         * <p>
         * The key ID must be provided in big endian, and Elastic Transcoder converts it to little endian before
         * inserting it into the PlayReady DRM headers. If you are unsure whether your license server provides your key
         * ID in big or little endian, check with your DRM provider.
         * </p>
         * 
         * @param keyId
         *        The ID for your DRM key, so that your DRM license provider knows which key to provide.</p>
         *        <p>
         *        The key ID must be provided in big endian, and Elastic Transcoder converts it to little endian before
         *        inserting it into the PlayReady DRM headers. If you are unsure whether your license server provides
         *        your key ID in big or little endian, check with your DRM provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * The series of random bits created by a random bit generator, unique for every encryption operation, that you
         * want Elastic Transcoder to use to encrypt your files. The initialization vector must be base64-encoded, and
         * it must be exactly 8 bytes long before being base64-encoded. If no initialization vector is provided, Elastic
         * Transcoder generates one for you.
         * </p>
         * 
         * @param initializationVector
         *        The series of random bits created by a random bit generator, unique for every encryption operation,
         *        that you want Elastic Transcoder to use to encrypt your files. The initialization vector must be
         *        base64-encoded, and it must be exactly 8 bytes long before being base64-encoded. If no initialization
         *        vector is provided, Elastic Transcoder generates one for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initializationVector(String initializationVector);

        /**
         * <p>
         * The location of the license key required to play DRM content. The URL must be an absolute path, and is
         * referenced by the PlayReady header. The PlayReady header is referenced in the protection header of the client
         * manifest for Smooth Streaming outputs, and in the EXT-X-DXDRM and EXT-XDXDRMINFO metadata tags for HLS
         * playlist outputs. An example URL looks like this: <code>https://www.example.com/exampleKey/</code>
         * </p>
         * 
         * @param licenseAcquisitionUrl
         *        The location of the license key required to play DRM content. The URL must be an absolute path, and is
         *        referenced by the PlayReady header. The PlayReady header is referenced in the protection header of the
         *        client manifest for Smooth Streaming outputs, and in the EXT-X-DXDRM and EXT-XDXDRMINFO metadata tags
         *        for HLS playlist outputs. An example URL looks like this:
         *        <code>https://www.example.com/exampleKey/</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseAcquisitionUrl(String licenseAcquisitionUrl);
    }

    static final class BuilderImpl implements Builder {
        private String format;

        private String key;

        private String keyMd5;

        private String keyId;

        private String initializationVector;

        private String licenseAcquisitionUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(PlayReadyDrm model) {
            format(model.format);
            key(model.key);
            keyMd5(model.keyMd5);
            keyId(model.keyId);
            initializationVector(model.initializationVector);
            licenseAcquisitionUrl(model.licenseAcquisitionUrl);
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getKeyMd5() {
            return keyMd5;
        }

        @Override
        public final Builder keyMd5(String keyMd5) {
            this.keyMd5 = keyMd5;
            return this;
        }

        public final void setKeyMd5(String keyMd5) {
            this.keyMd5 = keyMd5;
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getInitializationVector() {
            return initializationVector;
        }

        @Override
        public final Builder initializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
            return this;
        }

        public final void setInitializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
        }

        public final String getLicenseAcquisitionUrl() {
            return licenseAcquisitionUrl;
        }

        @Override
        public final Builder licenseAcquisitionUrl(String licenseAcquisitionUrl) {
            this.licenseAcquisitionUrl = licenseAcquisitionUrl;
            return this;
        }

        public final void setLicenseAcquisitionUrl(String licenseAcquisitionUrl) {
            this.licenseAcquisitionUrl = licenseAcquisitionUrl;
        }

        @Override
        public PlayReadyDrm build() {
            return new PlayReadyDrm(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
