/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the timing of a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Timing implements SdkPojo, Serializable, ToCopyableBuilder<Timing.Builder, Timing> {
    private static final SdkField<Long> SUBMIT_TIME_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Timing::submitTimeMillis)).setter(setter(Builder::submitTimeMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTimeMillis").build()).build();

    private static final SdkField<Long> START_TIME_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Timing::startTimeMillis)).setter(setter(Builder::startTimeMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimeMillis").build()).build();

    private static final SdkField<Long> FINISH_TIME_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Timing::finishTimeMillis)).setter(setter(Builder::finishTimeMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinishTimeMillis").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBMIT_TIME_MILLIS_FIELD,
            START_TIME_MILLIS_FIELD, FINISH_TIME_MILLIS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long submitTimeMillis;

    private final Long startTimeMillis;

    private final Long finishTimeMillis;

    private Timing(BuilderImpl builder) {
        this.submitTimeMillis = builder.submitTimeMillis;
        this.startTimeMillis = builder.startTimeMillis;
        this.finishTimeMillis = builder.finishTimeMillis;
    }

    /**
     * <p>
     * The time the job was submitted to Elastic Transcoder, in epoch milliseconds.
     * </p>
     * 
     * @return The time the job was submitted to Elastic Transcoder, in epoch milliseconds.
     */
    public Long submitTimeMillis() {
        return submitTimeMillis;
    }

    /**
     * <p>
     * The time the job began transcoding, in epoch milliseconds.
     * </p>
     * 
     * @return The time the job began transcoding, in epoch milliseconds.
     */
    public Long startTimeMillis() {
        return startTimeMillis;
    }

    /**
     * <p>
     * The time the job finished transcoding, in epoch milliseconds.
     * </p>
     * 
     * @return The time the job finished transcoding, in epoch milliseconds.
     */
    public Long finishTimeMillis() {
        return finishTimeMillis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(submitTimeMillis());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeMillis());
        hashCode = 31 * hashCode + Objects.hashCode(finishTimeMillis());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Timing)) {
            return false;
        }
        Timing other = (Timing) obj;
        return Objects.equals(submitTimeMillis(), other.submitTimeMillis())
                && Objects.equals(startTimeMillis(), other.startTimeMillis())
                && Objects.equals(finishTimeMillis(), other.finishTimeMillis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Timing").add("SubmitTimeMillis", submitTimeMillis()).add("StartTimeMillis", startTimeMillis())
                .add("FinishTimeMillis", finishTimeMillis()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubmitTimeMillis":
            return Optional.ofNullable(clazz.cast(submitTimeMillis()));
        case "StartTimeMillis":
            return Optional.ofNullable(clazz.cast(startTimeMillis()));
        case "FinishTimeMillis":
            return Optional.ofNullable(clazz.cast(finishTimeMillis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Timing, T> g) {
        return obj -> g.apply((Timing) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Timing> {
        /**
         * <p>
         * The time the job was submitted to Elastic Transcoder, in epoch milliseconds.
         * </p>
         * 
         * @param submitTimeMillis
         *        The time the job was submitted to Elastic Transcoder, in epoch milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitTimeMillis(Long submitTimeMillis);

        /**
         * <p>
         * The time the job began transcoding, in epoch milliseconds.
         * </p>
         * 
         * @param startTimeMillis
         *        The time the job began transcoding, in epoch milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeMillis(Long startTimeMillis);

        /**
         * <p>
         * The time the job finished transcoding, in epoch milliseconds.
         * </p>
         * 
         * @param finishTimeMillis
         *        The time the job finished transcoding, in epoch milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finishTimeMillis(Long finishTimeMillis);
    }

    static final class BuilderImpl implements Builder {
        private Long submitTimeMillis;

        private Long startTimeMillis;

        private Long finishTimeMillis;

        private BuilderImpl() {
        }

        private BuilderImpl(Timing model) {
            submitTimeMillis(model.submitTimeMillis);
            startTimeMillis(model.startTimeMillis);
            finishTimeMillis(model.finishTimeMillis);
        }

        public final Long getSubmitTimeMillis() {
            return submitTimeMillis;
        }

        @Override
        public final Builder submitTimeMillis(Long submitTimeMillis) {
            this.submitTimeMillis = submitTimeMillis;
            return this;
        }

        public final void setSubmitTimeMillis(Long submitTimeMillis) {
            this.submitTimeMillis = submitTimeMillis;
        }

        public final Long getStartTimeMillis() {
            return startTimeMillis;
        }

        @Override
        public final Builder startTimeMillis(Long startTimeMillis) {
            this.startTimeMillis = startTimeMillis;
            return this;
        }

        public final void setStartTimeMillis(Long startTimeMillis) {
            this.startTimeMillis = startTimeMillis;
        }

        public final Long getFinishTimeMillis() {
            return finishTimeMillis;
        }

        @Override
        public final Builder finishTimeMillis(Long finishTimeMillis) {
            this.finishTimeMillis = finishTimeMillis;
            return this;
        }

        public final void setFinishTimeMillis(Long finishTimeMillis) {
            this.finishTimeMillis = finishTimeMillis;
        }

        @Override
        public Timing build() {
            return new Timing(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
