/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When you update status for a pipeline, Elastic Transcoder returns the values that you specified in the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePipelineStatusResponse extends ElasticTranscoderResponse implements
        ToCopyableBuilder<UpdatePipelineStatusResponse.Builder, UpdatePipelineStatusResponse> {
    private static final SdkField<Pipeline> PIPELINE_FIELD = SdkField.<Pipeline> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdatePipelineStatusResponse::pipeline)).setter(setter(Builder::pipeline))
            .constructor(Pipeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pipeline").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_FIELD));

    private final Pipeline pipeline;

    private UpdatePipelineStatusResponse(BuilderImpl builder) {
        super(builder);
        this.pipeline = builder.pipeline;
    }

    /**
     * <p>
     * A section of the response body that provides information about the pipeline.
     * </p>
     * 
     * @return A section of the response body that provides information about the pipeline.
     */
    public Pipeline pipeline() {
        return pipeline;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipeline());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipelineStatusResponse)) {
            return false;
        }
        UpdatePipelineStatusResponse other = (UpdatePipelineStatusResponse) obj;
        return Objects.equals(pipeline(), other.pipeline());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdatePipelineStatusResponse").add("Pipeline", pipeline()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Pipeline":
            return Optional.ofNullable(clazz.cast(pipeline()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipelineStatusResponse, T> g) {
        return obj -> g.apply((UpdatePipelineStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticTranscoderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdatePipelineStatusResponse> {
        /**
         * <p>
         * A section of the response body that provides information about the pipeline.
         * </p>
         * 
         * @param pipeline
         *        A section of the response body that provides information about the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipeline(Pipeline pipeline);

        /**
         * <p>
         * A section of the response body that provides information about the pipeline.
         * </p>
         * This is a convenience that creates an instance of the {@link Pipeline.Builder} avoiding the need to create
         * one manually via {@link Pipeline#builder()}.
         *
         * When the {@link Consumer} completes, {@link Pipeline.Builder#build()} is called immediately and its result is
         * passed to {@link #pipeline(Pipeline)}.
         * 
         * @param pipeline
         *        a consumer that will call methods on {@link Pipeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipeline(Pipeline)
         */
        default Builder pipeline(Consumer<Pipeline.Builder> pipeline) {
            return pipeline(Pipeline.builder().applyMutation(pipeline).build());
        }
    }

    static final class BuilderImpl extends ElasticTranscoderResponse.BuilderImpl implements Builder {
        private Pipeline pipeline;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipelineStatusResponse model) {
            super(model);
            pipeline(model.pipeline);
        }

        public final Pipeline.Builder getPipeline() {
            return pipeline != null ? pipeline.toBuilder() : null;
        }

        @Override
        public final Builder pipeline(Pipeline pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public final void setPipeline(Pipeline.BuilderImpl pipeline) {
            this.pipeline = pipeline != null ? pipeline.build() : null;
        }

        @Override
        public UpdatePipelineStatusResponse build() {
            return new UpdatePipelineStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
