/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elastictranscoder.model.Captions;
import software.amazon.awssdk.services.elastictranscoder.model.Clip;
import software.amazon.awssdk.services.elastictranscoder.model.CompositionCopier;
import software.amazon.awssdk.services.elastictranscoder.model.Encryption;
import software.amazon.awssdk.services.elastictranscoder.model.JobAlbumArt;
import software.amazon.awssdk.services.elastictranscoder.model.JobWatermark;
import software.amazon.awssdk.services.elastictranscoder.model.JobWatermarksCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateJobOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateJobOutput> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateJobOutput.getter(CreateJobOutput::key)).setter(CreateJobOutput.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()}).build();
    private static final SdkField<String> THUMBNAIL_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateJobOutput.getter(CreateJobOutput::thumbnailPattern)).setter(CreateJobOutput.setter(Builder::thumbnailPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThumbnailPattern").build()}).build();
    private static final SdkField<Encryption> THUMBNAIL_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateJobOutput.getter(CreateJobOutput::thumbnailEncryption)).setter(CreateJobOutput.setter(Builder::thumbnailEncryption)).constructor(Encryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThumbnailEncryption").build()}).build();
    private static final SdkField<String> ROTATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateJobOutput.getter(CreateJobOutput::rotate)).setter(CreateJobOutput.setter(Builder::rotate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rotate").build()}).build();
    private static final SdkField<String> PRESET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateJobOutput.getter(CreateJobOutput::presetId)).setter(CreateJobOutput.setter(Builder::presetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PresetId").build()}).build();
    private static final SdkField<String> SEGMENT_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateJobOutput.getter(CreateJobOutput::segmentDuration)).setter(CreateJobOutput.setter(Builder::segmentDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentDuration").build()}).build();
    private static final SdkField<List<JobWatermark>> WATERMARKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateJobOutput.getter(CreateJobOutput::watermarks)).setter(CreateJobOutput.setter(Builder::watermarks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Watermarks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobWatermark::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<JobAlbumArt> ALBUM_ART_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateJobOutput.getter(CreateJobOutput::albumArt)).setter(CreateJobOutput.setter(Builder::albumArt)).constructor(JobAlbumArt::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlbumArt").build()}).build();
    private static final SdkField<List<Clip>> COMPOSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateJobOutput.getter(CreateJobOutput::composition)).setter(CreateJobOutput.setter(Builder::composition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Composition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Clip::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Captions> CAPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateJobOutput.getter(CreateJobOutput::captions)).setter(CreateJobOutput.setter(Builder::captions)).constructor(Captions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Captions").build()}).build();
    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateJobOutput.getter(CreateJobOutput::encryption)).setter(CreateJobOutput.setter(Builder::encryption)).constructor(Encryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, THUMBNAIL_PATTERN_FIELD, THUMBNAIL_ENCRYPTION_FIELD, ROTATE_FIELD, PRESET_ID_FIELD, SEGMENT_DURATION_FIELD, WATERMARKS_FIELD, ALBUM_ART_FIELD, COMPOSITION_FIELD, CAPTIONS_FIELD, ENCRYPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String key;
    private final String thumbnailPattern;
    private final Encryption thumbnailEncryption;
    private final String rotate;
    private final String presetId;
    private final String segmentDuration;
    private final List<JobWatermark> watermarks;
    private final JobAlbumArt albumArt;
    private final List<Clip> composition;
    private final Captions captions;
    private final Encryption encryption;

    private CreateJobOutput(BuilderImpl builder) {
        this.key = builder.key;
        this.thumbnailPattern = builder.thumbnailPattern;
        this.thumbnailEncryption = builder.thumbnailEncryption;
        this.rotate = builder.rotate;
        this.presetId = builder.presetId;
        this.segmentDuration = builder.segmentDuration;
        this.watermarks = builder.watermarks;
        this.albumArt = builder.albumArt;
        this.composition = builder.composition;
        this.captions = builder.captions;
        this.encryption = builder.encryption;
    }

    public String key() {
        return this.key;
    }

    public String thumbnailPattern() {
        return this.thumbnailPattern;
    }

    public Encryption thumbnailEncryption() {
        return this.thumbnailEncryption;
    }

    public String rotate() {
        return this.rotate;
    }

    public String presetId() {
        return this.presetId;
    }

    public String segmentDuration() {
        return this.segmentDuration;
    }

    public List<JobWatermark> watermarks() {
        return this.watermarks;
    }

    public JobAlbumArt albumArt() {
        return this.albumArt;
    }

    public List<Clip> composition() {
        return this.composition;
    }

    public Captions captions() {
        return this.captions;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbnailPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbnailEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.rotate());
        hashCode = 31 * hashCode + Objects.hashCode(this.presetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.watermarks());
        hashCode = 31 * hashCode + Objects.hashCode(this.albumArt());
        hashCode = 31 * hashCode + Objects.hashCode(this.composition());
        hashCode = 31 * hashCode + Objects.hashCode(this.captions());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobOutput)) {
            return false;
        }
        CreateJobOutput other = (CreateJobOutput)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.thumbnailPattern(), other.thumbnailPattern()) && Objects.equals(this.thumbnailEncryption(), other.thumbnailEncryption()) && Objects.equals(this.rotate(), other.rotate()) && Objects.equals(this.presetId(), other.presetId()) && Objects.equals(this.segmentDuration(), other.segmentDuration()) && Objects.equals(this.watermarks(), other.watermarks()) && Objects.equals(this.albumArt(), other.albumArt()) && Objects.equals(this.composition(), other.composition()) && Objects.equals(this.captions(), other.captions()) && Objects.equals(this.encryption(), other.encryption());
    }

    public String toString() {
        return ToString.builder((String)"CreateJobOutput").add("Key", (Object)this.key()).add("ThumbnailPattern", (Object)this.thumbnailPattern()).add("ThumbnailEncryption", (Object)this.thumbnailEncryption()).add("Rotate", (Object)this.rotate()).add("PresetId", (Object)this.presetId()).add("SegmentDuration", (Object)this.segmentDuration()).add("Watermarks", this.watermarks()).add("AlbumArt", (Object)this.albumArt()).add("Composition", this.composition()).add("Captions", (Object)this.captions()).add("Encryption", (Object)this.encryption()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "ThumbnailPattern": {
                return Optional.ofNullable(clazz.cast(this.thumbnailPattern()));
            }
            case "ThumbnailEncryption": {
                return Optional.ofNullable(clazz.cast(this.thumbnailEncryption()));
            }
            case "Rotate": {
                return Optional.ofNullable(clazz.cast(this.rotate()));
            }
            case "PresetId": {
                return Optional.ofNullable(clazz.cast(this.presetId()));
            }
            case "SegmentDuration": {
                return Optional.ofNullable(clazz.cast(this.segmentDuration()));
            }
            case "Watermarks": {
                return Optional.ofNullable(clazz.cast(this.watermarks()));
            }
            case "AlbumArt": {
                return Optional.ofNullable(clazz.cast(this.albumArt()));
            }
            case "Composition": {
                return Optional.ofNullable(clazz.cast(this.composition()));
            }
            case "Captions": {
                return Optional.ofNullable(clazz.cast(this.captions()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobOutput, T> g) {
        return obj -> g.apply((CreateJobOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private String thumbnailPattern;
        private Encryption thumbnailEncryption;
        private String rotate;
        private String presetId;
        private String segmentDuration;
        private List<JobWatermark> watermarks = DefaultSdkAutoConstructList.getInstance();
        private JobAlbumArt albumArt;
        private List<Clip> composition = DefaultSdkAutoConstructList.getInstance();
        private Captions captions;
        private Encryption encryption;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobOutput model) {
            this.key(model.key);
            this.thumbnailPattern(model.thumbnailPattern);
            this.thumbnailEncryption(model.thumbnailEncryption);
            this.rotate(model.rotate);
            this.presetId(model.presetId);
            this.segmentDuration(model.segmentDuration);
            this.watermarks(model.watermarks);
            this.albumArt(model.albumArt);
            this.composition(model.composition);
            this.captions(model.captions);
            this.encryption(model.encryption);
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getThumbnailPattern() {
            return this.thumbnailPattern;
        }

        @Override
        public final Builder thumbnailPattern(String thumbnailPattern) {
            this.thumbnailPattern = thumbnailPattern;
            return this;
        }

        public final void setThumbnailPattern(String thumbnailPattern) {
            this.thumbnailPattern = thumbnailPattern;
        }

        public final Encryption.Builder getThumbnailEncryption() {
            return this.thumbnailEncryption != null ? this.thumbnailEncryption.toBuilder() : null;
        }

        @Override
        public final Builder thumbnailEncryption(Encryption thumbnailEncryption) {
            this.thumbnailEncryption = thumbnailEncryption;
            return this;
        }

        public final void setThumbnailEncryption(Encryption.BuilderImpl thumbnailEncryption) {
            this.thumbnailEncryption = thumbnailEncryption != null ? thumbnailEncryption.build() : null;
        }

        public final String getRotate() {
            return this.rotate;
        }

        @Override
        public final Builder rotate(String rotate) {
            this.rotate = rotate;
            return this;
        }

        public final void setRotate(String rotate) {
            this.rotate = rotate;
        }

        public final String getPresetId() {
            return this.presetId;
        }

        @Override
        public final Builder presetId(String presetId) {
            this.presetId = presetId;
            return this;
        }

        public final void setPresetId(String presetId) {
            this.presetId = presetId;
        }

        public final String getSegmentDuration() {
            return this.segmentDuration;
        }

        @Override
        public final Builder segmentDuration(String segmentDuration) {
            this.segmentDuration = segmentDuration;
            return this;
        }

        public final void setSegmentDuration(String segmentDuration) {
            this.segmentDuration = segmentDuration;
        }

        public final Collection<JobWatermark.Builder> getWatermarks() {
            return this.watermarks != null ? (Collection)this.watermarks.stream().map(JobWatermark::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder watermarks(Collection<JobWatermark> watermarks) {
            this.watermarks = JobWatermarksCopier.copy(watermarks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watermarks(JobWatermark ... watermarks) {
            this.watermarks(Arrays.asList(watermarks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watermarks(Consumer<JobWatermark.Builder> ... watermarks) {
            this.watermarks(Stream.of(watermarks).map(c -> (JobWatermark)((JobWatermark.Builder)JobWatermark.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWatermarks(Collection<JobWatermark.BuilderImpl> watermarks) {
            this.watermarks = JobWatermarksCopier.copyFromBuilder(watermarks);
        }

        public final JobAlbumArt.Builder getAlbumArt() {
            return this.albumArt != null ? this.albumArt.toBuilder() : null;
        }

        @Override
        public final Builder albumArt(JobAlbumArt albumArt) {
            this.albumArt = albumArt;
            return this;
        }

        public final void setAlbumArt(JobAlbumArt.BuilderImpl albumArt) {
            this.albumArt = albumArt != null ? albumArt.build() : null;
        }

        public final Collection<Clip.Builder> getComposition() {
            return this.composition != null ? (Collection)this.composition.stream().map(Clip::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder composition(Collection<Clip> composition) {
            this.composition = CompositionCopier.copy(composition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder composition(Clip ... composition) {
            this.composition(Arrays.asList(composition));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder composition(Consumer<Clip.Builder> ... composition) {
            this.composition(Stream.of(composition).map(c -> (Clip)((Clip.Builder)Clip.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setComposition(Collection<Clip.BuilderImpl> composition) {
            this.composition = CompositionCopier.copyFromBuilder(composition);
        }

        public final Captions.Builder getCaptions() {
            return this.captions != null ? this.captions.toBuilder() : null;
        }

        @Override
        public final Builder captions(Captions captions) {
            this.captions = captions;
            return this;
        }

        public final void setCaptions(Captions.BuilderImpl captions) {
            this.captions = captions != null ? captions.build() : null;
        }

        public final Encryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public CreateJobOutput build() {
            return new CreateJobOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateJobOutput> {
        public Builder key(String var1);

        public Builder thumbnailPattern(String var1);

        public Builder thumbnailEncryption(Encryption var1);

        default public Builder thumbnailEncryption(Consumer<Encryption.Builder> thumbnailEncryption) {
            return this.thumbnailEncryption((Encryption)((Encryption.Builder)Encryption.builder().applyMutation(thumbnailEncryption)).build());
        }

        public Builder rotate(String var1);

        public Builder presetId(String var1);

        public Builder segmentDuration(String var1);

        public Builder watermarks(Collection<JobWatermark> var1);

        public Builder watermarks(JobWatermark ... var1);

        public Builder watermarks(Consumer<JobWatermark.Builder> ... var1);

        public Builder albumArt(JobAlbumArt var1);

        default public Builder albumArt(Consumer<JobAlbumArt.Builder> albumArt) {
            return this.albumArt((JobAlbumArt)((JobAlbumArt.Builder)JobAlbumArt.builder().applyMutation(albumArt)).build());
        }

        public Builder composition(Collection<Clip> var1);

        public Builder composition(Clip ... var1);

        public Builder composition(Consumer<Clip.Builder> ... var1);

        public Builder captions(Captions var1);

        default public Builder captions(Consumer<Captions.Builder> captions) {
            return this.captions((Captions)((Captions.Builder)Captions.builder().applyMutation(captions)).build());
        }

        public Builder encryption(Encryption var1);

        default public Builder encryption(Consumer<Encryption.Builder> encryption) {
            return this.encryption((Encryption)((Encryption.Builder)Encryption.builder().applyMutation(encryption)).build());
        }
    }
}

