/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.elastictranscoder.ElasticTranscoderClient;
import software.amazon.awssdk.services.elastictranscoder.model.AccessDeniedException;
import software.amazon.awssdk.services.elastictranscoder.model.CancelJobRequest;
import software.amazon.awssdk.services.elastictranscoder.model.CancelJobResponse;
import software.amazon.awssdk.services.elastictranscoder.model.CreateJobRequest;
import software.amazon.awssdk.services.elastictranscoder.model.CreateJobResponse;
import software.amazon.awssdk.services.elastictranscoder.model.CreatePipelineRequest;
import software.amazon.awssdk.services.elastictranscoder.model.CreatePipelineResponse;
import software.amazon.awssdk.services.elastictranscoder.model.CreatePresetRequest;
import software.amazon.awssdk.services.elastictranscoder.model.CreatePresetResponse;
import software.amazon.awssdk.services.elastictranscoder.model.DeletePipelineRequest;
import software.amazon.awssdk.services.elastictranscoder.model.DeletePipelineResponse;
import software.amazon.awssdk.services.elastictranscoder.model.DeletePresetRequest;
import software.amazon.awssdk.services.elastictranscoder.model.DeletePresetResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ElasticTranscoderException;
import software.amazon.awssdk.services.elastictranscoder.model.ElasticTranscoderRequest;
import software.amazon.awssdk.services.elastictranscoder.model.IncompatibleVersionException;
import software.amazon.awssdk.services.elastictranscoder.model.InternalServiceException;
import software.amazon.awssdk.services.elastictranscoder.model.LimitExceededException;
import software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ListJobsByStatusResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ListPresetsRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ListPresetsResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ReadJobRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ReadJobResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ReadPipelineRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ReadPipelineResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ReadPresetRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ReadPresetResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ResourceInUseException;
import software.amazon.awssdk.services.elastictranscoder.model.ResourceNotFoundException;
import software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineNotificationsRequest;
import software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineNotificationsResponse;
import software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineRequest;
import software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineResponse;
import software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineStatusRequest;
import software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineStatusResponse;
import software.amazon.awssdk.services.elastictranscoder.model.ValidationException;
import software.amazon.awssdk.services.elastictranscoder.paginators.ListJobsByPipelineIterable;
import software.amazon.awssdk.services.elastictranscoder.paginators.ListJobsByStatusIterable;
import software.amazon.awssdk.services.elastictranscoder.paginators.ListPipelinesIterable;
import software.amazon.awssdk.services.elastictranscoder.paginators.ListPresetsIterable;
import software.amazon.awssdk.services.elastictranscoder.transform.CancelJobRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.CreateJobRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.CreatePipelineRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.CreatePresetRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.DeletePipelineRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.DeletePresetRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.ListJobsByPipelineRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.ListJobsByStatusRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.ListPipelinesRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.ListPresetsRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.ReadJobRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.ReadPipelineRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.ReadPresetRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.UpdatePipelineNotificationsRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.UpdatePipelineRequestMarshaller;
import software.amazon.awssdk.services.elastictranscoder.transform.UpdatePipelineStatusRequestMarshaller;

@SdkInternalApi
final class DefaultElasticTranscoderClient
implements ElasticTranscoderClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultElasticTranscoderClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "elastictranscoder";
    }

    @Override
    public CancelJobResponse cancelJob(CancelJobRequest cancelJobRequest) throws ValidationException, IncompatibleVersionException, ResourceNotFoundException, ResourceInUseException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, ElasticTranscoderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CancelJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelJobRequest).withMarshaller((Marshaller)new CancelJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateJobResponse createJob(CreateJobRequest createJobRequest) throws ValidationException, IncompatibleVersionException, ResourceNotFoundException, AccessDeniedException, LimitExceededException, InternalServiceException, AwsServiceException, SdkClientException, ElasticTranscoderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createJobRequest).withMarshaller((Marshaller)new CreateJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreatePipelineResponse createPipeline(CreatePipelineRequest createPipelineRequest) throws ValidationException, IncompatibleVersionException, AccessDeniedException, ResourceNotFoundException, LimitExceededException, InternalServiceException, AwsServiceException, SdkClientException, ElasticTranscoderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreatePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPipelineRequest).withMarshaller((Marshaller)new CreatePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreatePresetResponse createPreset(CreatePresetRequest createPresetRequest) throws ValidationException, IncompatibleVersionException, AccessDeniedException, LimitExceededException, InternalServiceException, AwsServiceException, SdkClientException, ElasticTranscoderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePresetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreatePresetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePreset").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createPresetRequest).withMarshaller((Marshaller)new CreatePresetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeletePipelineResponse deletePipeline(DeletePipelineRequest deletePipelineRequest) throws ValidationException, IncompatibleVersionException, ResourceNotFoundException, ResourceInUseException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, ElasticTranscoderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeletePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePipelineRequest).withMarshaller((Marshaller)new DeletePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeletePresetResponse deletePreset(DeletePresetRequest deletePresetRequest) throws ValidationException, IncompatibleVersionException, ResourceNotFoundException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, ElasticTranscoderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePresetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeletePresetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePreset").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePresetRequest).withMarshaller((Marshaller)new DeletePresetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListJobsByPipelineResponse listJobsByPipeline(ListJobsByPipelineRequest listJobsByPipelineRequest) throws ValidationException, IncompatibleVersionException, ResourceNotFoundException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, ElasticTranscoderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListJobsByPipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListJobsByPipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListJobsByPipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listJobsByPipelineRequest).withMarshaller((Marshaller)new ListJobsByPipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListJobsByPipelineIterable listJobsByPipelinePaginator(ListJobsByPipelineRequest listJobsByPipelineRequest) throws ValidationException, IncompatibleVersionException, ResourceNotFoundException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, ElasticTranscoderException {
        return new ListJobsByPipelineIterable(this, this.applyPaginatorUserAgent(listJobsByPipelineRequest));
    }

    @Override
    public ListJobsByStatusResponse listJobsByStatus(ListJobsByStatusRequest listJobsByStatusRequest) throws ValidationException, IncompatibleVersionException, ResourceNotFoundException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, ElasticTranscoderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListJobsByStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListJobsByStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListJobsByStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listJobsByStatusRequest).withMarshaller((Marshaller)new ListJobsByStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListJobsByStatusIterable listJobsByStatusPaginator(ListJobsByStatusRequest listJobsByStatusRequest) throws ValidationException, IncompatibleVersionException, ResourceNotFoundException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, ElasticTranscoderException {
        return new ListJobsByStatusIterable(this, this.applyPaginatorUserAgent(listJobsByStatusRequest));
    }

    @Override
    public ListPipelinesResponse listPipelines(ListPipelinesRequest listPipelinesRequest) throws ValidationException, IncompatibleVersionException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, ElasticTranscoderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPipelinesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListPipelinesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPipelines").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPipelinesRequest).withMarshaller((Marshaller)new ListPipelinesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListPipelinesIterable listPipelinesPaginator(ListPipelinesRequest listPipelinesRequest) throws ValidationException, IncompatibleVersionException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, ElasticTranscoderException {
        return new ListPipelinesIterable(this, this.applyPaginatorUserAgent(listPipelinesRequest));
    }

    @Override
    public ListPresetsResponse listPresets(ListPresetsRequest listPresetsRequest) throws ValidationException, IncompatibleVersionException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, ElasticTranscoderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPresetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListPresetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPresets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPresetsRequest).withMarshaller((Marshaller)new ListPresetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListPresetsIterable listPresetsPaginator(ListPresetsRequest listPresetsRequest) throws ValidationException, IncompatibleVersionException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, ElasticTranscoderException {
        return new ListPresetsIterable(this, this.applyPaginatorUserAgent(listPresetsRequest));
    }

    @Override
    public ReadJobResponse readJob(ReadJobRequest readJobRequest) throws ValidationException, IncompatibleVersionException, ResourceNotFoundException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, ElasticTranscoderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReadJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ReadJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReadJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)readJobRequest).withMarshaller((Marshaller)new ReadJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ReadPipelineResponse readPipeline(ReadPipelineRequest readPipelineRequest) throws ValidationException, IncompatibleVersionException, ResourceNotFoundException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, ElasticTranscoderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReadPipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ReadPipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReadPipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)readPipelineRequest).withMarshaller((Marshaller)new ReadPipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ReadPresetResponse readPreset(ReadPresetRequest readPresetRequest) throws ValidationException, IncompatibleVersionException, ResourceNotFoundException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, ElasticTranscoderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ReadPresetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ReadPresetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ReadPreset").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)readPresetRequest).withMarshaller((Marshaller)new ReadPresetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdatePipelineResponse updatePipeline(UpdatePipelineRequest updatePipelineRequest) throws ValidationException, IncompatibleVersionException, AccessDeniedException, ResourceInUseException, ResourceNotFoundException, InternalServiceException, AwsServiceException, SdkClientException, ElasticTranscoderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePipelineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdatePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePipeline").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePipelineRequest).withMarshaller((Marshaller)new UpdatePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdatePipelineNotificationsResponse updatePipelineNotifications(UpdatePipelineNotificationsRequest updatePipelineNotificationsRequest) throws ValidationException, IncompatibleVersionException, ResourceNotFoundException, ResourceInUseException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, ElasticTranscoderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePipelineNotificationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdatePipelineNotificationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePipelineNotifications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePipelineNotificationsRequest).withMarshaller((Marshaller)new UpdatePipelineNotificationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdatePipelineStatusResponse updatePipelineStatus(UpdatePipelineStatusRequest updatePipelineStatusRequest) throws ValidationException, IncompatibleVersionException, ResourceNotFoundException, ResourceInUseException, AccessDeniedException, InternalServiceException, AwsServiceException, SdkClientException, ElasticTranscoderException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePipelineStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdatePipelineStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePipelineStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePipelineStatusRequest).withMarshaller((Marshaller)new UpdatePipelineStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ElasticTranscoderException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUseException").exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IncompatibleVersionException").exceptionBuilderSupplier(IncompatibleVersionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(429)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends ElasticTranscoderRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.9.4").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ElasticTranscoderRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

