/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEventSourceMappingRequest extends LambdaRequest implements
        ToCopyableBuilder<CreateEventSourceMappingRequest.Builder, CreateEventSourceMappingRequest> {
    private static final SdkField<String> EVENT_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEventSourceMappingRequest::eventSourceArn)).setter(setter(Builder::eventSourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceArn").build()).build();

    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEventSourceMappingRequest::functionName)).setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateEventSourceMappingRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateEventSourceMappingRequest::batchSize)).setter(setter(Builder::batchSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()).build();

    private static final SdkField<String> STARTING_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEventSourceMappingRequest::startingPositionAsString)).setter(setter(Builder::startingPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingPosition").build()).build();

    private static final SdkField<Instant> STARTING_POSITION_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CreateEventSourceMappingRequest::startingPositionTimestamp))
            .setter(setter(Builder::startingPositionTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingPositionTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_SOURCE_ARN_FIELD,
            FUNCTION_NAME_FIELD, ENABLED_FIELD, BATCH_SIZE_FIELD, STARTING_POSITION_FIELD, STARTING_POSITION_TIMESTAMP_FIELD));

    private final String eventSourceArn;

    private final String functionName;

    private final Boolean enabled;

    private final Integer batchSize;

    private final String startingPosition;

    private final Instant startingPositionTimestamp;

    private CreateEventSourceMappingRequest(BuilderImpl builder) {
        super(builder);
        this.eventSourceArn = builder.eventSourceArn;
        this.functionName = builder.functionName;
        this.enabled = builder.enabled;
        this.batchSize = builder.batchSize;
        this.startingPosition = builder.startingPosition;
        this.startingPositionTimestamp = builder.startingPositionTimestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the event source.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the event source.
     */
    public String eventSourceArn() {
        return eventSourceArn;
    }

    /**
     * <p>
     * The name of the lambda function.
     * </p>
     * <p class="title">
     * <b>Name formats</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Function name</b> - <code>MyFunction</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
     * characters in length.
     * </p>
     * 
     * @return The name of the lambda function.</p>
     *         <p class="title">
     *         <b>Name formats</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Function name</b> - <code>MyFunction</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The length constraint applies only to the full ARN. If you specify only the function name, it is limited
     *         to 64 characters in length.
     */
    public String functionName() {
        return functionName;
    }

    /**
     * <p>
     * Set to false to disable the event source upon creation.
     * </p>
     * 
     * @return Set to false to disable the event source upon creation.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your
     * function. Your function receives an event with all the retrieved records. The default for Amazon Kinesis and
     * Amazon DynamoDB is 100 records. Both the default and maximum for Amazon SQS are 10 messages.
     * </p>
     * 
     * @return The largest number of records that AWS Lambda will retrieve from your event source at the time of
     *         invoking your function. Your function receives an event with all the retrieved records. The default for
     *         Amazon Kinesis and Amazon DynamoDB is 100 records. Both the default and maximum for Amazon SQS are 10
     *         messages.
     */
    public Integer batchSize() {
        return batchSize;
    }

    /**
     * <p>
     * The position in the DynamoDB or Kinesis stream where AWS Lambda should start reading. For more information, see
     * <a href=
     * "http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType"
     * >GetShardIterator</a> in the <i>Amazon Kinesis API Reference Guide</i> or <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_streams_GetShardIterator.html"
     * >GetShardIterator</a> in the <i>Amazon DynamoDB API Reference Guide</i>. The <code>AT_TIMESTAMP</code> value is
     * supported only for <a href="http://docs.aws.amazon.com/streams/latest/dev/amazon-kinesis-streams.html">Kinesis
     * streams</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #startingPosition}
     * will return {@link EventSourcePosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #startingPositionAsString}.
     * </p>
     * 
     * @return The position in the DynamoDB or Kinesis stream where AWS Lambda should start reading. For more
     *         information, see <a href=
     *         "http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType"
     *         >GetShardIterator</a> in the <i>Amazon Kinesis API Reference Guide</i> or <a
     *         href="http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_streams_GetShardIterator.html"
     *         >GetShardIterator</a> in the <i>Amazon DynamoDB API Reference Guide</i>. The <code>AT_TIMESTAMP</code>
     *         value is supported only for <a
     *         href="http://docs.aws.amazon.com/streams/latest/dev/amazon-kinesis-streams.html">Kinesis streams</a>.
     * @see EventSourcePosition
     */
    public EventSourcePosition startingPosition() {
        return EventSourcePosition.fromValue(startingPosition);
    }

    /**
     * <p>
     * The position in the DynamoDB or Kinesis stream where AWS Lambda should start reading. For more information, see
     * <a href=
     * "http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType"
     * >GetShardIterator</a> in the <i>Amazon Kinesis API Reference Guide</i> or <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_streams_GetShardIterator.html"
     * >GetShardIterator</a> in the <i>Amazon DynamoDB API Reference Guide</i>. The <code>AT_TIMESTAMP</code> value is
     * supported only for <a href="http://docs.aws.amazon.com/streams/latest/dev/amazon-kinesis-streams.html">Kinesis
     * streams</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #startingPosition}
     * will return {@link EventSourcePosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #startingPositionAsString}.
     * </p>
     * 
     * @return The position in the DynamoDB or Kinesis stream where AWS Lambda should start reading. For more
     *         information, see <a href=
     *         "http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType"
     *         >GetShardIterator</a> in the <i>Amazon Kinesis API Reference Guide</i> or <a
     *         href="http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_streams_GetShardIterator.html"
     *         >GetShardIterator</a> in the <i>Amazon DynamoDB API Reference Guide</i>. The <code>AT_TIMESTAMP</code>
     *         value is supported only for <a
     *         href="http://docs.aws.amazon.com/streams/latest/dev/amazon-kinesis-streams.html">Kinesis streams</a>.
     * @see EventSourcePosition
     */
    public String startingPositionAsString() {
        return startingPosition;
    }

    /**
     * <p>
     * The timestamp of the data record from which to start reading. Used with <a href=
     * "http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType"
     * >shard iterator type</a> AT_TIMESTAMP. If a record with this exact timestamp does not exist, the iterator
     * returned is for the next (later) record. If the timestamp is older than the current trim horizon, the iterator
     * returned is for the oldest untrimmed data record (TRIM_HORIZON). Valid only for <a
     * href="http://docs.aws.amazon.com/streams/latest/dev/amazon-kinesis-streams.html">Kinesis streams</a>.
     * </p>
     * 
     * @return The timestamp of the data record from which to start reading. Used with <a href=
     *         "http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType"
     *         >shard iterator type</a> AT_TIMESTAMP. If a record with this exact timestamp does not exist, the iterator
     *         returned is for the next (later) record. If the timestamp is older than the current trim horizon, the
     *         iterator returned is for the oldest untrimmed data record (TRIM_HORIZON). Valid only for <a
     *         href="http://docs.aws.amazon.com/streams/latest/dev/amazon-kinesis-streams.html">Kinesis streams</a>.
     */
    public Instant startingPositionTimestamp() {
        return startingPositionTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(startingPositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startingPositionTimestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventSourceMappingRequest)) {
            return false;
        }
        CreateEventSourceMappingRequest other = (CreateEventSourceMappingRequest) obj;
        return Objects.equals(eventSourceArn(), other.eventSourceArn()) && Objects.equals(functionName(), other.functionName())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(batchSize(), other.batchSize())
                && Objects.equals(startingPositionAsString(), other.startingPositionAsString())
                && Objects.equals(startingPositionTimestamp(), other.startingPositionTimestamp());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateEventSourceMappingRequest").add("EventSourceArn", eventSourceArn())
                .add("FunctionName", functionName()).add("Enabled", enabled()).add("BatchSize", batchSize())
                .add("StartingPosition", startingPositionAsString())
                .add("StartingPositionTimestamp", startingPositionTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventSourceArn":
            return Optional.ofNullable(clazz.cast(eventSourceArn()));
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "BatchSize":
            return Optional.ofNullable(clazz.cast(batchSize()));
        case "StartingPosition":
            return Optional.ofNullable(clazz.cast(startingPositionAsString()));
        case "StartingPositionTimestamp":
            return Optional.ofNullable(clazz.cast(startingPositionTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEventSourceMappingRequest, T> g) {
        return obj -> g.apply((CreateEventSourceMappingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEventSourceMappingRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the event source.
         * </p>
         * 
         * @param eventSourceArn
         *        The Amazon Resource Name (ARN) of the event source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSourceArn(String eventSourceArn);

        /**
         * <p>
         * The name of the lambda function.
         * </p>
         * <p class="title">
         * <b>Name formats</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Function name</b> - <code>MyFunction</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to
         * 64 characters in length.
         * </p>
         * 
         * @param functionName
         *        The name of the lambda function.</p>
         *        <p class="title">
         *        <b>Name formats</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Function name</b> - <code>MyFunction</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Version or Alias ARN</b> -
         *        <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The length constraint applies only to the full ARN. If you specify only the function name, it is
         *        limited to 64 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * Set to false to disable the event source upon creation.
         * </p>
         * 
         * @param enabled
         *        Set to false to disable the event source upon creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking
         * your function. Your function receives an event with all the retrieved records. The default for Amazon Kinesis
         * and Amazon DynamoDB is 100 records. Both the default and maximum for Amazon SQS are 10 messages.
         * </p>
         * 
         * @param batchSize
         *        The largest number of records that AWS Lambda will retrieve from your event source at the time of
         *        invoking your function. Your function receives an event with all the retrieved records. The default
         *        for Amazon Kinesis and Amazon DynamoDB is 100 records. Both the default and maximum for Amazon SQS are
         *        10 messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchSize(Integer batchSize);

        /**
         * <p>
         * The position in the DynamoDB or Kinesis stream where AWS Lambda should start reading. For more information,
         * see <a href=
         * "http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType"
         * >GetShardIterator</a> in the <i>Amazon Kinesis API Reference Guide</i> or <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_streams_GetShardIterator.html"
         * >GetShardIterator</a> in the <i>Amazon DynamoDB API Reference Guide</i>. The <code>AT_TIMESTAMP</code> value
         * is supported only for <a
         * href="http://docs.aws.amazon.com/streams/latest/dev/amazon-kinesis-streams.html">Kinesis streams</a>.
         * </p>
         * 
         * @param startingPosition
         *        The position in the DynamoDB or Kinesis stream where AWS Lambda should start reading. For more
         *        information, see <a href=
         *        "http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType"
         *        >GetShardIterator</a> in the <i>Amazon Kinesis API Reference Guide</i> or <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_streams_GetShardIterator.html"
         *        >GetShardIterator</a> in the <i>Amazon DynamoDB API Reference Guide</i>. The <code>AT_TIMESTAMP</code>
         *        value is supported only for <a
         *        href="http://docs.aws.amazon.com/streams/latest/dev/amazon-kinesis-streams.html">Kinesis streams</a>.
         * @see EventSourcePosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSourcePosition
         */
        Builder startingPosition(String startingPosition);

        /**
         * <p>
         * The position in the DynamoDB or Kinesis stream where AWS Lambda should start reading. For more information,
         * see <a href=
         * "http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType"
         * >GetShardIterator</a> in the <i>Amazon Kinesis API Reference Guide</i> or <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_streams_GetShardIterator.html"
         * >GetShardIterator</a> in the <i>Amazon DynamoDB API Reference Guide</i>. The <code>AT_TIMESTAMP</code> value
         * is supported only for <a
         * href="http://docs.aws.amazon.com/streams/latest/dev/amazon-kinesis-streams.html">Kinesis streams</a>.
         * </p>
         * 
         * @param startingPosition
         *        The position in the DynamoDB or Kinesis stream where AWS Lambda should start reading. For more
         *        information, see <a href=
         *        "http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType"
         *        >GetShardIterator</a> in the <i>Amazon Kinesis API Reference Guide</i> or <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_streams_GetShardIterator.html"
         *        >GetShardIterator</a> in the <i>Amazon DynamoDB API Reference Guide</i>. The <code>AT_TIMESTAMP</code>
         *        value is supported only for <a
         *        href="http://docs.aws.amazon.com/streams/latest/dev/amazon-kinesis-streams.html">Kinesis streams</a>.
         * @see EventSourcePosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSourcePosition
         */
        Builder startingPosition(EventSourcePosition startingPosition);

        /**
         * <p>
         * The timestamp of the data record from which to start reading. Used with <a href=
         * "http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType"
         * >shard iterator type</a> AT_TIMESTAMP. If a record with this exact timestamp does not exist, the iterator
         * returned is for the next (later) record. If the timestamp is older than the current trim horizon, the
         * iterator returned is for the oldest untrimmed data record (TRIM_HORIZON). Valid only for <a
         * href="http://docs.aws.amazon.com/streams/latest/dev/amazon-kinesis-streams.html">Kinesis streams</a>.
         * </p>
         * 
         * @param startingPositionTimestamp
         *        The timestamp of the data record from which to start reading. Used with <a href=
         *        "http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType"
         *        >shard iterator type</a> AT_TIMESTAMP. If a record with this exact timestamp does not exist, the
         *        iterator returned is for the next (later) record. If the timestamp is older than the current trim
         *        horizon, the iterator returned is for the oldest untrimmed data record (TRIM_HORIZON). Valid only for
         *        <a href="http://docs.aws.amazon.com/streams/latest/dev/amazon-kinesis-streams.html">Kinesis
         *        streams</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingPositionTimestamp(Instant startingPositionTimestamp);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String eventSourceArn;

        private String functionName;

        private Boolean enabled;

        private Integer batchSize;

        private String startingPosition;

        private Instant startingPositionTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEventSourceMappingRequest model) {
            super(model);
            eventSourceArn(model.eventSourceArn);
            functionName(model.functionName);
            enabled(model.enabled);
            batchSize(model.batchSize);
            startingPosition(model.startingPosition);
            startingPositionTimestamp(model.startingPositionTimestamp);
        }

        public final String getEventSourceArn() {
            return eventSourceArn;
        }

        @Override
        public final Builder eventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        public final void setEventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
        }

        public final String getFunctionName() {
            return functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Integer getBatchSize() {
            return batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        public final String getStartingPosition() {
            return startingPosition;
        }

        @Override
        public final Builder startingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        @Override
        public final Builder startingPosition(EventSourcePosition startingPosition) {
            this.startingPosition(startingPosition.toString());
            return this;
        }

        public final void setStartingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
        }

        public final Instant getStartingPositionTimestamp() {
            return startingPositionTimestamp;
        }

        @Override
        public final Builder startingPositionTimestamp(Instant startingPositionTimestamp) {
            this.startingPositionTimestamp = startingPositionTimestamp;
            return this;
        }

        public final void setStartingPositionTimestamp(Instant startingPositionTimestamp) {
            this.startingPositionTimestamp = startingPositionTimestamp;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEventSourceMappingRequest build() {
            return new CreateEventSourceMappingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
