/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFunctionsRequest extends LambdaRequest implements
        ToCopyableBuilder<ListFunctionsRequest.Builder, ListFunctionsRequest> {
    private static final SdkField<String> MASTER_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListFunctionsRequest::masterRegion)).setter(setter(Builder::masterRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MasterRegion").build()).build();

    private static final SdkField<String> FUNCTION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListFunctionsRequest::functionVersionAsString)).setter(setter(Builder::functionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("FunctionVersion").build())
            .build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListFunctionsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListFunctionsRequest::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MASTER_REGION_FIELD,
            FUNCTION_VERSION_FIELD, MARKER_FIELD, MAX_ITEMS_FIELD));

    private final String masterRegion;

    private final String functionVersion;

    private final String marker;

    private final Integer maxItems;

    private ListFunctionsRequest(BuilderImpl builder) {
        super(builder);
        this.masterRegion = builder.masterRegion;
        this.functionVersion = builder.functionVersion;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * Specify a region (e.g. <code>us-east-2</code>) to only list functions that were created in that region, or
     * <code>ALL</code> to include functions replicated from any region. If specified, you also must specify the
     * <code>FunctionVersion</code>.
     * </p>
     * 
     * @return Specify a region (e.g. <code>us-east-2</code>) to only list functions that were created in that region,
     *         or <code>ALL</code> to include functions replicated from any region. If specified, you also must specify
     *         the <code>FunctionVersion</code>.
     */
    public String masterRegion() {
        return masterRegion;
    }

    /**
     * <p>
     * Set to <code>ALL</code> to list all published versions. If not specified, only the latest unpublished version ARN
     * is returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #functionVersion}
     * will return {@link FunctionVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #functionVersionAsString}.
     * </p>
     * 
     * @return Set to <code>ALL</code> to list all published versions. If not specified, only the latest unpublished
     *         version ARN is returned.
     * @see FunctionVersion
     */
    public FunctionVersion functionVersion() {
        return FunctionVersion.fromValue(functionVersion);
    }

    /**
     * <p>
     * Set to <code>ALL</code> to list all published versions. If not specified, only the latest unpublished version ARN
     * is returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #functionVersion}
     * will return {@link FunctionVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #functionVersionAsString}.
     * </p>
     * 
     * @return Set to <code>ALL</code> to list all published versions. If not specified, only the latest unpublished
     *         version ARN is returned.
     * @see FunctionVersion
     */
    public String functionVersionAsString() {
        return functionVersion;
    }

    /**
     * <p>
     * Optional string. An opaque pagination token returned from a previous <code>ListFunctions</code> operation. If
     * present, indicates where to continue the listing.
     * </p>
     * 
     * @return Optional string. An opaque pagination token returned from a previous <code>ListFunctions</code>
     *         operation. If present, indicates where to continue the listing.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * Optional integer. Specifies the maximum number of AWS Lambda functions to return in response. This parameter
     * value must be greater than 0. The absolute maximum of AWS Lambda functions that can be returned is 50.
     * </p>
     * 
     * @return Optional integer. Specifies the maximum number of AWS Lambda functions to return in response. This
     *         parameter value must be greater than 0. The absolute maximum of AWS Lambda functions that can be returned
     *         is 50.
     */
    public Integer maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(masterRegion());
        hashCode = 31 * hashCode + Objects.hashCode(functionVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFunctionsRequest)) {
            return false;
        }
        ListFunctionsRequest other = (ListFunctionsRequest) obj;
        return Objects.equals(masterRegion(), other.masterRegion())
                && Objects.equals(functionVersionAsString(), other.functionVersionAsString())
                && Objects.equals(marker(), other.marker()) && Objects.equals(maxItems(), other.maxItems());
    }

    @Override
    public String toString() {
        return ToString.builder("ListFunctionsRequest").add("MasterRegion", masterRegion())
                .add("FunctionVersion", functionVersionAsString()).add("Marker", marker()).add("MaxItems", maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MasterRegion":
            return Optional.ofNullable(clazz.cast(masterRegion()));
        case "FunctionVersion":
            return Optional.ofNullable(clazz.cast(functionVersionAsString()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFunctionsRequest, T> g) {
        return obj -> g.apply((ListFunctionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListFunctionsRequest> {
        /**
         * <p>
         * Specify a region (e.g. <code>us-east-2</code>) to only list functions that were created in that region, or
         * <code>ALL</code> to include functions replicated from any region. If specified, you also must specify the
         * <code>FunctionVersion</code>.
         * </p>
         * 
         * @param masterRegion
         *        Specify a region (e.g. <code>us-east-2</code>) to only list functions that were created in that
         *        region, or <code>ALL</code> to include functions replicated from any region. If specified, you also
         *        must specify the <code>FunctionVersion</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterRegion(String masterRegion);

        /**
         * <p>
         * Set to <code>ALL</code> to list all published versions. If not specified, only the latest unpublished version
         * ARN is returned.
         * </p>
         * 
         * @param functionVersion
         *        Set to <code>ALL</code> to list all published versions. If not specified, only the latest unpublished
         *        version ARN is returned.
         * @see FunctionVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FunctionVersion
         */
        Builder functionVersion(String functionVersion);

        /**
         * <p>
         * Set to <code>ALL</code> to list all published versions. If not specified, only the latest unpublished version
         * ARN is returned.
         * </p>
         * 
         * @param functionVersion
         *        Set to <code>ALL</code> to list all published versions. If not specified, only the latest unpublished
         *        version ARN is returned.
         * @see FunctionVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FunctionVersion
         */
        Builder functionVersion(FunctionVersion functionVersion);

        /**
         * <p>
         * Optional string. An opaque pagination token returned from a previous <code>ListFunctions</code> operation. If
         * present, indicates where to continue the listing.
         * </p>
         * 
         * @param marker
         *        Optional string. An opaque pagination token returned from a previous <code>ListFunctions</code>
         *        operation. If present, indicates where to continue the listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Optional integer. Specifies the maximum number of AWS Lambda functions to return in response. This parameter
         * value must be greater than 0. The absolute maximum of AWS Lambda functions that can be returned is 50.
         * </p>
         * 
         * @param maxItems
         *        Optional integer. Specifies the maximum number of AWS Lambda functions to return in response. This
         *        parameter value must be greater than 0. The absolute maximum of AWS Lambda functions that can be
         *        returned is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String masterRegion;

        private String functionVersion;

        private String marker;

        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFunctionsRequest model) {
            super(model);
            masterRegion(model.masterRegion);
            functionVersion(model.functionVersion);
            marker(model.marker);
            maxItems(model.maxItems);
        }

        public final String getMasterRegion() {
            return masterRegion;
        }

        @Override
        public final Builder masterRegion(String masterRegion) {
            this.masterRegion = masterRegion;
            return this;
        }

        public final void setMasterRegion(String masterRegion) {
            this.masterRegion = masterRegion;
        }

        public final String getFunctionVersion() {
            return functionVersion;
        }

        @Override
        public final Builder functionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        @Override
        public final Builder functionVersion(FunctionVersion functionVersion) {
            this.functionVersion(functionVersion.toString());
            return this;
        }

        public final void setFunctionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFunctionsRequest build() {
            return new ListFunctionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
