/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLayersResponse extends LambdaResponse implements
        ToCopyableBuilder<ListLayersResponse.Builder, ListLayersResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListLayersResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<List<LayersListItem>> LAYERS_FIELD = SdkField
            .<List<LayersListItem>> builder(MarshallingType.LIST)
            .getter(getter(ListLayersResponse::layers))
            .setter(setter(Builder::layers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LayersListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(LayersListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            LAYERS_FIELD));

    private final String nextMarker;

    private final List<LayersListItem> layers;

    private ListLayersResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.layers = builder.layers;
    }

    /**
     * <p>
     * A pagination token returned when the response doesn't contain all layers.
     * </p>
     * 
     * @return A pagination token returned when the response doesn't contain all layers.
     */
    public String nextMarker() {
        return nextMarker;
    }

    /**
     * <p>
     * A list of function layers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of function layers.
     */
    public List<LayersListItem> layers() {
        return layers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(layers());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLayersResponse)) {
            return false;
        }
        ListLayersResponse other = (ListLayersResponse) obj;
        return Objects.equals(nextMarker(), other.nextMarker()) && Objects.equals(layers(), other.layers());
    }

    @Override
    public String toString() {
        return ToString.builder("ListLayersResponse").add("NextMarker", nextMarker()).add("Layers", layers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "Layers":
            return Optional.ofNullable(clazz.cast(layers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLayersResponse, T> g) {
        return obj -> g.apply((ListLayersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListLayersResponse> {
        /**
         * <p>
         * A pagination token returned when the response doesn't contain all layers.
         * </p>
         * 
         * @param nextMarker
         *        A pagination token returned when the response doesn't contain all layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * A list of function layers.
         * </p>
         * 
         * @param layers
         *        A list of function layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(Collection<LayersListItem> layers);

        /**
         * <p>
         * A list of function layers.
         * </p>
         * 
         * @param layers
         *        A list of function layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(LayersListItem... layers);

        /**
         * <p>
         * A list of function layers.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LayersListItem>.Builder} avoiding the need
         * to create one manually via {@link List<LayersListItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LayersListItem>.Builder#build()} is called immediately and
         * its result is passed to {@link #layers(List<LayersListItem>)}.
         * 
         * @param layers
         *        a consumer that will call methods on {@link List<LayersListItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #layers(List<LayersListItem>)
         */
        Builder layers(Consumer<LayersListItem.Builder>... layers);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String nextMarker;

        private List<LayersListItem> layers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListLayersResponse model) {
            super(model);
            nextMarker(model.nextMarker);
            layers(model.layers);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<LayersListItem.Builder> getLayers() {
            return layers != null ? layers.stream().map(LayersListItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder layers(Collection<LayersListItem> layers) {
            this.layers = LayersListCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(LayersListItem... layers) {
            layers(Arrays.asList(layers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Consumer<LayersListItem.Builder>... layers) {
            layers(Stream.of(layers).map(c -> LayersListItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLayers(Collection<LayersListItem.BuilderImpl> layers) {
            this.layers = LayersListCopier.copyFromBuilder(layers);
        }

        @Override
        public ListLayersResponse build() {
            return new ListLayersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
