/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEventSourceMappingRequest extends LambdaRequest implements
        ToCopyableBuilder<GetEventSourceMappingRequest.Builder, GetEventSourceMappingRequest> {
    private static final SdkField<String> UUID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetEventSourceMappingRequest::uuid)).setter(setter(Builder::uuid))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("UUID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UUID_FIELD));

    private final String uuid;

    private GetEventSourceMappingRequest(BuilderImpl builder) {
        super(builder);
        this.uuid = builder.uuid;
    }

    /**
     * <p>
     * The identifier of the event source mapping.
     * </p>
     * 
     * @return The identifier of the event source mapping.
     */
    public String uuid() {
        return uuid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uuid());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEventSourceMappingRequest)) {
            return false;
        }
        GetEventSourceMappingRequest other = (GetEventSourceMappingRequest) obj;
        return Objects.equals(uuid(), other.uuid());
    }

    @Override
    public String toString() {
        return ToString.builder("GetEventSourceMappingRequest").add("UUID", uuid()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UUID":
            return Optional.ofNullable(clazz.cast(uuid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEventSourceMappingRequest, T> g) {
        return obj -> g.apply((GetEventSourceMappingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetEventSourceMappingRequest> {
        /**
         * <p>
         * The identifier of the event source mapping.
         * </p>
         * 
         * @param uuid
         *        The identifier of the event source mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uuid(String uuid);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String uuid;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEventSourceMappingRequest model) {
            super(model);
            uuid(model.uuid);
        }

        public final String getUUID() {
            return uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public final void setUUID(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEventSourceMappingRequest build() {
            return new GetEventSourceMappingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
