/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFunctionCodeRequest extends LambdaRequest implements
        ToCopyableBuilder<UpdateFunctionCodeRequest.Builder, UpdateFunctionCodeRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFunctionCodeRequest::functionName)).setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()).build();

    private static final SdkField<SdkBytes> ZIP_FILE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(UpdateFunctionCodeRequest::zipFile)).setter(setter(Builder::zipFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZipFile").build()).build();

    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFunctionCodeRequest::s3Bucket)).setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()).build();

    private static final SdkField<String> S3_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFunctionCodeRequest::s3Key)).setter(setter(Builder::s3Key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Key").build()).build();

    private static final SdkField<String> S3_OBJECT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFunctionCodeRequest::s3ObjectVersion)).setter(setter(Builder::s3ObjectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ObjectVersion").build()).build();

    private static final SdkField<Boolean> PUBLISH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateFunctionCodeRequest::publish)).setter(setter(Builder::publish))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Publish").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateFunctionCodeRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFunctionCodeRequest::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD,
            ZIP_FILE_FIELD, S3_BUCKET_FIELD, S3_KEY_FIELD, S3_OBJECT_VERSION_FIELD, PUBLISH_FIELD, DRY_RUN_FIELD,
            REVISION_ID_FIELD));

    private final String functionName;

    private final SdkBytes zipFile;

    private final String s3Bucket;

    private final String s3Key;

    private final String s3ObjectVersion;

    private final Boolean publish;

    private final Boolean dryRun;

    private final String revisionId;

    private UpdateFunctionCodeRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.zipFile = builder.zipFile;
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
        this.s3ObjectVersion = builder.s3ObjectVersion;
        this.publish = builder.publish;
        this.dryRun = builder.dryRun;
        this.revisionId = builder.revisionId;
    }

    /**
     * <p>
     * The name of the Lambda function.
     * </p>
     * <p class="title">
     * <b>Name formats</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Function name</b> - <code>MyFunction</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
     * characters in length.
     * </p>
     * 
     * @return The name of the Lambda function.</p>
     *         <p class="title">
     *         <b>Name formats</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Function name</b> - <code>MyFunction</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The length constraint applies only to the full ARN. If you specify only the function name, it is limited
     *         to 64 characters in length.
     */
    public String functionName() {
        return functionName;
    }

    /**
     * <p>
     * The contents of your zip file containing your deployment package. If you are using the web API directly, the
     * contents of the zip file must be base64-encoded. If you are using the AWS SDKs or the AWS CLI, the SDKs or CLI
     * will do the encoding for you. For more information about creating a .zip file, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role.html"
     * >Execution Permissions</a>.
     * </p>
     * 
     * @return The contents of your zip file containing your deployment package. If you are using the web API directly,
     *         the contents of the zip file must be base64-encoded. If you are using the AWS SDKs or the AWS CLI, the
     *         SDKs or CLI will do the encoding for you. For more information about creating a .zip file, see <a href=
     *         "http://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role.html"
     *         >Execution Permissions</a>.
     */
    public SdkBytes zipFile() {
        return zipFile;
    }

    /**
     * <p>
     * Amazon S3 bucket name where the .zip file containing your deployment package is stored. This bucket must reside
     * in the same AWS Region where you are creating the Lambda function.
     * </p>
     * 
     * @return Amazon S3 bucket name where the .zip file containing your deployment package is stored. This bucket must
     *         reside in the same AWS Region where you are creating the Lambda function.
     */
    public String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The Amazon S3 object (the deployment package) key name you want to upload.
     * </p>
     * 
     * @return The Amazon S3 object (the deployment package) key name you want to upload.
     */
    public String s3Key() {
        return s3Key;
    }

    /**
     * <p>
     * The Amazon S3 object (the deployment package) version you want to upload.
     * </p>
     * 
     * @return The Amazon S3 object (the deployment package) version you want to upload.
     */
    public String s3ObjectVersion() {
        return s3ObjectVersion;
    }

    /**
     * <p>
     * This boolean parameter can be used to request AWS Lambda to update the Lambda function and publish a version as
     * an atomic operation.
     * </p>
     * 
     * @return This boolean parameter can be used to request AWS Lambda to update the Lambda function and publish a
     *         version as an atomic operation.
     */
    public Boolean publish() {
        return publish;
    }

    /**
     * <p>
     * This boolean parameter can be used to test your request to AWS Lambda to update the Lambda function and publish a
     * version as an atomic operation. It will do all necessary computation and validation of your code but will not
     * upload it or a publish a version. Each time this operation is invoked, the <code>CodeSha256</code> hash value of
     * the provided code will also be computed and returned in the response.
     * </p>
     * 
     * @return This boolean parameter can be used to test your request to AWS Lambda to update the Lambda function and
     *         publish a version as an atomic operation. It will do all necessary computation and validation of your
     *         code but will not upload it or a publish a version. Each time this operation is invoked, the
     *         <code>CodeSha256</code> hash value of the provided code will also be computed and returned in the
     *         response.
     */
    public Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * An optional value you can use to ensure you are updating the latest update of the function version or alias. If
     * the <code>RevisionID</code> you pass doesn't match the latest <code>RevisionId</code> of the function or alias,
     * it will fail with an error message, advising you to retrieve the latest function version or alias
     * <code>RevisionID</code> using either using using either <a>GetFunction</a> or <a>GetAlias</a>.
     * </p>
     * 
     * @return An optional value you can use to ensure you are updating the latest update of the function version or
     *         alias. If the <code>RevisionID</code> you pass doesn't match the latest <code>RevisionId</code> of the
     *         function or alias, it will fail with an error message, advising you to retrieve the latest function
     *         version or alias <code>RevisionID</code> using either using using either <a>GetFunction</a> or
     *         <a>GetAlias</a>.
     */
    public String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(zipFile());
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3Key());
        hashCode = 31 * hashCode + Objects.hashCode(s3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(publish());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFunctionCodeRequest)) {
            return false;
        }
        UpdateFunctionCodeRequest other = (UpdateFunctionCodeRequest) obj;
        return Objects.equals(functionName(), other.functionName()) && Objects.equals(zipFile(), other.zipFile())
                && Objects.equals(s3Bucket(), other.s3Bucket()) && Objects.equals(s3Key(), other.s3Key())
                && Objects.equals(s3ObjectVersion(), other.s3ObjectVersion()) && Objects.equals(publish(), other.publish())
                && Objects.equals(dryRun(), other.dryRun()) && Objects.equals(revisionId(), other.revisionId());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateFunctionCodeRequest").add("FunctionName", functionName()).add("ZipFile", zipFile())
                .add("S3Bucket", s3Bucket()).add("S3Key", s3Key()).add("S3ObjectVersion", s3ObjectVersion())
                .add("Publish", publish()).add("DryRun", dryRun()).add("RevisionId", revisionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "ZipFile":
            return Optional.ofNullable(clazz.cast(zipFile()));
        case "S3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "S3Key":
            return Optional.ofNullable(clazz.cast(s3Key()));
        case "S3ObjectVersion":
            return Optional.ofNullable(clazz.cast(s3ObjectVersion()));
        case "Publish":
            return Optional.ofNullable(clazz.cast(publish()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFunctionCodeRequest, T> g) {
        return obj -> g.apply((UpdateFunctionCodeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFunctionCodeRequest> {
        /**
         * <p>
         * The name of the Lambda function.
         * </p>
         * <p class="title">
         * <b>Name formats</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Function name</b> - <code>MyFunction</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to
         * 64 characters in length.
         * </p>
         * 
         * @param functionName
         *        The name of the Lambda function.</p>
         *        <p class="title">
         *        <b>Name formats</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Function name</b> - <code>MyFunction</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The length constraint applies only to the full ARN. If you specify only the function name, it is
         *        limited to 64 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * The contents of your zip file containing your deployment package. If you are using the web API directly, the
         * contents of the zip file must be base64-encoded. If you are using the AWS SDKs or the AWS CLI, the SDKs or
         * CLI will do the encoding for you. For more information about creating a .zip file, see <a href=
         * "http://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role.html"
         * >Execution Permissions</a>.
         * </p>
         * 
         * @param zipFile
         *        The contents of your zip file containing your deployment package. If you are using the web API
         *        directly, the contents of the zip file must be base64-encoded. If you are using the AWS SDKs or the
         *        AWS CLI, the SDKs or CLI will do the encoding for you. For more information about creating a .zip
         *        file, see <a href=
         *        "http://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role.html"
         *        >Execution Permissions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zipFile(SdkBytes zipFile);

        /**
         * <p>
         * Amazon S3 bucket name where the .zip file containing your deployment package is stored. This bucket must
         * reside in the same AWS Region where you are creating the Lambda function.
         * </p>
         * 
         * @param s3Bucket
         *        Amazon S3 bucket name where the .zip file containing your deployment package is stored. This bucket
         *        must reside in the same AWS Region where you are creating the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The Amazon S3 object (the deployment package) key name you want to upload.
         * </p>
         * 
         * @param s3Key
         *        The Amazon S3 object (the deployment package) key name you want to upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Key(String s3Key);

        /**
         * <p>
         * The Amazon S3 object (the deployment package) version you want to upload.
         * </p>
         * 
         * @param s3ObjectVersion
         *        The Amazon S3 object (the deployment package) version you want to upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ObjectVersion(String s3ObjectVersion);

        /**
         * <p>
         * This boolean parameter can be used to request AWS Lambda to update the Lambda function and publish a version
         * as an atomic operation.
         * </p>
         * 
         * @param publish
         *        This boolean parameter can be used to request AWS Lambda to update the Lambda function and publish a
         *        version as an atomic operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publish(Boolean publish);

        /**
         * <p>
         * This boolean parameter can be used to test your request to AWS Lambda to update the Lambda function and
         * publish a version as an atomic operation. It will do all necessary computation and validation of your code
         * but will not upload it or a publish a version. Each time this operation is invoked, the
         * <code>CodeSha256</code> hash value of the provided code will also be computed and returned in the response.
         * </p>
         * 
         * @param dryRun
         *        This boolean parameter can be used to test your request to AWS Lambda to update the Lambda function
         *        and publish a version as an atomic operation. It will do all necessary computation and validation of
         *        your code but will not upload it or a publish a version. Each time this operation is invoked, the
         *        <code>CodeSha256</code> hash value of the provided code will also be computed and returned in the
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * An optional value you can use to ensure you are updating the latest update of the function version or alias.
         * If the <code>RevisionID</code> you pass doesn't match the latest <code>RevisionId</code> of the function or
         * alias, it will fail with an error message, advising you to retrieve the latest function version or alias
         * <code>RevisionID</code> using either using using either <a>GetFunction</a> or <a>GetAlias</a>.
         * </p>
         * 
         * @param revisionId
         *        An optional value you can use to ensure you are updating the latest update of the function version or
         *        alias. If the <code>RevisionID</code> you pass doesn't match the latest <code>RevisionId</code> of the
         *        function or alias, it will fail with an error message, advising you to retrieve the latest function
         *        version or alias <code>RevisionID</code> using either using using either <a>GetFunction</a> or
         *        <a>GetAlias</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String functionName;

        private SdkBytes zipFile;

        private String s3Bucket;

        private String s3Key;

        private String s3ObjectVersion;

        private Boolean publish;

        private Boolean dryRun;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFunctionCodeRequest model) {
            super(model);
            functionName(model.functionName);
            zipFile(model.zipFile);
            s3Bucket(model.s3Bucket);
            s3Key(model.s3Key);
            s3ObjectVersion(model.s3ObjectVersion);
            publish(model.publish);
            dryRun(model.dryRun);
            revisionId(model.revisionId);
        }

        public final String getFunctionName() {
            return functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final ByteBuffer getZipFile() {
            return zipFile == null ? null : zipFile.asByteBuffer();
        }

        @Override
        public final Builder zipFile(SdkBytes zipFile) {
            this.zipFile = StandardMemberCopier.copy(zipFile);
            return this;
        }

        public final void setZipFile(ByteBuffer zipFile) {
            zipFile(zipFile == null ? null : SdkBytes.fromByteBuffer(zipFile));
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Key() {
            return s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        public final String getS3ObjectVersion() {
            return s3ObjectVersion;
        }

        @Override
        public final Builder s3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
            return this;
        }

        public final void setS3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
        }

        public final Boolean getPublish() {
            return publish;
        }

        @Override
        public final Builder publish(Boolean publish) {
            this.publish = publish;
            return this;
        }

        public final void setPublish(Boolean publish) {
            this.publish = publish;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFunctionCodeRequest build() {
            return new UpdateFunctionCodeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
