/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.services.lambda.model.LayersListCopier;
import software.amazon.awssdk.services.lambda.model.LayersListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLayersResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, ListLayersResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListLayersResponse.getter(ListLayersResponse::nextMarker)).setter(ListLayersResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<LayersListItem>> LAYERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListLayersResponse.getter(ListLayersResponse::layers)).setter(ListLayersResponse.setter(Builder::layers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LayersListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, LAYERS_FIELD));
    private final String nextMarker;
    private final List<LayersListItem> layers;

    private ListLayersResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.layers = builder.layers;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<LayersListItem> layers() {
        return this.layers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.layers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLayersResponse)) {
            return false;
        }
        ListLayersResponse other = (ListLayersResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.layers(), other.layers());
    }

    public String toString() {
        return ToString.builder((String)"ListLayersResponse").add("NextMarker", (Object)this.nextMarker()).add("Layers", this.layers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "Layers": {
                return Optional.ofNullable(clazz.cast(this.layers()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLayersResponse, T> g) {
        return obj -> g.apply((ListLayersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<LayersListItem> layers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListLayersResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.layers(model.layers);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<LayersListItem.Builder> getLayers() {
            return this.layers != null ? (Collection)this.layers.stream().map(LayersListItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder layers(Collection<LayersListItem> layers) {
            this.layers = LayersListCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(LayersListItem ... layers) {
            this.layers(Arrays.asList(layers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Consumer<LayersListItem.Builder> ... layers) {
            this.layers(Stream.of(layers).map(c -> (LayersListItem)((LayersListItem.Builder)LayersListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLayers(Collection<LayersListItem.BuilderImpl> layers) {
            this.layers = LayersListCopier.copyFromBuilder(layers);
        }

        @Override
        public ListLayersResponse build() {
            return new ListLayersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLayersResponse> {
        public Builder nextMarker(String var1);

        public Builder layers(Collection<LayersListItem> var1);

        public Builder layers(LayersListItem ... var1);

        public Builder layers(Consumer<LayersListItem.Builder> ... var1);
    }
}

