/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddLayerVersionPermissionRequest extends LambdaRequest implements
        ToCopyableBuilder<AddLayerVersionPermissionRequest.Builder, AddLayerVersionPermissionRequest> {
    private static final SdkField<String> LAYER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddLayerVersionPermissionRequest::layerName)).setter(setter(Builder::layerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("LayerName").build()).build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(AddLayerVersionPermissionRequest::versionNumber)).setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("VersionNumber").build()).build();

    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddLayerVersionPermissionRequest::statementId)).setter(setter(Builder::statementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementId").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddLayerVersionPermissionRequest::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddLayerVersionPermissionRequest::principal)).setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()).build();

    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddLayerVersionPermissionRequest::organizationId)).setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddLayerVersionPermissionRequest::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("RevisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYER_NAME_FIELD,
            VERSION_NUMBER_FIELD, STATEMENT_ID_FIELD, ACTION_FIELD, PRINCIPAL_FIELD, ORGANIZATION_ID_FIELD, REVISION_ID_FIELD));

    private final String layerName;

    private final Long versionNumber;

    private final String statementId;

    private final String action;

    private final String principal;

    private final String organizationId;

    private final String revisionId;

    private AddLayerVersionPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.layerName = builder.layerName;
        this.versionNumber = builder.versionNumber;
        this.statementId = builder.statementId;
        this.action = builder.action;
        this.principal = builder.principal;
        this.organizationId = builder.organizationId;
        this.revisionId = builder.revisionId;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the layer.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the layer.
     */
    public String layerName() {
        return layerName;
    }

    /**
     * <p>
     * The version number.
     * </p>
     * 
     * @return The version number.
     */
    public Long versionNumber() {
        return versionNumber;
    }

    /**
     * <p>
     * An identifier that distinguishes the policy from others on the same layer version.
     * </p>
     * 
     * @return An identifier that distinguishes the policy from others on the same layer version.
     */
    public String statementId() {
        return statementId;
    }

    /**
     * <p>
     * The API action that grants access to the layer. For example, <code>lambda:GetLayerVersion</code>.
     * </p>
     * 
     * @return The API action that grants access to the layer. For example, <code>lambda:GetLayerVersion</code>.
     */
    public String action() {
        return action;
    }

    /**
     * <p>
     * An account ID, or <code>*</code> to grant permission to all AWS accounts.
     * </p>
     * 
     * @return An account ID, or <code>*</code> to grant permission to all AWS accounts.
     */
    public String principal() {
        return principal;
    }

    /**
     * <p>
     * With the principal set to <code>*</code>, grant permission to all accounts in the specified organization.
     * </p>
     * 
     * @return With the principal set to <code>*</code>, grant permission to all accounts in the specified organization.
     */
    public String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a policy
     * that has changed since you last read it.
     * </p>
     * 
     * @return Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a
     *         policy that has changed since you last read it.
     */
    public String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(layerName());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(statementId());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddLayerVersionPermissionRequest)) {
            return false;
        }
        AddLayerVersionPermissionRequest other = (AddLayerVersionPermissionRequest) obj;
        return Objects.equals(layerName(), other.layerName()) && Objects.equals(versionNumber(), other.versionNumber())
                && Objects.equals(statementId(), other.statementId()) && Objects.equals(action(), other.action())
                && Objects.equals(principal(), other.principal()) && Objects.equals(organizationId(), other.organizationId())
                && Objects.equals(revisionId(), other.revisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AddLayerVersionPermissionRequest").add("LayerName", layerName())
                .add("VersionNumber", versionNumber()).add("StatementId", statementId()).add("Action", action())
                .add("Principal", principal()).add("OrganizationId", organizationId()).add("RevisionId", revisionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LayerName":
            return Optional.ofNullable(clazz.cast(layerName()));
        case "VersionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "StatementId":
            return Optional.ofNullable(clazz.cast(statementId()));
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "Principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddLayerVersionPermissionRequest, T> g) {
        return obj -> g.apply((AddLayerVersionPermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddLayerVersionPermissionRequest> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the layer.
         * </p>
         * 
         * @param layerName
         *        The name or Amazon Resource Name (ARN) of the layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerName(String layerName);

        /**
         * <p>
         * The version number.
         * </p>
         * 
         * @param versionNumber
         *        The version number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);

        /**
         * <p>
         * An identifier that distinguishes the policy from others on the same layer version.
         * </p>
         * 
         * @param statementId
         *        An identifier that distinguishes the policy from others on the same layer version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementId(String statementId);

        /**
         * <p>
         * The API action that grants access to the layer. For example, <code>lambda:GetLayerVersion</code>.
         * </p>
         * 
         * @param action
         *        The API action that grants access to the layer. For example, <code>lambda:GetLayerVersion</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * An account ID, or <code>*</code> to grant permission to all AWS accounts.
         * </p>
         * 
         * @param principal
         *        An account ID, or <code>*</code> to grant permission to all AWS accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);

        /**
         * <p>
         * With the principal set to <code>*</code>, grant permission to all accounts in the specified organization.
         * </p>
         * 
         * @param organizationId
         *        With the principal set to <code>*</code>, grant permission to all accounts in the specified
         *        organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a
         * policy that has changed since you last read it.
         * </p>
         * 
         * @param revisionId
         *        Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying
         *        a policy that has changed since you last read it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String layerName;

        private Long versionNumber;

        private String statementId;

        private String action;

        private String principal;

        private String organizationId;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(AddLayerVersionPermissionRequest model) {
            super(model);
            layerName(model.layerName);
            versionNumber(model.versionNumber);
            statementId(model.statementId);
            action(model.action);
            principal(model.principal);
            organizationId(model.organizationId);
            revisionId(model.revisionId);
        }

        public final String getLayerName() {
            return layerName;
        }

        @Override
        public final Builder layerName(String layerName) {
            this.layerName = layerName;
            return this;
        }

        public final void setLayerName(String layerName) {
            this.layerName = layerName;
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public final String getStatementId() {
            return statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getPrincipal() {
            return principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddLayerVersionPermissionRequest build() {
            return new AddLayerVersionPermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
