/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides configuration information about a Lambda function <a
 * href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AliasConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AliasConfiguration.Builder, AliasConfiguration> {
    private static final SdkField<String> ALIAS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AliasConfiguration::aliasArn)).setter(setter(Builder::aliasArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AliasConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> FUNCTION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AliasConfiguration::functionVersion)).setter(setter(Builder::functionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionVersion").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AliasConfiguration::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<AliasRoutingConfiguration> ROUTING_CONFIG_FIELD = SdkField
            .<AliasRoutingConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(AliasConfiguration::routingConfig))
            .setter(setter(Builder::routingConfig)).constructor(AliasRoutingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingConfig").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AliasConfiguration::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_ARN_FIELD, NAME_FIELD,
            FUNCTION_VERSION_FIELD, DESCRIPTION_FIELD, ROUTING_CONFIG_FIELD, REVISION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String aliasArn;

    private final String name;

    private final String functionVersion;

    private final String description;

    private final AliasRoutingConfiguration routingConfig;

    private final String revisionId;

    private AliasConfiguration(BuilderImpl builder) {
        this.aliasArn = builder.aliasArn;
        this.name = builder.name;
        this.functionVersion = builder.functionVersion;
        this.description = builder.description;
        this.routingConfig = builder.routingConfig;
        this.revisionId = builder.revisionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the alias.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the alias.
     */
    public String aliasArn() {
        return aliasArn;
    }

    /**
     * <p>
     * The name of the alias.
     * </p>
     * 
     * @return The name of the alias.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The function version that the alias invokes.
     * </p>
     * 
     * @return The function version that the alias invokes.
     */
    public String functionVersion() {
        return functionVersion;
    }

    /**
     * <p>
     * A description of the alias.
     * </p>
     * 
     * @return A description of the alias.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing
     * configuration</a> of the alias.
     * </p>
     * 
     * @return The <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing
     *         configuration</a> of the alias.
     */
    public AliasRoutingConfiguration routingConfig() {
        return routingConfig;
    }

    /**
     * <p>
     * A unique identifier that changes when you update the alias.
     * </p>
     * 
     * @return A unique identifier that changes when you update the alias.
     */
    public String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(functionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(routingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AliasConfiguration)) {
            return false;
        }
        AliasConfiguration other = (AliasConfiguration) obj;
        return Objects.equals(aliasArn(), other.aliasArn()) && Objects.equals(name(), other.name())
                && Objects.equals(functionVersion(), other.functionVersion())
                && Objects.equals(description(), other.description()) && Objects.equals(routingConfig(), other.routingConfig())
                && Objects.equals(revisionId(), other.revisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AliasConfiguration").add("AliasArn", aliasArn()).add("Name", name())
                .add("FunctionVersion", functionVersion()).add("Description", description())
                .add("RoutingConfig", routingConfig()).add("RevisionId", revisionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AliasArn":
            return Optional.ofNullable(clazz.cast(aliasArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "FunctionVersion":
            return Optional.ofNullable(clazz.cast(functionVersion()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RoutingConfig":
            return Optional.ofNullable(clazz.cast(routingConfig()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AliasConfiguration, T> g) {
        return obj -> g.apply((AliasConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AliasConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the alias.
         * </p>
         * 
         * @param aliasArn
         *        The Amazon Resource Name (ARN) of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasArn(String aliasArn);

        /**
         * <p>
         * The name of the alias.
         * </p>
         * 
         * @param name
         *        The name of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The function version that the alias invokes.
         * </p>
         * 
         * @param functionVersion
         *        The function version that the alias invokes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionVersion(String functionVersion);

        /**
         * <p>
         * A description of the alias.
         * </p>
         * 
         * @param description
         *        A description of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing
         * configuration</a> of the alias.
         * </p>
         * 
         * @param routingConfig
         *        The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">
         *        routing configuration</a> of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingConfig(AliasRoutingConfiguration routingConfig);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">routing
         * configuration</a> of the alias.
         * </p>
         * This is a convenience that creates an instance of the {@link AliasRoutingConfiguration.Builder} avoiding the
         * need to create one manually via {@link AliasRoutingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AliasRoutingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #routingConfig(AliasRoutingConfiguration)}.
         * 
         * @param routingConfig
         *        a consumer that will call methods on {@link AliasRoutingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingConfig(AliasRoutingConfiguration)
         */
        default Builder routingConfig(Consumer<AliasRoutingConfiguration.Builder> routingConfig) {
            return routingConfig(AliasRoutingConfiguration.builder().applyMutation(routingConfig).build());
        }

        /**
         * <p>
         * A unique identifier that changes when you update the alias.
         * </p>
         * 
         * @param revisionId
         *        A unique identifier that changes when you update the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);
    }

    static final class BuilderImpl implements Builder {
        private String aliasArn;

        private String name;

        private String functionVersion;

        private String description;

        private AliasRoutingConfiguration routingConfig;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(AliasConfiguration model) {
            aliasArn(model.aliasArn);
            name(model.name);
            functionVersion(model.functionVersion);
            description(model.description);
            routingConfig(model.routingConfig);
            revisionId(model.revisionId);
        }

        public final String getAliasArn() {
            return aliasArn;
        }

        @Override
        public final Builder aliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
            return this;
        }

        public final void setAliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFunctionVersion() {
            return functionVersion;
        }

        @Override
        public final Builder functionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        public final void setFunctionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final AliasRoutingConfiguration.Builder getRoutingConfig() {
            return routingConfig != null ? routingConfig.toBuilder() : null;
        }

        @Override
        public final Builder routingConfig(AliasRoutingConfiguration routingConfig) {
            this.routingConfig = routingConfig;
            return this;
        }

        public final void setRoutingConfig(AliasRoutingConfiguration.BuilderImpl routingConfig) {
            this.routingConfig = routingConfig != null ? routingConfig.build() : null;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public AliasConfiguration build() {
            return new AliasConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
