/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the provisioned concurrency configuration for a function alias or version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionedConcurrencyConfigListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<ProvisionedConcurrencyConfigListItem.Builder, ProvisionedConcurrencyConfigListItem> {
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProvisionedConcurrencyConfigListItem::functionArn)).setter(setter(Builder::functionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()).build();

    private static final SdkField<Integer> REQUESTED_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ProvisionedConcurrencyConfigListItem::requestedProvisionedConcurrentExecutions))
            .setter(setter(Builder::requestedProvisionedConcurrentExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("RequestedProvisionedConcurrentExecutions").build()).build();

    private static final SdkField<Integer> AVAILABLE_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ProvisionedConcurrencyConfigListItem::availableProvisionedConcurrentExecutions))
            .setter(setter(Builder::availableProvisionedConcurrentExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AvailableProvisionedConcurrentExecutions").build()).build();

    private static final SdkField<Integer> ALLOCATED_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ProvisionedConcurrencyConfigListItem::allocatedProvisionedConcurrentExecutions))
            .setter(setter(Builder::allocatedProvisionedConcurrentExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AllocatedProvisionedConcurrentExecutions").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProvisionedConcurrencyConfigListItem::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProvisionedConcurrencyConfigListItem::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<String> LAST_MODIFIED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProvisionedConcurrencyConfigListItem::lastModified)).setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_ARN_FIELD,
            REQUESTED_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD, AVAILABLE_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD,
            ALLOCATED_PROVISIONED_CONCURRENT_EXECUTIONS_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, LAST_MODIFIED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String functionArn;

    private final Integer requestedProvisionedConcurrentExecutions;

    private final Integer availableProvisionedConcurrentExecutions;

    private final Integer allocatedProvisionedConcurrentExecutions;

    private final String status;

    private final String statusReason;

    private final String lastModified;

    private ProvisionedConcurrencyConfigListItem(BuilderImpl builder) {
        this.functionArn = builder.functionArn;
        this.requestedProvisionedConcurrentExecutions = builder.requestedProvisionedConcurrentExecutions;
        this.availableProvisionedConcurrentExecutions = builder.availableProvisionedConcurrentExecutions;
        this.allocatedProvisionedConcurrentExecutions = builder.allocatedProvisionedConcurrentExecutions;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.lastModified = builder.lastModified;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the alias or version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the alias or version.
     */
    public String functionArn() {
        return functionArn;
    }

    /**
     * <p>
     * The amount of provisioned concurrency requested.
     * </p>
     * 
     * @return The amount of provisioned concurrency requested.
     */
    public Integer requestedProvisionedConcurrentExecutions() {
        return requestedProvisionedConcurrentExecutions;
    }

    /**
     * <p>
     * The amount of provisioned concurrency available.
     * </p>
     * 
     * @return The amount of provisioned concurrency available.
     */
    public Integer availableProvisionedConcurrentExecutions() {
        return availableProvisionedConcurrentExecutions;
    }

    /**
     * <p>
     * The amount of provisioned concurrency allocated.
     * </p>
     * 
     * @return The amount of provisioned concurrency allocated.
     */
    public Integer allocatedProvisionedConcurrentExecutions() {
        return allocatedProvisionedConcurrentExecutions;
    }

    /**
     * <p>
     * The status of the allocation process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProvisionedConcurrencyStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the allocation process.
     * @see ProvisionedConcurrencyStatusEnum
     */
    public ProvisionedConcurrencyStatusEnum status() {
        return ProvisionedConcurrencyStatusEnum.fromValue(status);
    }

    /**
     * <p>
     * The status of the allocation process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProvisionedConcurrencyStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the allocation process.
     * @see ProvisionedConcurrencyStatusEnum
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * For failed allocations, the reason that provisioned concurrency could not be allocated.
     * </p>
     * 
     * @return For failed allocations, the reason that provisioned concurrency could not be allocated.
     */
    public String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The date and time that a user last updated the configuration, in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.
     * </p>
     * 
     * @return The date and time that a user last updated the configuration, in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.
     */
    public String lastModified() {
        return lastModified;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(requestedProvisionedConcurrentExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(availableProvisionedConcurrentExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedProvisionedConcurrentExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedConcurrencyConfigListItem)) {
            return false;
        }
        ProvisionedConcurrencyConfigListItem other = (ProvisionedConcurrencyConfigListItem) obj;
        return Objects.equals(functionArn(), other.functionArn())
                && Objects.equals(requestedProvisionedConcurrentExecutions(), other.requestedProvisionedConcurrentExecutions())
                && Objects.equals(availableProvisionedConcurrentExecutions(), other.availableProvisionedConcurrentExecutions())
                && Objects.equals(allocatedProvisionedConcurrentExecutions(), other.allocatedProvisionedConcurrentExecutions())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(lastModified(), other.lastModified());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProvisionedConcurrencyConfigListItem").add("FunctionArn", functionArn())
                .add("RequestedProvisionedConcurrentExecutions", requestedProvisionedConcurrentExecutions())
                .add("AvailableProvisionedConcurrentExecutions", availableProvisionedConcurrentExecutions())
                .add("AllocatedProvisionedConcurrentExecutions", allocatedProvisionedConcurrentExecutions())
                .add("Status", statusAsString()).add("StatusReason", statusReason()).add("LastModified", lastModified()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionArn":
            return Optional.ofNullable(clazz.cast(functionArn()));
        case "RequestedProvisionedConcurrentExecutions":
            return Optional.ofNullable(clazz.cast(requestedProvisionedConcurrentExecutions()));
        case "AvailableProvisionedConcurrentExecutions":
            return Optional.ofNullable(clazz.cast(availableProvisionedConcurrentExecutions()));
        case "AllocatedProvisionedConcurrentExecutions":
            return Optional.ofNullable(clazz.cast(allocatedProvisionedConcurrentExecutions()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionedConcurrencyConfigListItem, T> g) {
        return obj -> g.apply((ProvisionedConcurrencyConfigListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProvisionedConcurrencyConfigListItem> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the alias or version.
         * </p>
         * 
         * @param functionArn
         *        The Amazon Resource Name (ARN) of the alias or version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionArn(String functionArn);

        /**
         * <p>
         * The amount of provisioned concurrency requested.
         * </p>
         * 
         * @param requestedProvisionedConcurrentExecutions
         *        The amount of provisioned concurrency requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedProvisionedConcurrentExecutions(Integer requestedProvisionedConcurrentExecutions);

        /**
         * <p>
         * The amount of provisioned concurrency available.
         * </p>
         * 
         * @param availableProvisionedConcurrentExecutions
         *        The amount of provisioned concurrency available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableProvisionedConcurrentExecutions(Integer availableProvisionedConcurrentExecutions);

        /**
         * <p>
         * The amount of provisioned concurrency allocated.
         * </p>
         * 
         * @param allocatedProvisionedConcurrentExecutions
         *        The amount of provisioned concurrency allocated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedProvisionedConcurrentExecutions(Integer allocatedProvisionedConcurrentExecutions);

        /**
         * <p>
         * The status of the allocation process.
         * </p>
         * 
         * @param status
         *        The status of the allocation process.
         * @see ProvisionedConcurrencyStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisionedConcurrencyStatusEnum
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the allocation process.
         * </p>
         * 
         * @param status
         *        The status of the allocation process.
         * @see ProvisionedConcurrencyStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProvisionedConcurrencyStatusEnum
         */
        Builder status(ProvisionedConcurrencyStatusEnum status);

        /**
         * <p>
         * For failed allocations, the reason that provisioned concurrency could not be allocated.
         * </p>
         * 
         * @param statusReason
         *        For failed allocations, the reason that provisioned concurrency could not be allocated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The date and time that a user last updated the configuration, in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.
         * </p>
         * 
         * @param lastModified
         *        The date and time that a user last updated the configuration, in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(String lastModified);
    }

    static final class BuilderImpl implements Builder {
        private String functionArn;

        private Integer requestedProvisionedConcurrentExecutions;

        private Integer availableProvisionedConcurrentExecutions;

        private Integer allocatedProvisionedConcurrentExecutions;

        private String status;

        private String statusReason;

        private String lastModified;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedConcurrencyConfigListItem model) {
            functionArn(model.functionArn);
            requestedProvisionedConcurrentExecutions(model.requestedProvisionedConcurrentExecutions);
            availableProvisionedConcurrentExecutions(model.availableProvisionedConcurrentExecutions);
            allocatedProvisionedConcurrentExecutions(model.allocatedProvisionedConcurrentExecutions);
            status(model.status);
            statusReason(model.statusReason);
            lastModified(model.lastModified);
        }

        public final String getFunctionArn() {
            return functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        public final Integer getRequestedProvisionedConcurrentExecutions() {
            return requestedProvisionedConcurrentExecutions;
        }

        @Override
        public final Builder requestedProvisionedConcurrentExecutions(Integer requestedProvisionedConcurrentExecutions) {
            this.requestedProvisionedConcurrentExecutions = requestedProvisionedConcurrentExecutions;
            return this;
        }

        public final void setRequestedProvisionedConcurrentExecutions(Integer requestedProvisionedConcurrentExecutions) {
            this.requestedProvisionedConcurrentExecutions = requestedProvisionedConcurrentExecutions;
        }

        public final Integer getAvailableProvisionedConcurrentExecutions() {
            return availableProvisionedConcurrentExecutions;
        }

        @Override
        public final Builder availableProvisionedConcurrentExecutions(Integer availableProvisionedConcurrentExecutions) {
            this.availableProvisionedConcurrentExecutions = availableProvisionedConcurrentExecutions;
            return this;
        }

        public final void setAvailableProvisionedConcurrentExecutions(Integer availableProvisionedConcurrentExecutions) {
            this.availableProvisionedConcurrentExecutions = availableProvisionedConcurrentExecutions;
        }

        public final Integer getAllocatedProvisionedConcurrentExecutions() {
            return allocatedProvisionedConcurrentExecutions;
        }

        @Override
        public final Builder allocatedProvisionedConcurrentExecutions(Integer allocatedProvisionedConcurrentExecutions) {
            this.allocatedProvisionedConcurrentExecutions = allocatedProvisionedConcurrentExecutions;
            return this;
        }

        public final void setAllocatedProvisionedConcurrentExecutions(Integer allocatedProvisionedConcurrentExecutions) {
            this.allocatedProvisionedConcurrentExecutions = allocatedProvisionedConcurrentExecutions;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProvisionedConcurrencyStatusEnum status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final String getLastModified() {
            return lastModified;
        }

        @Override
        public final Builder lastModified(String lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public ProvisionedConcurrencyConfigListItem build() {
            return new ProvisionedConcurrencyConfigListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
