/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A mapping between an AWS resource and an AWS Lambda function. See <a>CreateEventSourceMapping</a> for details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEventSourceMappingResponse extends LambdaResponse implements
        ToCopyableBuilder<UpdateEventSourceMappingResponse.Builder, UpdateEventSourceMappingResponse> {
    private static final SdkField<String> UUID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEventSourceMappingResponse::uuid)).setter(setter(Builder::uuid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UUID").build()).build();

    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateEventSourceMappingResponse::batchSize)).setter(setter(Builder::batchSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()).build();

    private static final SdkField<Integer> MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateEventSourceMappingResponse::maximumBatchingWindowInSeconds))
            .setter(setter(Builder::maximumBatchingWindowInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchingWindowInSeconds")
                    .build()).build();

    private static final SdkField<Integer> PARALLELIZATION_FACTOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateEventSourceMappingResponse::parallelizationFactor))
            .setter(setter(Builder::parallelizationFactor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelizationFactor").build())
            .build();

    private static final SdkField<String> EVENT_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEventSourceMappingResponse::eventSourceArn)).setter(setter(Builder::eventSourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceArn").build()).build();

    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEventSourceMappingResponse::functionArn)).setter(setter(Builder::functionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(UpdateEventSourceMappingResponse::lastModified)).setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()).build();

    private static final SdkField<String> LAST_PROCESSING_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEventSourceMappingResponse::lastProcessingResult)).setter(setter(Builder::lastProcessingResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastProcessingResult").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEventSourceMappingResponse::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATE_TRANSITION_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEventSourceMappingResponse::stateTransitionReason))
            .setter(setter(Builder::stateTransitionReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateTransitionReason").build())
            .build();

    private static final SdkField<DestinationConfig> DESTINATION_CONFIG_FIELD = SdkField
            .<DestinationConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateEventSourceMappingResponse::destinationConfig)).setter(setter(Builder::destinationConfig))
            .constructor(DestinationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationConfig").build()).build();

    private static final SdkField<List<String>> TOPICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UpdateEventSourceMappingResponse::topics))
            .setter(setter(Builder::topics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Topics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateEventSourceMappingResponse::maximumRecordAgeInSeconds))
            .setter(setter(Builder::maximumRecordAgeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRecordAgeInSeconds").build())
            .build();

    private static final SdkField<Boolean> BISECT_BATCH_ON_FUNCTION_ERROR_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateEventSourceMappingResponse::bisectBatchOnFunctionError))
            .setter(setter(Builder::bisectBatchOnFunctionError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BisectBatchOnFunctionError").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_RETRY_ATTEMPTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateEventSourceMappingResponse::maximumRetryAttempts)).setter(setter(Builder::maximumRetryAttempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRetryAttempts").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UUID_FIELD, BATCH_SIZE_FIELD,
            MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD, PARALLELIZATION_FACTOR_FIELD, EVENT_SOURCE_ARN_FIELD, FUNCTION_ARN_FIELD,
            LAST_MODIFIED_FIELD, LAST_PROCESSING_RESULT_FIELD, STATE_FIELD, STATE_TRANSITION_REASON_FIELD,
            DESTINATION_CONFIG_FIELD, TOPICS_FIELD, MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD, BISECT_BATCH_ON_FUNCTION_ERROR_FIELD,
            MAXIMUM_RETRY_ATTEMPTS_FIELD));

    private final String uuid;

    private final Integer batchSize;

    private final Integer maximumBatchingWindowInSeconds;

    private final Integer parallelizationFactor;

    private final String eventSourceArn;

    private final String functionArn;

    private final Instant lastModified;

    private final String lastProcessingResult;

    private final String state;

    private final String stateTransitionReason;

    private final DestinationConfig destinationConfig;

    private final List<String> topics;

    private final Integer maximumRecordAgeInSeconds;

    private final Boolean bisectBatchOnFunctionError;

    private final Integer maximumRetryAttempts;

    private UpdateEventSourceMappingResponse(BuilderImpl builder) {
        super(builder);
        this.uuid = builder.uuid;
        this.batchSize = builder.batchSize;
        this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
        this.parallelizationFactor = builder.parallelizationFactor;
        this.eventSourceArn = builder.eventSourceArn;
        this.functionArn = builder.functionArn;
        this.lastModified = builder.lastModified;
        this.lastProcessingResult = builder.lastProcessingResult;
        this.state = builder.state;
        this.stateTransitionReason = builder.stateTransitionReason;
        this.destinationConfig = builder.destinationConfig;
        this.topics = builder.topics;
        this.maximumRecordAgeInSeconds = builder.maximumRecordAgeInSeconds;
        this.bisectBatchOnFunctionError = builder.bisectBatchOnFunctionError;
        this.maximumRetryAttempts = builder.maximumRetryAttempts;
    }

    /**
     * <p>
     * The identifier of the event source mapping.
     * </p>
     * 
     * @return The identifier of the event source mapping.
     */
    public String uuid() {
        return uuid;
    }

    /**
     * <p>
     * The maximum number of items to retrieve in a single batch.
     * </p>
     * 
     * @return The maximum number of items to retrieve in a single batch.
     */
    public Integer batchSize() {
        return batchSize;
    }

    /**
     * <p>
     * (Streams) The maximum amount of time to gather records before invoking the function, in seconds.
     * </p>
     * 
     * @return (Streams) The maximum amount of time to gather records before invoking the function, in seconds.
     */
    public Integer maximumBatchingWindowInSeconds() {
        return maximumBatchingWindowInSeconds;
    }

    /**
     * <p>
     * (Streams) The number of batches to process from each shard concurrently.
     * </p>
     * 
     * @return (Streams) The number of batches to process from each shard concurrently.
     */
    public Integer parallelizationFactor() {
        return parallelizationFactor;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the event source.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the event source.
     */
    public String eventSourceArn() {
        return eventSourceArn;
    }

    /**
     * <p>
     * The ARN of the Lambda function.
     * </p>
     * 
     * @return The ARN of the Lambda function.
     */
    public String functionArn() {
        return functionArn;
    }

    /**
     * <p>
     * The date that the event source mapping was last updated, or its state changed.
     * </p>
     * 
     * @return The date that the event source mapping was last updated, or its state changed.
     */
    public Instant lastModified() {
        return lastModified;
    }

    /**
     * <p>
     * The result of the last AWS Lambda invocation of your Lambda function.
     * </p>
     * 
     * @return The result of the last AWS Lambda invocation of your Lambda function.
     */
    public String lastProcessingResult() {
        return lastProcessingResult;
    }

    /**
     * <p>
     * The state of the event source mapping. It can be one of the following: <code>Creating</code>,
     * <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>, <code>Updating</code>
     * , or <code>Deleting</code>.
     * </p>
     * 
     * @return The state of the event source mapping. It can be one of the following: <code>Creating</code>,
     *         <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
     *         <code>Updating</code>, or <code>Deleting</code>.
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * Indicates whether the last change to the event source mapping was made by a user, or by the Lambda service.
     * </p>
     * 
     * @return Indicates whether the last change to the event source mapping was made by a user, or by the Lambda
     *         service.
     */
    public String stateTransitionReason() {
        return stateTransitionReason;
    }

    /**
     * <p>
     * (Streams) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
     * </p>
     * 
     * @return (Streams) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
     */
    public DestinationConfig destinationConfig() {
        return destinationConfig;
    }

    /**
     * Returns true if the Topics property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTopics() {
        return topics != null && !(topics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (MSK) The name of the Kafka topic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTopics()} to see if a value was sent in this field.
     * </p>
     * 
     * @return (MSK) The name of the Kafka topic.
     */
    public List<String> topics() {
        return topics;
    }

    /**
     * <p>
     * (Streams) The maximum age of a record that Lambda sends to a function for processing.
     * </p>
     * 
     * @return (Streams) The maximum age of a record that Lambda sends to a function for processing.
     */
    public Integer maximumRecordAgeInSeconds() {
        return maximumRecordAgeInSeconds;
    }

    /**
     * <p>
     * (Streams) If the function returns an error, split the batch in two and retry.
     * </p>
     * 
     * @return (Streams) If the function returns an error, split the batch in two and retry.
     */
    public Boolean bisectBatchOnFunctionError() {
        return bisectBatchOnFunctionError;
    }

    /**
     * <p>
     * (Streams) The maximum number of times to retry when the function returns an error.
     * </p>
     * 
     * @return (Streams) The maximum number of times to retry when the function returns an error.
     */
    public Integer maximumRetryAttempts() {
        return maximumRetryAttempts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(uuid());
        hashCode = 31 * hashCode + Objects.hashCode(batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(maximumBatchingWindowInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(parallelizationFactor());
        hashCode = 31 * hashCode + Objects.hashCode(eventSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(lastProcessingResult());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(stateTransitionReason());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(topics());
        hashCode = 31 * hashCode + Objects.hashCode(maximumRecordAgeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(bisectBatchOnFunctionError());
        hashCode = 31 * hashCode + Objects.hashCode(maximumRetryAttempts());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventSourceMappingResponse)) {
            return false;
        }
        UpdateEventSourceMappingResponse other = (UpdateEventSourceMappingResponse) obj;
        return Objects.equals(uuid(), other.uuid()) && Objects.equals(batchSize(), other.batchSize())
                && Objects.equals(maximumBatchingWindowInSeconds(), other.maximumBatchingWindowInSeconds())
                && Objects.equals(parallelizationFactor(), other.parallelizationFactor())
                && Objects.equals(eventSourceArn(), other.eventSourceArn()) && Objects.equals(functionArn(), other.functionArn())
                && Objects.equals(lastModified(), other.lastModified())
                && Objects.equals(lastProcessingResult(), other.lastProcessingResult()) && Objects.equals(state(), other.state())
                && Objects.equals(stateTransitionReason(), other.stateTransitionReason())
                && Objects.equals(destinationConfig(), other.destinationConfig()) && Objects.equals(topics(), other.topics())
                && Objects.equals(maximumRecordAgeInSeconds(), other.maximumRecordAgeInSeconds())
                && Objects.equals(bisectBatchOnFunctionError(), other.bisectBatchOnFunctionError())
                && Objects.equals(maximumRetryAttempts(), other.maximumRetryAttempts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateEventSourceMappingResponse").add("UUID", uuid()).add("BatchSize", batchSize())
                .add("MaximumBatchingWindowInSeconds", maximumBatchingWindowInSeconds())
                .add("ParallelizationFactor", parallelizationFactor()).add("EventSourceArn", eventSourceArn())
                .add("FunctionArn", functionArn()).add("LastModified", lastModified())
                .add("LastProcessingResult", lastProcessingResult()).add("State", state())
                .add("StateTransitionReason", stateTransitionReason()).add("DestinationConfig", destinationConfig())
                .add("Topics", topics()).add("MaximumRecordAgeInSeconds", maximumRecordAgeInSeconds())
                .add("BisectBatchOnFunctionError", bisectBatchOnFunctionError())
                .add("MaximumRetryAttempts", maximumRetryAttempts()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UUID":
            return Optional.ofNullable(clazz.cast(uuid()));
        case "BatchSize":
            return Optional.ofNullable(clazz.cast(batchSize()));
        case "MaximumBatchingWindowInSeconds":
            return Optional.ofNullable(clazz.cast(maximumBatchingWindowInSeconds()));
        case "ParallelizationFactor":
            return Optional.ofNullable(clazz.cast(parallelizationFactor()));
        case "EventSourceArn":
            return Optional.ofNullable(clazz.cast(eventSourceArn()));
        case "FunctionArn":
            return Optional.ofNullable(clazz.cast(functionArn()));
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "LastProcessingResult":
            return Optional.ofNullable(clazz.cast(lastProcessingResult()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "StateTransitionReason":
            return Optional.ofNullable(clazz.cast(stateTransitionReason()));
        case "DestinationConfig":
            return Optional.ofNullable(clazz.cast(destinationConfig()));
        case "Topics":
            return Optional.ofNullable(clazz.cast(topics()));
        case "MaximumRecordAgeInSeconds":
            return Optional.ofNullable(clazz.cast(maximumRecordAgeInSeconds()));
        case "BisectBatchOnFunctionError":
            return Optional.ofNullable(clazz.cast(bisectBatchOnFunctionError()));
        case "MaximumRetryAttempts":
            return Optional.ofNullable(clazz.cast(maximumRetryAttempts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEventSourceMappingResponse, T> g) {
        return obj -> g.apply((UpdateEventSourceMappingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEventSourceMappingResponse> {
        /**
         * <p>
         * The identifier of the event source mapping.
         * </p>
         * 
         * @param uuid
         *        The identifier of the event source mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uuid(String uuid);

        /**
         * <p>
         * The maximum number of items to retrieve in a single batch.
         * </p>
         * 
         * @param batchSize
         *        The maximum number of items to retrieve in a single batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchSize(Integer batchSize);

        /**
         * <p>
         * (Streams) The maximum amount of time to gather records before invoking the function, in seconds.
         * </p>
         * 
         * @param maximumBatchingWindowInSeconds
         *        (Streams) The maximum amount of time to gather records before invoking the function, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds);

        /**
         * <p>
         * (Streams) The number of batches to process from each shard concurrently.
         * </p>
         * 
         * @param parallelizationFactor
         *        (Streams) The number of batches to process from each shard concurrently.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelizationFactor(Integer parallelizationFactor);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the event source.
         * </p>
         * 
         * @param eventSourceArn
         *        The Amazon Resource Name (ARN) of the event source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSourceArn(String eventSourceArn);

        /**
         * <p>
         * The ARN of the Lambda function.
         * </p>
         * 
         * @param functionArn
         *        The ARN of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionArn(String functionArn);

        /**
         * <p>
         * The date that the event source mapping was last updated, or its state changed.
         * </p>
         * 
         * @param lastModified
         *        The date that the event source mapping was last updated, or its state changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);

        /**
         * <p>
         * The result of the last AWS Lambda invocation of your Lambda function.
         * </p>
         * 
         * @param lastProcessingResult
         *        The result of the last AWS Lambda invocation of your Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastProcessingResult(String lastProcessingResult);

        /**
         * <p>
         * The state of the event source mapping. It can be one of the following: <code>Creating</code>,
         * <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
         * <code>Updating</code>, or <code>Deleting</code>.
         * </p>
         * 
         * @param state
         *        The state of the event source mapping. It can be one of the following: <code>Creating</code>,
         *        <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
         *        <code>Updating</code>, or <code>Deleting</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * Indicates whether the last change to the event source mapping was made by a user, or by the Lambda service.
         * </p>
         * 
         * @param stateTransitionReason
         *        Indicates whether the last change to the event source mapping was made by a user, or by the Lambda
         *        service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTransitionReason(String stateTransitionReason);

        /**
         * <p>
         * (Streams) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
         * </p>
         * 
         * @param destinationConfig
         *        (Streams) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfig(DestinationConfig destinationConfig);

        /**
         * <p>
         * (Streams) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
         * </p>
         * This is a convenience that creates an instance of the {@link DestinationConfig.Builder} avoiding the need to
         * create one manually via {@link DestinationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationConfig(DestinationConfig)}.
         * 
         * @param destinationConfig
         *        a consumer that will call methods on {@link DestinationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfig(DestinationConfig)
         */
        default Builder destinationConfig(Consumer<DestinationConfig.Builder> destinationConfig) {
            return destinationConfig(DestinationConfig.builder().applyMutation(destinationConfig).build());
        }

        /**
         * <p>
         * (MSK) The name of the Kafka topic.
         * </p>
         * 
         * @param topics
         *        (MSK) The name of the Kafka topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topics(Collection<String> topics);

        /**
         * <p>
         * (MSK) The name of the Kafka topic.
         * </p>
         * 
         * @param topics
         *        (MSK) The name of the Kafka topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topics(String... topics);

        /**
         * <p>
         * (Streams) The maximum age of a record that Lambda sends to a function for processing.
         * </p>
         * 
         * @param maximumRecordAgeInSeconds
         *        (Streams) The maximum age of a record that Lambda sends to a function for processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds);

        /**
         * <p>
         * (Streams) If the function returns an error, split the batch in two and retry.
         * </p>
         * 
         * @param bisectBatchOnFunctionError
         *        (Streams) If the function returns an error, split the batch in two and retry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bisectBatchOnFunctionError(Boolean bisectBatchOnFunctionError);

        /**
         * <p>
         * (Streams) The maximum number of times to retry when the function returns an error.
         * </p>
         * 
         * @param maximumRetryAttempts
         *        (Streams) The maximum number of times to retry when the function returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumRetryAttempts(Integer maximumRetryAttempts);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String uuid;

        private Integer batchSize;

        private Integer maximumBatchingWindowInSeconds;

        private Integer parallelizationFactor;

        private String eventSourceArn;

        private String functionArn;

        private Instant lastModified;

        private String lastProcessingResult;

        private String state;

        private String stateTransitionReason;

        private DestinationConfig destinationConfig;

        private List<String> topics = DefaultSdkAutoConstructList.getInstance();

        private Integer maximumRecordAgeInSeconds;

        private Boolean bisectBatchOnFunctionError;

        private Integer maximumRetryAttempts;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventSourceMappingResponse model) {
            super(model);
            uuid(model.uuid);
            batchSize(model.batchSize);
            maximumBatchingWindowInSeconds(model.maximumBatchingWindowInSeconds);
            parallelizationFactor(model.parallelizationFactor);
            eventSourceArn(model.eventSourceArn);
            functionArn(model.functionArn);
            lastModified(model.lastModified);
            lastProcessingResult(model.lastProcessingResult);
            state(model.state);
            stateTransitionReason(model.stateTransitionReason);
            destinationConfig(model.destinationConfig);
            topics(model.topics);
            maximumRecordAgeInSeconds(model.maximumRecordAgeInSeconds);
            bisectBatchOnFunctionError(model.bisectBatchOnFunctionError);
            maximumRetryAttempts(model.maximumRetryAttempts);
        }

        public final String getUuid() {
            return uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public final void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public final Integer getBatchSize() {
            return batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        public final Integer getMaximumBatchingWindowInSeconds() {
            return maximumBatchingWindowInSeconds;
        }

        @Override
        public final Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        public final void setMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
        }

        public final Integer getParallelizationFactor() {
            return parallelizationFactor;
        }

        @Override
        public final Builder parallelizationFactor(Integer parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
            return this;
        }

        public final void setParallelizationFactor(Integer parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
        }

        public final String getEventSourceArn() {
            return eventSourceArn;
        }

        @Override
        public final Builder eventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        public final void setEventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
        }

        public final String getFunctionArn() {
            return functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final String getLastProcessingResult() {
            return lastProcessingResult;
        }

        @Override
        public final Builder lastProcessingResult(String lastProcessingResult) {
            this.lastProcessingResult = lastProcessingResult;
            return this;
        }

        public final void setLastProcessingResult(String lastProcessingResult) {
            this.lastProcessingResult = lastProcessingResult;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateTransitionReason() {
            return stateTransitionReason;
        }

        @Override
        public final Builder stateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
            return this;
        }

        public final void setStateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
        }

        public final DestinationConfig.Builder getDestinationConfig() {
            return destinationConfig != null ? destinationConfig.toBuilder() : null;
        }

        @Override
        public final Builder destinationConfig(DestinationConfig destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        public final void setDestinationConfig(DestinationConfig.BuilderImpl destinationConfig) {
            this.destinationConfig = destinationConfig != null ? destinationConfig.build() : null;
        }

        public final Collection<String> getTopics() {
            return topics;
        }

        @Override
        public final Builder topics(Collection<String> topics) {
            this.topics = TopicsCopier.copy(topics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topics(String... topics) {
            topics(Arrays.asList(topics));
            return this;
        }

        public final void setTopics(Collection<String> topics) {
            this.topics = TopicsCopier.copy(topics);
        }

        public final Integer getMaximumRecordAgeInSeconds() {
            return maximumRecordAgeInSeconds;
        }

        @Override
        public final Builder maximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
            return this;
        }

        public final void setMaximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
        }

        public final Boolean getBisectBatchOnFunctionError() {
            return bisectBatchOnFunctionError;
        }

        @Override
        public final Builder bisectBatchOnFunctionError(Boolean bisectBatchOnFunctionError) {
            this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
            return this;
        }

        public final void setBisectBatchOnFunctionError(Boolean bisectBatchOnFunctionError) {
            this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
        }

        public final Integer getMaximumRetryAttempts() {
            return maximumRetryAttempts;
        }

        @Override
        public final Builder maximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
            return this;
        }

        public final void setMaximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
        }

        @Override
        public UpdateEventSourceMappingResponse build() {
            return new UpdateEventSourceMappingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
