/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <a
 * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-traffic-shifting-using-aliases.html">traffic-shifting</a>
 * configuration of a Lambda function alias.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AliasRoutingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AliasRoutingConfiguration.Builder, AliasRoutingConfiguration> {
    private static final SdkField<Map<String, Double>> ADDITIONAL_VERSION_WEIGHTS_FIELD = SdkField
            .<Map<String, Double>> builder(MarshallingType.MAP)
            .memberName("AdditionalVersionWeights")
            .getter(getter(AliasRoutingConfiguration::additionalVersionWeights))
            .setter(setter(Builder::additionalVersionWeights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalVersionWeights").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ADDITIONAL_VERSION_WEIGHTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, Double> additionalVersionWeights;

    private AliasRoutingConfiguration(BuilderImpl builder) {
        this.additionalVersionWeights = builder.additionalVersionWeights;
    }

    /**
     * Returns true if the AdditionalVersionWeights property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAdditionalVersionWeights() {
        return additionalVersionWeights != null && !(additionalVersionWeights instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The second version, and the percentage of traffic that's routed to it.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdditionalVersionWeights()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The second version, and the percentage of traffic that's routed to it.
     */
    public Map<String, Double> additionalVersionWeights() {
        return additionalVersionWeights;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(additionalVersionWeights());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AliasRoutingConfiguration)) {
            return false;
        }
        AliasRoutingConfiguration other = (AliasRoutingConfiguration) obj;
        return Objects.equals(additionalVersionWeights(), other.additionalVersionWeights());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AliasRoutingConfiguration").add("AdditionalVersionWeights", additionalVersionWeights()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdditionalVersionWeights":
            return Optional.ofNullable(clazz.cast(additionalVersionWeights()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AliasRoutingConfiguration, T> g) {
        return obj -> g.apply((AliasRoutingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AliasRoutingConfiguration> {
        /**
         * <p>
         * The second version, and the percentage of traffic that's routed to it.
         * </p>
         * 
         * @param additionalVersionWeights
         *        The second version, and the percentage of traffic that's routed to it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalVersionWeights(Map<String, Double> additionalVersionWeights);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, Double> additionalVersionWeights = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AliasRoutingConfiguration model) {
            additionalVersionWeights(model.additionalVersionWeights);
        }

        public final Map<String, Double> getAdditionalVersionWeights() {
            return additionalVersionWeights;
        }

        @Override
        public final Builder additionalVersionWeights(Map<String, Double> additionalVersionWeights) {
            this.additionalVersionWeights = AdditionalVersionWeightsCopier.copy(additionalVersionWeights);
            return this;
        }

        public final void setAdditionalVersionWeights(Map<String, Double> additionalVersionWeights) {
            this.additionalVersionWeights = AdditionalVersionWeightsCopier.copy(additionalVersionWeights);
        }

        @Override
        public AliasRoutingConfiguration build() {
            return new AliasRoutingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
