/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.DestinationConfig;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.services.lambda.model.TopicsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEventSourceMappingResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, CreateEventSourceMappingResponse> {
    private static final SdkField<String> UUID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UUID").getter(CreateEventSourceMappingResponse.getter(CreateEventSourceMappingResponse::uuid)).setter(CreateEventSourceMappingResponse.setter(Builder::uuid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UUID").build()}).build();
    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BatchSize").getter(CreateEventSourceMappingResponse.getter(CreateEventSourceMappingResponse::batchSize)).setter(CreateEventSourceMappingResponse.setter(Builder::batchSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()}).build();
    private static final SdkField<Integer> MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumBatchingWindowInSeconds").getter(CreateEventSourceMappingResponse.getter(CreateEventSourceMappingResponse::maximumBatchingWindowInSeconds)).setter(CreateEventSourceMappingResponse.setter(Builder::maximumBatchingWindowInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchingWindowInSeconds").build()}).build();
    private static final SdkField<Integer> PARALLELIZATION_FACTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParallelizationFactor").getter(CreateEventSourceMappingResponse.getter(CreateEventSourceMappingResponse::parallelizationFactor)).setter(CreateEventSourceMappingResponse.setter(Builder::parallelizationFactor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelizationFactor").build()}).build();
    private static final SdkField<String> EVENT_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventSourceArn").getter(CreateEventSourceMappingResponse.getter(CreateEventSourceMappingResponse::eventSourceArn)).setter(CreateEventSourceMappingResponse.setter(Builder::eventSourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceArn").build()}).build();
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionArn").getter(CreateEventSourceMappingResponse.getter(CreateEventSourceMappingResponse::functionArn)).setter(CreateEventSourceMappingResponse.setter(Builder::functionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModified").getter(CreateEventSourceMappingResponse.getter(CreateEventSourceMappingResponse::lastModified)).setter(CreateEventSourceMappingResponse.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()}).build();
    private static final SdkField<String> LAST_PROCESSING_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastProcessingResult").getter(CreateEventSourceMappingResponse.getter(CreateEventSourceMappingResponse::lastProcessingResult)).setter(CreateEventSourceMappingResponse.setter(Builder::lastProcessingResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastProcessingResult").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CreateEventSourceMappingResponse.getter(CreateEventSourceMappingResponse::state)).setter(CreateEventSourceMappingResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_TRANSITION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateTransitionReason").getter(CreateEventSourceMappingResponse.getter(CreateEventSourceMappingResponse::stateTransitionReason)).setter(CreateEventSourceMappingResponse.setter(Builder::stateTransitionReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateTransitionReason").build()}).build();
    private static final SdkField<DestinationConfig> DESTINATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationConfig").getter(CreateEventSourceMappingResponse.getter(CreateEventSourceMappingResponse::destinationConfig)).setter(CreateEventSourceMappingResponse.setter(Builder::destinationConfig)).constructor(DestinationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationConfig").build()}).build();
    private static final SdkField<List<String>> TOPICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Topics").getter(CreateEventSourceMappingResponse.getter(CreateEventSourceMappingResponse::topics)).setter(CreateEventSourceMappingResponse.setter(Builder::topics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Topics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumRecordAgeInSeconds").getter(CreateEventSourceMappingResponse.getter(CreateEventSourceMappingResponse::maximumRecordAgeInSeconds)).setter(CreateEventSourceMappingResponse.setter(Builder::maximumRecordAgeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRecordAgeInSeconds").build()}).build();
    private static final SdkField<Boolean> BISECT_BATCH_ON_FUNCTION_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("BisectBatchOnFunctionError").getter(CreateEventSourceMappingResponse.getter(CreateEventSourceMappingResponse::bisectBatchOnFunctionError)).setter(CreateEventSourceMappingResponse.setter(Builder::bisectBatchOnFunctionError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BisectBatchOnFunctionError").build()}).build();
    private static final SdkField<Integer> MAXIMUM_RETRY_ATTEMPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumRetryAttempts").getter(CreateEventSourceMappingResponse.getter(CreateEventSourceMappingResponse::maximumRetryAttempts)).setter(CreateEventSourceMappingResponse.setter(Builder::maximumRetryAttempts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRetryAttempts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UUID_FIELD, BATCH_SIZE_FIELD, MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD, PARALLELIZATION_FACTOR_FIELD, EVENT_SOURCE_ARN_FIELD, FUNCTION_ARN_FIELD, LAST_MODIFIED_FIELD, LAST_PROCESSING_RESULT_FIELD, STATE_FIELD, STATE_TRANSITION_REASON_FIELD, DESTINATION_CONFIG_FIELD, TOPICS_FIELD, MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD, BISECT_BATCH_ON_FUNCTION_ERROR_FIELD, MAXIMUM_RETRY_ATTEMPTS_FIELD));
    private final String uuid;
    private final Integer batchSize;
    private final Integer maximumBatchingWindowInSeconds;
    private final Integer parallelizationFactor;
    private final String eventSourceArn;
    private final String functionArn;
    private final Instant lastModified;
    private final String lastProcessingResult;
    private final String state;
    private final String stateTransitionReason;
    private final DestinationConfig destinationConfig;
    private final List<String> topics;
    private final Integer maximumRecordAgeInSeconds;
    private final Boolean bisectBatchOnFunctionError;
    private final Integer maximumRetryAttempts;

    private CreateEventSourceMappingResponse(BuilderImpl builder) {
        super(builder);
        this.uuid = builder.uuid;
        this.batchSize = builder.batchSize;
        this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
        this.parallelizationFactor = builder.parallelizationFactor;
        this.eventSourceArn = builder.eventSourceArn;
        this.functionArn = builder.functionArn;
        this.lastModified = builder.lastModified;
        this.lastProcessingResult = builder.lastProcessingResult;
        this.state = builder.state;
        this.stateTransitionReason = builder.stateTransitionReason;
        this.destinationConfig = builder.destinationConfig;
        this.topics = builder.topics;
        this.maximumRecordAgeInSeconds = builder.maximumRecordAgeInSeconds;
        this.bisectBatchOnFunctionError = builder.bisectBatchOnFunctionError;
        this.maximumRetryAttempts = builder.maximumRetryAttempts;
    }

    public String uuid() {
        return this.uuid;
    }

    public Integer batchSize() {
        return this.batchSize;
    }

    public Integer maximumBatchingWindowInSeconds() {
        return this.maximumBatchingWindowInSeconds;
    }

    public Integer parallelizationFactor() {
        return this.parallelizationFactor;
    }

    public String eventSourceArn() {
        return this.eventSourceArn;
    }

    public String functionArn() {
        return this.functionArn;
    }

    public Instant lastModified() {
        return this.lastModified;
    }

    public String lastProcessingResult() {
        return this.lastProcessingResult;
    }

    public String state() {
        return this.state;
    }

    public String stateTransitionReason() {
        return this.stateTransitionReason;
    }

    public DestinationConfig destinationConfig() {
        return this.destinationConfig;
    }

    public boolean hasTopics() {
        return this.topics != null && !(this.topics instanceof SdkAutoConstructList);
    }

    public List<String> topics() {
        return this.topics;
    }

    public Integer maximumRecordAgeInSeconds() {
        return this.maximumRecordAgeInSeconds;
    }

    public Boolean bisectBatchOnFunctionError() {
        return this.bisectBatchOnFunctionError;
    }

    public Integer maximumRetryAttempts() {
        return this.maximumRetryAttempts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.uuid());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumBatchingWindowInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelizationFactor());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastProcessingResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateTransitionReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopics() ? this.topics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumRecordAgeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.bisectBatchOnFunctionError());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumRetryAttempts());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventSourceMappingResponse)) {
            return false;
        }
        CreateEventSourceMappingResponse other = (CreateEventSourceMappingResponse)((Object)obj);
        return Objects.equals(this.uuid(), other.uuid()) && Objects.equals(this.batchSize(), other.batchSize()) && Objects.equals(this.maximumBatchingWindowInSeconds(), other.maximumBatchingWindowInSeconds()) && Objects.equals(this.parallelizationFactor(), other.parallelizationFactor()) && Objects.equals(this.eventSourceArn(), other.eventSourceArn()) && Objects.equals(this.functionArn(), other.functionArn()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.lastProcessingResult(), other.lastProcessingResult()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.stateTransitionReason(), other.stateTransitionReason()) && Objects.equals(this.destinationConfig(), other.destinationConfig()) && this.hasTopics() == other.hasTopics() && Objects.equals(this.topics(), other.topics()) && Objects.equals(this.maximumRecordAgeInSeconds(), other.maximumRecordAgeInSeconds()) && Objects.equals(this.bisectBatchOnFunctionError(), other.bisectBatchOnFunctionError()) && Objects.equals(this.maximumRetryAttempts(), other.maximumRetryAttempts());
    }

    public String toString() {
        return ToString.builder((String)"CreateEventSourceMappingResponse").add("UUID", (Object)this.uuid()).add("BatchSize", (Object)this.batchSize()).add("MaximumBatchingWindowInSeconds", (Object)this.maximumBatchingWindowInSeconds()).add("ParallelizationFactor", (Object)this.parallelizationFactor()).add("EventSourceArn", (Object)this.eventSourceArn()).add("FunctionArn", (Object)this.functionArn()).add("LastModified", (Object)this.lastModified()).add("LastProcessingResult", (Object)this.lastProcessingResult()).add("State", (Object)this.state()).add("StateTransitionReason", (Object)this.stateTransitionReason()).add("DestinationConfig", (Object)this.destinationConfig()).add("Topics", this.hasTopics() ? this.topics() : null).add("MaximumRecordAgeInSeconds", (Object)this.maximumRecordAgeInSeconds()).add("BisectBatchOnFunctionError", (Object)this.bisectBatchOnFunctionError()).add("MaximumRetryAttempts", (Object)this.maximumRetryAttempts()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UUID": {
                return Optional.ofNullable(clazz.cast(this.uuid()));
            }
            case "BatchSize": {
                return Optional.ofNullable(clazz.cast(this.batchSize()));
            }
            case "MaximumBatchingWindowInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maximumBatchingWindowInSeconds()));
            }
            case "ParallelizationFactor": {
                return Optional.ofNullable(clazz.cast(this.parallelizationFactor()));
            }
            case "EventSourceArn": {
                return Optional.ofNullable(clazz.cast(this.eventSourceArn()));
            }
            case "FunctionArn": {
                return Optional.ofNullable(clazz.cast(this.functionArn()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "LastProcessingResult": {
                return Optional.ofNullable(clazz.cast(this.lastProcessingResult()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "StateTransitionReason": {
                return Optional.ofNullable(clazz.cast(this.stateTransitionReason()));
            }
            case "DestinationConfig": {
                return Optional.ofNullable(clazz.cast(this.destinationConfig()));
            }
            case "Topics": {
                return Optional.ofNullable(clazz.cast(this.topics()));
            }
            case "MaximumRecordAgeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maximumRecordAgeInSeconds()));
            }
            case "BisectBatchOnFunctionError": {
                return Optional.ofNullable(clazz.cast(this.bisectBatchOnFunctionError()));
            }
            case "MaximumRetryAttempts": {
                return Optional.ofNullable(clazz.cast(this.maximumRetryAttempts()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEventSourceMappingResponse, T> g) {
        return obj -> g.apply((CreateEventSourceMappingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private String uuid;
        private Integer batchSize;
        private Integer maximumBatchingWindowInSeconds;
        private Integer parallelizationFactor;
        private String eventSourceArn;
        private String functionArn;
        private Instant lastModified;
        private String lastProcessingResult;
        private String state;
        private String stateTransitionReason;
        private DestinationConfig destinationConfig;
        private List<String> topics = DefaultSdkAutoConstructList.getInstance();
        private Integer maximumRecordAgeInSeconds;
        private Boolean bisectBatchOnFunctionError;
        private Integer maximumRetryAttempts;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEventSourceMappingResponse model) {
            super(model);
            this.uuid(model.uuid);
            this.batchSize(model.batchSize);
            this.maximumBatchingWindowInSeconds(model.maximumBatchingWindowInSeconds);
            this.parallelizationFactor(model.parallelizationFactor);
            this.eventSourceArn(model.eventSourceArn);
            this.functionArn(model.functionArn);
            this.lastModified(model.lastModified);
            this.lastProcessingResult(model.lastProcessingResult);
            this.state(model.state);
            this.stateTransitionReason(model.stateTransitionReason);
            this.destinationConfig(model.destinationConfig);
            this.topics(model.topics);
            this.maximumRecordAgeInSeconds(model.maximumRecordAgeInSeconds);
            this.bisectBatchOnFunctionError(model.bisectBatchOnFunctionError);
            this.maximumRetryAttempts(model.maximumRetryAttempts);
        }

        public final String getUuid() {
            return this.uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public final void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public final Integer getBatchSize() {
            return this.batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        public final Integer getMaximumBatchingWindowInSeconds() {
            return this.maximumBatchingWindowInSeconds;
        }

        @Override
        public final Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        public final void setMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
        }

        public final Integer getParallelizationFactor() {
            return this.parallelizationFactor;
        }

        @Override
        public final Builder parallelizationFactor(Integer parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
            return this;
        }

        public final void setParallelizationFactor(Integer parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
        }

        public final String getEventSourceArn() {
            return this.eventSourceArn;
        }

        @Override
        public final Builder eventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        public final void setEventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
        }

        public final String getFunctionArn() {
            return this.functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final String getLastProcessingResult() {
            return this.lastProcessingResult;
        }

        @Override
        public final Builder lastProcessingResult(String lastProcessingResult) {
            this.lastProcessingResult = lastProcessingResult;
            return this;
        }

        public final void setLastProcessingResult(String lastProcessingResult) {
            this.lastProcessingResult = lastProcessingResult;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateTransitionReason() {
            return this.stateTransitionReason;
        }

        @Override
        public final Builder stateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
            return this;
        }

        public final void setStateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
        }

        public final DestinationConfig.Builder getDestinationConfig() {
            return this.destinationConfig != null ? this.destinationConfig.toBuilder() : null;
        }

        @Override
        public final Builder destinationConfig(DestinationConfig destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        public final void setDestinationConfig(DestinationConfig.BuilderImpl destinationConfig) {
            this.destinationConfig = destinationConfig != null ? destinationConfig.build() : null;
        }

        public final Collection<String> getTopics() {
            if (this.topics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.topics;
        }

        @Override
        public final Builder topics(Collection<String> topics) {
            this.topics = TopicsCopier.copy(topics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topics(String ... topics) {
            this.topics(Arrays.asList(topics));
            return this;
        }

        public final void setTopics(Collection<String> topics) {
            this.topics = TopicsCopier.copy(topics);
        }

        public final Integer getMaximumRecordAgeInSeconds() {
            return this.maximumRecordAgeInSeconds;
        }

        @Override
        public final Builder maximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
            return this;
        }

        public final void setMaximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
        }

        public final Boolean getBisectBatchOnFunctionError() {
            return this.bisectBatchOnFunctionError;
        }

        @Override
        public final Builder bisectBatchOnFunctionError(Boolean bisectBatchOnFunctionError) {
            this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
            return this;
        }

        public final void setBisectBatchOnFunctionError(Boolean bisectBatchOnFunctionError) {
            this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
        }

        public final Integer getMaximumRetryAttempts() {
            return this.maximumRetryAttempts;
        }

        @Override
        public final Builder maximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
            return this;
        }

        public final void setMaximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
        }

        @Override
        public CreateEventSourceMappingResponse build() {
            return new CreateEventSourceMappingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEventSourceMappingResponse> {
        public Builder uuid(String var1);

        public Builder batchSize(Integer var1);

        public Builder maximumBatchingWindowInSeconds(Integer var1);

        public Builder parallelizationFactor(Integer var1);

        public Builder eventSourceArn(String var1);

        public Builder functionArn(String var1);

        public Builder lastModified(Instant var1);

        public Builder lastProcessingResult(String var1);

        public Builder state(String var1);

        public Builder stateTransitionReason(String var1);

        public Builder destinationConfig(DestinationConfig var1);

        default public Builder destinationConfig(Consumer<DestinationConfig.Builder> destinationConfig) {
            return this.destinationConfig((DestinationConfig)((DestinationConfig.Builder)DestinationConfig.builder().applyMutation(destinationConfig)).build());
        }

        public Builder topics(Collection<String> var1);

        public Builder topics(String ... var1);

        public Builder maximumRecordAgeInSeconds(Integer var1);

        public Builder bisectBatchOnFunctionError(Boolean var1);

        public Builder maximumRetryAttempts(Integer var1);
    }
}

