/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFunctionEventInvokeConfigsResponse extends LambdaResponse implements
        ToCopyableBuilder<ListFunctionEventInvokeConfigsResponse.Builder, ListFunctionEventInvokeConfigsResponse> {
    private static final SdkField<List<FunctionEventInvokeConfig>> FUNCTION_EVENT_INVOKE_CONFIGS_FIELD = SdkField
            .<List<FunctionEventInvokeConfig>> builder(MarshallingType.LIST)
            .memberName("FunctionEventInvokeConfigs")
            .getter(getter(ListFunctionEventInvokeConfigsResponse::functionEventInvokeConfigs))
            .setter(setter(Builder::functionEventInvokeConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionEventInvokeConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FunctionEventInvokeConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(FunctionEventInvokeConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListFunctionEventInvokeConfigsResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FUNCTION_EVENT_INVOKE_CONFIGS_FIELD, NEXT_MARKER_FIELD));

    private final List<FunctionEventInvokeConfig> functionEventInvokeConfigs;

    private final String nextMarker;

    private ListFunctionEventInvokeConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.functionEventInvokeConfigs = builder.functionEventInvokeConfigs;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * Returns true if the FunctionEventInvokeConfigs property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasFunctionEventInvokeConfigs() {
        return functionEventInvokeConfigs != null && !(functionEventInvokeConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFunctionEventInvokeConfigs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of configurations.
     */
    public List<FunctionEventInvokeConfig> functionEventInvokeConfigs() {
        return functionEventInvokeConfigs;
    }

    /**
     * <p>
     * The pagination token that's included if more results are available.
     * </p>
     * 
     * @return The pagination token that's included if more results are available.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFunctionEventInvokeConfigs() ? functionEventInvokeConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFunctionEventInvokeConfigsResponse)) {
            return false;
        }
        ListFunctionEventInvokeConfigsResponse other = (ListFunctionEventInvokeConfigsResponse) obj;
        return hasFunctionEventInvokeConfigs() == other.hasFunctionEventInvokeConfigs()
                && Objects.equals(functionEventInvokeConfigs(), other.functionEventInvokeConfigs())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListFunctionEventInvokeConfigsResponse")
                .add("FunctionEventInvokeConfigs", hasFunctionEventInvokeConfigs() ? functionEventInvokeConfigs() : null)
                .add("NextMarker", nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionEventInvokeConfigs":
            return Optional.ofNullable(clazz.cast(functionEventInvokeConfigs()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFunctionEventInvokeConfigsResponse, T> g) {
        return obj -> g.apply((ListFunctionEventInvokeConfigsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFunctionEventInvokeConfigsResponse> {
        /**
         * <p>
         * A list of configurations.
         * </p>
         * 
         * @param functionEventInvokeConfigs
         *        A list of configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionEventInvokeConfigs(Collection<FunctionEventInvokeConfig> functionEventInvokeConfigs);

        /**
         * <p>
         * A list of configurations.
         * </p>
         * 
         * @param functionEventInvokeConfigs
         *        A list of configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionEventInvokeConfigs(FunctionEventInvokeConfig... functionEventInvokeConfigs);

        /**
         * <p>
         * A list of configurations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FunctionEventInvokeConfig>.Builder}
         * avoiding the need to create one manually via {@link List<FunctionEventInvokeConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FunctionEventInvokeConfig>.Builder#build()} is called
         * immediately and its result is passed to {@link #functionEventInvokeConfigs(List<FunctionEventInvokeConfig>)}.
         * 
         * @param functionEventInvokeConfigs
         *        a consumer that will call methods on {@link List<FunctionEventInvokeConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functionEventInvokeConfigs(List<FunctionEventInvokeConfig>)
         */
        Builder functionEventInvokeConfigs(Consumer<FunctionEventInvokeConfig.Builder>... functionEventInvokeConfigs);

        /**
         * <p>
         * The pagination token that's included if more results are available.
         * </p>
         * 
         * @param nextMarker
         *        The pagination token that's included if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private List<FunctionEventInvokeConfig> functionEventInvokeConfigs = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFunctionEventInvokeConfigsResponse model) {
            super(model);
            functionEventInvokeConfigs(model.functionEventInvokeConfigs);
            nextMarker(model.nextMarker);
        }

        public final Collection<FunctionEventInvokeConfig.Builder> getFunctionEventInvokeConfigs() {
            if (functionEventInvokeConfigs instanceof SdkAutoConstructList) {
                return null;
            }
            return functionEventInvokeConfigs != null ? functionEventInvokeConfigs.stream()
                    .map(FunctionEventInvokeConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder functionEventInvokeConfigs(Collection<FunctionEventInvokeConfig> functionEventInvokeConfigs) {
            this.functionEventInvokeConfigs = FunctionEventInvokeConfigListCopier.copy(functionEventInvokeConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionEventInvokeConfigs(FunctionEventInvokeConfig... functionEventInvokeConfigs) {
            functionEventInvokeConfigs(Arrays.asList(functionEventInvokeConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionEventInvokeConfigs(Consumer<FunctionEventInvokeConfig.Builder>... functionEventInvokeConfigs) {
            functionEventInvokeConfigs(Stream.of(functionEventInvokeConfigs)
                    .map(c -> FunctionEventInvokeConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFunctionEventInvokeConfigs(
                Collection<FunctionEventInvokeConfig.BuilderImpl> functionEventInvokeConfigs) {
            this.functionEventInvokeConfigs = FunctionEventInvokeConfigListCopier.copyFromBuilder(functionEventInvokeConfigs);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListFunctionEventInvokeConfigsResponse build() {
            return new ListFunctionEventInvokeConfigsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
