/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.FunctionArnListCopier;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFunctionsByCodeSigningConfigResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, ListFunctionsByCodeSigningConfigResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListFunctionsByCodeSigningConfigResponse.getter(ListFunctionsByCodeSigningConfigResponse::nextMarker)).setter(ListFunctionsByCodeSigningConfigResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<String>> FUNCTION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FunctionArns").getter(ListFunctionsByCodeSigningConfigResponse.getter(ListFunctionsByCodeSigningConfigResponse::functionArns)).setter(ListFunctionsByCodeSigningConfigResponse.setter(Builder::functionArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, FUNCTION_ARNS_FIELD));
    private final String nextMarker;
    private final List<String> functionArns;

    private ListFunctionsByCodeSigningConfigResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.functionArns = builder.functionArns;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public boolean hasFunctionArns() {
        return this.functionArns != null && !(this.functionArns instanceof SdkAutoConstructList);
    }

    public List<String> functionArns() {
        return this.functionArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFunctionArns() ? this.functionArns() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFunctionsByCodeSigningConfigResponse)) {
            return false;
        }
        ListFunctionsByCodeSigningConfigResponse other = (ListFunctionsByCodeSigningConfigResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && this.hasFunctionArns() == other.hasFunctionArns() && Objects.equals(this.functionArns(), other.functionArns());
    }

    public String toString() {
        return ToString.builder((String)"ListFunctionsByCodeSigningConfigResponse").add("NextMarker", (Object)this.nextMarker()).add("FunctionArns", this.hasFunctionArns() ? this.functionArns() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "FunctionArns": {
                return Optional.ofNullable(clazz.cast(this.functionArns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFunctionsByCodeSigningConfigResponse, T> g) {
        return obj -> g.apply((ListFunctionsByCodeSigningConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<String> functionArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFunctionsByCodeSigningConfigResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.functionArns(model.functionArns);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<String> getFunctionArns() {
            if (this.functionArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.functionArns;
        }

        @Override
        public final Builder functionArns(Collection<String> functionArns) {
            this.functionArns = FunctionArnListCopier.copy(functionArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionArns(String ... functionArns) {
            this.functionArns(Arrays.asList(functionArns));
            return this;
        }

        public final void setFunctionArns(Collection<String> functionArns) {
            this.functionArns = FunctionArnListCopier.copy(functionArns);
        }

        @Override
        public ListFunctionsByCodeSigningConfigResponse build() {
            return new ListFunctionsByCodeSigningConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFunctionsByCodeSigningConfigResponse> {
        public Builder nextMarker(String var1);

        public Builder functionArns(Collection<String> var1);

        public Builder functionArns(String ... var1);
    }
}

