/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a function's configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFunctionConfigurationResponse extends LambdaResponse implements
        ToCopyableBuilder<GetFunctionConfigurationResponse.Builder, GetFunctionConfigurationResponse> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionName").getter(getter(GetFunctionConfigurationResponse::functionName))
            .setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()).build();

    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionArn").getter(getter(GetFunctionConfigurationResponse::functionArn))
            .setter(setter(Builder::functionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()).build();

    private static final SdkField<String> RUNTIME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Runtime")
            .getter(getter(GetFunctionConfigurationResponse::runtimeAsString)).setter(setter(Builder::runtime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Runtime").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(GetFunctionConfigurationResponse::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> HANDLER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Handler")
            .getter(getter(GetFunctionConfigurationResponse::handler)).setter(setter(Builder::handler))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Handler").build()).build();

    private static final SdkField<Long> CODE_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("CodeSize")
            .getter(getter(GetFunctionConfigurationResponse::codeSize)).setter(setter(Builder::codeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSize").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetFunctionConfigurationResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Timeout").getter(getter(GetFunctionConfigurationResponse::timeout)).setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final SdkField<Integer> MEMORY_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MemorySize").getter(getter(GetFunctionConfigurationResponse::memorySize))
            .setter(setter(Builder::memorySize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemorySize").build()).build();

    private static final SdkField<String> LAST_MODIFIED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModified").getter(getter(GetFunctionConfigurationResponse::lastModified))
            .setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()).build();

    private static final SdkField<String> CODE_SHA256_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeSha256").getter(getter(GetFunctionConfigurationResponse::codeSha256))
            .setter(setter(Builder::codeSha256))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSha256").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(GetFunctionConfigurationResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<VpcConfigResponse> VPC_CONFIG_FIELD = SdkField
            .<VpcConfigResponse> builder(MarshallingType.SDK_POJO).memberName("VpcConfig")
            .getter(getter(GetFunctionConfigurationResponse::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfigResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<DeadLetterConfig> DEAD_LETTER_CONFIG_FIELD = SdkField
            .<DeadLetterConfig> builder(MarshallingType.SDK_POJO).memberName("DeadLetterConfig")
            .getter(getter(GetFunctionConfigurationResponse::deadLetterConfig)).setter(setter(Builder::deadLetterConfig))
            .constructor(DeadLetterConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterConfig").build()).build();

    private static final SdkField<EnvironmentResponse> ENVIRONMENT_FIELD = SdkField
            .<EnvironmentResponse> builder(MarshallingType.SDK_POJO).memberName("Environment")
            .getter(getter(GetFunctionConfigurationResponse::environment)).setter(setter(Builder::environment))
            .constructor(EnvironmentResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KMSKeyArn").getter(getter(GetFunctionConfigurationResponse::kmsKeyArn))
            .setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyArn").build()).build();

    private static final SdkField<TracingConfigResponse> TRACING_CONFIG_FIELD = SdkField
            .<TracingConfigResponse> builder(MarshallingType.SDK_POJO).memberName("TracingConfig")
            .getter(getter(GetFunctionConfigurationResponse::tracingConfig)).setter(setter(Builder::tracingConfig))
            .constructor(TracingConfigResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TracingConfig").build()).build();

    private static final SdkField<String> MASTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterArn").getter(getter(GetFunctionConfigurationResponse::masterArn))
            .setter(setter(Builder::masterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterArn").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevisionId").getter(getter(GetFunctionConfigurationResponse::revisionId))
            .setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()).build();

    private static final SdkField<List<Layer>> LAYERS_FIELD = SdkField
            .<List<Layer>> builder(MarshallingType.LIST)
            .memberName("Layers")
            .getter(getter(GetFunctionConfigurationResponse::layers))
            .setter(setter(Builder::layers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Layer> builder(MarshallingType.SDK_POJO)
                                            .constructor(Layer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(GetFunctionConfigurationResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReason").getter(getter(GetFunctionConfigurationResponse::stateReason))
            .setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()).build();

    private static final SdkField<String> STATE_REASON_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReasonCode").getter(getter(GetFunctionConfigurationResponse::stateReasonCodeAsString))
            .setter(setter(Builder::stateReasonCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReasonCode").build()).build();

    private static final SdkField<String> LAST_UPDATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUpdateStatus").getter(getter(GetFunctionConfigurationResponse::lastUpdateStatusAsString))
            .setter(setter(Builder::lastUpdateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateStatus").build()).build();

    private static final SdkField<String> LAST_UPDATE_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUpdateStatusReason").getter(getter(GetFunctionConfigurationResponse::lastUpdateStatusReason))
            .setter(setter(Builder::lastUpdateStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateStatusReason").build())
            .build();

    private static final SdkField<String> LAST_UPDATE_STATUS_REASON_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LastUpdateStatusReasonCode")
            .getter(getter(GetFunctionConfigurationResponse::lastUpdateStatusReasonCodeAsString))
            .setter(setter(Builder::lastUpdateStatusReasonCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateStatusReasonCode").build())
            .build();

    private static final SdkField<List<FileSystemConfig>> FILE_SYSTEM_CONFIGS_FIELD = SdkField
            .<List<FileSystemConfig>> builder(MarshallingType.LIST)
            .memberName("FileSystemConfigs")
            .getter(getter(GetFunctionConfigurationResponse::fileSystemConfigs))
            .setter(setter(Builder::fileSystemConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FileSystemConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(FileSystemConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PACKAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageType").getter(getter(GetFunctionConfigurationResponse::packageTypeAsString))
            .setter(setter(Builder::packageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageType").build()).build();

    private static final SdkField<ImageConfigResponse> IMAGE_CONFIG_RESPONSE_FIELD = SdkField
            .<ImageConfigResponse> builder(MarshallingType.SDK_POJO).memberName("ImageConfigResponse")
            .getter(getter(GetFunctionConfigurationResponse::imageConfigResponse)).setter(setter(Builder::imageConfigResponse))
            .constructor(ImageConfigResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageConfigResponse").build())
            .build();

    private static final SdkField<String> SIGNING_PROFILE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SigningProfileVersionArn").getter(getter(GetFunctionConfigurationResponse::signingProfileVersionArn))
            .setter(setter(Builder::signingProfileVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningProfileVersionArn").build())
            .build();

    private static final SdkField<String> SIGNING_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SigningJobArn").getter(getter(GetFunctionConfigurationResponse::signingJobArn))
            .setter(setter(Builder::signingJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningJobArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD,
            FUNCTION_ARN_FIELD, RUNTIME_FIELD, ROLE_FIELD, HANDLER_FIELD, CODE_SIZE_FIELD, DESCRIPTION_FIELD, TIMEOUT_FIELD,
            MEMORY_SIZE_FIELD, LAST_MODIFIED_FIELD, CODE_SHA256_FIELD, VERSION_FIELD, VPC_CONFIG_FIELD, DEAD_LETTER_CONFIG_FIELD,
            ENVIRONMENT_FIELD, KMS_KEY_ARN_FIELD, TRACING_CONFIG_FIELD, MASTER_ARN_FIELD, REVISION_ID_FIELD, LAYERS_FIELD,
            STATE_FIELD, STATE_REASON_FIELD, STATE_REASON_CODE_FIELD, LAST_UPDATE_STATUS_FIELD, LAST_UPDATE_STATUS_REASON_FIELD,
            LAST_UPDATE_STATUS_REASON_CODE_FIELD, FILE_SYSTEM_CONFIGS_FIELD, PACKAGE_TYPE_FIELD, IMAGE_CONFIG_RESPONSE_FIELD,
            SIGNING_PROFILE_VERSION_ARN_FIELD, SIGNING_JOB_ARN_FIELD));

    private final String functionName;

    private final String functionArn;

    private final String runtime;

    private final String role;

    private final String handler;

    private final Long codeSize;

    private final String description;

    private final Integer timeout;

    private final Integer memorySize;

    private final String lastModified;

    private final String codeSha256;

    private final String version;

    private final VpcConfigResponse vpcConfig;

    private final DeadLetterConfig deadLetterConfig;

    private final EnvironmentResponse environment;

    private final String kmsKeyArn;

    private final TracingConfigResponse tracingConfig;

    private final String masterArn;

    private final String revisionId;

    private final List<Layer> layers;

    private final String state;

    private final String stateReason;

    private final String stateReasonCode;

    private final String lastUpdateStatus;

    private final String lastUpdateStatusReason;

    private final String lastUpdateStatusReasonCode;

    private final List<FileSystemConfig> fileSystemConfigs;

    private final String packageType;

    private final ImageConfigResponse imageConfigResponse;

    private final String signingProfileVersionArn;

    private final String signingJobArn;

    private GetFunctionConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.functionArn = builder.functionArn;
        this.runtime = builder.runtime;
        this.role = builder.role;
        this.handler = builder.handler;
        this.codeSize = builder.codeSize;
        this.description = builder.description;
        this.timeout = builder.timeout;
        this.memorySize = builder.memorySize;
        this.lastModified = builder.lastModified;
        this.codeSha256 = builder.codeSha256;
        this.version = builder.version;
        this.vpcConfig = builder.vpcConfig;
        this.deadLetterConfig = builder.deadLetterConfig;
        this.environment = builder.environment;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tracingConfig = builder.tracingConfig;
        this.masterArn = builder.masterArn;
        this.revisionId = builder.revisionId;
        this.layers = builder.layers;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.stateReasonCode = builder.stateReasonCode;
        this.lastUpdateStatus = builder.lastUpdateStatus;
        this.lastUpdateStatusReason = builder.lastUpdateStatusReason;
        this.lastUpdateStatusReasonCode = builder.lastUpdateStatusReasonCode;
        this.fileSystemConfigs = builder.fileSystemConfigs;
        this.packageType = builder.packageType;
        this.imageConfigResponse = builder.imageConfigResponse;
        this.signingProfileVersionArn = builder.signingProfileVersionArn;
        this.signingJobArn = builder.signingJobArn;
    }

    /**
     * <p>
     * The name of the function.
     * </p>
     * 
     * @return The name of the function.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * The function's Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The function's Amazon Resource Name (ARN).
     */
    public final String functionArn() {
        return functionArn;
    }

    /**
     * <p>
     * The runtime environment for the Lambda function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runtime} will
     * return {@link Runtime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runtimeAsString}.
     * </p>
     * 
     * @return The runtime environment for the Lambda function.
     * @see Runtime
     */
    public final Runtime runtime() {
        return Runtime.fromValue(runtime);
    }

    /**
     * <p>
     * The runtime environment for the Lambda function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runtime} will
     * return {@link Runtime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runtimeAsString}.
     * </p>
     * 
     * @return The runtime environment for the Lambda function.
     * @see Runtime
     */
    public final String runtimeAsString() {
        return runtime;
    }

    /**
     * <p>
     * The function's execution role.
     * </p>
     * 
     * @return The function's execution role.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * The function that Lambda calls to begin executing your function.
     * </p>
     * 
     * @return The function that Lambda calls to begin executing your function.
     */
    public final String handler() {
        return handler;
    }

    /**
     * <p>
     * The size of the function's deployment package, in bytes.
     * </p>
     * 
     * @return The size of the function's deployment package, in bytes.
     */
    public final Long codeSize() {
        return codeSize;
    }

    /**
     * <p>
     * The function's description.
     * </p>
     * 
     * @return The function's description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The amount of time in seconds that Lambda allows a function to run before stopping it.
     * </p>
     * 
     * @return The amount of time in seconds that Lambda allows a function to run before stopping it.
     */
    public final Integer timeout() {
        return timeout;
    }

    /**
     * <p>
     * The amount of memory available to the function at runtime.
     * </p>
     * 
     * @return The amount of memory available to the function at runtime.
     */
    public final Integer memorySize() {
        return memorySize;
    }

    /**
     * <p>
     * The date and time that the function was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
     * format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
     * </p>
     * 
     * @return The date and time that the function was last updated, in <a
     *         href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
     */
    public final String lastModified() {
        return lastModified;
    }

    /**
     * <p>
     * The SHA256 hash of the function's deployment package.
     * </p>
     * 
     * @return The SHA256 hash of the function's deployment package.
     */
    public final String codeSha256() {
        return codeSha256;
    }

    /**
     * <p>
     * The version of the Lambda function.
     * </p>
     * 
     * @return The version of the Lambda function.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The function's networking configuration.
     * </p>
     * 
     * @return The function's networking configuration.
     */
    public final VpcConfigResponse vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The function's dead letter queue.
     * </p>
     * 
     * @return The function's dead letter queue.
     */
    public final DeadLetterConfig deadLetterConfig() {
        return deadLetterConfig;
    }

    /**
     * <p>
     * The function's environment variables.
     * </p>
     * 
     * @return The function's environment variables.
     */
    public final EnvironmentResponse environment() {
        return environment;
    }

    /**
     * <p>
     * The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
     * configured a customer managed CMK.
     * </p>
     * 
     * @return The KMS key that's used to encrypt the function's environment variables. This key is only returned if
     *         you've configured a customer managed CMK.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The function's AWS X-Ray tracing configuration.
     * </p>
     * 
     * @return The function's AWS X-Ray tracing configuration.
     */
    public final TracingConfigResponse tracingConfig() {
        return tracingConfig;
    }

    /**
     * <p>
     * For Lambda@Edge functions, the ARN of the master function.
     * </p>
     * 
     * @return For Lambda@Edge functions, the ARN of the master function.
     */
    public final String masterArn() {
        return masterArn;
    }

    /**
     * <p>
     * The latest updated revision of the function or alias.
     * </p>
     * 
     * @return The latest updated revision of the function or alias.
     */
    public final String revisionId() {
        return revisionId;
    }

    /**
     * Returns true if the Layers property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLayers() {
        return layers != null && !(layers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html"> layers</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLayers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
     *         layers</a>.
     */
    public final List<Layer> layers() {
        return layers;
    }

    /**
     * <p>
     * The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
     * invoking it.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the function. When the state is <code>Inactive</code>, you can reactivate the
     *         function by invoking it.
     * @see State
     */
    public final State state() {
        return State.fromValue(state);
    }

    /**
     * <p>
     * The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function by
     * invoking it.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the function. When the state is <code>Inactive</code>, you can reactivate the
     *         function by invoking it.
     * @see State
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The reason for the function's current state.
     * </p>
     * 
     * @return The reason for the function's current state.
     */
    public final String stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
     * modify the function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateReasonCode}
     * will return {@link StateReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateReasonCodeAsString}.
     * </p>
     * 
     * @return The reason code for the function's current state. When the code is <code>Creating</code>, you can't
     *         invoke or modify the function.
     * @see StateReasonCode
     */
    public final StateReasonCode stateReasonCode() {
        return StateReasonCode.fromValue(stateReasonCode);
    }

    /**
     * <p>
     * The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
     * modify the function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateReasonCode}
     * will return {@link StateReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #stateReasonCodeAsString}.
     * </p>
     * 
     * @return The reason code for the function's current state. When the code is <code>Creating</code>, you can't
     *         invoke or modify the function.
     * @see StateReasonCode
     */
    public final String stateReasonCodeAsString() {
        return stateReasonCode;
    }

    /**
     * <p>
     * The status of the last update that was performed on the function. This is first set to <code>Successful</code>
     * after function creation completes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastUpdateStatus}
     * will return {@link LastUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lastUpdateStatusAsString}.
     * </p>
     * 
     * @return The status of the last update that was performed on the function. This is first set to
     *         <code>Successful</code> after function creation completes.
     * @see LastUpdateStatus
     */
    public final LastUpdateStatus lastUpdateStatus() {
        return LastUpdateStatus.fromValue(lastUpdateStatus);
    }

    /**
     * <p>
     * The status of the last update that was performed on the function. This is first set to <code>Successful</code>
     * after function creation completes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastUpdateStatus}
     * will return {@link LastUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lastUpdateStatusAsString}.
     * </p>
     * 
     * @return The status of the last update that was performed on the function. This is first set to
     *         <code>Successful</code> after function creation completes.
     * @see LastUpdateStatus
     */
    public final String lastUpdateStatusAsString() {
        return lastUpdateStatus;
    }

    /**
     * <p>
     * The reason for the last update that was performed on the function.
     * </p>
     * 
     * @return The reason for the last update that was performed on the function.
     */
    public final String lastUpdateStatusReason() {
        return lastUpdateStatusReason;
    }

    /**
     * <p>
     * The reason code for the last update that was performed on the function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lastUpdateStatusReasonCode} will return {@link LastUpdateStatusReasonCode#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #lastUpdateStatusReasonCodeAsString}.
     * </p>
     * 
     * @return The reason code for the last update that was performed on the function.
     * @see LastUpdateStatusReasonCode
     */
    public final LastUpdateStatusReasonCode lastUpdateStatusReasonCode() {
        return LastUpdateStatusReasonCode.fromValue(lastUpdateStatusReasonCode);
    }

    /**
     * <p>
     * The reason code for the last update that was performed on the function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lastUpdateStatusReasonCode} will return {@link LastUpdateStatusReasonCode#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #lastUpdateStatusReasonCodeAsString}.
     * </p>
     * 
     * @return The reason code for the last update that was performed on the function.
     * @see LastUpdateStatusReasonCode
     */
    public final String lastUpdateStatusReasonCodeAsString() {
        return lastUpdateStatusReasonCode;
    }

    /**
     * Returns true if the FileSystemConfigs property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasFileSystemConfigs() {
        return fileSystemConfigs != null && !(fileSystemConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Connection settings for an Amazon EFS file system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFileSystemConfigs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Connection settings for an Amazon EFS file system.
     */
    public final List<FileSystemConfig> fileSystemConfigs() {
        return fileSystemConfigs;
    }

    /**
     * <p>
     * The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip
     * file archive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageType} will
     * return {@link PackageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #packageTypeAsString}.
     * </p>
     * 
     * @return The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code>
     *         for .zip file archive.
     * @see PackageType
     */
    public final PackageType packageType() {
        return PackageType.fromValue(packageType);
    }

    /**
     * <p>
     * The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip
     * file archive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageType} will
     * return {@link PackageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #packageTypeAsString}.
     * </p>
     * 
     * @return The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code>
     *         for .zip file archive.
     * @see PackageType
     */
    public final String packageTypeAsString() {
        return packageType;
    }

    /**
     * <p>
     * The function's image configuration values.
     * </p>
     * 
     * @return The function's image configuration values.
     */
    public final ImageConfigResponse imageConfigResponse() {
        return imageConfigResponse;
    }

    /**
     * <p>
     * The ARN of the signing profile version.
     * </p>
     * 
     * @return The ARN of the signing profile version.
     */
    public final String signingProfileVersionArn() {
        return signingProfileVersionArn;
    }

    /**
     * <p>
     * The ARN of the signing job.
     * </p>
     * 
     * @return The ARN of the signing job.
     */
    public final String signingJobArn() {
        return signingJobArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(handler());
        hashCode = 31 * hashCode + Objects.hashCode(codeSize());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(memorySize());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(codeSha256());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(deadLetterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(environment());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(tracingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(masterArn());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasLayers() ? layers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(stateReasonCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateStatusReasonCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFileSystemConfigs() ? fileSystemConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(packageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageConfigResponse());
        hashCode = 31 * hashCode + Objects.hashCode(signingProfileVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(signingJobArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFunctionConfigurationResponse)) {
            return false;
        }
        GetFunctionConfigurationResponse other = (GetFunctionConfigurationResponse) obj;
        return Objects.equals(functionName(), other.functionName()) && Objects.equals(functionArn(), other.functionArn())
                && Objects.equals(runtimeAsString(), other.runtimeAsString()) && Objects.equals(role(), other.role())
                && Objects.equals(handler(), other.handler()) && Objects.equals(codeSize(), other.codeSize())
                && Objects.equals(description(), other.description()) && Objects.equals(timeout(), other.timeout())
                && Objects.equals(memorySize(), other.memorySize()) && Objects.equals(lastModified(), other.lastModified())
                && Objects.equals(codeSha256(), other.codeSha256()) && Objects.equals(version(), other.version())
                && Objects.equals(vpcConfig(), other.vpcConfig()) && Objects.equals(deadLetterConfig(), other.deadLetterConfig())
                && Objects.equals(environment(), other.environment()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(tracingConfig(), other.tracingConfig()) && Objects.equals(masterArn(), other.masterArn())
                && Objects.equals(revisionId(), other.revisionId()) && hasLayers() == other.hasLayers()
                && Objects.equals(layers(), other.layers()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(stateReason(), other.stateReason())
                && Objects.equals(stateReasonCodeAsString(), other.stateReasonCodeAsString())
                && Objects.equals(lastUpdateStatusAsString(), other.lastUpdateStatusAsString())
                && Objects.equals(lastUpdateStatusReason(), other.lastUpdateStatusReason())
                && Objects.equals(lastUpdateStatusReasonCodeAsString(), other.lastUpdateStatusReasonCodeAsString())
                && hasFileSystemConfigs() == other.hasFileSystemConfigs()
                && Objects.equals(fileSystemConfigs(), other.fileSystemConfigs())
                && Objects.equals(packageTypeAsString(), other.packageTypeAsString())
                && Objects.equals(imageConfigResponse(), other.imageConfigResponse())
                && Objects.equals(signingProfileVersionArn(), other.signingProfileVersionArn())
                && Objects.equals(signingJobArn(), other.signingJobArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFunctionConfigurationResponse").add("FunctionName", functionName())
                .add("FunctionArn", functionArn()).add("Runtime", runtimeAsString()).add("Role", role())
                .add("Handler", handler()).add("CodeSize", codeSize()).add("Description", description())
                .add("Timeout", timeout()).add("MemorySize", memorySize()).add("LastModified", lastModified())
                .add("CodeSha256", codeSha256()).add("Version", version()).add("VpcConfig", vpcConfig())
                .add("DeadLetterConfig", deadLetterConfig()).add("Environment", environment()).add("KMSKeyArn", kmsKeyArn())
                .add("TracingConfig", tracingConfig()).add("MasterArn", masterArn()).add("RevisionId", revisionId())
                .add("Layers", hasLayers() ? layers() : null).add("State", stateAsString()).add("StateReason", stateReason())
                .add("StateReasonCode", stateReasonCodeAsString()).add("LastUpdateStatus", lastUpdateStatusAsString())
                .add("LastUpdateStatusReason", lastUpdateStatusReason())
                .add("LastUpdateStatusReasonCode", lastUpdateStatusReasonCodeAsString())
                .add("FileSystemConfigs", hasFileSystemConfigs() ? fileSystemConfigs() : null)
                .add("PackageType", packageTypeAsString()).add("ImageConfigResponse", imageConfigResponse())
                .add("SigningProfileVersionArn", signingProfileVersionArn()).add("SigningJobArn", signingJobArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "FunctionArn":
            return Optional.ofNullable(clazz.cast(functionArn()));
        case "Runtime":
            return Optional.ofNullable(clazz.cast(runtimeAsString()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "Handler":
            return Optional.ofNullable(clazz.cast(handler()));
        case "CodeSize":
            return Optional.ofNullable(clazz.cast(codeSize()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "MemorySize":
            return Optional.ofNullable(clazz.cast(memorySize()));
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "CodeSha256":
            return Optional.ofNullable(clazz.cast(codeSha256()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "DeadLetterConfig":
            return Optional.ofNullable(clazz.cast(deadLetterConfig()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "KMSKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "TracingConfig":
            return Optional.ofNullable(clazz.cast(tracingConfig()));
        case "MasterArn":
            return Optional.ofNullable(clazz.cast(masterArn()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        case "Layers":
            return Optional.ofNullable(clazz.cast(layers()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "StateReasonCode":
            return Optional.ofNullable(clazz.cast(stateReasonCodeAsString()));
        case "LastUpdateStatus":
            return Optional.ofNullable(clazz.cast(lastUpdateStatusAsString()));
        case "LastUpdateStatusReason":
            return Optional.ofNullable(clazz.cast(lastUpdateStatusReason()));
        case "LastUpdateStatusReasonCode":
            return Optional.ofNullable(clazz.cast(lastUpdateStatusReasonCodeAsString()));
        case "FileSystemConfigs":
            return Optional.ofNullable(clazz.cast(fileSystemConfigs()));
        case "PackageType":
            return Optional.ofNullable(clazz.cast(packageTypeAsString()));
        case "ImageConfigResponse":
            return Optional.ofNullable(clazz.cast(imageConfigResponse()));
        case "SigningProfileVersionArn":
            return Optional.ofNullable(clazz.cast(signingProfileVersionArn()));
        case "SigningJobArn":
            return Optional.ofNullable(clazz.cast(signingJobArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFunctionConfigurationResponse, T> g) {
        return obj -> g.apply((GetFunctionConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFunctionConfigurationResponse> {
        /**
         * <p>
         * The name of the function.
         * </p>
         * 
         * @param functionName
         *        The name of the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * The function's Amazon Resource Name (ARN).
         * </p>
         * 
         * @param functionArn
         *        The function's Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionArn(String functionArn);

        /**
         * <p>
         * The runtime environment for the Lambda function.
         * </p>
         * 
         * @param runtime
         *        The runtime environment for the Lambda function.
         * @see Runtime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Runtime
         */
        Builder runtime(String runtime);

        /**
         * <p>
         * The runtime environment for the Lambda function.
         * </p>
         * 
         * @param runtime
         *        The runtime environment for the Lambda function.
         * @see Runtime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Runtime
         */
        Builder runtime(Runtime runtime);

        /**
         * <p>
         * The function's execution role.
         * </p>
         * 
         * @param role
         *        The function's execution role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * The function that Lambda calls to begin executing your function.
         * </p>
         * 
         * @param handler
         *        The function that Lambda calls to begin executing your function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder handler(String handler);

        /**
         * <p>
         * The size of the function's deployment package, in bytes.
         * </p>
         * 
         * @param codeSize
         *        The size of the function's deployment package, in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSize(Long codeSize);

        /**
         * <p>
         * The function's description.
         * </p>
         * 
         * @param description
         *        The function's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The amount of time in seconds that Lambda allows a function to run before stopping it.
         * </p>
         * 
         * @param timeout
         *        The amount of time in seconds that Lambda allows a function to run before stopping it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        /**
         * <p>
         * The amount of memory available to the function at runtime.
         * </p>
         * 
         * @param memorySize
         *        The amount of memory available to the function at runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memorySize(Integer memorySize);

        /**
         * <p>
         * The date and time that the function was last updated, in <a
         * href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
         * </p>
         * 
         * @param lastModified
         *        The date and time that the function was last updated, in <a
         *        href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(String lastModified);

        /**
         * <p>
         * The SHA256 hash of the function's deployment package.
         * </p>
         * 
         * @param codeSha256
         *        The SHA256 hash of the function's deployment package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSha256(String codeSha256);

        /**
         * <p>
         * The version of the Lambda function.
         * </p>
         * 
         * @param version
         *        The version of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The function's networking configuration.
         * </p>
         * 
         * @param vpcConfig
         *        The function's networking configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfigResponse vpcConfig);

        /**
         * <p>
         * The function's networking configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConfigResponse.Builder} avoiding the need to
         * create one manually via {@link VpcConfigResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfigResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfig(VpcConfigResponse)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfigResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfigResponse)
         */
        default Builder vpcConfig(Consumer<VpcConfigResponse.Builder> vpcConfig) {
            return vpcConfig(VpcConfigResponse.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * The function's dead letter queue.
         * </p>
         * 
         * @param deadLetterConfig
         *        The function's dead letter queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deadLetterConfig(DeadLetterConfig deadLetterConfig);

        /**
         * <p>
         * The function's dead letter queue.
         * </p>
         * This is a convenience that creates an instance of the {@link DeadLetterConfig.Builder} avoiding the need to
         * create one manually via {@link DeadLetterConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeadLetterConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #deadLetterConfig(DeadLetterConfig)}.
         * 
         * @param deadLetterConfig
         *        a consumer that will call methods on {@link DeadLetterConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deadLetterConfig(DeadLetterConfig)
         */
        default Builder deadLetterConfig(Consumer<DeadLetterConfig.Builder> deadLetterConfig) {
            return deadLetterConfig(DeadLetterConfig.builder().applyMutation(deadLetterConfig).build());
        }

        /**
         * <p>
         * The function's environment variables.
         * </p>
         * 
         * @param environment
         *        The function's environment variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(EnvironmentResponse environment);

        /**
         * <p>
         * The function's environment variables.
         * </p>
         * This is a convenience that creates an instance of the {@link EnvironmentResponse.Builder} avoiding the need
         * to create one manually via {@link EnvironmentResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link EnvironmentResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #environment(EnvironmentResponse)}.
         * 
         * @param environment
         *        a consumer that will call methods on {@link EnvironmentResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environment(EnvironmentResponse)
         */
        default Builder environment(Consumer<EnvironmentResponse.Builder> environment) {
            return environment(EnvironmentResponse.builder().applyMutation(environment).build());
        }

        /**
         * <p>
         * The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
         * configured a customer managed CMK.
         * </p>
         * 
         * @param kmsKeyArn
         *        The KMS key that's used to encrypt the function's environment variables. This key is only returned if
         *        you've configured a customer managed CMK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The function's AWS X-Ray tracing configuration.
         * </p>
         * 
         * @param tracingConfig
         *        The function's AWS X-Ray tracing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracingConfig(TracingConfigResponse tracingConfig);

        /**
         * <p>
         * The function's AWS X-Ray tracing configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link TracingConfigResponse.Builder} avoiding the need
         * to create one manually via {@link TracingConfigResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link TracingConfigResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #tracingConfig(TracingConfigResponse)}.
         * 
         * @param tracingConfig
         *        a consumer that will call methods on {@link TracingConfigResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tracingConfig(TracingConfigResponse)
         */
        default Builder tracingConfig(Consumer<TracingConfigResponse.Builder> tracingConfig) {
            return tracingConfig(TracingConfigResponse.builder().applyMutation(tracingConfig).build());
        }

        /**
         * <p>
         * For Lambda@Edge functions, the ARN of the master function.
         * </p>
         * 
         * @param masterArn
         *        For Lambda@Edge functions, the ARN of the master function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterArn(String masterArn);

        /**
         * <p>
         * The latest updated revision of the function or alias.
         * </p>
         * 
         * @param revisionId
         *        The latest updated revision of the function or alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        /**
         * <p>
         * The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html"> layers</a>.
         * </p>
         * 
         * @param layers
         *        The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
         *        layers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(Collection<Layer> layers);

        /**
         * <p>
         * The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html"> layers</a>.
         * </p>
         * 
         * @param layers
         *        The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">
         *        layers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(Layer... layers);

        /**
         * <p>
         * The function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html"> layers</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Layer>.Builder} avoiding the need to create
         * one manually via {@link List<Layer>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Layer>.Builder#build()} is called immediately and its result
         * is passed to {@link #layers(List<Layer>)}.
         * 
         * @param layers
         *        a consumer that will call methods on {@link List<Layer>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #layers(List<Layer>)
         */
        Builder layers(Consumer<Layer.Builder>... layers);

        /**
         * <p>
         * The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function
         * by invoking it.
         * </p>
         * 
         * @param state
         *        The current state of the function. When the state is <code>Inactive</code>, you can reactivate the
         *        function by invoking it.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the function. When the state is <code>Inactive</code>, you can reactivate the function
         * by invoking it.
         * </p>
         * 
         * @param state
         *        The current state of the function. When the state is <code>Inactive</code>, you can reactivate the
         *        function by invoking it.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(State state);

        /**
         * <p>
         * The reason for the function's current state.
         * </p>
         * 
         * @param stateReason
         *        The reason for the function's current state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
         * modify the function.
         * </p>
         * 
         * @param stateReasonCode
         *        The reason code for the function's current state. When the code is <code>Creating</code>, you can't
         *        invoke or modify the function.
         * @see StateReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateReasonCode
         */
        Builder stateReasonCode(String stateReasonCode);

        /**
         * <p>
         * The reason code for the function's current state. When the code is <code>Creating</code>, you can't invoke or
         * modify the function.
         * </p>
         * 
         * @param stateReasonCode
         *        The reason code for the function's current state. When the code is <code>Creating</code>, you can't
         *        invoke or modify the function.
         * @see StateReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateReasonCode
         */
        Builder stateReasonCode(StateReasonCode stateReasonCode);

        /**
         * <p>
         * The status of the last update that was performed on the function. This is first set to
         * <code>Successful</code> after function creation completes.
         * </p>
         * 
         * @param lastUpdateStatus
         *        The status of the last update that was performed on the function. This is first set to
         *        <code>Successful</code> after function creation completes.
         * @see LastUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LastUpdateStatus
         */
        Builder lastUpdateStatus(String lastUpdateStatus);

        /**
         * <p>
         * The status of the last update that was performed on the function. This is first set to
         * <code>Successful</code> after function creation completes.
         * </p>
         * 
         * @param lastUpdateStatus
         *        The status of the last update that was performed on the function. This is first set to
         *        <code>Successful</code> after function creation completes.
         * @see LastUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LastUpdateStatus
         */
        Builder lastUpdateStatus(LastUpdateStatus lastUpdateStatus);

        /**
         * <p>
         * The reason for the last update that was performed on the function.
         * </p>
         * 
         * @param lastUpdateStatusReason
         *        The reason for the last update that was performed on the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateStatusReason(String lastUpdateStatusReason);

        /**
         * <p>
         * The reason code for the last update that was performed on the function.
         * </p>
         * 
         * @param lastUpdateStatusReasonCode
         *        The reason code for the last update that was performed on the function.
         * @see LastUpdateStatusReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LastUpdateStatusReasonCode
         */
        Builder lastUpdateStatusReasonCode(String lastUpdateStatusReasonCode);

        /**
         * <p>
         * The reason code for the last update that was performed on the function.
         * </p>
         * 
         * @param lastUpdateStatusReasonCode
         *        The reason code for the last update that was performed on the function.
         * @see LastUpdateStatusReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LastUpdateStatusReasonCode
         */
        Builder lastUpdateStatusReasonCode(LastUpdateStatusReasonCode lastUpdateStatusReasonCode);

        /**
         * <p>
         * Connection settings for an Amazon EFS file system.
         * </p>
         * 
         * @param fileSystemConfigs
         *        Connection settings for an Amazon EFS file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemConfigs(Collection<FileSystemConfig> fileSystemConfigs);

        /**
         * <p>
         * Connection settings for an Amazon EFS file system.
         * </p>
         * 
         * @param fileSystemConfigs
         *        Connection settings for an Amazon EFS file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemConfigs(FileSystemConfig... fileSystemConfigs);

        /**
         * <p>
         * Connection settings for an Amazon EFS file system.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FileSystemConfig>.Builder} avoiding the
         * need to create one manually via {@link List<FileSystemConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FileSystemConfig>.Builder#build()} is called immediately and
         * its result is passed to {@link #fileSystemConfigs(List<FileSystemConfig>)}.
         * 
         * @param fileSystemConfigs
         *        a consumer that will call methods on {@link List<FileSystemConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileSystemConfigs(List<FileSystemConfig>)
         */
        Builder fileSystemConfigs(Consumer<FileSystemConfig.Builder>... fileSystemConfigs);

        /**
         * <p>
         * The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for
         * .zip file archive.
         * </p>
         * 
         * @param packageType
         *        The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code>
         *        for .zip file archive.
         * @see PackageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageType
         */
        Builder packageType(String packageType);

        /**
         * <p>
         * The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for
         * .zip file archive.
         * </p>
         * 
         * @param packageType
         *        The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code>
         *        for .zip file archive.
         * @see PackageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageType
         */
        Builder packageType(PackageType packageType);

        /**
         * <p>
         * The function's image configuration values.
         * </p>
         * 
         * @param imageConfigResponse
         *        The function's image configuration values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageConfigResponse(ImageConfigResponse imageConfigResponse);

        /**
         * <p>
         * The function's image configuration values.
         * </p>
         * This is a convenience that creates an instance of the {@link ImageConfigResponse.Builder} avoiding the need
         * to create one manually via {@link ImageConfigResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageConfigResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #imageConfigResponse(ImageConfigResponse)}.
         * 
         * @param imageConfigResponse
         *        a consumer that will call methods on {@link ImageConfigResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageConfigResponse(ImageConfigResponse)
         */
        default Builder imageConfigResponse(Consumer<ImageConfigResponse.Builder> imageConfigResponse) {
            return imageConfigResponse(ImageConfigResponse.builder().applyMutation(imageConfigResponse).build());
        }

        /**
         * <p>
         * The ARN of the signing profile version.
         * </p>
         * 
         * @param signingProfileVersionArn
         *        The ARN of the signing profile version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingProfileVersionArn(String signingProfileVersionArn);

        /**
         * <p>
         * The ARN of the signing job.
         * </p>
         * 
         * @param signingJobArn
         *        The ARN of the signing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingJobArn(String signingJobArn);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String functionName;

        private String functionArn;

        private String runtime;

        private String role;

        private String handler;

        private Long codeSize;

        private String description;

        private Integer timeout;

        private Integer memorySize;

        private String lastModified;

        private String codeSha256;

        private String version;

        private VpcConfigResponse vpcConfig;

        private DeadLetterConfig deadLetterConfig;

        private EnvironmentResponse environment;

        private String kmsKeyArn;

        private TracingConfigResponse tracingConfig;

        private String masterArn;

        private String revisionId;

        private List<Layer> layers = DefaultSdkAutoConstructList.getInstance();

        private String state;

        private String stateReason;

        private String stateReasonCode;

        private String lastUpdateStatus;

        private String lastUpdateStatusReason;

        private String lastUpdateStatusReasonCode;

        private List<FileSystemConfig> fileSystemConfigs = DefaultSdkAutoConstructList.getInstance();

        private String packageType;

        private ImageConfigResponse imageConfigResponse;

        private String signingProfileVersionArn;

        private String signingJobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFunctionConfigurationResponse model) {
            super(model);
            functionName(model.functionName);
            functionArn(model.functionArn);
            runtime(model.runtime);
            role(model.role);
            handler(model.handler);
            codeSize(model.codeSize);
            description(model.description);
            timeout(model.timeout);
            memorySize(model.memorySize);
            lastModified(model.lastModified);
            codeSha256(model.codeSha256);
            version(model.version);
            vpcConfig(model.vpcConfig);
            deadLetterConfig(model.deadLetterConfig);
            environment(model.environment);
            kmsKeyArn(model.kmsKeyArn);
            tracingConfig(model.tracingConfig);
            masterArn(model.masterArn);
            revisionId(model.revisionId);
            layers(model.layers);
            state(model.state);
            stateReason(model.stateReason);
            stateReasonCode(model.stateReasonCode);
            lastUpdateStatus(model.lastUpdateStatus);
            lastUpdateStatusReason(model.lastUpdateStatusReason);
            lastUpdateStatusReasonCode(model.lastUpdateStatusReasonCode);
            fileSystemConfigs(model.fileSystemConfigs);
            packageType(model.packageType);
            imageConfigResponse(model.imageConfigResponse);
            signingProfileVersionArn(model.signingProfileVersionArn);
            signingJobArn(model.signingJobArn);
        }

        public final String getFunctionName() {
            return functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getFunctionArn() {
            return functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        public final String getRuntime() {
            return runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(Runtime runtime) {
            this.runtime(runtime == null ? null : runtime.toString());
            return this;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        public final String getRole() {
            return role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getHandler() {
            return handler;
        }

        @Override
        public final Builder handler(String handler) {
            this.handler = handler;
            return this;
        }

        public final void setHandler(String handler) {
            this.handler = handler;
        }

        public final Long getCodeSize() {
            return codeSize;
        }

        @Override
        public final Builder codeSize(Long codeSize) {
            this.codeSize = codeSize;
            return this;
        }

        public final void setCodeSize(Long codeSize) {
            this.codeSize = codeSize;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getTimeout() {
            return timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final Integer getMemorySize() {
            return memorySize;
        }

        @Override
        public final Builder memorySize(Integer memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        public final void setMemorySize(Integer memorySize) {
            this.memorySize = memorySize;
        }

        public final String getLastModified() {
            return lastModified;
        }

        @Override
        public final Builder lastModified(String lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        public final String getCodeSha256() {
            return codeSha256;
        }

        @Override
        public final Builder codeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
            return this;
        }

        public final void setCodeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final VpcConfigResponse.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfigResponse vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfigResponse.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final DeadLetterConfig.Builder getDeadLetterConfig() {
            return deadLetterConfig != null ? deadLetterConfig.toBuilder() : null;
        }

        @Override
        public final Builder deadLetterConfig(DeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        public final void setDeadLetterConfig(DeadLetterConfig.BuilderImpl deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig != null ? deadLetterConfig.build() : null;
        }

        public final EnvironmentResponse.Builder getEnvironment() {
            return environment != null ? environment.toBuilder() : null;
        }

        @Override
        public final Builder environment(EnvironmentResponse environment) {
            this.environment = environment;
            return this;
        }

        public final void setEnvironment(EnvironmentResponse.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public final TracingConfigResponse.Builder getTracingConfig() {
            return tracingConfig != null ? tracingConfig.toBuilder() : null;
        }

        @Override
        public final Builder tracingConfig(TracingConfigResponse tracingConfig) {
            this.tracingConfig = tracingConfig;
            return this;
        }

        public final void setTracingConfig(TracingConfigResponse.BuilderImpl tracingConfig) {
            this.tracingConfig = tracingConfig != null ? tracingConfig.build() : null;
        }

        public final String getMasterArn() {
            return masterArn;
        }

        @Override
        public final Builder masterArn(String masterArn) {
            this.masterArn = masterArn;
            return this;
        }

        public final void setMasterArn(String masterArn) {
            this.masterArn = masterArn;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        public final Collection<Layer.Builder> getLayers() {
            if (layers instanceof SdkAutoConstructList) {
                return null;
            }
            return layers != null ? layers.stream().map(Layer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder layers(Collection<Layer> layers) {
            this.layers = LayersReferenceListCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Layer... layers) {
            layers(Arrays.asList(layers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Consumer<Layer.Builder>... layers) {
            layers(Stream.of(layers).map(c -> Layer.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLayers(Collection<Layer.BuilderImpl> layers) {
            this.layers = LayersReferenceListCopier.copyFromBuilder(layers);
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateReason() {
            return stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        public final String getStateReasonCode() {
            return stateReasonCode;
        }

        @Override
        public final Builder stateReasonCode(String stateReasonCode) {
            this.stateReasonCode = stateReasonCode;
            return this;
        }

        @Override
        public final Builder stateReasonCode(StateReasonCode stateReasonCode) {
            this.stateReasonCode(stateReasonCode == null ? null : stateReasonCode.toString());
            return this;
        }

        public final void setStateReasonCode(String stateReasonCode) {
            this.stateReasonCode = stateReasonCode;
        }

        public final String getLastUpdateStatus() {
            return lastUpdateStatus;
        }

        @Override
        public final Builder lastUpdateStatus(String lastUpdateStatus) {
            this.lastUpdateStatus = lastUpdateStatus;
            return this;
        }

        @Override
        public final Builder lastUpdateStatus(LastUpdateStatus lastUpdateStatus) {
            this.lastUpdateStatus(lastUpdateStatus == null ? null : lastUpdateStatus.toString());
            return this;
        }

        public final void setLastUpdateStatus(String lastUpdateStatus) {
            this.lastUpdateStatus = lastUpdateStatus;
        }

        public final String getLastUpdateStatusReason() {
            return lastUpdateStatusReason;
        }

        @Override
        public final Builder lastUpdateStatusReason(String lastUpdateStatusReason) {
            this.lastUpdateStatusReason = lastUpdateStatusReason;
            return this;
        }

        public final void setLastUpdateStatusReason(String lastUpdateStatusReason) {
            this.lastUpdateStatusReason = lastUpdateStatusReason;
        }

        public final String getLastUpdateStatusReasonCode() {
            return lastUpdateStatusReasonCode;
        }

        @Override
        public final Builder lastUpdateStatusReasonCode(String lastUpdateStatusReasonCode) {
            this.lastUpdateStatusReasonCode = lastUpdateStatusReasonCode;
            return this;
        }

        @Override
        public final Builder lastUpdateStatusReasonCode(LastUpdateStatusReasonCode lastUpdateStatusReasonCode) {
            this.lastUpdateStatusReasonCode(lastUpdateStatusReasonCode == null ? null : lastUpdateStatusReasonCode.toString());
            return this;
        }

        public final void setLastUpdateStatusReasonCode(String lastUpdateStatusReasonCode) {
            this.lastUpdateStatusReasonCode = lastUpdateStatusReasonCode;
        }

        public final Collection<FileSystemConfig.Builder> getFileSystemConfigs() {
            if (fileSystemConfigs instanceof SdkAutoConstructList) {
                return null;
            }
            return fileSystemConfigs != null ? fileSystemConfigs.stream().map(FileSystemConfig::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fileSystemConfigs(Collection<FileSystemConfig> fileSystemConfigs) {
            this.fileSystemConfigs = FileSystemConfigListCopier.copy(fileSystemConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemConfigs(FileSystemConfig... fileSystemConfigs) {
            fileSystemConfigs(Arrays.asList(fileSystemConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemConfigs(Consumer<FileSystemConfig.Builder>... fileSystemConfigs) {
            fileSystemConfigs(Stream.of(fileSystemConfigs).map(c -> FileSystemConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFileSystemConfigs(Collection<FileSystemConfig.BuilderImpl> fileSystemConfigs) {
            this.fileSystemConfigs = FileSystemConfigListCopier.copyFromBuilder(fileSystemConfigs);
        }

        public final String getPackageType() {
            return packageType;
        }

        @Override
        public final Builder packageType(String packageType) {
            this.packageType = packageType;
            return this;
        }

        @Override
        public final Builder packageType(PackageType packageType) {
            this.packageType(packageType == null ? null : packageType.toString());
            return this;
        }

        public final void setPackageType(String packageType) {
            this.packageType = packageType;
        }

        public final ImageConfigResponse.Builder getImageConfigResponse() {
            return imageConfigResponse != null ? imageConfigResponse.toBuilder() : null;
        }

        @Override
        public final Builder imageConfigResponse(ImageConfigResponse imageConfigResponse) {
            this.imageConfigResponse = imageConfigResponse;
            return this;
        }

        public final void setImageConfigResponse(ImageConfigResponse.BuilderImpl imageConfigResponse) {
            this.imageConfigResponse = imageConfigResponse != null ? imageConfigResponse.build() : null;
        }

        public final String getSigningProfileVersionArn() {
            return signingProfileVersionArn;
        }

        @Override
        public final Builder signingProfileVersionArn(String signingProfileVersionArn) {
            this.signingProfileVersionArn = signingProfileVersionArn;
            return this;
        }

        public final void setSigningProfileVersionArn(String signingProfileVersionArn) {
            this.signingProfileVersionArn = signingProfileVersionArn;
        }

        public final String getSigningJobArn() {
            return signingJobArn;
        }

        @Override
        public final Builder signingJobArn(String signingJobArn) {
            this.signingJobArn = signingJobArn;
            return this;
        }

        public final void setSigningJobArn(String signingJobArn) {
            this.signingJobArn = signingJobArn;
        }

        @Override
        public GetFunctionConfigurationResponse build() {
            return new GetFunctionConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
