/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * AWS Lambda received an unexpected EC2 client exception while setting up for the Lambda function.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ec2UnexpectedException extends LambdaException implements
        ToCopyableBuilder<Ec2UnexpectedException.Builder, Ec2UnexpectedException> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Ec2UnexpectedException::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> EC2_ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EC2ErrorCode").getter(getter(Ec2UnexpectedException::ec2ErrorCode))
            .setter(setter(Builder::ec2ErrorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2ErrorCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            EC2_ERROR_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String ec2ErrorCode;

    private Ec2UnexpectedException(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.ec2ErrorCode = builder.ec2ErrorCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the Type property for this object.
     * 
     * @return The value of the Type property for this object.
     */
    public String type() {
        return type;
    }

    /**
     * Returns the value of the EC2ErrorCode property for this object.
     * 
     * @return The value of the EC2ErrorCode property for this object.
     */
    public String ec2ErrorCode() {
        return ec2ErrorCode;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ec2UnexpectedException, T> g) {
        return obj -> g.apply((Ec2UnexpectedException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ec2UnexpectedException>, LambdaException.Builder {
        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * Sets the value of the EC2ErrorCode property for this object.
         *
         * @param ec2ErrorCode
         *        The new value for the EC2ErrorCode property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2ErrorCode(String ec2ErrorCode);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends LambdaException.BuilderImpl implements Builder {
        private String type;

        private String ec2ErrorCode;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2UnexpectedException model) {
            super(model);
            type(model.type);
            ec2ErrorCode(model.ec2ErrorCode);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getEc2ErrorCode() {
            return ec2ErrorCode;
        }

        @Override
        public final Builder ec2ErrorCode(String ec2ErrorCode) {
            this.ec2ErrorCode = ec2ErrorCode;
            return this;
        }

        public final void setEc2ErrorCode(String ec2ErrorCode) {
            this.ec2ErrorCode = ec2ErrorCode;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public Ec2UnexpectedException build() {
            return new Ec2UnexpectedException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
