/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SourceAccessType {
    BASIC_AUTH("BASIC_AUTH"),
    VPC_SUBNET("VPC_SUBNET"),
    VPC_SECURITY_GROUP("VPC_SECURITY_GROUP"),
    SASL_SCRAM_512_AUTH("SASL_SCRAM_512_AUTH"),
    SASL_SCRAM_256_AUTH("SASL_SCRAM_256_AUTH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SourceAccessType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SourceAccessType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SourceAccessType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SourceAccessType> knownValues() {
        return Stream.of(SourceAccessType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

