/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Code signing configuration policies specifies the validation failure action for signature mismatch or expiry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeSigningPolicies implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeSigningPolicies.Builder, CodeSigningPolicies> {
    private static final SdkField<String> UNTRUSTED_ARTIFACT_ON_DEPLOYMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UntrustedArtifactOnDeployment")
            .getter(getter(CodeSigningPolicies::untrustedArtifactOnDeploymentAsString))
            .setter(setter(Builder::untrustedArtifactOnDeployment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UntrustedArtifactOnDeployment")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(UNTRUSTED_ARTIFACT_ON_DEPLOYMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String untrustedArtifactOnDeployment;

    private CodeSigningPolicies(BuilderImpl builder) {
        this.untrustedArtifactOnDeployment = builder.untrustedArtifactOnDeployment;
    }

    /**
     * <p>
     * Code signing configuration policy for deployment validation failure. If you set the policy to
     * <code>Enforce</code>, Lambda blocks the deployment request if signature validation checks fail. If you set the
     * policy to <code>Warn</code>, Lambda allows the deployment and creates a CloudWatch log.
     * </p>
     * <p>
     * Default value: <code>Warn</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #untrustedArtifactOnDeployment} will return {@link CodeSigningPolicy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #untrustedArtifactOnDeploymentAsString}.
     * </p>
     * 
     * @return Code signing configuration policy for deployment validation failure. If you set the policy to
     *         <code>Enforce</code>, Lambda blocks the deployment request if signature validation checks fail. If you
     *         set the policy to <code>Warn</code>, Lambda allows the deployment and creates a CloudWatch log. </p>
     *         <p>
     *         Default value: <code>Warn</code>
     * @see CodeSigningPolicy
     */
    public final CodeSigningPolicy untrustedArtifactOnDeployment() {
        return CodeSigningPolicy.fromValue(untrustedArtifactOnDeployment);
    }

    /**
     * <p>
     * Code signing configuration policy for deployment validation failure. If you set the policy to
     * <code>Enforce</code>, Lambda blocks the deployment request if signature validation checks fail. If you set the
     * policy to <code>Warn</code>, Lambda allows the deployment and creates a CloudWatch log.
     * </p>
     * <p>
     * Default value: <code>Warn</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #untrustedArtifactOnDeployment} will return {@link CodeSigningPolicy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #untrustedArtifactOnDeploymentAsString}.
     * </p>
     * 
     * @return Code signing configuration policy for deployment validation failure. If you set the policy to
     *         <code>Enforce</code>, Lambda blocks the deployment request if signature validation checks fail. If you
     *         set the policy to <code>Warn</code>, Lambda allows the deployment and creates a CloudWatch log. </p>
     *         <p>
     *         Default value: <code>Warn</code>
     * @see CodeSigningPolicy
     */
    public final String untrustedArtifactOnDeploymentAsString() {
        return untrustedArtifactOnDeployment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(untrustedArtifactOnDeploymentAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeSigningPolicies)) {
            return false;
        }
        CodeSigningPolicies other = (CodeSigningPolicies) obj;
        return Objects.equals(untrustedArtifactOnDeploymentAsString(), other.untrustedArtifactOnDeploymentAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeSigningPolicies")
                .add("UntrustedArtifactOnDeployment", untrustedArtifactOnDeploymentAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UntrustedArtifactOnDeployment":
            return Optional.ofNullable(clazz.cast(untrustedArtifactOnDeploymentAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeSigningPolicies, T> g) {
        return obj -> g.apply((CodeSigningPolicies) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeSigningPolicies> {
        /**
         * <p>
         * Code signing configuration policy for deployment validation failure. If you set the policy to
         * <code>Enforce</code>, Lambda blocks the deployment request if signature validation checks fail. If you set
         * the policy to <code>Warn</code>, Lambda allows the deployment and creates a CloudWatch log.
         * </p>
         * <p>
         * Default value: <code>Warn</code>
         * </p>
         * 
         * @param untrustedArtifactOnDeployment
         *        Code signing configuration policy for deployment validation failure. If you set the policy to
         *        <code>Enforce</code>, Lambda blocks the deployment request if signature validation checks fail. If you
         *        set the policy to <code>Warn</code>, Lambda allows the deployment and creates a CloudWatch log. </p>
         *        <p>
         *        Default value: <code>Warn</code>
         * @see CodeSigningPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeSigningPolicy
         */
        Builder untrustedArtifactOnDeployment(String untrustedArtifactOnDeployment);

        /**
         * <p>
         * Code signing configuration policy for deployment validation failure. If you set the policy to
         * <code>Enforce</code>, Lambda blocks the deployment request if signature validation checks fail. If you set
         * the policy to <code>Warn</code>, Lambda allows the deployment and creates a CloudWatch log.
         * </p>
         * <p>
         * Default value: <code>Warn</code>
         * </p>
         * 
         * @param untrustedArtifactOnDeployment
         *        Code signing configuration policy for deployment validation failure. If you set the policy to
         *        <code>Enforce</code>, Lambda blocks the deployment request if signature validation checks fail. If you
         *        set the policy to <code>Warn</code>, Lambda allows the deployment and creates a CloudWatch log. </p>
         *        <p>
         *        Default value: <code>Warn</code>
         * @see CodeSigningPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeSigningPolicy
         */
        Builder untrustedArtifactOnDeployment(CodeSigningPolicy untrustedArtifactOnDeployment);
    }

    static final class BuilderImpl implements Builder {
        private String untrustedArtifactOnDeployment;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeSigningPolicies model) {
            untrustedArtifactOnDeployment(model.untrustedArtifactOnDeployment);
        }

        public final String getUntrustedArtifactOnDeployment() {
            return untrustedArtifactOnDeployment;
        }

        @Override
        public final Builder untrustedArtifactOnDeployment(String untrustedArtifactOnDeployment) {
            this.untrustedArtifactOnDeployment = untrustedArtifactOnDeployment;
            return this;
        }

        @Override
        public final Builder untrustedArtifactOnDeployment(CodeSigningPolicy untrustedArtifactOnDeployment) {
            this.untrustedArtifactOnDeployment(untrustedArtifactOnDeployment == null ? null : untrustedArtifactOnDeployment
                    .toString());
            return this;
        }

        public final void setUntrustedArtifactOnDeployment(String untrustedArtifactOnDeployment) {
            this.untrustedArtifactOnDeployment = untrustedArtifactOnDeployment;
        }

        @Override
        public CodeSigningPolicies build() {
            return new CodeSigningPolicies(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
