/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionResponse;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.services.lambda.waiters.LambdaAsyncWaiter;
import software.amazon.awssdk.services.lambda.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultLambdaAsyncWaiter
implements LambdaAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final LambdaAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<GetFunctionResponse> functionExistsWaiter;
    private final AsyncWaiter<GetFunctionConfigurationResponse> functionActiveWaiter;
    private final AsyncWaiter<GetFunctionConfigurationResponse> functionUpdatedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultLambdaAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (LambdaAsyncClient)LambdaAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.functionExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetFunctionResponse.class).acceptors(DefaultLambdaAsyncWaiter.functionExistsWaiterAcceptors())).overrideConfiguration(DefaultLambdaAsyncWaiter.functionExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.functionActiveWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetFunctionConfigurationResponse.class).acceptors(DefaultLambdaAsyncWaiter.functionActiveWaiterAcceptors())).overrideConfiguration(DefaultLambdaAsyncWaiter.functionActiveWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.functionUpdatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetFunctionConfigurationResponse.class).acceptors(DefaultLambdaAsyncWaiter.functionUpdatedWaiterAcceptors())).overrideConfiguration(DefaultLambdaAsyncWaiter.functionUpdatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<GetFunctionConfigurationResponse>> waitUntilFunctionActive(GetFunctionConfigurationRequest getFunctionConfigurationRequest) {
        return this.functionActiveWaiter.runAsync(() -> this.client.getFunctionConfiguration(this.applyWaitersUserAgent(getFunctionConfigurationRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetFunctionConfigurationResponse>> waitUntilFunctionActive(GetFunctionConfigurationRequest getFunctionConfigurationRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.functionActiveWaiter.runAsync(() -> this.client.getFunctionConfiguration(this.applyWaitersUserAgent(getFunctionConfigurationRequest)), DefaultLambdaAsyncWaiter.functionActiveWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetFunctionResponse>> waitUntilFunctionExists(GetFunctionRequest getFunctionRequest) {
        return this.functionExistsWaiter.runAsync(() -> this.client.getFunction(this.applyWaitersUserAgent(getFunctionRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetFunctionResponse>> waitUntilFunctionExists(GetFunctionRequest getFunctionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.functionExistsWaiter.runAsync(() -> this.client.getFunction(this.applyWaitersUserAgent(getFunctionRequest)), DefaultLambdaAsyncWaiter.functionExistsWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetFunctionConfigurationResponse>> waitUntilFunctionUpdated(GetFunctionConfigurationRequest getFunctionConfigurationRequest) {
        return this.functionUpdatedWaiter.runAsync(() -> this.client.getFunctionConfiguration(this.applyWaitersUserAgent(getFunctionConfigurationRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetFunctionConfigurationResponse>> waitUntilFunctionUpdated(GetFunctionConfigurationRequest getFunctionConfigurationRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.functionUpdatedWaiter.runAsync(() -> this.client.getFunctionConfiguration(this.applyWaitersUserAgent(getFunctionConfigurationRequest)), DefaultLambdaAsyncWaiter.functionUpdatedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetFunctionResponse>> functionExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetFunctionResponse>> result = new ArrayList<WaiterAcceptor<? super GetFunctionResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultLambdaAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetFunctionConfigurationResponse>> functionActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetFunctionConfigurationResponse>> result = new ArrayList<WaiterAcceptor<? super GetFunctionConfigurationResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "Active");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "Failed");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "Pending");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetFunctionConfigurationResponse>> functionUpdatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetFunctionConfigurationResponse>> result = new ArrayList<WaiterAcceptor<? super GetFunctionConfigurationResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("LastUpdateStatus").value(), "Successful");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("LastUpdateStatus").value(), "Failed");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("LastUpdateStatus").value(), "InProgress");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration functionExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(1L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration functionActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration functionUpdatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static LambdaAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends LambdaRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((LambdaRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements LambdaAsyncWaiter.Builder {
        private LambdaAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public LambdaAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public LambdaAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public LambdaAsyncWaiter.Builder client(LambdaAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public LambdaAsyncWaiter build() {
            return new DefaultLambdaAsyncWaiter(this);
        }
    }
}

