/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCodeSigningConfigsResponse extends LambdaResponse implements
        ToCopyableBuilder<ListCodeSigningConfigsResponse.Builder, ListCodeSigningConfigsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListCodeSigningConfigsResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<List<CodeSigningConfig>> CODE_SIGNING_CONFIGS_FIELD = SdkField
            .<List<CodeSigningConfig>> builder(MarshallingType.LIST)
            .memberName("CodeSigningConfigs")
            .getter(getter(ListCodeSigningConfigsResponse::codeSigningConfigs))
            .setter(setter(Builder::codeSigningConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSigningConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CodeSigningConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodeSigningConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            CODE_SIGNING_CONFIGS_FIELD));

    private final String nextMarker;

    private final List<CodeSigningConfig> codeSigningConfigs;

    private ListCodeSigningConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.codeSigningConfigs = builder.codeSigningConfigs;
    }

    /**
     * <p>
     * The pagination token that's included if more results are available.
     * </p>
     * 
     * @return The pagination token that's included if more results are available.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * Returns true if the CodeSigningConfigs property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasCodeSigningConfigs() {
        return codeSigningConfigs != null && !(codeSigningConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The code signing configurations
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCodeSigningConfigs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The code signing configurations
     */
    public final List<CodeSigningConfig> codeSigningConfigs() {
        return codeSigningConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(hasCodeSigningConfigs() ? codeSigningConfigs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCodeSigningConfigsResponse)) {
            return false;
        }
        ListCodeSigningConfigsResponse other = (ListCodeSigningConfigsResponse) obj;
        return Objects.equals(nextMarker(), other.nextMarker()) && hasCodeSigningConfigs() == other.hasCodeSigningConfigs()
                && Objects.equals(codeSigningConfigs(), other.codeSigningConfigs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCodeSigningConfigsResponse").add("NextMarker", nextMarker())
                .add("CodeSigningConfigs", hasCodeSigningConfigs() ? codeSigningConfigs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "CodeSigningConfigs":
            return Optional.ofNullable(clazz.cast(codeSigningConfigs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCodeSigningConfigsResponse, T> g) {
        return obj -> g.apply((ListCodeSigningConfigsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCodeSigningConfigsResponse> {
        /**
         * <p>
         * The pagination token that's included if more results are available.
         * </p>
         * 
         * @param nextMarker
         *        The pagination token that's included if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * The code signing configurations
         * </p>
         * 
         * @param codeSigningConfigs
         *        The code signing configurations
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSigningConfigs(Collection<CodeSigningConfig> codeSigningConfigs);

        /**
         * <p>
         * The code signing configurations
         * </p>
         * 
         * @param codeSigningConfigs
         *        The code signing configurations
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSigningConfigs(CodeSigningConfig... codeSigningConfigs);

        /**
         * <p>
         * The code signing configurations
         * </p>
         * This is a convenience that creates an instance of the {@link List<CodeSigningConfig>.Builder} avoiding the
         * need to create one manually via {@link List<CodeSigningConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CodeSigningConfig>.Builder#build()} is called immediately
         * and its result is passed to {@link #codeSigningConfigs(List<CodeSigningConfig>)}.
         * 
         * @param codeSigningConfigs
         *        a consumer that will call methods on {@link List<CodeSigningConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeSigningConfigs(List<CodeSigningConfig>)
         */
        Builder codeSigningConfigs(Consumer<CodeSigningConfig.Builder>... codeSigningConfigs);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String nextMarker;

        private List<CodeSigningConfig> codeSigningConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCodeSigningConfigsResponse model) {
            super(model);
            nextMarker(model.nextMarker);
            codeSigningConfigs(model.codeSigningConfigs);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        @Transient
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<CodeSigningConfig.Builder> getCodeSigningConfigs() {
            List<CodeSigningConfig.Builder> result = CodeSigningConfigListCopier.copyToBuilder(this.codeSigningConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCodeSigningConfigs(Collection<CodeSigningConfig.BuilderImpl> codeSigningConfigs) {
            this.codeSigningConfigs = CodeSigningConfigListCopier.copyFromBuilder(codeSigningConfigs);
        }

        @Override
        @Transient
        public final Builder codeSigningConfigs(Collection<CodeSigningConfig> codeSigningConfigs) {
            this.codeSigningConfigs = CodeSigningConfigListCopier.copy(codeSigningConfigs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder codeSigningConfigs(CodeSigningConfig... codeSigningConfigs) {
            codeSigningConfigs(Arrays.asList(codeSigningConfigs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder codeSigningConfigs(Consumer<CodeSigningConfig.Builder>... codeSigningConfigs) {
            codeSigningConfigs(Stream.of(codeSigningConfigs).map(c -> CodeSigningConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCodeSigningConfigsResponse build() {
            return new ListCodeSigningConfigsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
