/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.DestinationConfig;
import software.amazon.awssdk.services.lambda.model.EventSourcePosition;
import software.amazon.awssdk.services.lambda.model.FilterCriteria;
import software.amazon.awssdk.services.lambda.model.FunctionResponseType;
import software.amazon.awssdk.services.lambda.model.FunctionResponseTypeListCopier;
import software.amazon.awssdk.services.lambda.model.QueuesCopier;
import software.amazon.awssdk.services.lambda.model.SelfManagedEventSource;
import software.amazon.awssdk.services.lambda.model.SourceAccessConfiguration;
import software.amazon.awssdk.services.lambda.model.SourceAccessConfigurationsCopier;
import software.amazon.awssdk.services.lambda.model.TopicsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventSourceMappingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventSourceMappingConfiguration> {
    private static final SdkField<String> UUID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UUID").getter(EventSourceMappingConfiguration.getter(EventSourceMappingConfiguration::uuid)).setter(EventSourceMappingConfiguration.setter(Builder::uuid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UUID").build()}).build();
    private static final SdkField<String> STARTING_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartingPosition").getter(EventSourceMappingConfiguration.getter(EventSourceMappingConfiguration::startingPositionAsString)).setter(EventSourceMappingConfiguration.setter(Builder::startingPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingPosition").build()}).build();
    private static final SdkField<Instant> STARTING_POSITION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartingPositionTimestamp").getter(EventSourceMappingConfiguration.getter(EventSourceMappingConfiguration::startingPositionTimestamp)).setter(EventSourceMappingConfiguration.setter(Builder::startingPositionTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingPositionTimestamp").build()}).build();
    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BatchSize").getter(EventSourceMappingConfiguration.getter(EventSourceMappingConfiguration::batchSize)).setter(EventSourceMappingConfiguration.setter(Builder::batchSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()}).build();
    private static final SdkField<Integer> MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumBatchingWindowInSeconds").getter(EventSourceMappingConfiguration.getter(EventSourceMappingConfiguration::maximumBatchingWindowInSeconds)).setter(EventSourceMappingConfiguration.setter(Builder::maximumBatchingWindowInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchingWindowInSeconds").build()}).build();
    private static final SdkField<Integer> PARALLELIZATION_FACTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParallelizationFactor").getter(EventSourceMappingConfiguration.getter(EventSourceMappingConfiguration::parallelizationFactor)).setter(EventSourceMappingConfiguration.setter(Builder::parallelizationFactor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelizationFactor").build()}).build();
    private static final SdkField<String> EVENT_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventSourceArn").getter(EventSourceMappingConfiguration.getter(EventSourceMappingConfiguration::eventSourceArn)).setter(EventSourceMappingConfiguration.setter(Builder::eventSourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceArn").build()}).build();
    private static final SdkField<FilterCriteria> FILTER_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterCriteria").getter(EventSourceMappingConfiguration.getter(EventSourceMappingConfiguration::filterCriteria)).setter(EventSourceMappingConfiguration.setter(Builder::filterCriteria)).constructor(FilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterCriteria").build()}).build();
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionArn").getter(EventSourceMappingConfiguration.getter(EventSourceMappingConfiguration::functionArn)).setter(EventSourceMappingConfiguration.setter(Builder::functionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModified").getter(EventSourceMappingConfiguration.getter(EventSourceMappingConfiguration::lastModified)).setter(EventSourceMappingConfiguration.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()}).build();
    private static final SdkField<String> LAST_PROCESSING_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastProcessingResult").getter(EventSourceMappingConfiguration.getter(EventSourceMappingConfiguration::lastProcessingResult)).setter(EventSourceMappingConfiguration.setter(Builder::lastProcessingResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastProcessingResult").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(EventSourceMappingConfiguration.getter(EventSourceMappingConfiguration::state)).setter(EventSourceMappingConfiguration.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_TRANSITION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateTransitionReason").getter(EventSourceMappingConfiguration.getter(EventSourceMappingConfiguration::stateTransitionReason)).setter(EventSourceMappingConfiguration.setter(Builder::stateTransitionReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateTransitionReason").build()}).build();
    private static final SdkField<DestinationConfig> DESTINATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationConfig").getter(EventSourceMappingConfiguration.getter(EventSourceMappingConfiguration::destinationConfig)).setter(EventSourceMappingConfiguration.setter(Builder::destinationConfig)).constructor(DestinationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationConfig").build()}).build();
    private static final SdkField<List<String>> TOPICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Topics").getter(EventSourceMappingConfiguration.getter(EventSourceMappingConfiguration::topics)).setter(EventSourceMappingConfiguration.setter(Builder::topics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Topics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> QUEUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Queues").getter(EventSourceMappingConfiguration.getter(EventSourceMappingConfiguration::queues)).setter(EventSourceMappingConfiguration.setter(Builder::queues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SourceAccessConfiguration>> SOURCE_ACCESS_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceAccessConfigurations").getter(EventSourceMappingConfiguration.getter(EventSourceMappingConfiguration::sourceAccessConfigurations)).setter(EventSourceMappingConfiguration.setter(Builder::sourceAccessConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAccessConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceAccessConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SelfManagedEventSource> SELF_MANAGED_EVENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SelfManagedEventSource").getter(EventSourceMappingConfiguration.getter(EventSourceMappingConfiguration::selfManagedEventSource)).setter(EventSourceMappingConfiguration.setter(Builder::selfManagedEventSource)).constructor(SelfManagedEventSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedEventSource").build()}).build();
    private static final SdkField<Integer> MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumRecordAgeInSeconds").getter(EventSourceMappingConfiguration.getter(EventSourceMappingConfiguration::maximumRecordAgeInSeconds)).setter(EventSourceMappingConfiguration.setter(Builder::maximumRecordAgeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRecordAgeInSeconds").build()}).build();
    private static final SdkField<Boolean> BISECT_BATCH_ON_FUNCTION_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("BisectBatchOnFunctionError").getter(EventSourceMappingConfiguration.getter(EventSourceMappingConfiguration::bisectBatchOnFunctionError)).setter(EventSourceMappingConfiguration.setter(Builder::bisectBatchOnFunctionError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BisectBatchOnFunctionError").build()}).build();
    private static final SdkField<Integer> MAXIMUM_RETRY_ATTEMPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumRetryAttempts").getter(EventSourceMappingConfiguration.getter(EventSourceMappingConfiguration::maximumRetryAttempts)).setter(EventSourceMappingConfiguration.setter(Builder::maximumRetryAttempts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRetryAttempts").build()}).build();
    private static final SdkField<Integer> TUMBLING_WINDOW_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TumblingWindowInSeconds").getter(EventSourceMappingConfiguration.getter(EventSourceMappingConfiguration::tumblingWindowInSeconds)).setter(EventSourceMappingConfiguration.setter(Builder::tumblingWindowInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TumblingWindowInSeconds").build()}).build();
    private static final SdkField<List<String>> FUNCTION_RESPONSE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FunctionResponseTypes").getter(EventSourceMappingConfiguration.getter(EventSourceMappingConfiguration::functionResponseTypesAsStrings)).setter(EventSourceMappingConfiguration.setter(Builder::functionResponseTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionResponseTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UUID_FIELD, STARTING_POSITION_FIELD, STARTING_POSITION_TIMESTAMP_FIELD, BATCH_SIZE_FIELD, MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD, PARALLELIZATION_FACTOR_FIELD, EVENT_SOURCE_ARN_FIELD, FILTER_CRITERIA_FIELD, FUNCTION_ARN_FIELD, LAST_MODIFIED_FIELD, LAST_PROCESSING_RESULT_FIELD, STATE_FIELD, STATE_TRANSITION_REASON_FIELD, DESTINATION_CONFIG_FIELD, TOPICS_FIELD, QUEUES_FIELD, SOURCE_ACCESS_CONFIGURATIONS_FIELD, SELF_MANAGED_EVENT_SOURCE_FIELD, MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD, BISECT_BATCH_ON_FUNCTION_ERROR_FIELD, MAXIMUM_RETRY_ATTEMPTS_FIELD, TUMBLING_WINDOW_IN_SECONDS_FIELD, FUNCTION_RESPONSE_TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String uuid;
    private final String startingPosition;
    private final Instant startingPositionTimestamp;
    private final Integer batchSize;
    private final Integer maximumBatchingWindowInSeconds;
    private final Integer parallelizationFactor;
    private final String eventSourceArn;
    private final FilterCriteria filterCriteria;
    private final String functionArn;
    private final Instant lastModified;
    private final String lastProcessingResult;
    private final String state;
    private final String stateTransitionReason;
    private final DestinationConfig destinationConfig;
    private final List<String> topics;
    private final List<String> queues;
    private final List<SourceAccessConfiguration> sourceAccessConfigurations;
    private final SelfManagedEventSource selfManagedEventSource;
    private final Integer maximumRecordAgeInSeconds;
    private final Boolean bisectBatchOnFunctionError;
    private final Integer maximumRetryAttempts;
    private final Integer tumblingWindowInSeconds;
    private final List<String> functionResponseTypes;

    private EventSourceMappingConfiguration(BuilderImpl builder) {
        this.uuid = builder.uuid;
        this.startingPosition = builder.startingPosition;
        this.startingPositionTimestamp = builder.startingPositionTimestamp;
        this.batchSize = builder.batchSize;
        this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
        this.parallelizationFactor = builder.parallelizationFactor;
        this.eventSourceArn = builder.eventSourceArn;
        this.filterCriteria = builder.filterCriteria;
        this.functionArn = builder.functionArn;
        this.lastModified = builder.lastModified;
        this.lastProcessingResult = builder.lastProcessingResult;
        this.state = builder.state;
        this.stateTransitionReason = builder.stateTransitionReason;
        this.destinationConfig = builder.destinationConfig;
        this.topics = builder.topics;
        this.queues = builder.queues;
        this.sourceAccessConfigurations = builder.sourceAccessConfigurations;
        this.selfManagedEventSource = builder.selfManagedEventSource;
        this.maximumRecordAgeInSeconds = builder.maximumRecordAgeInSeconds;
        this.bisectBatchOnFunctionError = builder.bisectBatchOnFunctionError;
        this.maximumRetryAttempts = builder.maximumRetryAttempts;
        this.tumblingWindowInSeconds = builder.tumblingWindowInSeconds;
        this.functionResponseTypes = builder.functionResponseTypes;
    }

    public final String uuid() {
        return this.uuid;
    }

    public final EventSourcePosition startingPosition() {
        return EventSourcePosition.fromValue(this.startingPosition);
    }

    public final String startingPositionAsString() {
        return this.startingPosition;
    }

    public final Instant startingPositionTimestamp() {
        return this.startingPositionTimestamp;
    }

    public final Integer batchSize() {
        return this.batchSize;
    }

    public final Integer maximumBatchingWindowInSeconds() {
        return this.maximumBatchingWindowInSeconds;
    }

    public final Integer parallelizationFactor() {
        return this.parallelizationFactor;
    }

    public final String eventSourceArn() {
        return this.eventSourceArn;
    }

    public final FilterCriteria filterCriteria() {
        return this.filterCriteria;
    }

    public final String functionArn() {
        return this.functionArn;
    }

    public final Instant lastModified() {
        return this.lastModified;
    }

    public final String lastProcessingResult() {
        return this.lastProcessingResult;
    }

    public final String state() {
        return this.state;
    }

    public final String stateTransitionReason() {
        return this.stateTransitionReason;
    }

    public final DestinationConfig destinationConfig() {
        return this.destinationConfig;
    }

    public final boolean hasTopics() {
        return this.topics != null && !(this.topics instanceof SdkAutoConstructList);
    }

    public final List<String> topics() {
        return this.topics;
    }

    public final boolean hasQueues() {
        return this.queues != null && !(this.queues instanceof SdkAutoConstructList);
    }

    public final List<String> queues() {
        return this.queues;
    }

    public final boolean hasSourceAccessConfigurations() {
        return this.sourceAccessConfigurations != null && !(this.sourceAccessConfigurations instanceof SdkAutoConstructList);
    }

    public final List<SourceAccessConfiguration> sourceAccessConfigurations() {
        return this.sourceAccessConfigurations;
    }

    public final SelfManagedEventSource selfManagedEventSource() {
        return this.selfManagedEventSource;
    }

    public final Integer maximumRecordAgeInSeconds() {
        return this.maximumRecordAgeInSeconds;
    }

    public final Boolean bisectBatchOnFunctionError() {
        return this.bisectBatchOnFunctionError;
    }

    public final Integer maximumRetryAttempts() {
        return this.maximumRetryAttempts;
    }

    public final Integer tumblingWindowInSeconds() {
        return this.tumblingWindowInSeconds;
    }

    public final List<FunctionResponseType> functionResponseTypes() {
        return FunctionResponseTypeListCopier.copyStringToEnum(this.functionResponseTypes);
    }

    public final boolean hasFunctionResponseTypes() {
        return this.functionResponseTypes != null && !(this.functionResponseTypes instanceof SdkAutoConstructList);
    }

    public final List<String> functionResponseTypesAsStrings() {
        return this.functionResponseTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.uuid());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingPositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingPositionTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumBatchingWindowInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelizationFactor());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastProcessingResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateTransitionReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopics() ? this.topics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueues() ? this.queues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceAccessConfigurations() ? this.sourceAccessConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.selfManagedEventSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumRecordAgeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.bisectBatchOnFunctionError());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumRetryAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(this.tumblingWindowInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFunctionResponseTypes() ? this.functionResponseTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventSourceMappingConfiguration)) {
            return false;
        }
        EventSourceMappingConfiguration other = (EventSourceMappingConfiguration)obj;
        return Objects.equals(this.uuid(), other.uuid()) && Objects.equals(this.startingPositionAsString(), other.startingPositionAsString()) && Objects.equals(this.startingPositionTimestamp(), other.startingPositionTimestamp()) && Objects.equals(this.batchSize(), other.batchSize()) && Objects.equals(this.maximumBatchingWindowInSeconds(), other.maximumBatchingWindowInSeconds()) && Objects.equals(this.parallelizationFactor(), other.parallelizationFactor()) && Objects.equals(this.eventSourceArn(), other.eventSourceArn()) && Objects.equals(this.filterCriteria(), other.filterCriteria()) && Objects.equals(this.functionArn(), other.functionArn()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.lastProcessingResult(), other.lastProcessingResult()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.stateTransitionReason(), other.stateTransitionReason()) && Objects.equals(this.destinationConfig(), other.destinationConfig()) && this.hasTopics() == other.hasTopics() && Objects.equals(this.topics(), other.topics()) && this.hasQueues() == other.hasQueues() && Objects.equals(this.queues(), other.queues()) && this.hasSourceAccessConfigurations() == other.hasSourceAccessConfigurations() && Objects.equals(this.sourceAccessConfigurations(), other.sourceAccessConfigurations()) && Objects.equals(this.selfManagedEventSource(), other.selfManagedEventSource()) && Objects.equals(this.maximumRecordAgeInSeconds(), other.maximumRecordAgeInSeconds()) && Objects.equals(this.bisectBatchOnFunctionError(), other.bisectBatchOnFunctionError()) && Objects.equals(this.maximumRetryAttempts(), other.maximumRetryAttempts()) && Objects.equals(this.tumblingWindowInSeconds(), other.tumblingWindowInSeconds()) && this.hasFunctionResponseTypes() == other.hasFunctionResponseTypes() && Objects.equals(this.functionResponseTypesAsStrings(), other.functionResponseTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"EventSourceMappingConfiguration").add("UUID", (Object)this.uuid()).add("StartingPosition", (Object)this.startingPositionAsString()).add("StartingPositionTimestamp", (Object)this.startingPositionTimestamp()).add("BatchSize", (Object)this.batchSize()).add("MaximumBatchingWindowInSeconds", (Object)this.maximumBatchingWindowInSeconds()).add("ParallelizationFactor", (Object)this.parallelizationFactor()).add("EventSourceArn", (Object)this.eventSourceArn()).add("FilterCriteria", (Object)this.filterCriteria()).add("FunctionArn", (Object)this.functionArn()).add("LastModified", (Object)this.lastModified()).add("LastProcessingResult", (Object)this.lastProcessingResult()).add("State", (Object)this.state()).add("StateTransitionReason", (Object)this.stateTransitionReason()).add("DestinationConfig", (Object)this.destinationConfig()).add("Topics", this.hasTopics() ? this.topics() : null).add("Queues", this.hasQueues() ? this.queues() : null).add("SourceAccessConfigurations", this.hasSourceAccessConfigurations() ? this.sourceAccessConfigurations() : null).add("SelfManagedEventSource", (Object)this.selfManagedEventSource()).add("MaximumRecordAgeInSeconds", (Object)this.maximumRecordAgeInSeconds()).add("BisectBatchOnFunctionError", (Object)this.bisectBatchOnFunctionError()).add("MaximumRetryAttempts", (Object)this.maximumRetryAttempts()).add("TumblingWindowInSeconds", (Object)this.tumblingWindowInSeconds()).add("FunctionResponseTypes", this.hasFunctionResponseTypes() ? this.functionResponseTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UUID": {
                return Optional.ofNullable(clazz.cast(this.uuid()));
            }
            case "StartingPosition": {
                return Optional.ofNullable(clazz.cast(this.startingPositionAsString()));
            }
            case "StartingPositionTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startingPositionTimestamp()));
            }
            case "BatchSize": {
                return Optional.ofNullable(clazz.cast(this.batchSize()));
            }
            case "MaximumBatchingWindowInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maximumBatchingWindowInSeconds()));
            }
            case "ParallelizationFactor": {
                return Optional.ofNullable(clazz.cast(this.parallelizationFactor()));
            }
            case "EventSourceArn": {
                return Optional.ofNullable(clazz.cast(this.eventSourceArn()));
            }
            case "FilterCriteria": {
                return Optional.ofNullable(clazz.cast(this.filterCriteria()));
            }
            case "FunctionArn": {
                return Optional.ofNullable(clazz.cast(this.functionArn()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "LastProcessingResult": {
                return Optional.ofNullable(clazz.cast(this.lastProcessingResult()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "StateTransitionReason": {
                return Optional.ofNullable(clazz.cast(this.stateTransitionReason()));
            }
            case "DestinationConfig": {
                return Optional.ofNullable(clazz.cast(this.destinationConfig()));
            }
            case "Topics": {
                return Optional.ofNullable(clazz.cast(this.topics()));
            }
            case "Queues": {
                return Optional.ofNullable(clazz.cast(this.queues()));
            }
            case "SourceAccessConfigurations": {
                return Optional.ofNullable(clazz.cast(this.sourceAccessConfigurations()));
            }
            case "SelfManagedEventSource": {
                return Optional.ofNullable(clazz.cast(this.selfManagedEventSource()));
            }
            case "MaximumRecordAgeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maximumRecordAgeInSeconds()));
            }
            case "BisectBatchOnFunctionError": {
                return Optional.ofNullable(clazz.cast(this.bisectBatchOnFunctionError()));
            }
            case "MaximumRetryAttempts": {
                return Optional.ofNullable(clazz.cast(this.maximumRetryAttempts()));
            }
            case "TumblingWindowInSeconds": {
                return Optional.ofNullable(clazz.cast(this.tumblingWindowInSeconds()));
            }
            case "FunctionResponseTypes": {
                return Optional.ofNullable(clazz.cast(this.functionResponseTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventSourceMappingConfiguration, T> g) {
        return obj -> g.apply((EventSourceMappingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String uuid;
        private String startingPosition;
        private Instant startingPositionTimestamp;
        private Integer batchSize;
        private Integer maximumBatchingWindowInSeconds;
        private Integer parallelizationFactor;
        private String eventSourceArn;
        private FilterCriteria filterCriteria;
        private String functionArn;
        private Instant lastModified;
        private String lastProcessingResult;
        private String state;
        private String stateTransitionReason;
        private DestinationConfig destinationConfig;
        private List<String> topics = DefaultSdkAutoConstructList.getInstance();
        private List<String> queues = DefaultSdkAutoConstructList.getInstance();
        private List<SourceAccessConfiguration> sourceAccessConfigurations = DefaultSdkAutoConstructList.getInstance();
        private SelfManagedEventSource selfManagedEventSource;
        private Integer maximumRecordAgeInSeconds;
        private Boolean bisectBatchOnFunctionError;
        private Integer maximumRetryAttempts;
        private Integer tumblingWindowInSeconds;
        private List<String> functionResponseTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventSourceMappingConfiguration model) {
            this.uuid(model.uuid);
            this.startingPosition(model.startingPosition);
            this.startingPositionTimestamp(model.startingPositionTimestamp);
            this.batchSize(model.batchSize);
            this.maximumBatchingWindowInSeconds(model.maximumBatchingWindowInSeconds);
            this.parallelizationFactor(model.parallelizationFactor);
            this.eventSourceArn(model.eventSourceArn);
            this.filterCriteria(model.filterCriteria);
            this.functionArn(model.functionArn);
            this.lastModified(model.lastModified);
            this.lastProcessingResult(model.lastProcessingResult);
            this.state(model.state);
            this.stateTransitionReason(model.stateTransitionReason);
            this.destinationConfig(model.destinationConfig);
            this.topics(model.topics);
            this.queues(model.queues);
            this.sourceAccessConfigurations(model.sourceAccessConfigurations);
            this.selfManagedEventSource(model.selfManagedEventSource);
            this.maximumRecordAgeInSeconds(model.maximumRecordAgeInSeconds);
            this.bisectBatchOnFunctionError(model.bisectBatchOnFunctionError);
            this.maximumRetryAttempts(model.maximumRetryAttempts);
            this.tumblingWindowInSeconds(model.tumblingWindowInSeconds);
            this.functionResponseTypesWithStrings(model.functionResponseTypes);
        }

        public final String getUuid() {
            return this.uuid;
        }

        public final void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public final String getStartingPosition() {
            return this.startingPosition;
        }

        public final void setStartingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
        }

        @Override
        public final Builder startingPosition(String startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        @Override
        public final Builder startingPosition(EventSourcePosition startingPosition) {
            this.startingPosition(startingPosition == null ? null : startingPosition.toString());
            return this;
        }

        public final Instant getStartingPositionTimestamp() {
            return this.startingPositionTimestamp;
        }

        public final void setStartingPositionTimestamp(Instant startingPositionTimestamp) {
            this.startingPositionTimestamp = startingPositionTimestamp;
        }

        @Override
        public final Builder startingPositionTimestamp(Instant startingPositionTimestamp) {
            this.startingPositionTimestamp = startingPositionTimestamp;
            return this;
        }

        public final Integer getBatchSize() {
            return this.batchSize;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final Integer getMaximumBatchingWindowInSeconds() {
            return this.maximumBatchingWindowInSeconds;
        }

        public final void setMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
        }

        @Override
        public final Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        public final Integer getParallelizationFactor() {
            return this.parallelizationFactor;
        }

        public final void setParallelizationFactor(Integer parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
        }

        @Override
        public final Builder parallelizationFactor(Integer parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
            return this;
        }

        public final String getEventSourceArn() {
            return this.eventSourceArn;
        }

        public final void setEventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
        }

        @Override
        public final Builder eventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        public final FilterCriteria.Builder getFilterCriteria() {
            return this.filterCriteria != null ? this.filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(FilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(FilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final String getFunctionArn() {
            return this.functionArn;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final String getLastProcessingResult() {
            return this.lastProcessingResult;
        }

        public final void setLastProcessingResult(String lastProcessingResult) {
            this.lastProcessingResult = lastProcessingResult;
        }

        @Override
        public final Builder lastProcessingResult(String lastProcessingResult) {
            this.lastProcessingResult = lastProcessingResult;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getStateTransitionReason() {
            return this.stateTransitionReason;
        }

        public final void setStateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
        }

        @Override
        public final Builder stateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
            return this;
        }

        public final DestinationConfig.Builder getDestinationConfig() {
            return this.destinationConfig != null ? this.destinationConfig.toBuilder() : null;
        }

        public final void setDestinationConfig(DestinationConfig.BuilderImpl destinationConfig) {
            this.destinationConfig = destinationConfig != null ? destinationConfig.build() : null;
        }

        @Override
        public final Builder destinationConfig(DestinationConfig destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        public final Collection<String> getTopics() {
            if (this.topics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.topics;
        }

        public final void setTopics(Collection<String> topics) {
            this.topics = TopicsCopier.copy(topics);
        }

        @Override
        public final Builder topics(Collection<String> topics) {
            this.topics = TopicsCopier.copy(topics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topics(String ... topics) {
            this.topics(Arrays.asList(topics));
            return this;
        }

        public final Collection<String> getQueues() {
            if (this.queues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.queues;
        }

        public final void setQueues(Collection<String> queues) {
            this.queues = QueuesCopier.copy(queues);
        }

        @Override
        public final Builder queues(Collection<String> queues) {
            this.queues = QueuesCopier.copy(queues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(String ... queues) {
            this.queues(Arrays.asList(queues));
            return this;
        }

        public final List<SourceAccessConfiguration.Builder> getSourceAccessConfigurations() {
            List<SourceAccessConfiguration.Builder> result = SourceAccessConfigurationsCopier.copyToBuilder(this.sourceAccessConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceAccessConfigurations(Collection<SourceAccessConfiguration.BuilderImpl> sourceAccessConfigurations) {
            this.sourceAccessConfigurations = SourceAccessConfigurationsCopier.copyFromBuilder(sourceAccessConfigurations);
        }

        @Override
        public final Builder sourceAccessConfigurations(Collection<SourceAccessConfiguration> sourceAccessConfigurations) {
            this.sourceAccessConfigurations = SourceAccessConfigurationsCopier.copy(sourceAccessConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAccessConfigurations(SourceAccessConfiguration ... sourceAccessConfigurations) {
            this.sourceAccessConfigurations(Arrays.asList(sourceAccessConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAccessConfigurations(Consumer<SourceAccessConfiguration.Builder> ... sourceAccessConfigurations) {
            this.sourceAccessConfigurations(Stream.of(sourceAccessConfigurations).map(c -> (SourceAccessConfiguration)((SourceAccessConfiguration.Builder)SourceAccessConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SelfManagedEventSource.Builder getSelfManagedEventSource() {
            return this.selfManagedEventSource != null ? this.selfManagedEventSource.toBuilder() : null;
        }

        public final void setSelfManagedEventSource(SelfManagedEventSource.BuilderImpl selfManagedEventSource) {
            this.selfManagedEventSource = selfManagedEventSource != null ? selfManagedEventSource.build() : null;
        }

        @Override
        public final Builder selfManagedEventSource(SelfManagedEventSource selfManagedEventSource) {
            this.selfManagedEventSource = selfManagedEventSource;
            return this;
        }

        public final Integer getMaximumRecordAgeInSeconds() {
            return this.maximumRecordAgeInSeconds;
        }

        public final void setMaximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
        }

        @Override
        public final Builder maximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
            return this;
        }

        public final Boolean getBisectBatchOnFunctionError() {
            return this.bisectBatchOnFunctionError;
        }

        public final void setBisectBatchOnFunctionError(Boolean bisectBatchOnFunctionError) {
            this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
        }

        @Override
        public final Builder bisectBatchOnFunctionError(Boolean bisectBatchOnFunctionError) {
            this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
            return this;
        }

        public final Integer getMaximumRetryAttempts() {
            return this.maximumRetryAttempts;
        }

        public final void setMaximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
        }

        @Override
        public final Builder maximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
            return this;
        }

        public final Integer getTumblingWindowInSeconds() {
            return this.tumblingWindowInSeconds;
        }

        public final void setTumblingWindowInSeconds(Integer tumblingWindowInSeconds) {
            this.tumblingWindowInSeconds = tumblingWindowInSeconds;
        }

        @Override
        public final Builder tumblingWindowInSeconds(Integer tumblingWindowInSeconds) {
            this.tumblingWindowInSeconds = tumblingWindowInSeconds;
            return this;
        }

        public final Collection<String> getFunctionResponseTypes() {
            if (this.functionResponseTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.functionResponseTypes;
        }

        public final void setFunctionResponseTypes(Collection<String> functionResponseTypes) {
            this.functionResponseTypes = FunctionResponseTypeListCopier.copy(functionResponseTypes);
        }

        @Override
        public final Builder functionResponseTypesWithStrings(Collection<String> functionResponseTypes) {
            this.functionResponseTypes = FunctionResponseTypeListCopier.copy(functionResponseTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionResponseTypesWithStrings(String ... functionResponseTypes) {
            this.functionResponseTypesWithStrings(Arrays.asList(functionResponseTypes));
            return this;
        }

        @Override
        public final Builder functionResponseTypes(Collection<FunctionResponseType> functionResponseTypes) {
            this.functionResponseTypes = FunctionResponseTypeListCopier.copyEnumToString(functionResponseTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionResponseTypes(FunctionResponseType ... functionResponseTypes) {
            this.functionResponseTypes(Arrays.asList(functionResponseTypes));
            return this;
        }

        public EventSourceMappingConfiguration build() {
            return new EventSourceMappingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventSourceMappingConfiguration> {
        public Builder uuid(String var1);

        public Builder startingPosition(String var1);

        public Builder startingPosition(EventSourcePosition var1);

        public Builder startingPositionTimestamp(Instant var1);

        public Builder batchSize(Integer var1);

        public Builder maximumBatchingWindowInSeconds(Integer var1);

        public Builder parallelizationFactor(Integer var1);

        public Builder eventSourceArn(String var1);

        public Builder filterCriteria(FilterCriteria var1);

        default public Builder filterCriteria(Consumer<FilterCriteria.Builder> filterCriteria) {
            return this.filterCriteria((FilterCriteria)((FilterCriteria.Builder)FilterCriteria.builder().applyMutation(filterCriteria)).build());
        }

        public Builder functionArn(String var1);

        public Builder lastModified(Instant var1);

        public Builder lastProcessingResult(String var1);

        public Builder state(String var1);

        public Builder stateTransitionReason(String var1);

        public Builder destinationConfig(DestinationConfig var1);

        default public Builder destinationConfig(Consumer<DestinationConfig.Builder> destinationConfig) {
            return this.destinationConfig((DestinationConfig)((DestinationConfig.Builder)DestinationConfig.builder().applyMutation(destinationConfig)).build());
        }

        public Builder topics(Collection<String> var1);

        public Builder topics(String ... var1);

        public Builder queues(Collection<String> var1);

        public Builder queues(String ... var1);

        public Builder sourceAccessConfigurations(Collection<SourceAccessConfiguration> var1);

        public Builder sourceAccessConfigurations(SourceAccessConfiguration ... var1);

        public Builder sourceAccessConfigurations(Consumer<SourceAccessConfiguration.Builder> ... var1);

        public Builder selfManagedEventSource(SelfManagedEventSource var1);

        default public Builder selfManagedEventSource(Consumer<SelfManagedEventSource.Builder> selfManagedEventSource) {
            return this.selfManagedEventSource((SelfManagedEventSource)((SelfManagedEventSource.Builder)SelfManagedEventSource.builder().applyMutation(selfManagedEventSource)).build());
        }

        public Builder maximumRecordAgeInSeconds(Integer var1);

        public Builder bisectBatchOnFunctionError(Boolean var1);

        public Builder maximumRetryAttempts(Integer var1);

        public Builder tumblingWindowInSeconds(Integer var1);

        public Builder functionResponseTypesWithStrings(Collection<String> var1);

        public Builder functionResponseTypesWithStrings(String ... var1);

        public Builder functionResponseTypes(Collection<FunctionResponseType> var1);

        public Builder functionResponseTypes(FunctionResponseType ... var1);
    }
}

