/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
 * layer</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LayerVersionsListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<LayerVersionsListItem.Builder, LayerVersionsListItem> {
    private static final SdkField<String> LAYER_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LayerVersionArn").getter(getter(LayerVersionsListItem::layerVersionArn))
            .setter(setter(Builder::layerVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerVersionArn").build()).build();

    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Version")
            .getter(getter(LayerVersionsListItem::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(LayerVersionsListItem::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CREATED_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedDate").getter(getter(LayerVersionsListItem::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final SdkField<List<String>> COMPATIBLE_RUNTIMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CompatibleRuntimes")
            .getter(getter(LayerVersionsListItem::compatibleRuntimesAsStrings))
            .setter(setter(Builder::compatibleRuntimesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompatibleRuntimes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LICENSE_INFO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseInfo").getter(getter(LayerVersionsListItem::licenseInfo)).setter(setter(Builder::licenseInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYER_VERSION_ARN_FIELD,
            VERSION_FIELD, DESCRIPTION_FIELD, CREATED_DATE_FIELD, COMPATIBLE_RUNTIMES_FIELD, LICENSE_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String layerVersionArn;

    private final Long version;

    private final String description;

    private final String createdDate;

    private final List<String> compatibleRuntimes;

    private final String licenseInfo;

    private LayerVersionsListItem(BuilderImpl builder) {
        this.layerVersionArn = builder.layerVersionArn;
        this.version = builder.version;
        this.description = builder.description;
        this.createdDate = builder.createdDate;
        this.compatibleRuntimes = builder.compatibleRuntimes;
        this.licenseInfo = builder.licenseInfo;
    }

    /**
     * <p>
     * The ARN of the layer version.
     * </p>
     * 
     * @return The ARN of the layer version.
     */
    public final String layerVersionArn() {
        return layerVersionArn;
    }

    /**
     * <p>
     * The version number.
     * </p>
     * 
     * @return The version number.
     */
    public final Long version() {
        return version;
    }

    /**
     * <p>
     * The description of the version.
     * </p>
     * 
     * @return The description of the version.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The date that the version was created, in ISO 8601 format. For example, <code>2018-11-27T15:10:45.123+0000</code>
     * .
     * </p>
     * 
     * @return The date that the version was created, in ISO 8601 format. For example,
     *         <code>2018-11-27T15:10:45.123+0000</code>.
     */
    public final String createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The layer's compatible runtimes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompatibleRuntimes} method.
     * </p>
     * 
     * @return The layer's compatible runtimes.
     */
    public final List<Runtime> compatibleRuntimes() {
        return CompatibleRuntimesCopier.copyStringToEnum(compatibleRuntimes);
    }

    /**
     * For responses, this returns true if the service returned a value for the CompatibleRuntimes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCompatibleRuntimes() {
        return compatibleRuntimes != null && !(compatibleRuntimes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The layer's compatible runtimes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompatibleRuntimes} method.
     * </p>
     * 
     * @return The layer's compatible runtimes.
     */
    public final List<String> compatibleRuntimesAsStrings() {
        return compatibleRuntimes;
    }

    /**
     * <p>
     * The layer's open-source license.
     * </p>
     * 
     * @return The layer's open-source license.
     */
    public final String licenseInfo() {
        return licenseInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(layerVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasCompatibleRuntimes() ? compatibleRuntimesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(licenseInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayerVersionsListItem)) {
            return false;
        }
        LayerVersionsListItem other = (LayerVersionsListItem) obj;
        return Objects.equals(layerVersionArn(), other.layerVersionArn()) && Objects.equals(version(), other.version())
                && Objects.equals(description(), other.description()) && Objects.equals(createdDate(), other.createdDate())
                && hasCompatibleRuntimes() == other.hasCompatibleRuntimes()
                && Objects.equals(compatibleRuntimesAsStrings(), other.compatibleRuntimesAsStrings())
                && Objects.equals(licenseInfo(), other.licenseInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LayerVersionsListItem").add("LayerVersionArn", layerVersionArn()).add("Version", version())
                .add("Description", description()).add("CreatedDate", createdDate())
                .add("CompatibleRuntimes", hasCompatibleRuntimes() ? compatibleRuntimesAsStrings() : null)
                .add("LicenseInfo", licenseInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LayerVersionArn":
            return Optional.ofNullable(clazz.cast(layerVersionArn()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "CompatibleRuntimes":
            return Optional.ofNullable(clazz.cast(compatibleRuntimesAsStrings()));
        case "LicenseInfo":
            return Optional.ofNullable(clazz.cast(licenseInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LayerVersionsListItem, T> g) {
        return obj -> g.apply((LayerVersionsListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LayerVersionsListItem> {
        /**
         * <p>
         * The ARN of the layer version.
         * </p>
         * 
         * @param layerVersionArn
         *        The ARN of the layer version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerVersionArn(String layerVersionArn);

        /**
         * <p>
         * The version number.
         * </p>
         * 
         * @param version
         *        The version number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);

        /**
         * <p>
         * The description of the version.
         * </p>
         * 
         * @param description
         *        The description of the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date that the version was created, in ISO 8601 format. For example,
         * <code>2018-11-27T15:10:45.123+0000</code>.
         * </p>
         * 
         * @param createdDate
         *        The date that the version was created, in ISO 8601 format. For example,
         *        <code>2018-11-27T15:10:45.123+0000</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(String createdDate);

        /**
         * <p>
         * The layer's compatible runtimes.
         * </p>
         * 
         * @param compatibleRuntimes
         *        The layer's compatible runtimes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleRuntimesWithStrings(Collection<String> compatibleRuntimes);

        /**
         * <p>
         * The layer's compatible runtimes.
         * </p>
         * 
         * @param compatibleRuntimes
         *        The layer's compatible runtimes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleRuntimesWithStrings(String... compatibleRuntimes);

        /**
         * <p>
         * The layer's compatible runtimes.
         * </p>
         * 
         * @param compatibleRuntimes
         *        The layer's compatible runtimes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleRuntimes(Collection<Runtime> compatibleRuntimes);

        /**
         * <p>
         * The layer's compatible runtimes.
         * </p>
         * 
         * @param compatibleRuntimes
         *        The layer's compatible runtimes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleRuntimes(Runtime... compatibleRuntimes);

        /**
         * <p>
         * The layer's open-source license.
         * </p>
         * 
         * @param licenseInfo
         *        The layer's open-source license.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseInfo(String licenseInfo);
    }

    static final class BuilderImpl implements Builder {
        private String layerVersionArn;

        private Long version;

        private String description;

        private String createdDate;

        private List<String> compatibleRuntimes = DefaultSdkAutoConstructList.getInstance();

        private String licenseInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(LayerVersionsListItem model) {
            layerVersionArn(model.layerVersionArn);
            version(model.version);
            description(model.description);
            createdDate(model.createdDate);
            compatibleRuntimesWithStrings(model.compatibleRuntimes);
            licenseInfo(model.licenseInfo);
        }

        public final String getLayerVersionArn() {
            return layerVersionArn;
        }

        public final void setLayerVersionArn(String layerVersionArn) {
            this.layerVersionArn = layerVersionArn;
        }

        @Override
        @Transient
        public final Builder layerVersionArn(String layerVersionArn) {
            this.layerVersionArn = layerVersionArn;
            return this;
        }

        public final Long getVersion() {
            return version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        @Transient
        public final Builder createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Collection<String> getCompatibleRuntimes() {
            if (compatibleRuntimes instanceof SdkAutoConstructList) {
                return null;
            }
            return compatibleRuntimes;
        }

        public final void setCompatibleRuntimes(Collection<String> compatibleRuntimes) {
            this.compatibleRuntimes = CompatibleRuntimesCopier.copy(compatibleRuntimes);
        }

        @Override
        @Transient
        public final Builder compatibleRuntimesWithStrings(Collection<String> compatibleRuntimes) {
            this.compatibleRuntimes = CompatibleRuntimesCopier.copy(compatibleRuntimes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder compatibleRuntimesWithStrings(String... compatibleRuntimes) {
            compatibleRuntimesWithStrings(Arrays.asList(compatibleRuntimes));
            return this;
        }

        @Override
        @Transient
        public final Builder compatibleRuntimes(Collection<Runtime> compatibleRuntimes) {
            this.compatibleRuntimes = CompatibleRuntimesCopier.copyEnumToString(compatibleRuntimes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder compatibleRuntimes(Runtime... compatibleRuntimes) {
            compatibleRuntimes(Arrays.asList(compatibleRuntimes));
            return this;
        }

        public final String getLicenseInfo() {
            return licenseInfo;
        }

        public final void setLicenseInfo(String licenseInfo) {
            this.licenseInfo = licenseInfo;
        }

        @Override
        @Transient
        public final Builder licenseInfo(String licenseInfo) {
            this.licenseInfo = licenseInfo;
            return this;
        }

        @Override
        public LayerVersionsListItem build() {
            return new LayerVersionsListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
