/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEventSourceMappingRequest extends LambdaRequest implements
        ToCopyableBuilder<UpdateEventSourceMappingRequest.Builder, UpdateEventSourceMappingRequest> {
    private static final SdkField<String> UUID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UUID")
            .getter(getter(UpdateEventSourceMappingRequest::uuid)).setter(setter(Builder::uuid))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("UUID").build()).build();

    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionName").getter(getter(UpdateEventSourceMappingRequest::functionName))
            .setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(UpdateEventSourceMappingRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BatchSize").getter(getter(UpdateEventSourceMappingRequest::batchSize))
            .setter(setter(Builder::batchSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()).build();

    private static final SdkField<Integer> MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumBatchingWindowInSeconds")
            .getter(getter(UpdateEventSourceMappingRequest::maximumBatchingWindowInSeconds))
            .setter(setter(Builder::maximumBatchingWindowInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchingWindowInSeconds")
                    .build()).build();

    private static final SdkField<DestinationConfig> DESTINATION_CONFIG_FIELD = SdkField
            .<DestinationConfig> builder(MarshallingType.SDK_POJO).memberName("DestinationConfig")
            .getter(getter(UpdateEventSourceMappingRequest::destinationConfig)).setter(setter(Builder::destinationConfig))
            .constructor(DestinationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationConfig").build()).build();

    private static final SdkField<Integer> MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaximumRecordAgeInSeconds")
            .getter(getter(UpdateEventSourceMappingRequest::maximumRecordAgeInSeconds))
            .setter(setter(Builder::maximumRecordAgeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRecordAgeInSeconds").build())
            .build();

    private static final SdkField<Boolean> BISECT_BATCH_ON_FUNCTION_ERROR_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("BisectBatchOnFunctionError")
            .getter(getter(UpdateEventSourceMappingRequest::bisectBatchOnFunctionError))
            .setter(setter(Builder::bisectBatchOnFunctionError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BisectBatchOnFunctionError").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_RETRY_ATTEMPTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumRetryAttempts").getter(getter(UpdateEventSourceMappingRequest::maximumRetryAttempts))
            .setter(setter(Builder::maximumRetryAttempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRetryAttempts").build())
            .build();

    private static final SdkField<Integer> PARALLELIZATION_FACTOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParallelizationFactor").getter(getter(UpdateEventSourceMappingRequest::parallelizationFactor))
            .setter(setter(Builder::parallelizationFactor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelizationFactor").build())
            .build();

    private static final SdkField<List<SourceAccessConfiguration>> SOURCE_ACCESS_CONFIGURATIONS_FIELD = SdkField
            .<List<SourceAccessConfiguration>> builder(MarshallingType.LIST)
            .memberName("SourceAccessConfigurations")
            .getter(getter(UpdateEventSourceMappingRequest::sourceAccessConfigurations))
            .setter(setter(Builder::sourceAccessConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAccessConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SourceAccessConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(SourceAccessConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TUMBLING_WINDOW_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TumblingWindowInSeconds").getter(getter(UpdateEventSourceMappingRequest::tumblingWindowInSeconds))
            .setter(setter(Builder::tumblingWindowInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TumblingWindowInSeconds").build())
            .build();

    private static final SdkField<List<String>> FUNCTION_RESPONSE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FunctionResponseTypes")
            .getter(getter(UpdateEventSourceMappingRequest::functionResponseTypesAsStrings))
            .setter(setter(Builder::functionResponseTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionResponseTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UUID_FIELD,
            FUNCTION_NAME_FIELD, ENABLED_FIELD, BATCH_SIZE_FIELD, MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD,
            DESTINATION_CONFIG_FIELD, MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD, BISECT_BATCH_ON_FUNCTION_ERROR_FIELD,
            MAXIMUM_RETRY_ATTEMPTS_FIELD, PARALLELIZATION_FACTOR_FIELD, SOURCE_ACCESS_CONFIGURATIONS_FIELD,
            TUMBLING_WINDOW_IN_SECONDS_FIELD, FUNCTION_RESPONSE_TYPES_FIELD));

    private final String uuid;

    private final String functionName;

    private final Boolean enabled;

    private final Integer batchSize;

    private final Integer maximumBatchingWindowInSeconds;

    private final DestinationConfig destinationConfig;

    private final Integer maximumRecordAgeInSeconds;

    private final Boolean bisectBatchOnFunctionError;

    private final Integer maximumRetryAttempts;

    private final Integer parallelizationFactor;

    private final List<SourceAccessConfiguration> sourceAccessConfigurations;

    private final Integer tumblingWindowInSeconds;

    private final List<String> functionResponseTypes;

    private UpdateEventSourceMappingRequest(BuilderImpl builder) {
        super(builder);
        this.uuid = builder.uuid;
        this.functionName = builder.functionName;
        this.enabled = builder.enabled;
        this.batchSize = builder.batchSize;
        this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
        this.destinationConfig = builder.destinationConfig;
        this.maximumRecordAgeInSeconds = builder.maximumRecordAgeInSeconds;
        this.bisectBatchOnFunctionError = builder.bisectBatchOnFunctionError;
        this.maximumRetryAttempts = builder.maximumRetryAttempts;
        this.parallelizationFactor = builder.parallelizationFactor;
        this.sourceAccessConfigurations = builder.sourceAccessConfigurations;
        this.tumblingWindowInSeconds = builder.tumblingWindowInSeconds;
        this.functionResponseTypes = builder.functionResponseTypes;
    }

    /**
     * <p>
     * The identifier of the event source mapping.
     * </p>
     * 
     * @return The identifier of the event source mapping.
     */
    public final String uuid() {
        return uuid;
    }

    /**
     * <p>
     * The name of the Lambda function.
     * </p>
     * <p class="title">
     * <b>Name formats</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Function name</b> - <code>MyFunction</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64
     * characters in length.
     * </p>
     * 
     * @return The name of the Lambda function.</p>
     *         <p class="title">
     *         <b>Name formats</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Function name</b> - <code>MyFunction</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The length constraint applies only to the full ARN. If you specify only the function name, it's limited
     *         to 64 characters in length.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * When true, the event source mapping is active. When false, Lambda pauses polling and invocation.
     * </p>
     * <p>
     * Default: True
     * </p>
     * 
     * @return When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p>
     *         <p>
     *         Default: True
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your
     * function. Lambda passes all of the records in the batch to the function in a single call, up to the payload limit
     * for synchronous invocation (6 MB).
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Amazon Kinesis</b> - Default 100. Max 10,000.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon Simple Queue Service</b> - Default 10. For standard queues the max is 10,000. For FIFO queues the max
     * is 10.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon Managed Streaming for Apache Kafka</b> - Default 100. Max 10,000.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Self-Managed Apache Kafka</b> - Default 100. Max 10,000.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your
     *         function. Lambda passes all of the records in the batch to the function in a single call, up to the
     *         payload limit for synchronous invocation (6 MB).</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Amazon Kinesis</b> - Default 100. Max 10,000.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Amazon Simple Queue Service</b> - Default 10. For standard queues the max is 10,000. For FIFO queues
     *         the max is 10.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Amazon Managed Streaming for Apache Kafka</b> - Default 100. Max 10,000.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Self-Managed Apache Kafka</b> - Default 100. Max 10,000.
     *         </p>
     *         </li>
     */
    public final Integer batchSize() {
        return batchSize;
    }

    /**
     * <p>
     * (Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering
     * records before invoking the function.
     * </p>
     * <p>
     * Default: 0
     * </p>
     * <p>
     * Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set
     * <code>MaximumBatchingWindowInSeconds</code> to at least 1.
     * </p>
     * 
     * @return (Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends
     *         gathering records before invoking the function.</p>
     *         <p>
     *         Default: 0
     *         </p>
     *         <p>
     *         Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set
     *         <code>MaximumBatchingWindowInSeconds</code> to at least 1.
     */
    public final Integer maximumBatchingWindowInSeconds() {
        return maximumBatchingWindowInSeconds;
    }

    /**
     * <p>
     * (Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
     * </p>
     * 
     * @return (Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
     */
    public final DestinationConfig destinationConfig() {
        return destinationConfig;
    }

    /**
     * <p>
     * (Streams only) Discard records older than the specified age. The default value is infinite (-1).
     * </p>
     * 
     * @return (Streams only) Discard records older than the specified age. The default value is infinite (-1).
     */
    public final Integer maximumRecordAgeInSeconds() {
        return maximumRecordAgeInSeconds;
    }

    /**
     * <p>
     * (Streams only) If the function returns an error, split the batch in two and retry.
     * </p>
     * 
     * @return (Streams only) If the function returns an error, split the batch in two and retry.
     */
    public final Boolean bisectBatchOnFunctionError() {
        return bisectBatchOnFunctionError;
    }

    /**
     * <p>
     * (Streams only) Discard records after the specified number of retries. The default value is infinite (-1). When
     * set to infinite (-1), failed records will be retried until the record expires.
     * </p>
     * 
     * @return (Streams only) Discard records after the specified number of retries. The default value is infinite (-1).
     *         When set to infinite (-1), failed records will be retried until the record expires.
     */
    public final Integer maximumRetryAttempts() {
        return maximumRetryAttempts;
    }

    /**
     * <p>
     * (Streams only) The number of batches to process from each shard concurrently.
     * </p>
     * 
     * @return (Streams only) The number of batches to process from each shard concurrently.
     */
    public final Integer parallelizationFactor() {
        return parallelizationFactor;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceAccessConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSourceAccessConfigurations() {
        return sourceAccessConfigurations != null && !(sourceAccessConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of authentication protocols or VPC components required to secure your event source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceAccessConfigurations} method.
     * </p>
     * 
     * @return An array of authentication protocols or VPC components required to secure your event source.
     */
    public final List<SourceAccessConfiguration> sourceAccessConfigurations() {
        return sourceAccessConfigurations;
    }

    /**
     * <p>
     * (Streams only) The duration in seconds of a processing window. The range is between 1 second up to 900 seconds.
     * </p>
     * 
     * @return (Streams only) The duration in seconds of a processing window. The range is between 1 second up to 900
     *         seconds.
     */
    public final Integer tumblingWindowInSeconds() {
        return tumblingWindowInSeconds;
    }

    /**
     * <p>
     * (Streams only) A list of current response type enums applied to the event source mapping.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFunctionResponseTypes} method.
     * </p>
     * 
     * @return (Streams only) A list of current response type enums applied to the event source mapping.
     */
    public final List<FunctionResponseType> functionResponseTypes() {
        return FunctionResponseTypeListCopier.copyStringToEnum(functionResponseTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the FunctionResponseTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFunctionResponseTypes() {
        return functionResponseTypes != null && !(functionResponseTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Streams only) A list of current response type enums applied to the event source mapping.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFunctionResponseTypes} method.
     * </p>
     * 
     * @return (Streams only) A list of current response type enums applied to the event source mapping.
     */
    public final List<String> functionResponseTypesAsStrings() {
        return functionResponseTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(uuid());
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(maximumBatchingWindowInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(maximumRecordAgeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(bisectBatchOnFunctionError());
        hashCode = 31 * hashCode + Objects.hashCode(maximumRetryAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(parallelizationFactor());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceAccessConfigurations() ? sourceAccessConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tumblingWindowInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasFunctionResponseTypes() ? functionResponseTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventSourceMappingRequest)) {
            return false;
        }
        UpdateEventSourceMappingRequest other = (UpdateEventSourceMappingRequest) obj;
        return Objects.equals(uuid(), other.uuid()) && Objects.equals(functionName(), other.functionName())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(batchSize(), other.batchSize())
                && Objects.equals(maximumBatchingWindowInSeconds(), other.maximumBatchingWindowInSeconds())
                && Objects.equals(destinationConfig(), other.destinationConfig())
                && Objects.equals(maximumRecordAgeInSeconds(), other.maximumRecordAgeInSeconds())
                && Objects.equals(bisectBatchOnFunctionError(), other.bisectBatchOnFunctionError())
                && Objects.equals(maximumRetryAttempts(), other.maximumRetryAttempts())
                && Objects.equals(parallelizationFactor(), other.parallelizationFactor())
                && hasSourceAccessConfigurations() == other.hasSourceAccessConfigurations()
                && Objects.equals(sourceAccessConfigurations(), other.sourceAccessConfigurations())
                && Objects.equals(tumblingWindowInSeconds(), other.tumblingWindowInSeconds())
                && hasFunctionResponseTypes() == other.hasFunctionResponseTypes()
                && Objects.equals(functionResponseTypesAsStrings(), other.functionResponseTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEventSourceMappingRequest").add("UUID", uuid()).add("FunctionName", functionName())
                .add("Enabled", enabled()).add("BatchSize", batchSize())
                .add("MaximumBatchingWindowInSeconds", maximumBatchingWindowInSeconds())
                .add("DestinationConfig", destinationConfig()).add("MaximumRecordAgeInSeconds", maximumRecordAgeInSeconds())
                .add("BisectBatchOnFunctionError", bisectBatchOnFunctionError())
                .add("MaximumRetryAttempts", maximumRetryAttempts()).add("ParallelizationFactor", parallelizationFactor())
                .add("SourceAccessConfigurations", hasSourceAccessConfigurations() ? sourceAccessConfigurations() : null)
                .add("TumblingWindowInSeconds", tumblingWindowInSeconds())
                .add("FunctionResponseTypes", hasFunctionResponseTypes() ? functionResponseTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UUID":
            return Optional.ofNullable(clazz.cast(uuid()));
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "BatchSize":
            return Optional.ofNullable(clazz.cast(batchSize()));
        case "MaximumBatchingWindowInSeconds":
            return Optional.ofNullable(clazz.cast(maximumBatchingWindowInSeconds()));
        case "DestinationConfig":
            return Optional.ofNullable(clazz.cast(destinationConfig()));
        case "MaximumRecordAgeInSeconds":
            return Optional.ofNullable(clazz.cast(maximumRecordAgeInSeconds()));
        case "BisectBatchOnFunctionError":
            return Optional.ofNullable(clazz.cast(bisectBatchOnFunctionError()));
        case "MaximumRetryAttempts":
            return Optional.ofNullable(clazz.cast(maximumRetryAttempts()));
        case "ParallelizationFactor":
            return Optional.ofNullable(clazz.cast(parallelizationFactor()));
        case "SourceAccessConfigurations":
            return Optional.ofNullable(clazz.cast(sourceAccessConfigurations()));
        case "TumblingWindowInSeconds":
            return Optional.ofNullable(clazz.cast(tumblingWindowInSeconds()));
        case "FunctionResponseTypes":
            return Optional.ofNullable(clazz.cast(functionResponseTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEventSourceMappingRequest, T> g) {
        return obj -> g.apply((UpdateEventSourceMappingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEventSourceMappingRequest> {
        /**
         * <p>
         * The identifier of the event source mapping.
         * </p>
         * 
         * @param uuid
         *        The identifier of the event source mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uuid(String uuid);

        /**
         * <p>
         * The name of the Lambda function.
         * </p>
         * <p class="title">
         * <b>Name formats</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Function name</b> - <code>MyFunction</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64
         * characters in length.
         * </p>
         * 
         * @param functionName
         *        The name of the Lambda function.</p>
         *        <p class="title">
         *        <b>Name formats</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Function name</b> - <code>MyFunction</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Version or Alias ARN</b> -
         *        <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The length constraint applies only to the full ARN. If you specify only the function name, it's
         *        limited to 64 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * When true, the event source mapping is active. When false, Lambda pauses polling and invocation.
         * </p>
         * <p>
         * Default: True
         * </p>
         * 
         * @param enabled
         *        When true, the event source mapping is active. When false, Lambda pauses polling and invocation.</p>
         *        <p>
         *        Default: True
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your
         * function. Lambda passes all of the records in the batch to the function in a single call, up to the payload
         * limit for synchronous invocation (6 MB).
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Amazon Kinesis</b> - Default 100. Max 10,000.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Amazon Simple Queue Service</b> - Default 10. For standard queues the max is 10,000. For FIFO queues the
         * max is 10.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Amazon Managed Streaming for Apache Kafka</b> - Default 100. Max 10,000.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Self-Managed Apache Kafka</b> - Default 100. Max 10,000.
         * </p>
         * </li>
         * </ul>
         * 
         * @param batchSize
         *        The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to
         *        your function. Lambda passes all of the records in the batch to the function in a single call, up to
         *        the payload limit for synchronous invocation (6 MB).</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Amazon Kinesis</b> - Default 100. Max 10,000.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Amazon Simple Queue Service</b> - Default 10. For standard queues the max is 10,000. For FIFO
         *        queues the max is 10.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Amazon Managed Streaming for Apache Kafka</b> - Default 100. Max 10,000.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Self-Managed Apache Kafka</b> - Default 100. Max 10,000.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchSize(Integer batchSize);

        /**
         * <p>
         * (Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends gathering
         * records before invoking the function.
         * </p>
         * <p>
         * Default: 0
         * </p>
         * <p>
         * Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set
         * <code>MaximumBatchingWindowInSeconds</code> to at least 1.
         * </p>
         * 
         * @param maximumBatchingWindowInSeconds
         *        (Streams and Amazon SQS standard queues) The maximum amount of time, in seconds, that Lambda spends
         *        gathering records before invoking the function.</p>
         *        <p>
         *        Default: 0
         *        </p>
         *        <p>
         *        Related setting: When you set <code>BatchSize</code> to a value greater than 10, you must set
         *        <code>MaximumBatchingWindowInSeconds</code> to at least 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds);

        /**
         * <p>
         * (Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
         * </p>
         * 
         * @param destinationConfig
         *        (Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfig(DestinationConfig destinationConfig);

        /**
         * <p>
         * (Streams only) An Amazon SQS queue or Amazon SNS topic destination for discarded records.
         * </p>
         * This is a convenience that creates an instance of the {@link DestinationConfig.Builder} avoiding the need to
         * create one manually via {@link DestinationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationConfig(DestinationConfig)}.
         * 
         * @param destinationConfig
         *        a consumer that will call methods on {@link DestinationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfig(DestinationConfig)
         */
        default Builder destinationConfig(Consumer<DestinationConfig.Builder> destinationConfig) {
            return destinationConfig(DestinationConfig.builder().applyMutation(destinationConfig).build());
        }

        /**
         * <p>
         * (Streams only) Discard records older than the specified age. The default value is infinite (-1).
         * </p>
         * 
         * @param maximumRecordAgeInSeconds
         *        (Streams only) Discard records older than the specified age. The default value is infinite (-1).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds);

        /**
         * <p>
         * (Streams only) If the function returns an error, split the batch in two and retry.
         * </p>
         * 
         * @param bisectBatchOnFunctionError
         *        (Streams only) If the function returns an error, split the batch in two and retry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bisectBatchOnFunctionError(Boolean bisectBatchOnFunctionError);

        /**
         * <p>
         * (Streams only) Discard records after the specified number of retries. The default value is infinite (-1).
         * When set to infinite (-1), failed records will be retried until the record expires.
         * </p>
         * 
         * @param maximumRetryAttempts
         *        (Streams only) Discard records after the specified number of retries. The default value is infinite
         *        (-1). When set to infinite (-1), failed records will be retried until the record expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumRetryAttempts(Integer maximumRetryAttempts);

        /**
         * <p>
         * (Streams only) The number of batches to process from each shard concurrently.
         * </p>
         * 
         * @param parallelizationFactor
         *        (Streams only) The number of batches to process from each shard concurrently.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelizationFactor(Integer parallelizationFactor);

        /**
         * <p>
         * An array of authentication protocols or VPC components required to secure your event source.
         * </p>
         * 
         * @param sourceAccessConfigurations
         *        An array of authentication protocols or VPC components required to secure your event source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAccessConfigurations(Collection<SourceAccessConfiguration> sourceAccessConfigurations);

        /**
         * <p>
         * An array of authentication protocols or VPC components required to secure your event source.
         * </p>
         * 
         * @param sourceAccessConfigurations
         *        An array of authentication protocols or VPC components required to secure your event source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAccessConfigurations(SourceAccessConfiguration... sourceAccessConfigurations);

        /**
         * <p>
         * An array of authentication protocols or VPC components required to secure your event source.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SourceAccessConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<SourceAccessConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SourceAccessConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceAccessConfigurations(List<SourceAccessConfiguration>)}.
         * 
         * @param sourceAccessConfigurations
         *        a consumer that will call methods on {@link List<SourceAccessConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceAccessConfigurations(List<SourceAccessConfiguration>)
         */
        Builder sourceAccessConfigurations(Consumer<SourceAccessConfiguration.Builder>... sourceAccessConfigurations);

        /**
         * <p>
         * (Streams only) The duration in seconds of a processing window. The range is between 1 second up to 900
         * seconds.
         * </p>
         * 
         * @param tumblingWindowInSeconds
         *        (Streams only) The duration in seconds of a processing window. The range is between 1 second up to 900
         *        seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tumblingWindowInSeconds(Integer tumblingWindowInSeconds);

        /**
         * <p>
         * (Streams only) A list of current response type enums applied to the event source mapping.
         * </p>
         * 
         * @param functionResponseTypes
         *        (Streams only) A list of current response type enums applied to the event source mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionResponseTypesWithStrings(Collection<String> functionResponseTypes);

        /**
         * <p>
         * (Streams only) A list of current response type enums applied to the event source mapping.
         * </p>
         * 
         * @param functionResponseTypes
         *        (Streams only) A list of current response type enums applied to the event source mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionResponseTypesWithStrings(String... functionResponseTypes);

        /**
         * <p>
         * (Streams only) A list of current response type enums applied to the event source mapping.
         * </p>
         * 
         * @param functionResponseTypes
         *        (Streams only) A list of current response type enums applied to the event source mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionResponseTypes(Collection<FunctionResponseType> functionResponseTypes);

        /**
         * <p>
         * (Streams only) A list of current response type enums applied to the event source mapping.
         * </p>
         * 
         * @param functionResponseTypes
         *        (Streams only) A list of current response type enums applied to the event source mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionResponseTypes(FunctionResponseType... functionResponseTypes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String uuid;

        private String functionName;

        private Boolean enabled;

        private Integer batchSize;

        private Integer maximumBatchingWindowInSeconds;

        private DestinationConfig destinationConfig;

        private Integer maximumRecordAgeInSeconds;

        private Boolean bisectBatchOnFunctionError;

        private Integer maximumRetryAttempts;

        private Integer parallelizationFactor;

        private List<SourceAccessConfiguration> sourceAccessConfigurations = DefaultSdkAutoConstructList.getInstance();

        private Integer tumblingWindowInSeconds;

        private List<String> functionResponseTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventSourceMappingRequest model) {
            super(model);
            uuid(model.uuid);
            functionName(model.functionName);
            enabled(model.enabled);
            batchSize(model.batchSize);
            maximumBatchingWindowInSeconds(model.maximumBatchingWindowInSeconds);
            destinationConfig(model.destinationConfig);
            maximumRecordAgeInSeconds(model.maximumRecordAgeInSeconds);
            bisectBatchOnFunctionError(model.bisectBatchOnFunctionError);
            maximumRetryAttempts(model.maximumRetryAttempts);
            parallelizationFactor(model.parallelizationFactor);
            sourceAccessConfigurations(model.sourceAccessConfigurations);
            tumblingWindowInSeconds(model.tumblingWindowInSeconds);
            functionResponseTypesWithStrings(model.functionResponseTypes);
        }

        public final String getUuid() {
            return uuid;
        }

        public final void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @Override
        @Transient
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        @Transient
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        @Transient
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getBatchSize() {
            return batchSize;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        @Transient
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final Integer getMaximumBatchingWindowInSeconds() {
            return maximumBatchingWindowInSeconds;
        }

        public final void setMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
        }

        @Override
        @Transient
        public final Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        public final DestinationConfig.Builder getDestinationConfig() {
            return destinationConfig != null ? destinationConfig.toBuilder() : null;
        }

        public final void setDestinationConfig(DestinationConfig.BuilderImpl destinationConfig) {
            this.destinationConfig = destinationConfig != null ? destinationConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder destinationConfig(DestinationConfig destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        public final Integer getMaximumRecordAgeInSeconds() {
            return maximumRecordAgeInSeconds;
        }

        public final void setMaximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
        }

        @Override
        @Transient
        public final Builder maximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
            return this;
        }

        public final Boolean getBisectBatchOnFunctionError() {
            return bisectBatchOnFunctionError;
        }

        public final void setBisectBatchOnFunctionError(Boolean bisectBatchOnFunctionError) {
            this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
        }

        @Override
        @Transient
        public final Builder bisectBatchOnFunctionError(Boolean bisectBatchOnFunctionError) {
            this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
            return this;
        }

        public final Integer getMaximumRetryAttempts() {
            return maximumRetryAttempts;
        }

        public final void setMaximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
        }

        @Override
        @Transient
        public final Builder maximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
            return this;
        }

        public final Integer getParallelizationFactor() {
            return parallelizationFactor;
        }

        public final void setParallelizationFactor(Integer parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
        }

        @Override
        @Transient
        public final Builder parallelizationFactor(Integer parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
            return this;
        }

        public final List<SourceAccessConfiguration.Builder> getSourceAccessConfigurations() {
            List<SourceAccessConfiguration.Builder> result = SourceAccessConfigurationsCopier
                    .copyToBuilder(this.sourceAccessConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceAccessConfigurations(
                Collection<SourceAccessConfiguration.BuilderImpl> sourceAccessConfigurations) {
            this.sourceAccessConfigurations = SourceAccessConfigurationsCopier.copyFromBuilder(sourceAccessConfigurations);
        }

        @Override
        @Transient
        public final Builder sourceAccessConfigurations(Collection<SourceAccessConfiguration> sourceAccessConfigurations) {
            this.sourceAccessConfigurations = SourceAccessConfigurationsCopier.copy(sourceAccessConfigurations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sourceAccessConfigurations(SourceAccessConfiguration... sourceAccessConfigurations) {
            sourceAccessConfigurations(Arrays.asList(sourceAccessConfigurations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sourceAccessConfigurations(Consumer<SourceAccessConfiguration.Builder>... sourceAccessConfigurations) {
            sourceAccessConfigurations(Stream.of(sourceAccessConfigurations)
                    .map(c -> SourceAccessConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTumblingWindowInSeconds() {
            return tumblingWindowInSeconds;
        }

        public final void setTumblingWindowInSeconds(Integer tumblingWindowInSeconds) {
            this.tumblingWindowInSeconds = tumblingWindowInSeconds;
        }

        @Override
        @Transient
        public final Builder tumblingWindowInSeconds(Integer tumblingWindowInSeconds) {
            this.tumblingWindowInSeconds = tumblingWindowInSeconds;
            return this;
        }

        public final Collection<String> getFunctionResponseTypes() {
            if (functionResponseTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return functionResponseTypes;
        }

        public final void setFunctionResponseTypes(Collection<String> functionResponseTypes) {
            this.functionResponseTypes = FunctionResponseTypeListCopier.copy(functionResponseTypes);
        }

        @Override
        @Transient
        public final Builder functionResponseTypesWithStrings(Collection<String> functionResponseTypes) {
            this.functionResponseTypes = FunctionResponseTypeListCopier.copy(functionResponseTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder functionResponseTypesWithStrings(String... functionResponseTypes) {
            functionResponseTypesWithStrings(Arrays.asList(functionResponseTypes));
            return this;
        }

        @Override
        @Transient
        public final Builder functionResponseTypes(Collection<FunctionResponseType> functionResponseTypes) {
            this.functionResponseTypes = FunctionResponseTypeListCopier.copyEnumToString(functionResponseTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder functionResponseTypes(FunctionResponseType... functionResponseTypes) {
            functionResponseTypes(Arrays.asList(functionResponseTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEventSourceMappingRequest build() {
            return new UpdateEventSourceMappingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
