/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.AuthorizationType;
import software.amazon.awssdk.services.lambda.model.Cors;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFunctionUrlConfigRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, UpdateFunctionUrlConfigRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionName").getter(UpdateFunctionUrlConfigRequest.getter(UpdateFunctionUrlConfigRequest::functionName)).setter(UpdateFunctionUrlConfigRequest.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()}).build();
    private static final SdkField<String> QUALIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Qualifier").getter(UpdateFunctionUrlConfigRequest.getter(UpdateFunctionUrlConfigRequest::qualifier)).setter(UpdateFunctionUrlConfigRequest.setter(Builder::qualifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Qualifier").build()}).build();
    private static final SdkField<String> AUTHORIZATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthorizationType").getter(UpdateFunctionUrlConfigRequest.getter(UpdateFunctionUrlConfigRequest::authorizationTypeAsString)).setter(UpdateFunctionUrlConfigRequest.setter(Builder::authorizationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationType").build()}).build();
    private static final SdkField<Cors> CORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Cors").getter(UpdateFunctionUrlConfigRequest.getter(UpdateFunctionUrlConfigRequest::cors)).setter(UpdateFunctionUrlConfigRequest.setter(Builder::cors)).constructor(Cors::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cors").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD, QUALIFIER_FIELD, AUTHORIZATION_TYPE_FIELD, CORS_FIELD));
    private final String functionName;
    private final String qualifier;
    private final String authorizationType;
    private final Cors cors;

    private UpdateFunctionUrlConfigRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.qualifier = builder.qualifier;
        this.authorizationType = builder.authorizationType;
        this.cors = builder.cors;
    }

    public final String functionName() {
        return this.functionName;
    }

    public final String qualifier() {
        return this.qualifier;
    }

    public final AuthorizationType authorizationType() {
        return AuthorizationType.fromValue(this.authorizationType);
    }

    public final String authorizationTypeAsString() {
        return this.authorizationType;
    }

    public final Cors cors() {
        return this.cors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cors());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFunctionUrlConfigRequest)) {
            return false;
        }
        UpdateFunctionUrlConfigRequest other = (UpdateFunctionUrlConfigRequest)((Object)obj);
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.qualifier(), other.qualifier()) && Objects.equals(this.authorizationTypeAsString(), other.authorizationTypeAsString()) && Objects.equals(this.cors(), other.cors());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFunctionUrlConfigRequest").add("FunctionName", (Object)this.functionName()).add("Qualifier", (Object)this.qualifier()).add("AuthorizationType", (Object)this.authorizationTypeAsString()).add("Cors", (Object)this.cors()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "Qualifier": {
                return Optional.ofNullable(clazz.cast(this.qualifier()));
            }
            case "AuthorizationType": {
                return Optional.ofNullable(clazz.cast(this.authorizationTypeAsString()));
            }
            case "Cors": {
                return Optional.ofNullable(clazz.cast(this.cors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFunctionUrlConfigRequest, T> g) {
        return obj -> g.apply((UpdateFunctionUrlConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String functionName;
        private String qualifier;
        private String authorizationType;
        private Cors cors;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFunctionUrlConfigRequest model) {
            super(model);
            this.functionName(model.functionName);
            this.qualifier(model.qualifier);
            this.authorizationType(model.authorizationType);
            this.cors(model.cors);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        @Transient
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getQualifier() {
            return this.qualifier;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        @Override
        @Transient
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final String getAuthorizationType() {
            return this.authorizationType;
        }

        public final void setAuthorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
        }

        @Override
        @Transient
        public final Builder authorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        @Override
        @Transient
        public final Builder authorizationType(AuthorizationType authorizationType) {
            this.authorizationType(authorizationType == null ? null : authorizationType.toString());
            return this;
        }

        public final Cors.Builder getCors() {
            return this.cors != null ? this.cors.toBuilder() : null;
        }

        public final void setCors(Cors.BuilderImpl cors) {
            this.cors = cors != null ? cors.build() : null;
        }

        @Override
        @Transient
        public final Builder cors(Cors cors) {
            this.cors = cors;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFunctionUrlConfigRequest build() {
            return new UpdateFunctionUrlConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFunctionUrlConfigRequest> {
        public Builder functionName(String var1);

        public Builder qualifier(String var1);

        public Builder authorizationType(String var1);

        public Builder authorizationType(AuthorizationType var1);

        public Builder cors(Cors var1);

        default public Builder cors(Consumer<Cors.Builder> cors) {
            return this.cors((Cors)((Cors.Builder)Cors.builder().applyMutation(cors)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

