/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response to GetFunctionConfiguration request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageConfigResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageConfigResponse.Builder, ImageConfigResponse> {
    private static final SdkField<ImageConfig> IMAGE_CONFIG_FIELD = SdkField.<ImageConfig> builder(MarshallingType.SDK_POJO)
            .memberName("ImageConfig").getter(getter(ImageConfigResponse::imageConfig)).setter(setter(Builder::imageConfig))
            .constructor(ImageConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageConfig").build()).build();

    private static final SdkField<ImageConfigError> ERROR_FIELD = SdkField.<ImageConfigError> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(ImageConfigResponse::error)).setter(setter(Builder::error))
            .constructor(ImageConfigError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_CONFIG_FIELD,
            ERROR_FIELD));

    private static final long serialVersionUID = 1L;

    private final ImageConfig imageConfig;

    private final ImageConfigError error;

    private ImageConfigResponse(BuilderImpl builder) {
        this.imageConfig = builder.imageConfig;
        this.error = builder.error;
    }

    /**
     * <p>
     * Configuration values that override the container image Dockerfile.
     * </p>
     * 
     * @return Configuration values that override the container image Dockerfile.
     */
    public final ImageConfig imageConfig() {
        return imageConfig;
    }

    /**
     * <p>
     * Error response to GetFunctionConfiguration.
     * </p>
     * 
     * @return Error response to GetFunctionConfiguration.
     */
    public final ImageConfigError error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageConfigResponse)) {
            return false;
        }
        ImageConfigResponse other = (ImageConfigResponse) obj;
        return Objects.equals(imageConfig(), other.imageConfig()) && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageConfigResponse").add("ImageConfig", imageConfig()).add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageConfig":
            return Optional.ofNullable(clazz.cast(imageConfig()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageConfigResponse, T> g) {
        return obj -> g.apply((ImageConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageConfigResponse> {
        /**
         * <p>
         * Configuration values that override the container image Dockerfile.
         * </p>
         * 
         * @param imageConfig
         *        Configuration values that override the container image Dockerfile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageConfig(ImageConfig imageConfig);

        /**
         * <p>
         * Configuration values that override the container image Dockerfile.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageConfig.Builder} avoiding the need to
         * create one manually via {@link ImageConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #imageConfig(ImageConfig)}.
         * 
         * @param imageConfig
         *        a consumer that will call methods on {@link ImageConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageConfig(ImageConfig)
         */
        default Builder imageConfig(Consumer<ImageConfig.Builder> imageConfig) {
            return imageConfig(ImageConfig.builder().applyMutation(imageConfig).build());
        }

        /**
         * <p>
         * Error response to GetFunctionConfiguration.
         * </p>
         * 
         * @param error
         *        Error response to GetFunctionConfiguration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ImageConfigError error);

        /**
         * <p>
         * Error response to GetFunctionConfiguration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageConfigError.Builder} avoiding the
         * need to create one manually via {@link ImageConfigError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageConfigError.Builder#build()} is called immediately and its
         * result is passed to {@link #error(ImageConfigError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ImageConfigError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ImageConfigError)
         */
        default Builder error(Consumer<ImageConfigError.Builder> error) {
            return error(ImageConfigError.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ImageConfig imageConfig;

        private ImageConfigError error;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageConfigResponse model) {
            imageConfig(model.imageConfig);
            error(model.error);
        }

        public final ImageConfig.Builder getImageConfig() {
            return imageConfig != null ? imageConfig.toBuilder() : null;
        }

        public final void setImageConfig(ImageConfig.BuilderImpl imageConfig) {
            this.imageConfig = imageConfig != null ? imageConfig.build() : null;
        }

        @Override
        public final Builder imageConfig(ImageConfig imageConfig) {
            this.imageConfig = imageConfig;
            return this;
        }

        public final ImageConfigError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ImageConfigError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ImageConfigError error) {
            this.error = error;
            return this;
        }

        @Override
        public ImageConfigResponse build() {
            return new ImageConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
