/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specific configuration settings for a self-managed Apache Kafka event source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SelfManagedKafkaEventSourceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<SelfManagedKafkaEventSourceConfig.Builder, SelfManagedKafkaEventSourceConfig> {
    private static final SdkField<String> CONSUMER_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsumerGroupId").getter(getter(SelfManagedKafkaEventSourceConfig::consumerGroupId))
            .setter(setter(Builder::consumerGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerGroupId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMER_GROUP_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String consumerGroupId;

    private SelfManagedKafkaEventSourceConfig(BuilderImpl builder) {
        this.consumerGroupId = builder.consumerGroupId;
    }

    /**
     * <p>
     * The identifier for the Kafka consumer group to join. The consumer group ID must be unique among all your Kafka
     * event sources. After creating a Kafka event source mapping with the consumer group ID specified, you cannot
     * update this value. For more information, see <a>services-msk-consumer-group-id</a>.
     * </p>
     * 
     * @return The identifier for the Kafka consumer group to join. The consumer group ID must be unique among all your
     *         Kafka event sources. After creating a Kafka event source mapping with the consumer group ID specified,
     *         you cannot update this value. For more information, see <a>services-msk-consumer-group-id</a>.
     */
    public final String consumerGroupId() {
        return consumerGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(consumerGroupId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelfManagedKafkaEventSourceConfig)) {
            return false;
        }
        SelfManagedKafkaEventSourceConfig other = (SelfManagedKafkaEventSourceConfig) obj;
        return Objects.equals(consumerGroupId(), other.consumerGroupId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SelfManagedKafkaEventSourceConfig").add("ConsumerGroupId", consumerGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConsumerGroupId":
            return Optional.ofNullable(clazz.cast(consumerGroupId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SelfManagedKafkaEventSourceConfig, T> g) {
        return obj -> g.apply((SelfManagedKafkaEventSourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SelfManagedKafkaEventSourceConfig> {
        /**
         * <p>
         * The identifier for the Kafka consumer group to join. The consumer group ID must be unique among all your
         * Kafka event sources. After creating a Kafka event source mapping with the consumer group ID specified, you
         * cannot update this value. For more information, see <a>services-msk-consumer-group-id</a>.
         * </p>
         * 
         * @param consumerGroupId
         *        The identifier for the Kafka consumer group to join. The consumer group ID must be unique among all
         *        your Kafka event sources. After creating a Kafka event source mapping with the consumer group ID
         *        specified, you cannot update this value. For more information, see
         *        <a>services-msk-consumer-group-id</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerGroupId(String consumerGroupId);
    }

    static final class BuilderImpl implements Builder {
        private String consumerGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(SelfManagedKafkaEventSourceConfig model) {
            consumerGroupId(model.consumerGroupId);
        }

        public final String getConsumerGroupId() {
            return consumerGroupId;
        }

        public final void setConsumerGroupId(String consumerGroupId) {
            this.consumerGroupId = consumerGroupId;
        }

        @Override
        public final Builder consumerGroupId(String consumerGroupId) {
            this.consumerGroupId = consumerGroupId;
            return this;
        }

        @Override
        public SelfManagedKafkaEventSourceConfig build() {
            return new SelfManagedKafkaEventSourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
