/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionRequest;
import software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionResponse;
import software.amazon.awssdk.services.lambda.model.AddPermissionRequest;
import software.amazon.awssdk.services.lambda.model.AddPermissionResponse;
import software.amazon.awssdk.services.lambda.model.CodeSigningConfigNotFoundException;
import software.amazon.awssdk.services.lambda.model.CodeStorageExceededException;
import software.amazon.awssdk.services.lambda.model.CodeVerificationFailedException;
import software.amazon.awssdk.services.lambda.model.CreateAliasRequest;
import software.amazon.awssdk.services.lambda.model.CreateAliasResponse;
import software.amazon.awssdk.services.lambda.model.CreateCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.CreateCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.CreateFunctionRequest;
import software.amazon.awssdk.services.lambda.model.CreateFunctionResponse;
import software.amazon.awssdk.services.lambda.model.CreateFunctionUrlConfigRequest;
import software.amazon.awssdk.services.lambda.model.CreateFunctionUrlConfigResponse;
import software.amazon.awssdk.services.lambda.model.DeleteAliasRequest;
import software.amazon.awssdk.services.lambda.model.DeleteAliasResponse;
import software.amazon.awssdk.services.lambda.model.DeleteCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.DeleteCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.DeleteEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.DeleteEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionConcurrencyRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionConcurrencyResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionEventInvokeConfigRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionEventInvokeConfigResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionUrlConfigRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionUrlConfigResponse;
import software.amazon.awssdk.services.lambda.model.DeleteLayerVersionRequest;
import software.amazon.awssdk.services.lambda.model.DeleteLayerVersionResponse;
import software.amazon.awssdk.services.lambda.model.DeleteProvisionedConcurrencyConfigRequest;
import software.amazon.awssdk.services.lambda.model.DeleteProvisionedConcurrencyConfigResponse;
import software.amazon.awssdk.services.lambda.model.Ec2AccessDeniedException;
import software.amazon.awssdk.services.lambda.model.Ec2ThrottledException;
import software.amazon.awssdk.services.lambda.model.Ec2UnexpectedException;
import software.amazon.awssdk.services.lambda.model.EfsMountConnectivityException;
import software.amazon.awssdk.services.lambda.model.EfsMountFailureException;
import software.amazon.awssdk.services.lambda.model.EfsMountTimeoutException;
import software.amazon.awssdk.services.lambda.model.EfsioException;
import software.amazon.awssdk.services.lambda.model.EniLimitReachedException;
import software.amazon.awssdk.services.lambda.model.GetAccountSettingsRequest;
import software.amazon.awssdk.services.lambda.model.GetAccountSettingsResponse;
import software.amazon.awssdk.services.lambda.model.GetAliasRequest;
import software.amazon.awssdk.services.lambda.model.GetAliasResponse;
import software.amazon.awssdk.services.lambda.model.GetCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.GetCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.GetEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.GetEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionEventInvokeConfigRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionEventInvokeConfigResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionUrlConfigRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionUrlConfigResponse;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionByArnRequest;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionByArnResponse;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyRequest;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyResponse;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionRequest;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionResponse;
import software.amazon.awssdk.services.lambda.model.GetPolicyRequest;
import software.amazon.awssdk.services.lambda.model.GetPolicyResponse;
import software.amazon.awssdk.services.lambda.model.GetProvisionedConcurrencyConfigRequest;
import software.amazon.awssdk.services.lambda.model.GetProvisionedConcurrencyConfigResponse;
import software.amazon.awssdk.services.lambda.model.InvalidCodeSignatureException;
import software.amazon.awssdk.services.lambda.model.InvalidParameterValueException;
import software.amazon.awssdk.services.lambda.model.InvalidRequestContentException;
import software.amazon.awssdk.services.lambda.model.InvalidRuntimeException;
import software.amazon.awssdk.services.lambda.model.InvalidSecurityGroupIdException;
import software.amazon.awssdk.services.lambda.model.InvalidSubnetIdException;
import software.amazon.awssdk.services.lambda.model.InvalidZipFileException;
import software.amazon.awssdk.services.lambda.model.InvokeRequest;
import software.amazon.awssdk.services.lambda.model.InvokeResponse;
import software.amazon.awssdk.services.lambda.model.KmsAccessDeniedException;
import software.amazon.awssdk.services.lambda.model.KmsDisabledException;
import software.amazon.awssdk.services.lambda.model.KmsInvalidStateException;
import software.amazon.awssdk.services.lambda.model.KmsNotFoundException;
import software.amazon.awssdk.services.lambda.model.LambdaException;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.services.lambda.model.ListAliasesRequest;
import software.amazon.awssdk.services.lambda.model.ListAliasesResponse;
import software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest;
import software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsResponse;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse;
import software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsResponse;
import software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsResponse;
import software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.ListFunctionsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionsResponse;
import software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest;
import software.amazon.awssdk.services.lambda.model.ListLayerVersionsResponse;
import software.amazon.awssdk.services.lambda.model.ListLayersRequest;
import software.amazon.awssdk.services.lambda.model.ListLayersResponse;
import software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest;
import software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsResponse;
import software.amazon.awssdk.services.lambda.model.ListTagsRequest;
import software.amazon.awssdk.services.lambda.model.ListTagsResponse;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse;
import software.amazon.awssdk.services.lambda.model.PolicyLengthExceededException;
import software.amazon.awssdk.services.lambda.model.PreconditionFailedException;
import software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyConfigNotFoundException;
import software.amazon.awssdk.services.lambda.model.PublishLayerVersionRequest;
import software.amazon.awssdk.services.lambda.model.PublishLayerVersionResponse;
import software.amazon.awssdk.services.lambda.model.PublishVersionRequest;
import software.amazon.awssdk.services.lambda.model.PublishVersionResponse;
import software.amazon.awssdk.services.lambda.model.PutFunctionCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.PutFunctionCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyRequest;
import software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyResponse;
import software.amazon.awssdk.services.lambda.model.PutFunctionEventInvokeConfigRequest;
import software.amazon.awssdk.services.lambda.model.PutFunctionEventInvokeConfigResponse;
import software.amazon.awssdk.services.lambda.model.PutProvisionedConcurrencyConfigRequest;
import software.amazon.awssdk.services.lambda.model.PutProvisionedConcurrencyConfigResponse;
import software.amazon.awssdk.services.lambda.model.RemoveLayerVersionPermissionRequest;
import software.amazon.awssdk.services.lambda.model.RemoveLayerVersionPermissionResponse;
import software.amazon.awssdk.services.lambda.model.RemovePermissionRequest;
import software.amazon.awssdk.services.lambda.model.RemovePermissionResponse;
import software.amazon.awssdk.services.lambda.model.RequestTooLargeException;
import software.amazon.awssdk.services.lambda.model.ResourceConflictException;
import software.amazon.awssdk.services.lambda.model.ResourceInUseException;
import software.amazon.awssdk.services.lambda.model.ResourceNotFoundException;
import software.amazon.awssdk.services.lambda.model.ResourceNotReadyException;
import software.amazon.awssdk.services.lambda.model.ServiceException;
import software.amazon.awssdk.services.lambda.model.SnapStartException;
import software.amazon.awssdk.services.lambda.model.SnapStartNotReadyException;
import software.amazon.awssdk.services.lambda.model.SnapStartTimeoutException;
import software.amazon.awssdk.services.lambda.model.SubnetIpAddressLimitReachedException;
import software.amazon.awssdk.services.lambda.model.TagResourceRequest;
import software.amazon.awssdk.services.lambda.model.TagResourceResponse;
import software.amazon.awssdk.services.lambda.model.TooManyRequestsException;
import software.amazon.awssdk.services.lambda.model.UnsupportedMediaTypeException;
import software.amazon.awssdk.services.lambda.model.UntagResourceRequest;
import software.amazon.awssdk.services.lambda.model.UntagResourceResponse;
import software.amazon.awssdk.services.lambda.model.UpdateAliasRequest;
import software.amazon.awssdk.services.lambda.model.UpdateAliasResponse;
import software.amazon.awssdk.services.lambda.model.UpdateCodeSigningConfigRequest;
import software.amazon.awssdk.services.lambda.model.UpdateCodeSigningConfigResponse;
import software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionEventInvokeConfigRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionEventInvokeConfigResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionUrlConfigRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionUrlConfigResponse;
import software.amazon.awssdk.services.lambda.paginators.ListAliasesIterable;
import software.amazon.awssdk.services.lambda.paginators.ListCodeSigningConfigsIterable;
import software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable;
import software.amazon.awssdk.services.lambda.paginators.ListFunctionEventInvokeConfigsIterable;
import software.amazon.awssdk.services.lambda.paginators.ListFunctionUrlConfigsIterable;
import software.amazon.awssdk.services.lambda.paginators.ListFunctionsByCodeSigningConfigIterable;
import software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable;
import software.amazon.awssdk.services.lambda.paginators.ListLayerVersionsIterable;
import software.amazon.awssdk.services.lambda.paginators.ListLayersIterable;
import software.amazon.awssdk.services.lambda.paginators.ListProvisionedConcurrencyConfigsIterable;
import software.amazon.awssdk.services.lambda.paginators.ListVersionsByFunctionIterable;
import software.amazon.awssdk.services.lambda.transform.AddLayerVersionPermissionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.AddPermissionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.CreateCodeSigningConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.CreateEventSourceMappingRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.CreateFunctionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.CreateFunctionUrlConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteAliasRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteCodeSigningConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteEventSourceMappingRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteFunctionCodeSigningConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteFunctionConcurrencyRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteFunctionEventInvokeConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteFunctionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteFunctionUrlConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteLayerVersionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteProvisionedConcurrencyConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetAliasRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetCodeSigningConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetEventSourceMappingRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetFunctionCodeSigningConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetFunctionConcurrencyRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetFunctionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetFunctionEventInvokeConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetFunctionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetFunctionUrlConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetLayerVersionByArnRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetLayerVersionPolicyRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetLayerVersionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetPolicyRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetProvisionedConcurrencyConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.InvokeRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListAliasesRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListCodeSigningConfigsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListEventSourceMappingsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListFunctionEventInvokeConfigsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListFunctionUrlConfigsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListFunctionsByCodeSigningConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListFunctionsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListLayerVersionsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListLayersRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListProvisionedConcurrencyConfigsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListVersionsByFunctionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.PublishLayerVersionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.PublishVersionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.PutFunctionCodeSigningConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.PutFunctionConcurrencyRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.PutFunctionEventInvokeConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.PutProvisionedConcurrencyConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.RemoveLayerVersionPermissionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.RemovePermissionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateAliasRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateCodeSigningConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateEventSourceMappingRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateFunctionCodeRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateFunctionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateFunctionEventInvokeConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateFunctionUrlConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.waiters.LambdaWaiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link LambdaClient}.
 *
 * @see LambdaClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultLambdaClient implements LambdaClient {
    private static final Logger log = Logger.loggerFor(DefaultLambdaClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultLambdaClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Adds permissions to the resource-based policy of a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. Use this action
     * to grant layer usage permission to other accounts. You can grant permission to a single account, all accounts in
     * an organization, or all Amazon Web Services accounts.
     * </p>
     * <p>
     * To revoke permission, call <a>RemoveLayerVersionPermission</a> with the statement ID that you specified when you
     * added it.
     * </p>
     *
     * @param addLayerVersionPermissionRequest
     * @return Result of the AddLayerVersionPermission operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws PolicyLengthExceededException
     *         The permissions policy for the resource is too large. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.AddLayerVersionPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddLayerVersionPermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AddLayerVersionPermissionResponse addLayerVersionPermission(
            AddLayerVersionPermissionRequest addLayerVersionPermissionRequest) throws ServiceException,
            ResourceNotFoundException, ResourceConflictException, TooManyRequestsException, InvalidParameterValueException,
            PolicyLengthExceededException, PreconditionFailedException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddLayerVersionPermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AddLayerVersionPermissionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addLayerVersionPermissionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddLayerVersionPermission");

            return clientHandler
                    .execute(new ClientExecutionParams<AddLayerVersionPermissionRequest, AddLayerVersionPermissionResponse>()
                            .withOperationName("AddLayerVersionPermission").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(addLayerVersionPermissionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AddLayerVersionPermissionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants an Amazon Web Service, Amazon Web Services account, or Amazon Web Services organization permission to use
     * a function. You can apply the policy at the function level, or specify a qualifier to restrict access to a single
     * version or alias. If you use a qualifier, the invoker must use the full Amazon Resource Name (ARN) of that
     * version or alias to invoke the function. Note: Lambda does not support adding policies to version &#36LATEST.
     * </p>
     * <p>
     * To grant permission to another account, specify the account ID as the <code>Principal</code>. To grant permission
     * to an organization defined in Organizations, specify the organization ID as the <code>PrincipalOrgID</code>. For
     * Amazon Web Services, the principal is a domain-style identifier that the service defines, such as
     * <code>s3.amazonaws.com</code> or <code>sns.amazonaws.com</code>. For Amazon Web Services, you can also specify
     * the ARN of the associated resource as the <code>SourceArn</code>. If you grant permission to a service principal
     * without specifying the source, other accounts could potentially configure resources in their account to invoke
     * your Lambda function.
     * </p>
     * <p>
     * This operation adds a statement to a resource-based permissions policy for the function. For more information
     * about function policies, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">Using resource-based
     * policies for Lambda</a>.
     * </p>
     *
     * @param addPermissionRequest
     * @return Result of the AddPermission operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws PolicyLengthExceededException
     *         The permissions policy for the resource is too large. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.AddPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddPermission" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AddPermissionResponse addPermission(AddPermissionRequest addPermissionRequest) throws ServiceException,
            ResourceNotFoundException, ResourceConflictException, InvalidParameterValueException, PolicyLengthExceededException,
            TooManyRequestsException, PreconditionFailedException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddPermissionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AddPermissionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addPermissionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddPermission");

            return clientHandler.execute(new ClientExecutionParams<AddPermissionRequest, AddPermissionResponse>()
                    .withOperationName("AddPermission").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(addPermissionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddPermissionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a> for a Lambda
     * function version. Use aliases to provide clients with a function identifier that you can update to invoke a
     * different version.
     * </p>
     * <p>
     * You can also map an alias to split invocation requests between two versions. Use the <code>RoutingConfig</code>
     * parameter to specify a second version and the percentage of invocation requests that it receives.
     * </p>
     *
     * @param createAliasRequest
     * @return Result of the CreateAlias operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAliasResponse createAlias(CreateAliasRequest createAliasRequest) throws ServiceException,
            ResourceNotFoundException, ResourceConflictException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAlias");

            return clientHandler.execute(new ClientExecutionParams<CreateAliasRequest, CreateAliasResponse>()
                    .withOperationName("CreateAlias").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a code signing configuration. A <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html">code signing configuration</a>
     * defines a list of allowed signing profiles and defines the code-signing validation policy (action to be taken if
     * deployment validation checks fail).
     * </p>
     *
     * @param createCodeSigningConfigRequest
     * @return Result of the CreateCodeSigningConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCodeSigningConfigResponse createCodeSigningConfig(CreateCodeSigningConfigRequest createCodeSigningConfigRequest)
            throws ServiceException, InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCodeSigningConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCodeSigningConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCodeSigningConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCodeSigningConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCodeSigningConfigRequest, CreateCodeSigningConfigResponse>()
                            .withOperationName("CreateCodeSigningConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createCodeSigningConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateCodeSigningConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a mapping between an event source and an Lambda function. Lambda reads items from the event source and
     * invokes the function.
     * </p>
     * <p>
     * For details about how to configure different event sources, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping"> Amazon
     * DynamoDB Streams</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping">
     * Amazon Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource"> Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping"> Amazon MQ and
     * RabbitMQ</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html"> Amazon MSK</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html"> Apache Kafka</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following error handling options are available only for stream sources (DynamoDB and Kinesis):
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BisectBatchOnFunctionError</code> – If the function returns an error, split the batch in two and retry.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DestinationConfig</code> – Send discarded records to an Amazon SQS queue or Amazon SNS topic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRecordAgeInSeconds</code> – Discard records older than the specified age. The default value is
     * infinite (-1). When set to infinite (-1), failed records are retried until the record expires
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRetryAttempts</code> – Discard records after the specified number of retries. The default value is
     * infinite (-1). When set to infinite (-1), failed records are retried until the record expires.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ParallelizationFactor</code> – Process multiple batches from each shard concurrently.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about which configuration parameters apply to each event source, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-params"> Amazon DynamoDB
     * Streams</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-params"> Amazon
     * Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-params"> Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-params"> Amazon MQ and
     * RabbitMQ</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-parms"> Amazon MSK</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-kafka-parms"> Apache Kafka</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createEventSourceMappingRequest
     * @return Result of the CreateEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateEventSourceMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateEventSourceMappingResponse createEventSourceMapping(
            CreateEventSourceMappingRequest createEventSourceMappingRequest) throws ServiceException,
            InvalidParameterValueException, ResourceConflictException, TooManyRequestsException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateEventSourceMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateEventSourceMappingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEventSourceMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEventSourceMapping");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateEventSourceMappingRequest, CreateEventSourceMappingResponse>()
                            .withOperationName("CreateEventSourceMapping").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createEventSourceMappingRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateEventSourceMappingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Lambda function. To create a function, you need a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html">deployment package</a> and an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role">
     * execution role</a>. The deployment package is a .zip file archive or container image that contains your function
     * code. The execution role grants the function permission to use Amazon Web Services, such as Amazon CloudWatch
     * Logs for log streaming and X-Ray for request tracing.
     * </p>
     * <p>
     * If the deployment package is a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html">container image</a>, then you set the
     * package type to <code>Image</code>. For a container image, the code property must include the URI of a container
     * image in the Amazon ECR registry. You do not need to specify the handler and runtime properties.
     * </p>
     * <p>
     * If the deployment package is a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html#gettingstarted-package-zip">.zip
     * file archive</a>, then you set the package type to <code>Zip</code>. For a .zip file archive, the code property
     * specifies the location of the .zip file. You must also specify the handler and runtime properties. The code in
     * the deployment package must be compatible with the target instruction set architecture of the function (
     * <code>x86-64</code> or <code>arm64</code>). If you do not specify the architecture, then the default value is
     * <code>x86-64</code>.
     * </p>
     * <p>
     * When you create a function, Lambda provisions an instance of the function and its supporting resources. If your
     * function connects to a VPC, this process can take a minute or so. During this time, you can't invoke or modify
     * the function. The <code>State</code>, <code>StateReason</code>, and <code>StateReasonCode</code> fields in the
     * response from <a>GetFunctionConfiguration</a> indicate when the function is ready to invoke. For more
     * information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">Lambda function
     * states</a>.
     * </p>
     * <p>
     * A function has an unpublished version, and can have published versions and aliases. The unpublished version
     * changes when you update your function's code and configuration. A published version is a snapshot of your
     * function code and configuration that can't be changed. An alias is a named resource that maps to a version, and
     * can be changed to map to a different version. Use the <code>Publish</code> parameter to create version
     * <code>1</code> of your function from its initial configuration.
     * </p>
     * <p>
     * The other parameters let you configure version-specific and function-level settings. You can modify
     * version-specific settings later with <a>UpdateFunctionConfiguration</a>. Function-level settings apply to both
     * the unpublished and published versions of the function, and include tags (<a>TagResource</a>) and per-function
     * concurrency limits (<a>PutFunctionConcurrency</a>).
     * </p>
     * <p>
     * You can use code signing if your deployment package is a .zip file archive. To enable code signing for this
     * function, specify the ARN of a code-signing configuration. When a user attempts to deploy a code package with
     * <a>UpdateFunctionCode</a>, Lambda checks that the code package has a valid signature from a trusted publisher.
     * The code-signing configuration includes set of signing profiles, which define the trusted publishers for this
     * function.
     * </p>
     * <p>
     * If another Amazon Web Services account or an Amazon Web Service invokes your function, use <a>AddPermission</a>
     * to grant permission by creating a resource-based Identity and Access Management (IAM) policy. You can grant
     * permissions at the function level, on a version, or on an alias.
     * </p>
     * <p>
     * To invoke your function directly, use <a>Invoke</a>. To invoke your function in response to events in other
     * Amazon Web Services, create an event source mapping (<a>CreateEventSourceMapping</a>), or configure a function
     * trigger in the other service. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-invocation.html">Invoking Lambda functions</a>.
     * </p>
     *
     * @param createFunctionRequest
     * @return Result of the CreateFunction operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws CodeStorageExceededException
     *         Your Amazon Web Services account has exceeded its maximum total code size. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws CodeVerificationFailedException
     *         The code signature failed one or more of the validation checks for signature mismatch or expiry, and the
     *         code signing policy is set to ENFORCE. Lambda blocks the deployment.
     * @throws InvalidCodeSignatureException
     *         The code signature failed the integrity check. If the integrity check fails, then Lambda blocks
     *         deployment, even if the code signing policy is set to WARN.
     * @throws CodeSigningConfigNotFoundException
     *         The specified code signing configuration does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateFunctionResponse createFunction(CreateFunctionRequest createFunctionRequest) throws ServiceException,
            InvalidParameterValueException, ResourceNotFoundException, ResourceConflictException, TooManyRequestsException,
            CodeStorageExceededException, CodeVerificationFailedException, InvalidCodeSignatureException,
            CodeSigningConfigNotFoundException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFunctionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateFunctionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFunction");

            return clientHandler.execute(new ClientExecutionParams<CreateFunctionRequest, CreateFunctionResponse>()
                    .withOperationName("CreateFunction").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createFunctionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateFunctionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Lambda function URL with the specified configuration parameters. A function URL is a dedicated HTTP(S)
     * endpoint that you can use to invoke your function.
     * </p>
     *
     * @param createFunctionUrlConfigRequest
     * @return Result of the CreateFunctionUrlConfig operation returned by the service.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateFunctionUrlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateFunctionUrlConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateFunctionUrlConfigResponse createFunctionUrlConfig(CreateFunctionUrlConfigRequest createFunctionUrlConfigRequest)
            throws ResourceConflictException, ResourceNotFoundException, InvalidParameterValueException, ServiceException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFunctionUrlConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateFunctionUrlConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFunctionUrlConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFunctionUrlConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateFunctionUrlConfigRequest, CreateFunctionUrlConfigResponse>()
                            .withOperationName("CreateFunctionUrlConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createFunctionUrlConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateFunctionUrlConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a Lambda function <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.
     * </p>
     *
     * @param deleteAliasRequest
     * @return Result of the DeleteAlias operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAliasResponse deleteAlias(DeleteAliasRequest deleteAliasRequest) throws ServiceException,
            InvalidParameterValueException, ResourceConflictException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAlias");

            return clientHandler.execute(new ClientExecutionParams<DeleteAliasRequest, DeleteAliasResponse>()
                    .withOperationName("DeleteAlias").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the code signing configuration. You can delete the code signing configuration only if no function is
     * using it.
     * </p>
     *
     * @param deleteCodeSigningConfigRequest
     * @return Result of the DeleteCodeSigningConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCodeSigningConfigResponse deleteCodeSigningConfig(DeleteCodeSigningConfigRequest deleteCodeSigningConfigRequest)
            throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, ResourceConflictException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCodeSigningConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCodeSigningConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCodeSigningConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCodeSigningConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteCodeSigningConfigRequest, DeleteCodeSigningConfigResponse>()
                            .withOperationName("DeleteCodeSigningConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteCodeSigningConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteCodeSigningConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an <a href="https://docs.aws.amazon.com/lambda/latest/dg/intro-invocation-modes.html">event source
     * mapping</a>. You can get the identifier of a mapping from the output of <a>ListEventSourceMappings</a>.
     * </p>
     * <p>
     * When you delete an event source mapping, it enters a <code>Deleting</code> state and might not be completely
     * deleted for several seconds.
     * </p>
     *
     * @param deleteEventSourceMappingRequest
     * @return Result of the DeleteEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you tried to update an event
     *         source mapping in the CREATING state, or you tried to delete an event source mapping currently UPDATING.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteEventSourceMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteEventSourceMappingResponse deleteEventSourceMapping(
            DeleteEventSourceMappingRequest deleteEventSourceMappingRequest) throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, ResourceInUseException, AwsServiceException,
            SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEventSourceMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteEventSourceMappingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEventSourceMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventSourceMapping");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteEventSourceMappingRequest, DeleteEventSourceMappingResponse>()
                            .withOperationName("DeleteEventSourceMapping").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteEventSourceMappingRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteEventSourceMappingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a Lambda function. To delete a specific function version, use the <code>Qualifier</code> parameter.
     * Otherwise, all versions and aliases are deleted.
     * </p>
     * <p>
     * To delete Lambda event source mappings that invoke a function, use <a>DeleteEventSourceMapping</a>. For Amazon
     * Web Services and resources that invoke your function directly, delete the trigger in the service where you
     * originally configured it.
     * </p>
     *
     * @param deleteFunctionRequest
     * @return Result of the DeleteFunction operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteFunctionResponse deleteFunction(DeleteFunctionRequest deleteFunctionRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, ResourceConflictException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFunctionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteFunctionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFunction");

            return clientHandler.execute(new ClientExecutionParams<DeleteFunctionRequest, DeleteFunctionResponse>()
                    .withOperationName("DeleteFunction").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteFunctionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteFunctionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the code signing configuration from the function.
     * </p>
     *
     * @param deleteFunctionCodeSigningConfigRequest
     * @return Result of the DeleteFunctionCodeSigningConfig operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws CodeSigningConfigNotFoundException
     *         The specified code signing configuration does not exist.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteFunctionCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteFunctionCodeSigningConfigResponse deleteFunctionCodeSigningConfig(
            DeleteFunctionCodeSigningConfigRequest deleteFunctionCodeSigningConfigRequest) throws InvalidParameterValueException,
            CodeSigningConfigNotFoundException, ResourceNotFoundException, ServiceException, TooManyRequestsException,
            ResourceConflictException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFunctionCodeSigningConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteFunctionCodeSigningConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteFunctionCodeSigningConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFunctionCodeSigningConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteFunctionCodeSigningConfigRequest, DeleteFunctionCodeSigningConfigResponse>()
                            .withOperationName("DeleteFunctionCodeSigningConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteFunctionCodeSigningConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteFunctionCodeSigningConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a concurrent execution limit from a function.
     * </p>
     *
     * @param deleteFunctionConcurrencyRequest
     * @return Result of the DeleteFunctionConcurrency operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteFunctionConcurrency
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionConcurrency"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteFunctionConcurrencyResponse deleteFunctionConcurrency(
            DeleteFunctionConcurrencyRequest deleteFunctionConcurrencyRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, ResourceConflictException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFunctionConcurrencyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteFunctionConcurrencyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFunctionConcurrencyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFunctionConcurrency");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteFunctionConcurrencyRequest, DeleteFunctionConcurrencyResponse>()
                            .withOperationName("DeleteFunctionConcurrency").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteFunctionConcurrencyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteFunctionConcurrencyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the configuration for asynchronous invocation for a function, version, or alias.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     *
     * @param deleteFunctionEventInvokeConfigRequest
     * @return Result of the DeleteFunctionEventInvokeConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteFunctionEventInvokeConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteFunctionEventInvokeConfigResponse deleteFunctionEventInvokeConfig(
            DeleteFunctionEventInvokeConfigRequest deleteFunctionEventInvokeConfigRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceConflictException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFunctionEventInvokeConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteFunctionEventInvokeConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteFunctionEventInvokeConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFunctionEventInvokeConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteFunctionEventInvokeConfigRequest, DeleteFunctionEventInvokeConfigResponse>()
                            .withOperationName("DeleteFunctionEventInvokeConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteFunctionEventInvokeConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteFunctionEventInvokeConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a Lambda function URL. When you delete a function URL, you can't recover it. Creating a new function URL
     * results in a different URL address.
     * </p>
     *
     * @param deleteFunctionUrlConfigRequest
     * @return Result of the DeleteFunctionUrlConfig operation returned by the service.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteFunctionUrlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionUrlConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteFunctionUrlConfigResponse deleteFunctionUrlConfig(DeleteFunctionUrlConfigRequest deleteFunctionUrlConfigRequest)
            throws ResourceConflictException, ResourceNotFoundException, ServiceException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFunctionUrlConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteFunctionUrlConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFunctionUrlConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFunctionUrlConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteFunctionUrlConfigRequest, DeleteFunctionUrlConfigResponse>()
                            .withOperationName("DeleteFunctionUrlConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteFunctionUrlConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteFunctionUrlConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
     * layer</a>. Deleted versions can no longer be viewed or added to functions. To avoid breaking functions, a copy of
     * the version remains in Lambda until no functions refer to it.
     * </p>
     *
     * @param deleteLayerVersionRequest
     * @return Result of the DeleteLayerVersion operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteLayerVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteLayerVersionResponse deleteLayerVersion(DeleteLayerVersionRequest deleteLayerVersionRequest)
            throws ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteLayerVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteLayerVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLayerVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLayerVersion");

            return clientHandler.execute(new ClientExecutionParams<DeleteLayerVersionRequest, DeleteLayerVersionResponse>()
                    .withOperationName("DeleteLayerVersion").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteLayerVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteLayerVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the provisioned concurrency configuration for a function.
     * </p>
     *
     * @param deleteProvisionedConcurrencyConfigRequest
     * @return Result of the DeleteProvisionedConcurrencyConfig operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteProvisionedConcurrencyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteProvisionedConcurrencyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteProvisionedConcurrencyConfigResponse deleteProvisionedConcurrencyConfig(
            DeleteProvisionedConcurrencyConfigRequest deleteProvisionedConcurrencyConfigRequest)
            throws InvalidParameterValueException, ResourceConflictException, ResourceNotFoundException,
            TooManyRequestsException, ServiceException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteProvisionedConcurrencyConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteProvisionedConcurrencyConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteProvisionedConcurrencyConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProvisionedConcurrencyConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteProvisionedConcurrencyConfigRequest, DeleteProvisionedConcurrencyConfigResponse>()
                            .withOperationName("DeleteProvisionedConcurrencyConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteProvisionedConcurrencyConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteProvisionedConcurrencyConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves details about your account's <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">limits</a> and usage in an Amazon Web Services
     * Region.
     * </p>
     *
     * @param getAccountSettingsRequest
     * @return Result of the GetAccountSettings operation returned by the service.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetAccountSettingsResponse getAccountSettings(GetAccountSettingsRequest getAccountSettingsRequest)
            throws TooManyRequestsException, ServiceException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAccountSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAccountSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccountSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccountSettings");

            return clientHandler.execute(new ClientExecutionParams<GetAccountSettingsRequest, GetAccountSettingsResponse>()
                    .withOperationName("GetAccountSettings").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getAccountSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAccountSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns details about a Lambda function <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.
     * </p>
     *
     * @param getAliasRequest
     * @return Result of the GetAlias operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetAliasResponse getAlias(GetAliasRequest getAliasRequest) throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAlias");

            return clientHandler.execute(new ClientExecutionParams<GetAliasRequest, GetAliasResponse>()
                    .withOperationName("GetAlias").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getAliasRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the specified code signing configuration.
     * </p>
     *
     * @param getCodeSigningConfigRequest
     * @return Result of the GetCodeSigningConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetCodeSigningConfig" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetCodeSigningConfigResponse getCodeSigningConfig(GetCodeSigningConfigRequest getCodeSigningConfigRequest)
            throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCodeSigningConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCodeSigningConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCodeSigningConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCodeSigningConfig");

            return clientHandler.execute(new ClientExecutionParams<GetCodeSigningConfigRequest, GetCodeSigningConfigResponse>()
                    .withOperationName("GetCodeSigningConfig").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getCodeSigningConfigRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetCodeSigningConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns details about an event source mapping. You can get the identifier of a mapping from the output of
     * <a>ListEventSourceMappings</a>.
     * </p>
     *
     * @param getEventSourceMappingRequest
     * @return Result of the GetEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetEventSourceMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetEventSourceMapping" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetEventSourceMappingResponse getEventSourceMapping(GetEventSourceMappingRequest getEventSourceMappingRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEventSourceMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetEventSourceMappingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEventSourceMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEventSourceMapping");

            return clientHandler.execute(new ClientExecutionParams<GetEventSourceMappingRequest, GetEventSourceMappingResponse>()
                    .withOperationName("GetEventSourceMapping").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getEventSourceMappingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetEventSourceMappingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the function or function version, with a link to download the deployment package that's
     * valid for 10 minutes. If you specify a function version, only details that are specific to that version are
     * returned.
     * </p>
     *
     * @param getFunctionRequest
     * @return Result of the GetFunction operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetFunctionResponse getFunction(GetFunctionRequest getFunctionRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFunctionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetFunctionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFunction");

            return clientHandler.execute(new ClientExecutionParams<GetFunctionRequest, GetFunctionResponse>()
                    .withOperationName("GetFunction").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getFunctionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetFunctionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the code signing configuration for the specified function.
     * </p>
     *
     * @param getFunctionCodeSigningConfigRequest
     * @return Result of the GetFunctionCodeSigningConfig operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunctionCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetFunctionCodeSigningConfigResponse getFunctionCodeSigningConfig(
            GetFunctionCodeSigningConfigRequest getFunctionCodeSigningConfigRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException,
            LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFunctionCodeSigningConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetFunctionCodeSigningConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFunctionCodeSigningConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFunctionCodeSigningConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<GetFunctionCodeSigningConfigRequest, GetFunctionCodeSigningConfigResponse>()
                            .withOperationName("GetFunctionCodeSigningConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getFunctionCodeSigningConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetFunctionCodeSigningConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns details about the reserved concurrency configuration for a function. To set a concurrency limit for a
     * function, use <a>PutFunctionConcurrency</a>.
     * </p>
     *
     * @param getFunctionConcurrencyRequest
     * @return Result of the GetFunctionConcurrency operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunctionConcurrency
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConcurrency" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetFunctionConcurrencyResponse getFunctionConcurrency(GetFunctionConcurrencyRequest getFunctionConcurrencyRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException, ServiceException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFunctionConcurrencyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetFunctionConcurrencyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFunctionConcurrencyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFunctionConcurrency");

            return clientHandler
                    .execute(new ClientExecutionParams<GetFunctionConcurrencyRequest, GetFunctionConcurrencyResponse>()
                            .withOperationName("GetFunctionConcurrency").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getFunctionConcurrencyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetFunctionConcurrencyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the version-specific settings of a Lambda function or version. The output includes only options that can
     * vary between versions of a function. To modify these settings, use <a>UpdateFunctionConfiguration</a>.
     * </p>
     * <p>
     * To get all of a function's details, including function-level settings, use <a>GetFunction</a>.
     * </p>
     *
     * @param getFunctionConfigurationRequest
     * @return Result of the GetFunctionConfiguration operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunctionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetFunctionConfigurationResponse getFunctionConfiguration(
            GetFunctionConfigurationRequest getFunctionConfigurationRequest) throws ServiceException, ResourceNotFoundException,
            TooManyRequestsException, InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFunctionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetFunctionConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFunctionConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFunctionConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<GetFunctionConfigurationRequest, GetFunctionConfigurationResponse>()
                            .withOperationName("GetFunctionConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getFunctionConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetFunctionConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the configuration for asynchronous invocation for a function, version, or alias.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     *
     * @param getFunctionEventInvokeConfigRequest
     * @return Result of the GetFunctionEventInvokeConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunctionEventInvokeConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetFunctionEventInvokeConfigResponse getFunctionEventInvokeConfig(
            GetFunctionEventInvokeConfigRequest getFunctionEventInvokeConfigRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFunctionEventInvokeConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetFunctionEventInvokeConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFunctionEventInvokeConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFunctionEventInvokeConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<GetFunctionEventInvokeConfigRequest, GetFunctionEventInvokeConfigResponse>()
                            .withOperationName("GetFunctionEventInvokeConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getFunctionEventInvokeConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetFunctionEventInvokeConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns details about a Lambda function URL.
     * </p>
     *
     * @param getFunctionUrlConfigRequest
     * @return Result of the GetFunctionUrlConfig operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunctionUrlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionUrlConfig" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetFunctionUrlConfigResponse getFunctionUrlConfig(GetFunctionUrlConfigRequest getFunctionUrlConfigRequest)
            throws InvalidParameterValueException, ServiceException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFunctionUrlConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetFunctionUrlConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFunctionUrlConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFunctionUrlConfig");

            return clientHandler.execute(new ClientExecutionParams<GetFunctionUrlConfigRequest, GetFunctionUrlConfigResponse>()
                    .withOperationName("GetFunctionUrlConfig").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getFunctionUrlConfigRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetFunctionUrlConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>, with a link to
     * download the layer archive that's valid for 10 minutes.
     * </p>
     *
     * @param getLayerVersionRequest
     * @return Result of the GetLayerVersion operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetLayerVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetLayerVersionResponse getLayerVersion(GetLayerVersionRequest getLayerVersionRequest) throws ServiceException,
            InvalidParameterValueException, TooManyRequestsException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLayerVersionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetLayerVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLayerVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLayerVersion");

            return clientHandler.execute(new ClientExecutionParams<GetLayerVersionRequest, GetLayerVersionResponse>()
                    .withOperationName("GetLayerVersion").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getLayerVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetLayerVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>, with a link to
     * download the layer archive that's valid for 10 minutes.
     * </p>
     *
     * @param getLayerVersionByArnRequest
     * @return Result of the GetLayerVersionByArn operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetLayerVersionByArn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersionByArn" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetLayerVersionByArnResponse getLayerVersionByArn(GetLayerVersionByArnRequest getLayerVersionByArnRequest)
            throws ServiceException, InvalidParameterValueException, TooManyRequestsException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLayerVersionByArnResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetLayerVersionByArnResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLayerVersionByArnRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLayerVersionByArn");

            return clientHandler.execute(new ClientExecutionParams<GetLayerVersionByArnRequest, GetLayerVersionByArnResponse>()
                    .withOperationName("GetLayerVersionByArn").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getLayerVersionByArnRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetLayerVersionByArnRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the permission policy for a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. For more
     * information, see <a>AddLayerVersionPermission</a>.
     * </p>
     *
     * @param getLayerVersionPolicyRequest
     * @return Result of the GetLayerVersionPolicy operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetLayerVersionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetLayerVersionPolicyResponse getLayerVersionPolicy(GetLayerVersionPolicyRequest getLayerVersionPolicyRequest)
            throws ServiceException, ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLayerVersionPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetLayerVersionPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLayerVersionPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLayerVersionPolicy");

            return clientHandler.execute(new ClientExecutionParams<GetLayerVersionPolicyRequest, GetLayerVersionPolicyResponse>()
                    .withOperationName("GetLayerVersionPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getLayerVersionPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetLayerVersionPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">resource-based IAM
     * policy</a> for a function, version, or alias.
     * </p>
     *
     * @param getPolicyRequest
     * @return Result of the GetPolicy operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetPolicyResponse getPolicy(GetPolicyRequest getPolicyRequest) throws ServiceException, ResourceNotFoundException,
            TooManyRequestsException, InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPolicy");

            return clientHandler.execute(new ClientExecutionParams<GetPolicyRequest, GetPolicyResponse>()
                    .withOperationName("GetPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the provisioned concurrency configuration for a function's alias or version.
     * </p>
     *
     * @param getProvisionedConcurrencyConfigRequest
     * @return Result of the GetProvisionedConcurrencyConfig operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ProvisionedConcurrencyConfigNotFoundException
     *         The specified configuration does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetProvisionedConcurrencyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetProvisionedConcurrencyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetProvisionedConcurrencyConfigResponse getProvisionedConcurrencyConfig(
            GetProvisionedConcurrencyConfigRequest getProvisionedConcurrencyConfigRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, TooManyRequestsException, ServiceException, ProvisionedConcurrencyConfigNotFoundException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetProvisionedConcurrencyConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetProvisionedConcurrencyConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getProvisionedConcurrencyConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetProvisionedConcurrencyConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<GetProvisionedConcurrencyConfigRequest, GetProvisionedConcurrencyConfigResponse>()
                            .withOperationName("GetProvisionedConcurrencyConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getProvisionedConcurrencyConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetProvisionedConcurrencyConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Invokes a Lambda function. You can invoke a function synchronously (and wait for the response), or
     * asynchronously. To invoke a function asynchronously, set <code>InvocationType</code> to <code>Event</code>.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-sync.html">synchronous invocation</a>,
     * details about the function response, including errors, are included in the response body and headers. For either
     * invocation type, you can find more information in the <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/monitoring-functions.html">execution log</a> and <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-x-ray.html">trace</a>.
     * </p>
     * <p>
     * When an error occurs, your function may be invoked multiple times. Retry behavior varies by error type, client,
     * event source, and invocation type. For example, if you invoke a function asynchronously and it returns an error,
     * Lambda executes the function up to two more times. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-retries.html">Error handling and automatic retries
     * in Lambda</a>.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html">asynchronous invocation</a>,
     * Lambda adds events to a queue before sending them to your function. If your function does not have enough
     * capacity to keep up with the queue, events may be lost. Occasionally, your function may receive the same event
     * multiple times, even if no error occurs. To retain events that were not processed, configure your function with a
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-dlq">dead-letter
     * queue</a>.
     * </p>
     * <p>
     * The status code in the API response doesn't reflect function errors. Error codes are reserved for errors that
     * prevent your function from executing, such as permissions errors, <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">quota</a> errors, or issues with
     * your function's code and configuration. For example, Lambda returns <code>TooManyRequestsException</code> if
     * running the function would cause you to exceed a concurrency limit at either the account level (
     * <code>ConcurrentInvocationLimitExceeded</code>) or function level (
     * <code>ReservedFunctionConcurrentInvocationLimitExceeded</code>).
     * </p>
     * <p>
     * For functions with a long timeout, your client might disconnect during synchronous invocation while it waits for
     * a response. Configure your HTTP client, SDK, firewall, proxy, or operating system to allow for long connections
     * with timeout or keep-alive settings.
     * </p>
     * <p>
     * This operation requires permission for the <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awslambda.html">lambda:InvokeFunction</a> action. For
     * details on how to set up permissions for cross-account invocations, see <a href=
     * "https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html#permissions-resource-xaccountinvoke"
     * >Granting function access to other accounts</a>.
     * </p>
     *
     * @param invokeRequest
     * @return Result of the Invoke operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidRequestContentException
     *         The request body could not be parsed as JSON.
     * @throws RequestTooLargeException
     *         The request payload exceeded the <code>Invoke</code> request body JSON input quota. For more information,
     *         see <a href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws UnsupportedMediaTypeException
     *         The content type of the <code>Invoke</code> request body is not JSON.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws Ec2UnexpectedException
     *         Lambda received an unexpected Amazon EC2 client exception while setting up for the Lambda function.
     * @throws SubnetIpAddressLimitReachedException
     *         Lambda couldn't set up VPC access for the Lambda function because one or more configured subnets has no
     *         available IP addresses.
     * @throws EniLimitReachedException
     *         Lambda couldn't create an elastic network interface in the VPC, specified as part of Lambda function
     *         configuration, because the limit for network interfaces has been reached. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws EfsMountConnectivityException
     *         The Lambda function couldn't make a network connection to the configured file system.
     * @throws EfsMountFailureException
     *         The Lambda function couldn't mount the configured file system due to a permission or configuration issue.
     * @throws EfsMountTimeoutException
     *         The Lambda function made a network connection to the configured file system, but the mount operation
     *         timed out.
     * @throws EfsioException
     *         An error occurred when reading from or writing to a connected file system.
     * @throws SnapStartException
     *         The runtime restore hook encountered an error. For more information, check the Amazon CloudWatch logs.
     * @throws SnapStartTimeoutException
     *         The runtime restore hook failed to complete within the timeout limit (2 seconds).
     * @throws SnapStartNotReadyException
     *         Lambda is initializing your function. You can invoke the function when the <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">function state</a> becomes
     *         <code>Active</code>.
     * @throws Ec2ThrottledException
     *         Amazon EC2 throttled Lambda during Lambda function initialization using the execution role provided for
     *         the function.
     * @throws Ec2AccessDeniedException
     *         Need additional permissions to configure VPC settings.
     * @throws InvalidSubnetIdException
     *         The subnet ID provided in the Lambda function VPC configuration is not valid.
     * @throws InvalidSecurityGroupIdException
     *         The security group ID provided in the Lambda function VPC configuration is not valid.
     * @throws InvalidZipFileException
     *         Lambda could not unzip the deployment package.
     * @throws KmsDisabledException
     *         Lambda couldn't decrypt the environment variables because the KMS key used is disabled. Check the Lambda
     *         function's KMS key settings.
     * @throws KmsInvalidStateException
     *         Lambda couldn't decrypt the environment variables because the state of the KMS key used is not valid for
     *         Decrypt. Check the function's KMS key settings.
     * @throws KmsAccessDeniedException
     *         Lambda couldn't decrypt the environment variables because KMS access was denied. Check the Lambda
     *         function's KMS permissions.
     * @throws KmsNotFoundException
     *         Lambda couldn't decrypt the environment variables because the KMS key was not found. Check the function's
     *         KMS key settings.
     * @throws InvalidRuntimeException
     *         The runtime or runtime version specified is not supported.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotReadyException
     *         The function is inactive and its VPC connection is no longer available. Wait for the VPC connection to
     *         reestablish and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.Invoke
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/Invoke" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public InvokeResponse invoke(InvokeRequest invokeRequest) throws ServiceException, ResourceNotFoundException,
            InvalidRequestContentException, RequestTooLargeException, UnsupportedMediaTypeException, TooManyRequestsException,
            InvalidParameterValueException, Ec2UnexpectedException, SubnetIpAddressLimitReachedException,
            EniLimitReachedException, EfsMountConnectivityException, EfsMountFailureException, EfsMountTimeoutException,
            EfsioException, SnapStartException, SnapStartTimeoutException, SnapStartNotReadyException, Ec2ThrottledException,
            Ec2AccessDeniedException, InvalidSubnetIdException, InvalidSecurityGroupIdException, InvalidZipFileException,
            KmsDisabledException, KmsInvalidStateException, KmsAccessDeniedException, KmsNotFoundException,
            InvalidRuntimeException, ResourceConflictException, ResourceNotReadyException, AwsServiceException,
            SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(false).build();

        HttpResponseHandler<InvokeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                InvokeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, invokeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "Invoke");

            return clientHandler.execute(new ClientExecutionParams<InvokeRequest, InvokeResponse>().withOperationName("Invoke")
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(invokeRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new InvokeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">aliases</a> for
     * a Lambda function.
     * </p>
     *
     * @param listAliasesRequest
     * @return Result of the ListAliases operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAliasesResponse listAliases(ListAliasesRequest listAliasesRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAliasesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAliasesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAliasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAliases");

            return clientHandler.execute(new ClientExecutionParams<ListAliasesRequest, ListAliasesResponse>()
                    .withOperationName("ListAliases").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listAliasesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAliasesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">aliases</a> for
     * a Lambda function.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAliases(software.amazon.awssdk.services.lambda.model.ListAliasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAliases(software.amazon.awssdk.services.lambda.model.ListAliasesRequest)} operation.</b>
     * </p>
     *
     * @param listAliasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAliasesIterable listAliasesPaginator(ListAliasesRequest listAliasesRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return new ListAliasesIterable(this, applyPaginatorUserAgent(listAliasesRequest));
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuring-codesigning.html">code
     * signing configurations</a>. A request returns up to 10,000 configurations per call. You can use the
     * <code>MaxItems</code> parameter to return fewer configurations per call.
     * </p>
     *
     * @param listCodeSigningConfigsRequest
     * @return Result of the ListCodeSigningConfigs operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListCodeSigningConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListCodeSigningConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListCodeSigningConfigsResponse listCodeSigningConfigs(ListCodeSigningConfigsRequest listCodeSigningConfigsRequest)
            throws ServiceException, InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCodeSigningConfigsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCodeSigningConfigsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCodeSigningConfigsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCodeSigningConfigs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListCodeSigningConfigsRequest, ListCodeSigningConfigsResponse>()
                            .withOperationName("ListCodeSigningConfigs").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listCodeSigningConfigsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListCodeSigningConfigsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuring-codesigning.html">code
     * signing configurations</a>. A request returns up to 10,000 configurations per call. You can use the
     * <code>MaxItems</code> parameter to return fewer configurations per call.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCodeSigningConfigs(software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListCodeSigningConfigsIterable responses = client.listCodeSigningConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListCodeSigningConfigsIterable responses = client
     *             .listCodeSigningConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListCodeSigningConfigsIterable responses = client.listCodeSigningConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCodeSigningConfigs(software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCodeSigningConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListCodeSigningConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListCodeSigningConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListCodeSigningConfigsIterable listCodeSigningConfigsPaginator(
            ListCodeSigningConfigsRequest listCodeSigningConfigsRequest) throws ServiceException, InvalidParameterValueException,
            AwsServiceException, SdkClientException, LambdaException {
        return new ListCodeSigningConfigsIterable(this, applyPaginatorUserAgent(listCodeSigningConfigsRequest));
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to show only event source mappings for a
     * single event source.
     * </p>
     *
     * @param listEventSourceMappingsRequest
     * @return Result of the ListEventSourceMappings operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListEventSourceMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListEventSourceMappingsResponse listEventSourceMappings(ListEventSourceMappingsRequest listEventSourceMappingsRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEventSourceMappingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListEventSourceMappingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEventSourceMappingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEventSourceMappings");

            return clientHandler
                    .execute(new ClientExecutionParams<ListEventSourceMappingsRequest, ListEventSourceMappingsResponse>()
                            .withOperationName("ListEventSourceMappings").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listEventSourceMappingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListEventSourceMappingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to show only event source mappings for a
     * single event source.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client.listEventSourceMappingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client
     *             .listEventSourceMappingsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client.listEventSourceMappingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventSourceMappingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListEventSourceMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListEventSourceMappingsIterable listEventSourceMappingsPaginator(
            ListEventSourceMappingsRequest listEventSourceMappingsRequest) throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        return new ListEventSourceMappingsIterable(this, applyPaginatorUserAgent(listEventSourceMappingsRequest));
    }

    /**
     * <p>
     * Retrieves a list of configurations for asynchronous invocation for a function.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     *
     * @param listFunctionEventInvokeConfigsRequest
     * @return Result of the ListFunctionEventInvokeConfigs operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctionEventInvokeConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionEventInvokeConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListFunctionEventInvokeConfigsResponse listFunctionEventInvokeConfigs(
            ListFunctionEventInvokeConfigsRequest listFunctionEventInvokeConfigsRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, TooManyRequestsException, ServiceException, AwsServiceException, SdkClientException,
            LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFunctionEventInvokeConfigsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListFunctionEventInvokeConfigsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listFunctionEventInvokeConfigsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFunctionEventInvokeConfigs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListFunctionEventInvokeConfigsRequest, ListFunctionEventInvokeConfigsResponse>()
                            .withOperationName("ListFunctionEventInvokeConfigs").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listFunctionEventInvokeConfigsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListFunctionEventInvokeConfigsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of configurations for asynchronous invocation for a function.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFunctionEventInvokeConfigs(software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionEventInvokeConfigsIterable responses = client.listFunctionEventInvokeConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListFunctionEventInvokeConfigsIterable responses = client
     *             .listFunctionEventInvokeConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionEventInvokeConfigsIterable responses = client.listFunctionEventInvokeConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctionEventInvokeConfigs(software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFunctionEventInvokeConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctionEventInvokeConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionEventInvokeConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListFunctionEventInvokeConfigsIterable listFunctionEventInvokeConfigsPaginator(
            ListFunctionEventInvokeConfigsRequest listFunctionEventInvokeConfigsRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, TooManyRequestsException, ServiceException, AwsServiceException, SdkClientException,
            LambdaException {
        return new ListFunctionEventInvokeConfigsIterable(this, applyPaginatorUserAgent(listFunctionEventInvokeConfigsRequest));
    }

    /**
     * <p>
     * Returns a list of Lambda function URLs for the specified function.
     * </p>
     *
     * @param listFunctionUrlConfigsRequest
     * @return Result of the ListFunctionUrlConfigs operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctionUrlConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionUrlConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListFunctionUrlConfigsResponse listFunctionUrlConfigs(ListFunctionUrlConfigsRequest listFunctionUrlConfigsRequest)
            throws InvalidParameterValueException, ServiceException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFunctionUrlConfigsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListFunctionUrlConfigsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFunctionUrlConfigsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFunctionUrlConfigs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListFunctionUrlConfigsRequest, ListFunctionUrlConfigsResponse>()
                            .withOperationName("ListFunctionUrlConfigs").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listFunctionUrlConfigsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListFunctionUrlConfigsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of Lambda function URLs for the specified function.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFunctionUrlConfigs(software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionUrlConfigsIterable responses = client.listFunctionUrlConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListFunctionUrlConfigsIterable responses = client
     *             .listFunctionUrlConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionUrlConfigsIterable responses = client.listFunctionUrlConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctionUrlConfigs(software.amazon.awssdk.services.lambda.model.ListFunctionUrlConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFunctionUrlConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctionUrlConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionUrlConfigs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListFunctionUrlConfigsIterable listFunctionUrlConfigsPaginator(
            ListFunctionUrlConfigsRequest listFunctionUrlConfigsRequest) throws InvalidParameterValueException, ServiceException,
            ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        return new ListFunctionUrlConfigsIterable(this, applyPaginatorUserAgent(listFunctionUrlConfigsRequest));
    }

    /**
     * <p>
     * Returns a list of Lambda functions, with the version-specific configuration of each. Lambda returns up to 50
     * functions per call.
     * </p>
     * <p>
     * Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in
     * addition to the unpublished version.
     * </p>
     * <note>
     * <p>
     * The <code>ListFunctions</code> operation returns a subset of the <a>FunctionConfiguration</a> fields. To get the
     * additional fields (State, StateReasonCode, StateReason, LastUpdateStatus, LastUpdateStatusReason,
     * LastUpdateStatusReasonCode) for a function or version, use <a>GetFunction</a>.
     * </p>
     * </note>
     *
     * @param listFunctionsRequest
     * @return Result of the ListFunctions operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListFunctionsResponse listFunctions(ListFunctionsRequest listFunctionsRequest) throws ServiceException,
            TooManyRequestsException, InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFunctionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListFunctionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFunctionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFunctions");

            return clientHandler.execute(new ClientExecutionParams<ListFunctionsRequest, ListFunctionsResponse>()
                    .withOperationName("ListFunctions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listFunctionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListFunctionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of Lambda functions, with the version-specific configuration of each. Lambda returns up to 50
     * functions per call.
     * </p>
     * <p>
     * Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in
     * addition to the unpublished version.
     * </p>
     * <note>
     * <p>
     * The <code>ListFunctions</code> operation returns a subset of the <a>FunctionConfiguration</a> fields. To get the
     * additional fields (State, StateReasonCode, StateReason, LastUpdateStatus, LastUpdateStatusReason,
     * LastUpdateStatusReasonCode) for a function or version, use <a>GetFunction</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListFunctionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)} operation.</b>
     * </p>
     *
     * @param listFunctionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListFunctionsIterable listFunctionsPaginator(ListFunctionsRequest listFunctionsRequest) throws ServiceException,
            TooManyRequestsException, InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        return new ListFunctionsIterable(this, applyPaginatorUserAgent(listFunctionsRequest));
    }

    /**
     * <p>
     * List the functions that use the specified code signing configuration. You can use this method prior to deleting a
     * code signing configuration, to verify that no functions are using it.
     * </p>
     *
     * @param listFunctionsByCodeSigningConfigRequest
     * @return Result of the ListFunctionsByCodeSigningConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctionsByCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionsByCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListFunctionsByCodeSigningConfigResponse listFunctionsByCodeSigningConfig(
            ListFunctionsByCodeSigningConfigRequest listFunctionsByCodeSigningConfigRequest) throws ServiceException,
            InvalidParameterValueException, ResourceNotFoundException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFunctionsByCodeSigningConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListFunctionsByCodeSigningConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listFunctionsByCodeSigningConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFunctionsByCodeSigningConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<ListFunctionsByCodeSigningConfigRequest, ListFunctionsByCodeSigningConfigResponse>()
                            .withOperationName("ListFunctionsByCodeSigningConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listFunctionsByCodeSigningConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListFunctionsByCodeSigningConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List the functions that use the specified code signing configuration. You can use this method prior to deleting a
     * code signing configuration, to verify that no functions are using it.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFunctionsByCodeSigningConfig(software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsByCodeSigningConfigIterable responses = client.listFunctionsByCodeSigningConfigPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListFunctionsByCodeSigningConfigIterable responses = client
     *             .listFunctionsByCodeSigningConfigPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsByCodeSigningConfigIterable responses = client.listFunctionsByCodeSigningConfigPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctionsByCodeSigningConfig(software.amazon.awssdk.services.lambda.model.ListFunctionsByCodeSigningConfigRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFunctionsByCodeSigningConfigRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctionsByCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionsByCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListFunctionsByCodeSigningConfigIterable listFunctionsByCodeSigningConfigPaginator(
            ListFunctionsByCodeSigningConfigRequest listFunctionsByCodeSigningConfigRequest) throws ServiceException,
            InvalidParameterValueException, ResourceNotFoundException, AwsServiceException, SdkClientException, LambdaException {
        return new ListFunctionsByCodeSigningConfigIterable(this,
                applyPaginatorUserAgent(listFunctionsByCodeSigningConfigRequest));
    }

    /**
     * <p>
     * Lists the versions of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
     * layer</a>. Versions that have been deleted aren't listed. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * versions that indicate that they're compatible with that runtime. Specify a compatible architecture to include
     * only layer versions that are compatible with that architecture.
     * </p>
     *
     * @param listLayerVersionsRequest
     * @return Result of the ListLayerVersions operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListLayerVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayerVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListLayerVersionsResponse listLayerVersions(ListLayerVersionsRequest listLayerVersionsRequest)
            throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLayerVersionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListLayerVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLayerVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLayerVersions");

            return clientHandler.execute(new ClientExecutionParams<ListLayerVersionsRequest, ListLayerVersionsResponse>()
                    .withOperationName("ListLayerVersions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listLayerVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListLayerVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the versions of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda
     * layer</a>. Versions that have been deleted aren't listed. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * versions that indicate that they're compatible with that runtime. Specify a compatible architecture to include
     * only layer versions that are compatible with that architecture.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLayerVersions(software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayerVersionsIterable responses = client.listLayerVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListLayerVersionsIterable responses = client
     *             .listLayerVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListLayerVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayerVersionsIterable responses = client.listLayerVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLayerVersions(software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listLayerVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListLayerVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayerVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListLayerVersionsIterable listLayerVersionsPaginator(ListLayerVersionsRequest listLayerVersionsRequest)
            throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        return new ListLayerVersionsIterable(this, applyPaginatorUserAgent(listLayerVersionsRequest));
    }

    /**
     * <p>
     * Lists <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-layers.html">Lambda layers</a> and shows
     * information about the latest version of each. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * layers that indicate that they're compatible with that runtime. Specify a compatible architecture to include only
     * layers that are compatible with that <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.
     * </p>
     *
     * @param listLayersRequest
     * @return Result of the ListLayers operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListLayers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListLayersResponse listLayers(ListLayersRequest listLayersRequest) throws ServiceException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLayersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListLayersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLayersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLayers");

            return clientHandler
                    .execute(new ClientExecutionParams<ListLayersRequest, ListLayersResponse>().withOperationName("ListLayers")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listLayersRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListLayersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-layers.html">Lambda layers</a> and shows
     * information about the latest version of each. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * layers that indicate that they're compatible with that runtime. Specify a compatible architecture to include only
     * layers that are compatible with that <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/foundation-arch.html">instruction set architecture</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listLayers(software.amazon.awssdk.services.lambda.model.ListLayersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayersIterable responses = client.listLayersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListLayersIterable responses = client.listLayersPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListLayersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayersIterable responses = client.listLayersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLayers(software.amazon.awssdk.services.lambda.model.ListLayersRequest)} operation.</b>
     * </p>
     *
     * @param listLayersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListLayers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListLayersIterable listLayersPaginator(ListLayersRequest listLayersRequest) throws ServiceException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        return new ListLayersIterable(this, applyPaginatorUserAgent(listLayersRequest));
    }

    /**
     * <p>
     * Retrieves a list of provisioned concurrency configurations for a function.
     * </p>
     *
     * @param listProvisionedConcurrencyConfigsRequest
     * @return Result of the ListProvisionedConcurrencyConfigs operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListProvisionedConcurrencyConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListProvisionedConcurrencyConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListProvisionedConcurrencyConfigsResponse listProvisionedConcurrencyConfigs(
            ListProvisionedConcurrencyConfigsRequest listProvisionedConcurrencyConfigsRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException, ServiceException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListProvisionedConcurrencyConfigsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListProvisionedConcurrencyConfigsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listProvisionedConcurrencyConfigsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProvisionedConcurrencyConfigs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListProvisionedConcurrencyConfigsRequest, ListProvisionedConcurrencyConfigsResponse>()
                            .withOperationName("ListProvisionedConcurrencyConfigs").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listProvisionedConcurrencyConfigsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListProvisionedConcurrencyConfigsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of provisioned concurrency configurations for a function.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProvisionedConcurrencyConfigs(software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListProvisionedConcurrencyConfigsIterable responses = client.listProvisionedConcurrencyConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListProvisionedConcurrencyConfigsIterable responses = client
     *             .listProvisionedConcurrencyConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListProvisionedConcurrencyConfigsIterable responses = client.listProvisionedConcurrencyConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProvisionedConcurrencyConfigs(software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProvisionedConcurrencyConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListProvisionedConcurrencyConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListProvisionedConcurrencyConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListProvisionedConcurrencyConfigsIterable listProvisionedConcurrencyConfigsPaginator(
            ListProvisionedConcurrencyConfigsRequest listProvisionedConcurrencyConfigsRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException, ServiceException,
            AwsServiceException, SdkClientException, LambdaException {
        return new ListProvisionedConcurrencyConfigsIterable(this,
                applyPaginatorUserAgent(listProvisionedConcurrencyConfigsRequest));
    }

    /**
     * <p>
     * Returns a function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a>. You can also
     * view tags with <a>GetFunction</a>.
     * </p>
     *
     * @param listTagsRequest
     * @return Result of the ListTags operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTags");

            return clientHandler.execute(new ClientExecutionParams<ListTagsRequest, ListTagsResponse>()
                    .withOperationName("ListTags").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagsRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new ListTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">versions</a>,
     * with the version-specific configuration of each. Lambda returns up to 50 versions per call.
     * </p>
     *
     * @param listVersionsByFunctionRequest
     * @return Result of the ListVersionsByFunction operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListVersionsByFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunction" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListVersionsByFunctionResponse listVersionsByFunction(ListVersionsByFunctionRequest listVersionsByFunctionRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListVersionsByFunctionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListVersionsByFunctionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVersionsByFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVersionsByFunction");

            return clientHandler
                    .execute(new ClientExecutionParams<ListVersionsByFunctionRequest, ListVersionsByFunctionResponse>()
                            .withOperationName("ListVersionsByFunction").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listVersionsByFunctionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListVersionsByFunctionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">versions</a>,
     * with the version-specific configuration of each. Lambda returns up to 50 versions per call.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVersionsByFunction(software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListVersionsByFunctionIterable responses = client.listVersionsByFunctionPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListVersionsByFunctionIterable responses = client
     *             .listVersionsByFunctionPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListVersionsByFunctionIterable responses = client.listVersionsByFunctionPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVersionsByFunction(software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVersionsByFunctionRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListVersionsByFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunction" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListVersionsByFunctionIterable listVersionsByFunctionPaginator(
            ListVersionsByFunctionRequest listVersionsByFunctionRequest) throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        return new ListVersionsByFunctionIterable(this, applyPaginatorUserAgent(listVersionsByFunctionRequest));
    }

    /**
     * <p>
     * Creates an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a> from
     * a ZIP archive. Each time you call <code>PublishLayerVersion</code> with the same layer name, a new version is
     * created.
     * </p>
     * <p>
     * Add layers to your function with <a>CreateFunction</a> or <a>UpdateFunctionConfiguration</a>.
     * </p>
     *
     * @param publishLayerVersionRequest
     * @return Result of the PublishLayerVersion operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws CodeStorageExceededException
     *         Your Amazon Web Services account has exceeded its maximum total code size. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PublishLayerVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishLayerVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PublishLayerVersionResponse publishLayerVersion(PublishLayerVersionRequest publishLayerVersionRequest)
            throws ServiceException, ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException,
            CodeStorageExceededException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PublishLayerVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PublishLayerVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, publishLayerVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PublishLayerVersion");

            return clientHandler.execute(new ClientExecutionParams<PublishLayerVersionRequest, PublishLayerVersionResponse>()
                    .withOperationName("PublishLayerVersion").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(publishLayerVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PublishLayerVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">version</a> from the
     * current code and configuration of a function. Use versions to create a snapshot of your function code and
     * configuration that doesn't change.
     * </p>
     * <p>
     * Lambda doesn't publish a version if the function's configuration and code haven't changed since the last version.
     * Use <a>UpdateFunctionCode</a> or <a>UpdateFunctionConfiguration</a> to update the function before publishing a
     * version.
     * </p>
     * <p>
     * Clients can invoke versions directly or with an alias. To create an alias, use <a>CreateAlias</a>.
     * </p>
     *
     * @param publishVersionRequest
     * @return Result of the PublishVersion operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws CodeStorageExceededException
     *         Your Amazon Web Services account has exceeded its maximum total code size. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PublishVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PublishVersionResponse publishVersion(PublishVersionRequest publishVersionRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, CodeStorageExceededException,
            PreconditionFailedException, ResourceConflictException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PublishVersionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PublishVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, publishVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PublishVersion");

            return clientHandler.execute(new ClientExecutionParams<PublishVersionRequest, PublishVersionResponse>()
                    .withOperationName("PublishVersion").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(publishVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PublishVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update the code signing configuration for the function. Changes to the code signing configuration take effect the
     * next time a user tries to deploy a code package to the function.
     * </p>
     *
     * @param putFunctionCodeSigningConfigRequest
     * @return Result of the PutFunctionCodeSigningConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws CodeSigningConfigNotFoundException
     *         The specified code signing configuration does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PutFunctionCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutFunctionCodeSigningConfigResponse putFunctionCodeSigningConfig(
            PutFunctionCodeSigningConfigRequest putFunctionCodeSigningConfigRequest) throws ServiceException,
            InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException, ResourceConflictException,
            CodeSigningConfigNotFoundException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutFunctionCodeSigningConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutFunctionCodeSigningConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putFunctionCodeSigningConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutFunctionCodeSigningConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<PutFunctionCodeSigningConfigRequest, PutFunctionCodeSigningConfigResponse>()
                            .withOperationName("PutFunctionCodeSigningConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(putFunctionCodeSigningConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutFunctionCodeSigningConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the maximum number of simultaneous executions for a function, and reserves capacity for that concurrency
     * level.
     * </p>
     * <p>
     * Concurrency settings apply to the function as a whole, including all published versions and the unpublished
     * version. Reserving concurrency both ensures that your function has capacity to process the specified number of
     * events simultaneously, and prevents it from scaling beyond that level. Use <a>GetFunction</a> to see the current
     * setting for a function.
     * </p>
     * <p>
     * Use <a>GetAccountSettings</a> to see your Regional concurrency limit. You can reserve concurrency for as many
     * functions as you like, as long as you leave at least 100 simultaneous executions unreserved for functions that
     * aren't configured with a per-function limit. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-scaling.html">Lambda function scaling</a>.
     * </p>
     *
     * @param putFunctionConcurrencyRequest
     * @return Result of the PutFunctionConcurrency operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PutFunctionConcurrency
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionConcurrency" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PutFunctionConcurrencyResponse putFunctionConcurrency(PutFunctionConcurrencyRequest putFunctionConcurrencyRequest)
            throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException,
            ResourceConflictException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutFunctionConcurrencyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutFunctionConcurrencyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putFunctionConcurrencyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutFunctionConcurrency");

            return clientHandler
                    .execute(new ClientExecutionParams<PutFunctionConcurrencyRequest, PutFunctionConcurrencyResponse>()
                            .withOperationName("PutFunctionConcurrency").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(putFunctionConcurrencyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutFunctionConcurrencyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Configures options for <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html">asynchronous
     * invocation</a> on a function, version, or alias. If a configuration already exists for a function, version, or
     * alias, this operation overwrites it. If you exclude any settings, they are removed. To set one option without
     * affecting existing settings for other options, use <a>UpdateFunctionEventInvokeConfig</a>.
     * </p>
     * <p>
     * By default, Lambda retries an asynchronous invocation twice if the function returns an error. It retains events
     * in a queue for up to six hours. When an event fails all processing attempts or stays in the asynchronous
     * invocation queue for too long, Lambda discards it. To retain discarded events, configure a dead-letter queue with
     * <a>UpdateFunctionConfiguration</a>.
     * </p>
     * <p>
     * To send an invocation record to a queue, topic, function, or event bus, specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-async-destinations"
     * >destination</a>. You can configure separate destinations for successful invocations (on-success) and events that
     * fail all processing attempts (on-failure). You can configure destinations in addition to or instead of a
     * dead-letter queue.
     * </p>
     *
     * @param putFunctionEventInvokeConfigRequest
     * @return Result of the PutFunctionEventInvokeConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PutFunctionEventInvokeConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutFunctionEventInvokeConfigResponse putFunctionEventInvokeConfig(
            PutFunctionEventInvokeConfigRequest putFunctionEventInvokeConfigRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceConflictException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutFunctionEventInvokeConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutFunctionEventInvokeConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putFunctionEventInvokeConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutFunctionEventInvokeConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<PutFunctionEventInvokeConfigRequest, PutFunctionEventInvokeConfigResponse>()
                            .withOperationName("PutFunctionEventInvokeConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(putFunctionEventInvokeConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutFunctionEventInvokeConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a provisioned concurrency configuration to a function's alias or version.
     * </p>
     *
     * @param putProvisionedConcurrencyConfigRequest
     * @return Result of the PutProvisionedConcurrencyConfig operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PutProvisionedConcurrencyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutProvisionedConcurrencyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutProvisionedConcurrencyConfigResponse putProvisionedConcurrencyConfig(
            PutProvisionedConcurrencyConfigRequest putProvisionedConcurrencyConfigRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, ResourceConflictException, TooManyRequestsException, ServiceException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutProvisionedConcurrencyConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutProvisionedConcurrencyConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putProvisionedConcurrencyConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutProvisionedConcurrencyConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<PutProvisionedConcurrencyConfigRequest, PutProvisionedConcurrencyConfigResponse>()
                            .withOperationName("PutProvisionedConcurrencyConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(putProvisionedConcurrencyConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutProvisionedConcurrencyConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a statement from the permissions policy for a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">Lambda layer</a>. For more
     * information, see <a>AddLayerVersionPermission</a>.
     * </p>
     *
     * @param removeLayerVersionPermissionRequest
     * @return Result of the RemoveLayerVersionPermission operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.RemoveLayerVersionPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemoveLayerVersionPermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveLayerVersionPermissionResponse removeLayerVersionPermission(
            RemoveLayerVersionPermissionRequest removeLayerVersionPermissionRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, PreconditionFailedException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveLayerVersionPermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RemoveLayerVersionPermissionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeLayerVersionPermissionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveLayerVersionPermission");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveLayerVersionPermissionRequest, RemoveLayerVersionPermissionResponse>()
                            .withOperationName("RemoveLayerVersionPermission").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(removeLayerVersionPermissionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveLayerVersionPermissionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Revokes function-use permission from an Amazon Web Service or another Amazon Web Services account. You can get
     * the ID of the statement from the output of <a>GetPolicy</a>.
     * </p>
     *
     * @param removePermissionRequest
     * @return Result of the RemovePermission operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.RemovePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemovePermission" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RemovePermissionResponse removePermission(RemovePermissionRequest removePermissionRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, PreconditionFailedException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemovePermissionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RemovePermissionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removePermissionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemovePermission");

            return clientHandler.execute(new ClientExecutionParams<RemovePermissionRequest, RemovePermissionResponse>()
                    .withOperationName("RemovePermission").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(removePermissionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RemovePermissionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to a function.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceConflictException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> from a function.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceConflictException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration of a Lambda function <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.
     * </p>
     *
     * @param updateAliasRequest
     * @return Result of the UpdateAlias operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateAliasResponse updateAlias(UpdateAliasRequest updateAliasRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, PreconditionFailedException,
            ResourceConflictException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAlias");

            return clientHandler.execute(new ClientExecutionParams<UpdateAliasRequest, UpdateAliasResponse>()
                    .withOperationName("UpdateAlias").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update the code signing configuration. Changes to the code signing configuration take effect the next time a user
     * tries to deploy a code package to the function.
     * </p>
     *
     * @param updateCodeSigningConfigRequest
     * @return Result of the UpdateCodeSigningConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateCodeSigningConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateCodeSigningConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateCodeSigningConfigResponse updateCodeSigningConfig(UpdateCodeSigningConfigRequest updateCodeSigningConfigRequest)
            throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCodeSigningConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateCodeSigningConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCodeSigningConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCodeSigningConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateCodeSigningConfigRequest, UpdateCodeSigningConfigResponse>()
                            .withOperationName("UpdateCodeSigningConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateCodeSigningConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateCodeSigningConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an event source mapping. You can change the function that Lambda invokes, or pause invocation and resume
     * later from the same location.
     * </p>
     * <p>
     * For details about how to configure different event sources, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-dynamodb-eventsourcemapping"> Amazon
     * DynamoDB Streams</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-eventsourcemapping">
     * Amazon Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-eventsource"> Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-eventsourcemapping"> Amazon MQ and
     * RabbitMQ</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html"> Amazon MSK</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/kafka-smaa.html"> Apache Kafka</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following error handling options are available only for stream sources (DynamoDB and Kinesis):
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BisectBatchOnFunctionError</code> – If the function returns an error, split the batch in two and retry.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DestinationConfig</code> – Send discarded records to an Amazon SQS queue or Amazon SNS topic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRecordAgeInSeconds</code> – Discard records older than the specified age. The default value is
     * infinite (-1). When set to infinite (-1), failed records are retried until the record expires
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRetryAttempts</code> – Discard records after the specified number of retries. The default value is
     * infinite (-1). When set to infinite (-1), failed records are retried until the record expires.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ParallelizationFactor</code> – Process multiple batches from each shard concurrently.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about which configuration parameters apply to each event source, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html#services-ddb-params"> Amazon DynamoDB
     * Streams</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html#services-kinesis-params"> Amazon
     * Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-params"> Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-mq.html#services-mq-params"> Amazon MQ and
     * RabbitMQ</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#services-msk-parms"> Amazon MSK</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kafka.html#services-kafka-parms"> Apache Kafka</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param updateEventSourceMappingRequest
     * @return Result of the UpdateEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you tried to update an event
     *         source mapping in the CREATING state, or you tried to delete an event source mapping currently UPDATING.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateEventSourceMapping
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateEventSourceMappingResponse updateEventSourceMapping(
            UpdateEventSourceMappingRequest updateEventSourceMappingRequest) throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, ResourceConflictException, ResourceInUseException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateEventSourceMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateEventSourceMappingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEventSourceMappingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEventSourceMapping");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateEventSourceMappingRequest, UpdateEventSourceMappingResponse>()
                            .withOperationName("UpdateEventSourceMapping").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateEventSourceMappingRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateEventSourceMappingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a Lambda function's code. If code signing is enabled for the function, the code package must be signed by
     * a trusted publisher. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html">Configuring code signing for
     * Lambda</a>.
     * </p>
     * <p>
     * If the function's package type is <code>Image</code>, then you must specify the code package in
     * <code>ImageUri</code> as the URI of a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html">container image</a> in the Amazon ECR
     * registry.
     * </p>
     * <p>
     * If the function's package type is <code>Zip</code>, then you must specify the deployment package as a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html#gettingstarted-package-zip">.zip
     * file archive</a>. Enter the Amazon S3 bucket and key of the code .zip file location. You can also provide the
     * function code inline using the <code>ZipFile</code> field.
     * </p>
     * <p>
     * The code in the deployment package must be compatible with the target instruction set architecture of the
     * function (<code>x86-64</code> or <code>arm64</code>).
     * </p>
     * <p>
     * The function's code is locked when you publish a version. You can't modify the code of a published version, only
     * the unpublished version.
     * </p>
     * <note>
     * <p>
     * For a function defined as a container image, Lambda resolves the image tag to an image digest. In Amazon ECR, if
     * you update the image tag to a new image, Lambda does not automatically update the function.
     * </p>
     * </note>
     *
     * @param updateFunctionCodeRequest
     * @return Result of the UpdateFunctionCode operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws CodeStorageExceededException
     *         Your Amazon Web Services account has exceeded its maximum total code size. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html">Lambda quotas</a>.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws CodeVerificationFailedException
     *         The code signature failed one or more of the validation checks for signature mismatch or expiry, and the
     *         code signing policy is set to ENFORCE. Lambda blocks the deployment.
     * @throws InvalidCodeSignatureException
     *         The code signature failed the integrity check. If the integrity check fails, then Lambda blocks
     *         deployment, even if the code signing policy is set to WARN.
     * @throws CodeSigningConfigNotFoundException
     *         The specified code signing configuration does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateFunctionCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionCode" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateFunctionCodeResponse updateFunctionCode(UpdateFunctionCodeRequest updateFunctionCodeRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            CodeStorageExceededException, PreconditionFailedException, ResourceConflictException,
            CodeVerificationFailedException, InvalidCodeSignatureException, CodeSigningConfigNotFoundException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFunctionCodeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateFunctionCodeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFunctionCodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFunctionCode");

            return clientHandler.execute(new ClientExecutionParams<UpdateFunctionCodeRequest, UpdateFunctionCodeResponse>()
                    .withOperationName("UpdateFunctionCode").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateFunctionCodeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateFunctionCodeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modify the version-specific settings of a Lambda function.
     * </p>
     * <p>
     * When you update a function, Lambda provisions an instance of the function and its supporting resources. If your
     * function connects to a VPC, this process can take a minute. During this time, you can't modify the function, but
     * you can still invoke it. The <code>LastUpdateStatus</code>, <code>LastUpdateStatusReason</code>, and
     * <code>LastUpdateStatusReasonCode</code> fields in the response from <a>GetFunctionConfiguration</a> indicate when
     * the update is complete and the function is processing events with the new configuration. For more information,
     * see <a href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">Lambda function states</a>.
     * </p>
     * <p>
     * These settings can vary between versions of a function and are locked when you publish a version. You can't
     * modify the configuration of a published version, only the unpublished version.
     * </p>
     * <p>
     * To configure function concurrency, use <a>PutFunctionConcurrency</a>. To grant invoke permissions to an Amazon
     * Web Services account or Amazon Web Service, use <a>AddPermission</a>.
     * </p>
     *
     * @param updateFunctionConfigurationRequest
     * @return Result of the UpdateFunctionConfiguration operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API operation to retrieve the latest RevisionId for
     *         your resource.
     * @throws CodeVerificationFailedException
     *         The code signature failed one or more of the validation checks for signature mismatch or expiry, and the
     *         code signing policy is set to ENFORCE. Lambda blocks the deployment.
     * @throws InvalidCodeSignatureException
     *         The code signature failed the integrity check. If the integrity check fails, then Lambda blocks
     *         deployment, even if the code signing policy is set to WARN.
     * @throws CodeSigningConfigNotFoundException
     *         The specified code signing configuration does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateFunctionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateFunctionConfigurationResponse updateFunctionConfiguration(
            UpdateFunctionConfigurationRequest updateFunctionConfigurationRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceConflictException,
            PreconditionFailedException, CodeVerificationFailedException, InvalidCodeSignatureException,
            CodeSigningConfigNotFoundException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFunctionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateFunctionConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFunctionConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFunctionConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateFunctionConfigurationRequest, UpdateFunctionConfigurationResponse>()
                            .withOperationName("UpdateFunctionConfiguration").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateFunctionConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateFunctionConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration for asynchronous invocation for a function, version, or alias.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     *
     * @param updateFunctionEventInvokeConfigRequest
     * @return Result of the UpdateFunctionEventInvokeConfig operation returned by the service.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateFunctionEventInvokeConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateFunctionEventInvokeConfigResponse updateFunctionEventInvokeConfig(
            UpdateFunctionEventInvokeConfigRequest updateFunctionEventInvokeConfigRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceConflictException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFunctionEventInvokeConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateFunctionEventInvokeConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateFunctionEventInvokeConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFunctionEventInvokeConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateFunctionEventInvokeConfigRequest, UpdateFunctionEventInvokeConfigResponse>()
                            .withOperationName("UpdateFunctionEventInvokeConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateFunctionEventInvokeConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateFunctionEventInvokeConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration for a Lambda function URL.
     * </p>
     *
     * @param updateFunctionUrlConfigRequest
     * @return Result of the UpdateFunctionUrlConfig operation returned by the service.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is not valid.
     * @throws ServiceException
     *         The Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-limits.html#api-requests">Lambda
     *         quotas</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateFunctionUrlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionUrlConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateFunctionUrlConfigResponse updateFunctionUrlConfig(UpdateFunctionUrlConfigRequest updateFunctionUrlConfigRequest)
            throws ResourceConflictException, ResourceNotFoundException, InvalidParameterValueException, ServiceException,
            TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFunctionUrlConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateFunctionUrlConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFunctionUrlConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lambda");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFunctionUrlConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateFunctionUrlConfigRequest, UpdateFunctionUrlConfigResponse>()
                            .withOperationName("UpdateFunctionUrlConfig").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateFunctionUrlConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateFunctionUrlConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(LambdaException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotReadyException")
                                .exceptionBuilderSupplier(ResourceNotReadyException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KMSInvalidStateException")
                                .exceptionBuilderSupplier(KmsInvalidStateException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KMSNotFoundException")
                                .exceptionBuilderSupplier(KmsNotFoundException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubnetIPAddressLimitReachedException")
                                .exceptionBuilderSupplier(SubnetIpAddressLimitReachedException::builder).httpStatusCode(502)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidZipFileException")
                                .exceptionBuilderSupplier(InvalidZipFileException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapStartNotReadyException")
                                .exceptionBuilderSupplier(SnapStartNotReadyException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCodeSignatureException")
                                .exceptionBuilderSupplier(InvalidCodeSignatureException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRuntimeException")
                                .exceptionBuilderSupplier(InvalidRuntimeException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EFSMountFailureException")
                                .exceptionBuilderSupplier(EfsMountFailureException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapStartException")
                                .exceptionBuilderSupplier(SnapStartException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ENILimitReachedException")
                                .exceptionBuilderSupplier(EniLimitReachedException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceConflictException")
                                .exceptionBuilderSupplier(ResourceConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EC2ThrottledException")
                                .exceptionBuilderSupplier(Ec2ThrottledException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KMSAccessDeniedException")
                                .exceptionBuilderSupplier(KmsAccessDeniedException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PreconditionFailedException")
                                .exceptionBuilderSupplier(PreconditionFailedException::builder).httpStatusCode(412).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EFSMountTimeoutException")
                                .exceptionBuilderSupplier(EfsMountTimeoutException::builder).httpStatusCode(408).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedMediaTypeException")
                                .exceptionBuilderSupplier(UnsupportedMediaTypeException::builder).httpStatusCode(415).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                                .exceptionBuilderSupplier(InvalidParameterValueException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EC2AccessDeniedException")
                                .exceptionBuilderSupplier(Ec2AccessDeniedException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUseException")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PolicyLengthExceededException")
                                .exceptionBuilderSupplier(PolicyLengthExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceException")
                                .exceptionBuilderSupplier(ServiceException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SnapStartTimeoutException")
                                .exceptionBuilderSupplier(SnapStartTimeoutException::builder).httpStatusCode(408).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestContentException")
                                .exceptionBuilderSupplier(InvalidRequestContentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EFSMountConnectivityException")
                                .exceptionBuilderSupplier(EfsMountConnectivityException::builder).httpStatusCode(408).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CodeSigningConfigNotFoundException")
                                .exceptionBuilderSupplier(CodeSigningConfigNotFoundException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ProvisionedConcurrencyConfigNotFoundException")
                                .exceptionBuilderSupplier(ProvisionedConcurrencyConfigNotFoundException::builder)
                                .httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EFSIOException").exceptionBuilderSupplier(EfsioException::builder)
                                .httpStatusCode(410).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSubnetIDException")
                                .exceptionBuilderSupplier(InvalidSubnetIdException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CodeStorageExceededException")
                                .exceptionBuilderSupplier(CodeStorageExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSecurityGroupIDException")
                                .exceptionBuilderSupplier(InvalidSecurityGroupIdException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KMSDisabledException")
                                .exceptionBuilderSupplier(KmsDisabledException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CodeVerificationFailedException")
                                .exceptionBuilderSupplier(CodeVerificationFailedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EC2UnexpectedException")
                                .exceptionBuilderSupplier(Ec2UnexpectedException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RequestTooLargeException")
                                .exceptionBuilderSupplier(RequestTooLargeException::builder).httpStatusCode(413).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(429).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends LambdaRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    @Override
    public LambdaWaiter waiter() {
        return LambdaWaiter.builder().client(this).build();
    }
}
