/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides configuration information about a Lambda function version alias.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAliasResponse extends LambdaResponse implements
        ToCopyableBuilder<UpdateAliasResponse.Builder, UpdateAliasResponse> {
    private static final SdkField<String> ALIAS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateAliasResponse::aliasArn)).setter(setter(Builder::aliasArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateAliasResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> FUNCTION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateAliasResponse::functionVersion)).setter(setter(Builder::functionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionVersion").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateAliasResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<AliasRoutingConfiguration> ROUTING_CONFIG_FIELD = SdkField
            .<AliasRoutingConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(UpdateAliasResponse::routingConfig))
            .setter(setter(Builder::routingConfig)).constructor(AliasRoutingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingConfig").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateAliasResponse::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_ARN_FIELD, NAME_FIELD,
            FUNCTION_VERSION_FIELD, DESCRIPTION_FIELD, ROUTING_CONFIG_FIELD, REVISION_ID_FIELD));

    private final String aliasArn;

    private final String name;

    private final String functionVersion;

    private final String description;

    private final AliasRoutingConfiguration routingConfig;

    private final String revisionId;

    private UpdateAliasResponse(BuilderImpl builder) {
        super(builder);
        this.aliasArn = builder.aliasArn;
        this.name = builder.name;
        this.functionVersion = builder.functionVersion;
        this.description = builder.description;
        this.routingConfig = builder.routingConfig;
        this.revisionId = builder.revisionId;
    }

    /**
     * <p>
     * Lambda function ARN that is qualified using the alias name as the suffix. For example, if you create an alias
     * called <code>BETA</code> that points to a helloworld function version, the ARN is
     * <code>arn:aws:lambda:aws-regions:acct-id:function:helloworld:BETA</code>.
     * </p>
     * 
     * @return Lambda function ARN that is qualified using the alias name as the suffix. For example, if you create an
     *         alias called <code>BETA</code> that points to a helloworld function version, the ARN is
     *         <code>arn:aws:lambda:aws-regions:acct-id:function:helloworld:BETA</code>.
     */
    public String aliasArn() {
        return aliasArn;
    }

    /**
     * <p>
     * Alias name.
     * </p>
     * 
     * @return Alias name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Function version to which the alias points.
     * </p>
     * 
     * @return Function version to which the alias points.
     */
    public String functionVersion() {
        return functionVersion;
    }

    /**
     * <p>
     * Alias description.
     * </p>
     * 
     * @return Alias description.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Specifies an additional function versions the alias points to, allowing you to dictate what percentage of traffic
     * will invoke each version.
     * </p>
     * 
     * @return Specifies an additional function versions the alias points to, allowing you to dictate what percentage of
     *         traffic will invoke each version.
     */
    public AliasRoutingConfiguration routingConfig() {
        return routingConfig;
    }

    /**
     * <p>
     * Represents the latest updated revision of the function or alias.
     * </p>
     * 
     * @return Represents the latest updated revision of the function or alias.
     */
    public String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(functionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(routingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAliasResponse)) {
            return false;
        }
        UpdateAliasResponse other = (UpdateAliasResponse) obj;
        return Objects.equals(aliasArn(), other.aliasArn()) && Objects.equals(name(), other.name())
                && Objects.equals(functionVersion(), other.functionVersion())
                && Objects.equals(description(), other.description()) && Objects.equals(routingConfig(), other.routingConfig())
                && Objects.equals(revisionId(), other.revisionId());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateAliasResponse").add("AliasArn", aliasArn()).add("Name", name())
                .add("FunctionVersion", functionVersion()).add("Description", description())
                .add("RoutingConfig", routingConfig()).add("RevisionId", revisionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AliasArn":
            return Optional.ofNullable(clazz.cast(aliasArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "FunctionVersion":
            return Optional.ofNullable(clazz.cast(functionVersion()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RoutingConfig":
            return Optional.ofNullable(clazz.cast(routingConfig()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAliasResponse, T> g) {
        return obj -> g.apply((UpdateAliasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAliasResponse> {
        /**
         * <p>
         * Lambda function ARN that is qualified using the alias name as the suffix. For example, if you create an alias
         * called <code>BETA</code> that points to a helloworld function version, the ARN is
         * <code>arn:aws:lambda:aws-regions:acct-id:function:helloworld:BETA</code>.
         * </p>
         * 
         * @param aliasArn
         *        Lambda function ARN that is qualified using the alias name as the suffix. For example, if you create
         *        an alias called <code>BETA</code> that points to a helloworld function version, the ARN is
         *        <code>arn:aws:lambda:aws-regions:acct-id:function:helloworld:BETA</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasArn(String aliasArn);

        /**
         * <p>
         * Alias name.
         * </p>
         * 
         * @param name
         *        Alias name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Function version to which the alias points.
         * </p>
         * 
         * @param functionVersion
         *        Function version to which the alias points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionVersion(String functionVersion);

        /**
         * <p>
         * Alias description.
         * </p>
         * 
         * @param description
         *        Alias description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies an additional function versions the alias points to, allowing you to dictate what percentage of
         * traffic will invoke each version.
         * </p>
         * 
         * @param routingConfig
         *        Specifies an additional function versions the alias points to, allowing you to dictate what percentage
         *        of traffic will invoke each version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingConfig(AliasRoutingConfiguration routingConfig);

        /**
         * <p>
         * Specifies an additional function versions the alias points to, allowing you to dictate what percentage of
         * traffic will invoke each version.
         * </p>
         * This is a convenience that creates an instance of the {@link AliasRoutingConfiguration.Builder} avoiding the
         * need to create one manually via {@link AliasRoutingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AliasRoutingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #routingConfig(AliasRoutingConfiguration)}.
         * 
         * @param routingConfig
         *        a consumer that will call methods on {@link AliasRoutingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingConfig(AliasRoutingConfiguration)
         */
        default Builder routingConfig(Consumer<AliasRoutingConfiguration.Builder> routingConfig) {
            return routingConfig(AliasRoutingConfiguration.builder().applyMutation(routingConfig).build());
        }

        /**
         * <p>
         * Represents the latest updated revision of the function or alias.
         * </p>
         * 
         * @param revisionId
         *        Represents the latest updated revision of the function or alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String aliasArn;

        private String name;

        private String functionVersion;

        private String description;

        private AliasRoutingConfiguration routingConfig;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAliasResponse model) {
            super(model);
            aliasArn(model.aliasArn);
            name(model.name);
            functionVersion(model.functionVersion);
            description(model.description);
            routingConfig(model.routingConfig);
            revisionId(model.revisionId);
        }

        public final String getAliasArn() {
            return aliasArn;
        }

        @Override
        public final Builder aliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
            return this;
        }

        public final void setAliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFunctionVersion() {
            return functionVersion;
        }

        @Override
        public final Builder functionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        public final void setFunctionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final AliasRoutingConfiguration.Builder getRoutingConfig() {
            return routingConfig != null ? routingConfig.toBuilder() : null;
        }

        @Override
        public final Builder routingConfig(AliasRoutingConfiguration routingConfig) {
            this.routingConfig = routingConfig;
            return this;
        }

        public final void setRoutingConfig(AliasRoutingConfiguration.BuilderImpl routingConfig) {
            this.routingConfig = routingConfig != null ? routingConfig.build() : null;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public UpdateAliasResponse build() {
            return new UpdateAliasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
