/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFunctionUrlConfigRequest extends LambdaRequest implements
        ToCopyableBuilder<UpdateFunctionUrlConfigRequest.Builder, UpdateFunctionUrlConfigRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionName").getter(getter(UpdateFunctionUrlConfigRequest::functionName))
            .setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()).build();

    private static final SdkField<String> QUALIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Qualifier").getter(getter(UpdateFunctionUrlConfigRequest::qualifier)).setter(setter(Builder::qualifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Qualifier").build()).build();

    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthType").getter(getter(UpdateFunctionUrlConfigRequest::authTypeAsString))
            .setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthType").build()).build();

    private static final SdkField<Cors> CORS_FIELD = SdkField.<Cors> builder(MarshallingType.SDK_POJO).memberName("Cors")
            .getter(getter(UpdateFunctionUrlConfigRequest::cors)).setter(setter(Builder::cors)).constructor(Cors::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cors").build()).build();

    private static final SdkField<String> INVOKE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvokeMode").getter(getter(UpdateFunctionUrlConfigRequest::invokeModeAsString))
            .setter(setter(Builder::invokeMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvokeMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD,
            QUALIFIER_FIELD, AUTH_TYPE_FIELD, CORS_FIELD, INVOKE_MODE_FIELD));

    private final String functionName;

    private final String qualifier;

    private final String authType;

    private final Cors cors;

    private final String invokeMode;

    private UpdateFunctionUrlConfigRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.qualifier = builder.qualifier;
        this.authType = builder.authType;
        this.cors = builder.cors;
        this.invokeMode = builder.invokeMode;
    }

    /**
     * <p>
     * The name of the Lambda function.
     * </p>
     * <p class="title">
     * <b>Name formats</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Function name</b> – <code>my-function</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
     * characters in length.
     * </p>
     * 
     * @return The name of the Lambda function.</p>
     *         <p class="title">
     *         <b>Name formats</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Function name</b> – <code>my-function</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The length constraint applies only to the full ARN. If you specify only the function name, it is limited
     *         to 64 characters in length.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * The alias name.
     * </p>
     * 
     * @return The alias name.
     */
    public final String qualifier() {
        return qualifier;
    }

    /**
     * <p>
     * The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict
     * access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a
     * public endpoint. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda function
     * URLs</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link FunctionUrlAuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authTypeAsString}.
     * </p>
     * 
     * @return The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to
     *         restrict access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM
     *         authentication to create a public endpoint. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda
     *         function URLs</a>.
     * @see FunctionUrlAuthType
     */
    public final FunctionUrlAuthType authType() {
        return FunctionUrlAuthType.fromValue(authType);
    }

    /**
     * <p>
     * The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict
     * access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a
     * public endpoint. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda function
     * URLs</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link FunctionUrlAuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authTypeAsString}.
     * </p>
     * 
     * @return The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to
     *         restrict access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM
     *         authentication to create a public endpoint. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda
     *         function URLs</a>.
     * @see FunctionUrlAuthType
     */
    public final String authTypeAsString() {
        return authType;
    }

    /**
     * <p>
     * The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing (CORS)</a>
     * settings for your function URL.
     * </p>
     * 
     * @return The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing
     *         (CORS)</a> settings for your function URL.
     */
    public final Cors cors() {
        return cors;
    }

    /**
     * <p>
     * Use one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BUFFERED</code> – This is the default option. Lambda invokes your function using the <code>Invoke</code>
     * API operation. Invocation results are available when the payload is complete. The maximum payload size is 6 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESPONSE_STREAM</code> – Your function streams payload results as they become available. Lambda invokes
     * your function using the <code>InvokeWithResponseStream</code> API operation. The maximum response payload size is
     * 20 MB, however, you can <a
     * href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">request a quota
     * increase</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invokeMode} will
     * return {@link InvokeMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #invokeModeAsString}.
     * </p>
     * 
     * @return Use one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BUFFERED</code> – This is the default option. Lambda invokes your function using the
     *         <code>Invoke</code> API operation. Invocation results are available when the payload is complete. The
     *         maximum payload size is 6 MB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESPONSE_STREAM</code> – Your function streams payload results as they become available. Lambda
     *         invokes your function using the <code>InvokeWithResponseStream</code> API operation. The maximum response
     *         payload size is 20 MB, however, you can <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">request a
     *         quota increase</a>.
     *         </p>
     *         </li>
     * @see InvokeMode
     */
    public final InvokeMode invokeMode() {
        return InvokeMode.fromValue(invokeMode);
    }

    /**
     * <p>
     * Use one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BUFFERED</code> – This is the default option. Lambda invokes your function using the <code>Invoke</code>
     * API operation. Invocation results are available when the payload is complete. The maximum payload size is 6 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RESPONSE_STREAM</code> – Your function streams payload results as they become available. Lambda invokes
     * your function using the <code>InvokeWithResponseStream</code> API operation. The maximum response payload size is
     * 20 MB, however, you can <a
     * href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">request a quota
     * increase</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invokeMode} will
     * return {@link InvokeMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #invokeModeAsString}.
     * </p>
     * 
     * @return Use one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BUFFERED</code> – This is the default option. Lambda invokes your function using the
     *         <code>Invoke</code> API operation. Invocation results are available when the payload is complete. The
     *         maximum payload size is 6 MB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RESPONSE_STREAM</code> – Your function streams payload results as they become available. Lambda
     *         invokes your function using the <code>InvokeWithResponseStream</code> API operation. The maximum response
     *         payload size is 20 MB, however, you can <a
     *         href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">request a
     *         quota increase</a>.
     *         </p>
     *         </li>
     * @see InvokeMode
     */
    public final String invokeModeAsString() {
        return invokeMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(qualifier());
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cors());
        hashCode = 31 * hashCode + Objects.hashCode(invokeModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFunctionUrlConfigRequest)) {
            return false;
        }
        UpdateFunctionUrlConfigRequest other = (UpdateFunctionUrlConfigRequest) obj;
        return Objects.equals(functionName(), other.functionName()) && Objects.equals(qualifier(), other.qualifier())
                && Objects.equals(authTypeAsString(), other.authTypeAsString()) && Objects.equals(cors(), other.cors())
                && Objects.equals(invokeModeAsString(), other.invokeModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFunctionUrlConfigRequest").add("FunctionName", functionName())
                .add("Qualifier", qualifier()).add("AuthType", authTypeAsString()).add("Cors", cors())
                .add("InvokeMode", invokeModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "Qualifier":
            return Optional.ofNullable(clazz.cast(qualifier()));
        case "AuthType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        case "Cors":
            return Optional.ofNullable(clazz.cast(cors()));
        case "InvokeMode":
            return Optional.ofNullable(clazz.cast(invokeModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFunctionUrlConfigRequest, T> g) {
        return obj -> g.apply((UpdateFunctionUrlConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFunctionUrlConfigRequest> {
        /**
         * <p>
         * The name of the Lambda function.
         * </p>
         * <p class="title">
         * <b>Name formats</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Function name</b> – <code>my-function</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to
         * 64 characters in length.
         * </p>
         * 
         * @param functionName
         *        The name of the Lambda function.</p>
         *        <p class="title">
         *        <b>Name formats</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Function name</b> – <code>my-function</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The length constraint applies only to the full ARN. If you specify only the function name, it is
         *        limited to 64 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * The alias name.
         * </p>
         * 
         * @param qualifier
         *        The alias name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualifier(String qualifier);

        /**
         * <p>
         * The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict
         * access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM authentication to
         * create a public endpoint. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda
         * function URLs</a>.
         * </p>
         * 
         * @param authType
         *        The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to
         *        restrict access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM
         *        authentication to create a public endpoint. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda
         *        function URLs</a>.
         * @see FunctionUrlAuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FunctionUrlAuthType
         */
        Builder authType(String authType);

        /**
         * <p>
         * The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to restrict
         * access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM authentication to
         * create a public endpoint. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda
         * function URLs</a>.
         * </p>
         * 
         * @param authType
         *        The type of authentication that your function URL uses. Set to <code>AWS_IAM</code> if you want to
         *        restrict access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM
         *        authentication to create a public endpoint. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda
         *        function URLs</a>.
         * @see FunctionUrlAuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FunctionUrlAuthType
         */
        Builder authType(FunctionUrlAuthType authType);

        /**
         * <p>
         * The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing (CORS)</a>
         * settings for your function URL.
         * </p>
         * 
         * @param cors
         *        The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing
         *        (CORS)</a> settings for your function URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cors(Cors cors);

        /**
         * <p>
         * The <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">cross-origin resource sharing (CORS)</a>
         * settings for your function URL.
         * </p>
         * This is a convenience method that creates an instance of the {@link Cors.Builder} avoiding the need to create
         * one manually via {@link Cors#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Cors.Builder#build()} is called immediately and its result is
         * passed to {@link #cors(Cors)}.
         * 
         * @param cors
         *        a consumer that will call methods on {@link Cors.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cors(Cors)
         */
        default Builder cors(Consumer<Cors.Builder> cors) {
            return cors(Cors.builder().applyMutation(cors).build());
        }

        /**
         * <p>
         * Use one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BUFFERED</code> – This is the default option. Lambda invokes your function using the
         * <code>Invoke</code> API operation. Invocation results are available when the payload is complete. The maximum
         * payload size is 6 MB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESPONSE_STREAM</code> – Your function streams payload results as they become available. Lambda invokes
         * your function using the <code>InvokeWithResponseStream</code> API operation. The maximum response payload
         * size is 20 MB, however, you can <a
         * href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">request a quota
         * increase</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param invokeMode
         *        Use one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BUFFERED</code> – This is the default option. Lambda invokes your function using the
         *        <code>Invoke</code> API operation. Invocation results are available when the payload is complete. The
         *        maximum payload size is 6 MB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESPONSE_STREAM</code> – Your function streams payload results as they become available. Lambda
         *        invokes your function using the <code>InvokeWithResponseStream</code> API operation. The maximum
         *        response payload size is 20 MB, however, you can <a
         *        href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">request
         *        a quota increase</a>.
         *        </p>
         *        </li>
         * @see InvokeMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvokeMode
         */
        Builder invokeMode(String invokeMode);

        /**
         * <p>
         * Use one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BUFFERED</code> – This is the default option. Lambda invokes your function using the
         * <code>Invoke</code> API operation. Invocation results are available when the payload is complete. The maximum
         * payload size is 6 MB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RESPONSE_STREAM</code> – Your function streams payload results as they become available. Lambda invokes
         * your function using the <code>InvokeWithResponseStream</code> API operation. The maximum response payload
         * size is 20 MB, however, you can <a
         * href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">request a quota
         * increase</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param invokeMode
         *        Use one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BUFFERED</code> – This is the default option. Lambda invokes your function using the
         *        <code>Invoke</code> API operation. Invocation results are available when the payload is complete. The
         *        maximum payload size is 6 MB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RESPONSE_STREAM</code> – Your function streams payload results as they become available. Lambda
         *        invokes your function using the <code>InvokeWithResponseStream</code> API operation. The maximum
         *        response payload size is 20 MB, however, you can <a
         *        href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">request
         *        a quota increase</a>.
         *        </p>
         *        </li>
         * @see InvokeMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvokeMode
         */
        Builder invokeMode(InvokeMode invokeMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String functionName;

        private String qualifier;

        private String authType;

        private Cors cors;

        private String invokeMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFunctionUrlConfigRequest model) {
            super(model);
            functionName(model.functionName);
            qualifier(model.qualifier);
            authType(model.authType);
            cors(model.cors);
            invokeMode(model.invokeMode);
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getQualifier() {
            return qualifier;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final String getAuthType() {
            return authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(FunctionUrlAuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final Cors.Builder getCors() {
            return cors != null ? cors.toBuilder() : null;
        }

        public final void setCors(Cors.BuilderImpl cors) {
            this.cors = cors != null ? cors.build() : null;
        }

        @Override
        public final Builder cors(Cors cors) {
            this.cors = cors;
            return this;
        }

        public final String getInvokeMode() {
            return invokeMode;
        }

        public final void setInvokeMode(String invokeMode) {
            this.invokeMode = invokeMode;
        }

        @Override
        public final Builder invokeMode(String invokeMode) {
            this.invokeMode = invokeMode;
            return this;
        }

        @Override
        public final Builder invokeMode(InvokeMode invokeMode) {
            this.invokeMode(invokeMode == null ? null : invokeMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFunctionUrlConfigRequest build() {
            return new UpdateFunctionUrlConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
